<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('admin.menu.availability') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
    <div class="row py-10x">
      <div class="col-sm-3 col-md-2 right" style="line-height:34px">
        <label for="catalog">{{ mt._('admin.selectcatalog') }}</label>
      </div>
      <div class="col-sm-5 col-md-4">
        <select class="select2_single form-control" id="catalog" tabindex="-1">
          {% for catalog in catalogs %}
          <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
          {% endfor %}
        </select>
      </div>
      <div class="col-sm-3 col-md-2">
        <button type="button" class="btn btn-default waves-effect waves-light" id="load-articles">
          {{ mt._('admin.catalog.loadarticles') }}
        </button>
      </div>
      <div class="col-sm-12 col-md-4 right">
        <a href="#" id="add-article" class="btn btn-primary waves-effect waves-light" style="display:none" data-toggle='modal' data-target='#modal-new'>
          {{ mt._('_common.article.add') }}
        </a>
      </div>
    </div>
    <div class="row my-20x" id="articles-table" style="display:none">
      <table id="articles" class="table table-striped table-bordered">
        <thead>
          <tr>
            <th style="width:21%">{{ mt._('_common.article.code') }}</th>
            <th style="width:21%">{{ mt._('_common.article.description') }}</th>
            <th style="width:50%">{{ mt._('admin.availability.size') }}</th>
            <th style="width:8%"></th>
          </tr>
        </thead>
        <tbody>

        </tbody>
      </table>
    </div>

  </div>

</div>

<div class="modal fade" id="modal-delete" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title capitalize">{{ mt._('_common.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>
			<div class="modal-body">
        <input type="hidden" id="cdarti-to-delete" value=""/>
				<div class="py-10x">{{ mt._('admin.availability.warning') }}</div>
			</div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="confirm-delete" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-edit" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title capitalize">{{ mt._('_common.edit') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>

      <div class="modal-body">
        <input type="hidden" id="cdarti-to-edit" value=""/>
        <div style="font-weight:bold">{{ mt._('pdf.qty.persizeassortment') }}</div>
        <div class="row mt-20x center" id="edit-sizes">

        </div>
        <div class="mt-20x" id="edit-assortments">

        </div>
      </div>

      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="confirm-edit" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-new" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title capitalize">{{ mt._('_common.article.add') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>

      <div class="modal-body">
        <div class="row">
          <label for="select-article" class="control-label col-md-3 col-sm-3 col-xs-12 mt-10x right">{{ mt._('admin.order.selectarticle') }}</label>
          <div class="col-md-6 col-sm-6 col-xs-12">
            <select class="select2_group_article form-control selectpicker" id="select-article" data-live-search="true">

            </select>
          </div>
          <div class="col-md-3 col-sm-3 col-xs-12">
            <button type="button" class="btn btn-default right-btn" id="load-article">{{ mt._('_common.load') }}</button>
          </div>
        </div>
        <div class="mt-20x" style="font-weight:bold">{{ mt._('pdf.qty.persizeassortment') }}</div>
        <div class="row mt-20x center" id="new-sizes">

        </div>
        <div class="mt-20x" id="new-assortments">

        </div>
      </div>

      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="confirm-new" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
      </div>
    </div>
  </div>
</div>
