<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('_common.agents') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
				<button type="button" class="btn btn-primary waves-effect waves-light left-btn" data-toggle='modal' data-target='#modal-insert-agent'>
					{{ mt._('admin.agents.new') }}
				</button>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if agents|length > 0 %}
			  <table id="table-agents" class="table table-striped table-bordered">
			  	<thead class="text-capitalize">
			  		<tr>
			  			<th>{{ mt._('_common.code') }}</th>
			  			<th>{{ mt._('_common.name') }}</th>
			  			<th>{{ mt._('_common.typology') }}</th>
			  			<th>{{ mt._('admin.seqrap') }}</th>
			  			<th>{{ mt._('_common.pricelist') }}</th>
			  			<th></th>
			  		</tr>
			  	</thead>
			  	<tbody>
			  		{% for agent in agents %}
			  			<tr data-cdagen="{{ agent.cdagen }}" data-dsagen="{{ agent.dsagen }}" data-seqrap="{{ agent.seqrap }}"
			  				data-fltota="{{ agent.fltota }}" data-nulist="{{ agent.nulist }}">
			  				<td>{{ agent.cdagen }}</td>
			  				<td>{{ agent.dsagen }}</td>
			  				<td>{{ agent.fltota == 1 ? mt._('admin.agents.headoffice') : 'Standard' }}</td>
			  				<td>{{ agent.seqrap }}</td>
			  				<td>{{ agent.nulist }}</td>
			  				<td class="center" style="vertical-align:middle">
			  					<a href="#" class="open-edit-agent" title="{{ mt._('admin.agents.modifyagent') }}"
			  						data-toggle='modal' data-target='#modal-edit-agent'>
			  						<span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
			  					</a>
			  					<a href="#" class="open-delete-agent pl-10x" title="{{ mt._('admin.agents.delete') }}"
			  						data-toggle='modal' data-target='#modal-delete-agent'>
			  						<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
			  					</a>
			  				</td>
			  			</tr>
			  		{% endfor %}
			  	</tbody>
			  </table>
			{% else %}
			{{ mt._('admin.agents.no') }}
			{% endif %}
			</div>
		</div>
	</div>
</div>

<!-- Modal for insert agent -->
<div class="modal fade" id="modal-insert-agent" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.agents.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<div class="msg-error"></div>
				<div class="py-10x">
					<label for="cdagen" class="control-label text-capitalize">{{ mt._('admin.agents.agentcode') }}</label>
					<input type="text" id="cdagen" class="form-control" maxlength="10" title="{{ mt._('_common.code') }}">
				</div>
				<div class="py-10x">
					<label for="dsagen" class="control-label text-capitalize">{{ mt._('admin.agents.name') }}</label>
					<input type="text" id="dsagen" class="form-control" title="{{ mt._('admin.agents.name') }}">
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label text-capitalize">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="seqrap" class="form-control" value="0" min="0" title="{{ mt._('admin.seqrap') }}">
				</div>
				<div class="py-10x">
					<label for="nulist" class="control-label text-capitalize">{{ mt._('_common.pricelist') }}</label>
					<select id="nulist" class="form-control" title="{{ mt._('_common.pricelist') }}">
						<option value=""></option>
						{% for lst in lstest %}
						<option value="{{ lst.nulist }}">{{ lst.nulist }} - {{ lst.dslist }}</option>
						{% endfor %}
					</select>
				</div>
				<div class="py-10x">
					<label for="fltota" class="control-label text-capitalize">{{ mt._('_common.typology') }}</label>
					<span class="checkbox-container">
						<input type="checkbox" id="fltota">
						{{ mt._('admin.agents.headoffice') }}
						<span class="checkbox-checkmark"></span>
					</span>
				</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="insert-agent" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for edit agent -->
<div class="modal fade" id="modal-edit-agent" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.agents.modifyagent') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="edit-cdagen">
				<div class="py-10x">
					<label for="edit-dsagen" class="control-label text-capitalize">{{ mt._('admin.agents.name') }}</label>
					<input type="text" id="edit-dsagen" class="form-control" title="{{ mt._('admin.agents.name') }}">
				</div>
				<div class="py-10x">
					<label for="edit-seqrap" class="control-label text-capitalize">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="edit-seqrap" class="form-control" value="0" min="0" title="{{ mt._('admin.seqrap') }}">
				</div>
				<div class="py-10x">
					<label for="edit-nulist" class="control-label text-capitalize">{{ mt._('_common.pricelist') }}</label>
					<select id="edit-nulist" class="form-control" title="{{ mt._('_common.pricelist') }}">
						<option value=""></option>
						{% for lst in lstest %}
						<option value="{{ lst.nulist }}">{{ lst.nulist }} - {{ lst.dslist }}</option>
						{% endfor %}
					</select>
				</div>
				<div class="py-10x">
					<label for="edit-fltota" class="control-label text-capitalize">{{ mt._('_common.typology') }}</label>
					<span class="checkbox-container">
						<input type="checkbox" id="edit-fltota">
						{{ mt._('admin.agents.headoffice') }}
						<span class="checkbox-checkmark"></span>
					</span>
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="edit-agent" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for delete agent -->
<div class="modal fade" id="modal-delete-agent" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.agents.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="delete-cdagen">
				<div class="py-10x">{{ mt._('admin.agents.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-agent" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
