<div id="list-mode" class="model-block">
  <div id="results-counter" class="title-model-block">{{ tipolo|length }} {{ tipolo|length == 1 ? mt._('_common.searchresult') : mt._('_common.searchresults') }}</div>

{% for model in tipolo %}
  <div class="row model-list-row" id="row-{{ model.cdartn }}" data-code="{{ model.cdartn }}" data-descr="{{ model.dsartn }}">

    <!-- First level: image column -->
    <div class="col-4 col-md-3 little-space-img">
      {{ elements.getModelImgOrDefault(model.flimag, model.dsartn) }}
    </div>
    <div class="d-block d-md-none col-8 mt-20x">
      {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
        {% set detailUrl = url('model/' ~ model.cdartn) %}
      {% else %}
        {% set detailUrl = url('model/wizard/' ~ model.cdartn) %}
      {% endif %}
      <a href="{{ detailUrl }}">
        <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
      </a>
    </div>

    <!-- First level: info column -->
    <div class="col-12 col-md-9">

      <!-- Second level: model description row -->
      <div class="row d-none d-md-block">
        <div class="col-5">
          {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
            {% set detailUrl = url('model/' ~ model.cdartn) %}
          {% else %}
            {% set detailUrl = url('model/wizard/' ~ model.cdartn) %}
          {% endif %}
          <a href="{{ detailUrl }}">
            <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
          </a>
        </div>
      </div>

  {% set only_one = false %}
  {% for article in model['anaart'] %}
      <!-- Second level: article row -->
      <div class="row article-list-row" id="row-arti-{{ urlencode(article.cdarti) }}"
        data-cdarti="{{ article.cdarti }}"
        data-cdcolo="{{ article.cdcolo }}"
        data-nurorc="{{ article.presence }}"
        data-cdtagl="{{ model.cdtagl }}"
        data-tglini="{{ model.tglini }}"
        data-tglfin="{{ model.tglfin }}"
        data-scala-taglie-completa="{{ common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0' }}"
        data-tppers="{{ model.tppers }}">

        <!-- Col Image + Description -->
        <div class="col-6 col-md-4 col-desc-container">
          <div class="row d-block d-md-none">
            <div class="col-12 font-weight-bold">{{ article.cdcolo }} {{ article.dscolo }}</div>
          </div>
          <div class="row col-desc">
            <div class="col-3 h-100">{{ elements.getModelImgOrDefault(article.flimag, article.dsarti) }}</div>
            <div class="d-none d-md-block col-9"><span class="font-weight-bold">{{ article.cdcolo }}</span><br/>{{ article.dscolo }}</div>
          </div>
        </div>

        <!-- Col Sizes Desktop -->
        <div class="d-none d-md-block col-4">
          {% for size in article['qttagl'] %}
            {% set disabled = (loop.index < model.tglini and model.tglini != 0) or (loop.index > model.tglfin and model.tglfin != 0) %}
            {% set disc_price = 0 %}
            {% if common['showCatalogPrice'] == 1 %}
              {% set withDiscount = false %}
              {% set currentPrice = size.prezzo %}
              {% if currentPrice < 0 %}
                {% set currentPrice = mt._('quantity.priceforsize.short') %}
              {% elseif currentPrice == 0 %}
                {% set currentPrice = '-' %}
              {% else %}
                {% set real_price = currentPrice %}
                {% set cust_disc = model['cust_disc'] > 0 ? model['cust_disc'] : 0 %}
                {% set cust_disc = article['cust_disc'] > 0 ? article['cust_disc'] : cust_disc %}
                {% set disc_price = real_price * (1 - cust_disc / 100) %}
                {% set withDiscount = disc_price != real_price %}
                {% set currentPrice = disc_price|currency ~ ' ' ~ common['currency'] %}
              {% endif %}
            {% endif %}

          <div class="quick-order-size-box {{ disabled ? 'size-disabled' : '' }}">
            <div class="qosb-size">{{ size.taglia }}</div>
            <div class="qosb-qty">
              <input type="number" class="size-qty"
                data-taglia="{{ size.taglia }}" data-prezzo="{{ disc_price > 0 ? disc_price : size.prezzo }}"
                data-qtamin="{{ size.qtamin }}" data-qtamul="{{ size.qtamul > 0 ? size.qtamul : 1 }}"
                data-sconto="{{ cust_disc }}"
                name="quantity" min="0" step="{{ size.quanti > size.qtamin ? size.qtamul : size.qtamin }}"  value="{{ size.quanti > 0 ? size.quanti : '' }}"
                {{ disabled ? 'disabled' : '' }}/>

              {% if common('enableMinMulLabel') %}
              <div class='regqta-info'>
                {{ mt._('_common.qty.min.short') }}: {{ size.qtamin }}, {{ mt._('_common.qty.mul.short') }}: {{ size.qtamul }}{{ size.qtamax is defined and size.qtamax > 0 ? ', ' ~ mt._('_common.qty.max.short') ~ ': ' ~ size.qtamax : '' }}
              </div>
              {% endif %}
            </div>
            {% if common['showCatalogPrice'] == 1 %}
            <div class="qosb-price">
            {{ withDiscount
              ? "<span class='discounted'>" ~ real_price|currency ~ " " ~ common['currency'] ~ "</span> " ~ currentPrice
              : currentPrice }}
            </div>
            {% endif %}
          </div>
          {% endfor %}
        </div>

        <!-- Col Buy button -->
        <div class="col-6 col-md-4 col-btn-add">
          <div class="buy-list-box">{{ mt._('_common.addtocart') }}</div>
        </div>
      </div>
  {% endfor %}

    </div>
  </div>
{% endfor %}

</div>
