<div id="list-mode"
     class="container-listing"
     x-data="quickBuy">
    <div id="results-counter"
         class="title-model-block">{{ tipolo|length }} {{ tipolo|length == 1 ? mt._('_common.searchresult') : mt._('_common.searchresults') }}</div>

    {# Set first level col span #}
    {% set left_col_span = not common['isOrder'] or common['order_info'].tpordc != 0 ? 3 : 2 %}
    {% if common['imageOnCatalogList'] == 1 %}
        {% set left_col_span = 0 %}
    {% endif %}

    {% set right_col_span = 12 - left_col_span %}

    {# Set second level right col span #}
    {% set var_col_span = 4 %}
    {% set prc_col_span = 3 %}

    {% if common['isOrder'] %}
        {% if common['order_info'].tpordc != 0 %}
            {% set var_col_span = var_col_span + 1 %}
            {% set prc_col_span = prc_col_span + 1 %}
        {% endif %}
    {% else %}
        {% set var_col_span = var_col_span + 3 %}
        {% set prc_col_span = prc_col_span + 2 %}
    {% endif %}
    {% if common['showCatalogPrice'] == 0 %}
        {% set var_col_span = var_col_span + prc_col_span %}
    {% endif %}

    {% for model in tipolo %}
        {% set minPrice = null %}
        {% set maxPrice = null %}
        <div class="d-flex flex-wrap flex-md-nowrap tipolo-row" data-href="{{ model.cdartn }}">

            {% if common['imageOnCatalogList'] == 0 %}
                <!-- First level: image column -->
                <div class="col-12 d-flex md:d-block justify-content-center col-md-2 little-space-img">
                    {{ elements.getModelImgOrDefault(model.flimag, model.dsartn) }}
                </div>
                {# <div class="d-block d-md-none col-8 mt-20x">
                  {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
                    {% set detailUrl = url('model/' ~ model.cdartn) %}
                  {% else %}
                    {% set detailUrl = url('model/wizard/' ~ model.cdartn) %}
                  {% endif %}
                  <a href="{{ detailUrl }}" >
                    <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
                  </a>
                </div> #}
            {% endif %}

            <!-- First level: info column -->
            <div class="flex-grow-1">
                <!-- Second level: model description row -->
                <div class="row d-md-block mt-3 mt-md-0">
                    <div class="col-5">
                        {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
                            {% set detailUrl = url('model/' ~ model.cdartn) %}
                        {% else %}
                            {% set detailUrl = url('model/wizard/' ~ model.cdartn) %}
                        {% endif %}
                        <a href="{{ detailUrl }}">
                            <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
                        </a>
                    </div>
                </div>

                {% set only_one = false %}
              <div class="child-list-wrapper my-5 my-md-0">
                <div class="d-flex flex-wrap justify-content-between justify-content-md-start">
                {% for article in model['anaart'] %}
                    {% if common['showCatalogPrice'] == 1 %}
                        {% set withDiscount = false %}
                        {% set currentPrice = article.prezzo != 0 ? article.prezzo : model.catalogPrice %}
                        {% if currentPrice < 0 %}
                            {% set currentPrice = mt._('quantity.priceforsize.short') %}
                        {% elseif currentPrice == 0 %}
                            {% set currentPrice = '-' %}
                        {% else %}
                            {% set real_price = currentPrice %}
                            {% set cust_disc = model['cust_disc'] > 0 ? model['cust_disc'] : 0 %}
                            {% set cust_disc = article['cust_disc'] > 0 ? article['cust_disc'] : cust_disc %}
                            {% set disc_price = real_price * (1 - cust_disc / 100) %}
                            {% set withDiscount = disc_price != real_price %}
                            {% set currentPrice = disc_price|currency ~ ' ' ~ common['currency'] %}
                        {% endif %}
                        {% if minPrice == null or minPrice > disc_price %}
                            {% set minPrice = disc_price %}
                        {% endif %}
                        {% if maxPrice == null or maxPrice < disc_price %}
                            {% set maxPrice = disc_price %}
                        {% endif %}
                    {% endif %}

                    {% if model.tppers == "PT" %}
                        {% for color in article['colors'] %}
                            {% if not common['isOrder'] or common['order_info'].tpordc != 0 or
                                (common['shownotavailable'] == 1 or color['is_available'] > 0) %}

                                <div class="row article-list-row" id="row-arti-{{ urlencode(article.cdarti) }}"
                                     data-cdarti="{{ article.cdarti }}"
                                     data-cdcolo="{{ color['cdcolo'] }}"
                                     data-cdtagl="{{ model.cdtagl }}"
                                     data-tglini="{{ model.tglini }}"
                                     data-tglfin="{{ model.tglfin }}"
                                     data-scala-taglie-completa="{{ common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0' }}"
                                     data-tppers="{{ model.tppers }}">

                                    <div class="col-6 col-md-{{ var_col_span }}">
                                        <div class="row d-block d-md-none">
                                            <div class="col-12 font-weight-bold">{{ article.cdpers }} {{ color['cdcolo'] }}</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4 col-md-3 h-100 little-space-img small-img">{{ elements.getModelImgOrDefault(article.flimag, article.dsarti) }}</div>
                                            <div class="col-4 col-md-3 h-100 little-space-img small-img">{{ elements.getModelImgOrDefault(color['flimag'], color['dscolo']) }}</div>
                                            <div class="d-none d-md-block col-6 font-weight-bold">{{ article.cdpers }} {{ color['cdcolo'] }}</div>
                                        </div>
                                    </div>

                                    {# {% if common['showCatalogPrice'] == 1 %}
        <!-- Col Price Desktop -->
        <div class="d-none d-md-block col-{{ prc_col_span }}">
          {{ withDiscount
            ? "<div class='info-list-box-discounted'><span class='discounted'>" ~ real_price|currency ~ " " ~ common['currency'] ~ "</span> " ~ currentPrice ~ "</div>"
            : "<div class='info-list-box'>" ~ currentPrice ~ "</div>" }}
        </div>
        {% endif %}

        {% if common['isOrder'] and common['order_info'].tpordc == 0 %}
        <!-- Col Availability Desktop -->
        <div class="d-none d-md-block col-2">
          {% if color['is_available'] > 0 %}
          <div class="info-list-box">{{ color['is_available'] }}</div>
          {% else %}
          <div class="availability-model-box text-center">{{ mt._('_common.notavailable') }}</div>
          {% endif %}
        </div>
        {% endif %}

        <!-- Col Buy button -->
        <div class="col-6 col-md-3">
          <div class="row">
        {% if common['showCatalogPrice'] == 1 %}
            <div class="d-block d-md-none col-8 font-weight-bold float-left text-right">
              {{ withDiscount
                ? "<span class='discounted'>" ~ real_price|currency ~ " " ~ common['currency'] ~ "</span> " ~ currentPrice
                : currentPrice }}
            </div>
        {% endif %}
        {% if common['isOrder'] and (common['order_info'].tpordc != 0 or color['is_available'] > 0) %}
            <div class="d-block d-md-none col-4 font-weight-bold float-left text-right">
              {{ color['is_available'] > 0 ? color['is_available'] : mt._('_common.notavailable') }}
            </div>
            <div class="col-10 buy-list-box {{ common['showCatalogPrice'] == 0 ? 'offset-8' : '' }}">{{ mt._('_common.buy') }}</div>
        {% endif %}
          </div>
        </div> #}

                                </div>
                            {% endif %}
                        {% endfor %}

                    {% else %}

                        {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or article.qtdisp > 0 %}

                            <!-- Second level: article row -->
                            <div class="child-list-element" id="row-arti-{{ urlencode(article.cdarti) }}"
                                 data-cdarti="{{ article.cdarti }}"
                                 data-cdcolo="{{ article.cdcolo }}"
                                 data-cdtagl="{{ model.cdtagl }}"
                                 data-tglini="{{ model.tglini }}"
                                 data-tglfin="{{ model.tglfin }}"
                                 data-scala-taglie-completa="{{ common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0' }}"
                                 data-tppers="{{ model.tppers }}">

                                <!-- Col Image + Description -->
                                <div>
                                    {{ elements.getModelImgOrDefault(article.flimag, article.dsarti, ['data-enlargable': 'true', 'style': 'cursor:zoom-in']) }}
                                    <div>
                                        {{ common['articleListType'] == 0
                                        ? '<span class="font-weight-bold">' ~ article.cdcolo ~ '</span><br/>' ~ article.dscolo
                                        : '<span class="font-weight-bold">' ~ article.cdarti ~ '</span><br/>' ~ article.dsarti }}
                                    </div>
                                </div>
                            </div>
                        {% endif %}
                    {% endif %}

                {% endfor %}
                </div>
              </div>
            </div>

          <div class="col-12 col-md-4 col-lg-2">
            <div class="price-start">
              <span>{{ mt._('listing.priceFrom') }}</span><strong>{{ minPrice|currency ~ common['currency'] }}</strong>
            </div>
            <button x-bind:disabled="loading || !isOrder" :class="loading && 'loading'"
                    @click='openModal({{ model.cdartn|json_encode }})' class="btn btn-main w-100 btn-icon">
              <i class="fa fa-spinner fa-spin"></i>
              {{ mt._('listing.buyNow') }}
            </button>
          </div>

        </div>
    {% endfor %}

    {% include 'catalog/quickBuyModal.volt' %}

</div>

{% include 'scripts/catalog/quickBuyModalScripts.volt' %}
