<div id="list-mode" class="container-fluid">
{% set pages = (counters["tot_models"] - (counters["tot_models"] % 25)) / 25 %}
{% if counters["tot_models"] % 25 > 0 %}{% set pages = pages + 1 %}{% endif %}

{% set num_articles = 0 %}
{% for model in tipolo %}
  {% set num_articles = num_articles + model['anaart']|length %}
{% endfor %}

  <div class="row ml-0 mr-0">
    <div class="col-12 list-counter" id="list-counter">
      {{ mt._('_common.viewing') }} {{ tipolo|length }} {{ tipolo|length == 1 ? mt._('_common.model') : mt._('_common.models') }} / {{ num_articles }} {{ num_articles == 1 ? mt._('_common.article') : mt._('_common.articles') }}
    </div>
  </div>

  <!-- Header -->
  <div class="row model-list-row header-model-list-row d-none d-md-block">
    <div class="col-3 float-left text-center">{{ mt._('_common.model') }}</div>
    <div class="col-9 float-left">
      <div class="row">
        <div class="col-4">{{ mt._('_common.article') }}</div>
        <div class="col-4 text-center">{{ mt._('_common.sizes.qty') }}</div>
        <div class="col-4">&nbsp;</div>
      </div>
    </div>
  </div>

{% for model in tipolo %}
  <div class="row model-list-row" id="row-{{ model.cdartn }}" data-code="{{ model.cdartn }}" data-descr="{{ model.dsartn }}">

    <!-- First level: image column -->
    <div class="col-4 col-md-3 little-space-img">
      {{ elements.getModelImgOrDefault(model.flimag, model.dsartn) }}
    </div>
    <div class="d-block d-md-none col-8 mt-20x">
      <a href="{{ url('model/' ~ model.cdartn) }}" >
        <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
      </a>
    </div>

    <!-- First level: info column -->
    <div class="col-12 col-md-9">

      <!-- Second level: model description row -->
      <div class="row d-none d-md-block">
        <div class="col-5">
          <a href="{{ url('model/' ~ model.cdartn) }}">
            <span class="font-weight-bold">{{ model.cdartn }}</span><br/>{{ model.dsartn }}
          </a>
        </div>
      </div>

      {% set only_one = false %}
      {% for article in model['anaart'] %}
      <!-- Second level: article row -->
      <div class="row article-list-row" id="row-arti-{{ urlencode(article.cdarti) }}"
        data-cdarti="{{ article.cdarti }}"
        data-cdcolo="{{ article.cdcolo }}"
        data-nurorc="{{ article.presence }}"
        data-cdtagl="{{ model.cdtagl }}"
        data-tglini="{{ model.tglini }}"
        data-tglfin="{{ model.tglfin }}"
        data-tppers="{{ model.tppers }}">

        <!-- Col Image + Description -->
        <div class="col-6 col-md-4 col-desc-container">
          <div class="row d-block d-md-none">
            <div class="col-12 font-weight-bold">{{ article.cdcolo }} {{ article.dscolo }}</div>
          </div>
          <div class="row col-desc">
            <div class="col-3 h-100">{{ elements.getModelImgOrDefault(article.flimag, article.dsarti) }}</div>
            <div class="d-none d-md-block col-9"><span class="font-weight-bold">{{ article.cdcolo }}</span><br/>{{ article.dscolo }}</div>
          </div>
        </div>

        <!-- Col Sizes Desktop -->
        <div class="d-none d-md-block col-4">
          {% for size in article['qttagl'] %}
            {% set disabled = (loop.index < model.tglini and model.tglini != 0) or (loop.index > model.tglfin and model.tglfin != 0) %}
            {% set disc_price = 0 %}
            {% if common['showCatalogPrice'] == 1 %}
              {% set withDiscount = false %}
              {% set currentPrice = size.prezzo %}
              {% if currentPrice < 0 %}
                {% set currentPrice = mt._('quantity.priceforsize.short') %}
              {% elseif currentPrice == 0 %}
                {% set currentPrice = '-' %}
              {% else %}
                {% set real_price = currentPrice %}
                {% set cust_disc = model['cust_disc'] > 0 ? model['cust_disc'] : 0 %}
                {% set cust_disc = article['cust_disc'] > 0 ? article['cust_disc'] : cust_disc %}
                {% set disc_price = real_price * (1 - cust_disc / 100) %}
                {% set withDiscount = disc_price != real_price %}
                {% set currentPrice = disc_price|currency ~ ' ' ~ common['currency'] %}
              {% endif %}
            {% endif %}

          <div class="quick-order-size-box {{ disabled ? 'size-disabled' : '' }}">
            <div class="qosb-size">{{ size.taglia }}</div>
            <div class="qosb-qty">
              <input type="number" class="size-qty"
                data-taglia="{{ size.taglia }}" data-prezzo="{{ disc_price > 0 ? disc_price : size.prezzo }}"
                data-qtamin="{{ size.qtamin }}" data-qtamul="{{ size.qtamul > 0 ? size.qtamul : 1 }}"
                data-sconto="{{ cust_disc }}"
                name="quantity" min="0" step="{{ size.quanti > size.qtamin ? size.qtamul : size.qtamin }}"  value="{{ size.quanti > 0 ? size.quanti : '' }}"
                {{ disabled ? 'disabled' : '' }}/>
            </div>
            {% if common['showCatalogPrice'] == 1 %}
            <div class="qosb-price">
            {{ withDiscount
              ? "<span class='discounted'>" ~ real_price|currency ~ " " ~ common['currency'] ~ "</span> " ~ currentPrice
              : currentPrice }}
            </div>
            {% endif %}
          </div>
          {% endfor %}
        </div>

        <!-- Col Buy button -->
        <div class="col-6 col-md-4 col-btn-add">
          <div class="buy-list-box">{{ mt._('_common.addtocart') }}</div>
        </div>
      </div>
      {% endfor %}

    </div>
  </div>
{% endfor %}
</div>

{% if counters["tot_models"] > 0 %}
<div class="text-center">
  <div class="row m-0">
    <div class="col-12 mb-15x" id="list-counter">
      {{ counters["tot_models"] }} {{ counters["tot_models"] == 1 ? mt._('_common.model') : mt._('_common.models') }}
    </div>
  </div>
  <div class="pagination pt-0 mt-0 mb-40x">
    {{ counters['page'] > 1 ? '<a href="' ~ url('catalog/quickorder') ~ '?page=' ~ (counters['page'] - 1) ~ '">&laquo;</a>' : '<span>&laquo;</span>' }}
    {% for i in 1..pages %}
    <a href="{{ url('catalog/quickorder') }}?page={{ i }}" {% if i == counters['page'] %}class="active"{% endif %}>{{ i }}</a>
    {% endfor %}
    {{ counters['page'] < pages ? '<a href="' ~ url('catalog/quickorder') ~ '?page=' ~ (counters['page'] + 1) ~ '">&raquo;</a>' : '<span>&raquo;</span>' }}
  </div>
</div>
{% endif %}
