{% include "macros.volt" %}

<div class="row body-look text-uppercase mb-20x">
  <div class="col-12">{{ lktest['dslkbk'] }} - {{ lkcorp['dslook'] }}</div>
</div>

{% set imgurl = '' %}
{% if lkcorp and lkcorp['filimg'] is not empty %}
  {% set imgurl = getLookbookFileUrl(lkcorp['filimg']) %}
{% endif %}

{% if imgurl is not empty %}
  {% set lbImageSize = getimagesize(diskManager.normalizePathInApp('public/' ~ imgurl)) %}
  {% set md = lbImageSize[0] > lbImageSize[1] ? 12 : 6 %}
{% else %}
  {% set imgurl = "assets/img/default_look.jpg" %}
  {% set md = 6 %}
{% endif %}

<div class="row body-look">
  <div class="col-{{ md }} mb-40x">{{ image(imgurl, "class": "m-0-auto img-look", "alt": lkcorp['dslook']) }}</div>
  <div class="col-{{ md == 6 ? '6' : '12' }} col-lg-{{ md == 6 ? '6' : '12' }}">
    <div class="row">
    {% for item in lkcorp['items'] %}
      {% if lktest['fltipo'] == 0 %}
        {% if common['catalogProductType'] == 0 %}
          {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
            {% set link = url('model/' ~ item.cdartn) %}
          {% else %}
            {% set link = url('model/wizard/' ~ item.cdartn ~ '&lb=' ~ cdlkbk ~ '&lk=' ~ cdlook) %}
          {% endif %}
        {% else %}
          {% set link = url('model/' ~ item.cdarti) %}
        {% endif %}
        {% set code = item.cdartn %}
        {% set description = item.dsartn %}
        {% set flimag = item.flimag %}
      {% else %}
        {% if item.flimag_look != '' %}
          {% set flimag = item.flimag_look %}
        {% elseif item.flimag_arti != '' %}
          {% set flimag = item.flimag_arti %}
        {% elseif item.flimag_artn != '' %}
          {% set flimag = item.flimag_artn %}
        {% endif %}
        {% if lktest['fltipo'] == 1 %}
          {% set link = '#' %}
          {% set code = item.cdarti %}
          {% set description = item.dsarti %}
          {% set flimag = item.flimag %}
        {% else %}
          {% if common['catalogProductType'] == 0 %}
            {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
              {% set link = url('model/' ~ item.cdartn) %}
            {% else %}
              {% set link = url('model/wizard/' ~ item.cdartn ~ '/' ~ item.cdpers ~ '&lb=' ~ cdlkbk ~ '&lk=' ~ cdlook ~ '&cl=' ~ item.cdcolo) %}
            {% endif %}
          {% else %}
            {% set link = url('model/' ~ item.cdarti) %}
          {% endif %}
          {% set code = item.cdarti %}
          {% set description = item.dsarti %}
        {% endif %}
      {% endif %}
      <div class="col-{{ md == 6 ? '6' : '3' }} col-lg-{{ md == 6 ? '6' : '3' }} mb-20x py-0 px-40x fs11">
        <a href="{{ link }}" class="no-deco">
          <div class="image-model-box">{{ elements.getLookImgOrDefaultFromImgurl(flimag, description, ['title' : description]) }}</div>
          <div class="descr-model-box">{{ code }}</div>
          <div class="code-model-box">{{ description }}</div>
          {% if common['showCatalogPrice'] == 1 %}
             {# {{ elements.getPriceDiv(item.catalogPrice, item.cust_disc, common['currency'], common['cdvalu']) }} #}
             {{ elements.getPriceDiv(item.catalogPrice, item.cust_disc, common['currency'], common['cdvalu'], "center", link, item.cdartn ) }}
          {% endif %}
        </a>
      </div>
    {% endfor %}
    </div>
  </div>
</div>
