<div class="row featured-models-box">
  <div class="col-12 model-look">
    <span class="{{ elements.getHighlightClass() }} p-0-15x">{{ common['catalogProductType'] == 0 ? mt._('admin.featured.models') : mt._('admin.featured.articles') }}</span>
  </div>

{% for product in featured %}
  {% if common['catalogProductType'] == 0 %}
    {% set productCode = product.cdartn %}
    {% set productDes = product.dsartn %}
    {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
      {% set detailUrl = url('model/' ~ product.cdartn) %}
    {% else %}
      {% set detailUrl = url('model/wizard/' ~ product.cdartn) %}
    {% endif %}
  {% elseif common['catalogProductType'] == 1 %}
    {% set productCode = product.cdarti %}
    {% set productDes = product.dsarti %}
    {% set detailUrl = url('model/' ~ product.cdarti) %}
  {% elseif common['catalogProductType'] == 2 %}
    {% set productCode = product.cdarti ~ ' ' ~ product.color %}
    {% set productDes = product.dsarti %}
    {% set detailUrl = url('model/' ~ product.cdarti ~ '?COL=' ~ product.color) %}
  {% endif %}

  <div class="col-6 col-md-4 col-lg-3 model-box" id="{{ productCode }}">
    <div class="shop-item">
      <div class="image-model-box shop-thumbnail">
        <a href="{{ detailUrl }}" class="shop-thumbnail">
          {{ elements.getModelImgOrDefault(product.flimag, productDes, ["class": "mw-100"]) }}
        </a>
        <div class="shop-item-tools">
          <div class="w-50 float-left text-left">
            <a href="{{ detailUrl }}" class="d-none d-md-block btn-custom">{{ mt._('_common.seemore') }}</a>
          </div>
        </div>
      </div>
      <div class="descr-model-box">{{ productDes }}</div>
      <div class="code-model-box">{{ productCode }}</div>
      {% if common['showCatalogPrice'] == 1 %}
         {# {{ elements.getPriceDiv(product.catalogPrice, product.cust_disc, common['currency'], common['cdvalu'], detailUrl) }} #}
         {{ elements.getPriceDiv(product.catalogPrice, product.cust_disc, common['currency'], common['cdvalu'], "center", detailUrl,  product.cdartn ) }}
      {% endif %}

      {% if common['isOrder'] and common['order_info'].tpordc == 0 and not product.is_available %}
      <div class="availability-model-box text-center">{{ mt._('_common.notavailable') }}</div>
      {% endif %}
    </div>
  </div>
{% endfor %}
</div>
