<div id="visual-mode" class="fabrics-block">
  <div class="row">
    <div class="col-12 col-md-2">
      <div class="row">
        <div class='col-12 shop-item p-0' style="font-size:13px">
          <div class="mb-10x">{{ image(elements.getModelImageUrl(fabric.flimag), "alt": 'Articolo ' ~ fabric.dspers) }}</div>
          <div class='descr-fabric-box'>{{ fabric.dspers }}</div>
          <div class='code-fabric-box'>{{ fabric.cdpers }}</div>
          <div class='descr-composition-box'>{{ fabric.compos }}</div>
          {% if fabric.des_comm != '' %}
          <div class='descr-composition-box' style='text-transform:initial'>{{ fabric.des_comm }}</div>
          {% endif %}
        </div>
      {% if colors|length > 0 %}
        {% for color in colors %}
        <div class="col-6 mb-10x px-5x" style="font-size:12px">
          <div class='shop-thumbnail'><img src='{{ elements.getModelImageUrl(color["flimag"]) }}' alt='{{ color["cdcolo"] }}'/></div>
          <div class='code-fabric-box'>{{ color['cdcolo'] }}</div>
        </div>
        {% endfor %}
      {% endif %}
      </div>
    </div>
    <div class="col-12 col-md-9">
      <div class="row articles-container" id="articles-container">
    {% set lg = 'col-lg-3' %}
    {% if common['ItemsPerRow'] == 1 %}
      {% set lg = 'col-lg-4' %}
    {% elseif common['ItemsPerRow'] == 2 %}
      {% set lg = 'col-lg-6' %}
    {% endif %}

    {% set i = 12 %}
    {% for model in models %}
      {# SET PRICE #}
      {% set currentPrice = '' %}
      {% if common['showCatalogPrice'] == 1 %}
        {% set withDiscount = false %}
        {% set currentPrice = model.catalogPrice %}
        {% if currentPrice < 0 %}
          {% set currentPrice = mt._('quantity.priceforsize.short') %}
        {% elseif currentPrice == 0 %}
          {% set currentPrice = '-' %}
        {% else %}
          {% set real_price = currentPrice %}
          {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
          {% set disc_price = real_price * (1 - cust_disc / 100) %}
          {% set withDiscount = disc_price != real_price %}
          {% set currentPrice = disc_price|currency ~ ' ' ~ common['currency'] %}
        {% endif %}
      {% endif %}

      {# SET IMAGES #}
      {% set imgurl1 = "img/model/"  ~ model.flimag %}
      {% set imgurl2 = "img/model/"  ~ model.flimg2 %}
      <?php $exist1 = $model->flimag != '' && file_exists($imgurl1); ?>
      <?php $exist2 = $model->flimg2 != '' && file_exists($imgurl2); ?>
      {% if not exist1 %}{% set imgurl1 = "/assets/img/default_model.jpg" %}{% endif %}

        <div class="col-6 col-md-4 {{ lg }} model-box" id="{{ model.cdartn }}" data-code="{{ model.cdartn }}" data-price="{{ currentPrice }}" data-descr="{{ model.dsartn }}">

          <div class='shop-item'>
            <div class='image-model-box shop-thumbnail'>
              <a href="{{ not common['isOrder'] or common['order_info'].tpordc == 1 ? url('model/wizard/' ~ model.cdartn ~ '/' ~ fabric.cdpers) : url('model/' ~ model.cdartn) }}" class='no-deco'>
                {% if i > 0 %}
                  {% if exist2 %}
                    {{ image('assets/img/blank.gif', "alt": model.dsartn, "class": 'lazy', "data-src": url(imgurl1), "onmouseover": "this.src='" ~ url(imgurl2) ~ "'", "onmouseout": "this.src='" ~ url(imgurl1) ~ "'") }}
                  {% else %}
                    {{ image('assets/img/blank.gif', "alt": model.dsartn, "class": 'lazy', "data-src": url(imgurl1)) }}
                  {% endif %}
                  <noscript>
                {% endif %}
                {% if exist2 %}
                  {{ image(imgurl1, "alt": model.dsartn, "onmouseover": "this.src='" ~ url(imgurl2) ~ "'", "onmouseout": "this.src='" ~ url(imgurl1) ~ "'") }}
                {% else %}
                  {{ image(imgurl1, "alt": model.dsartn) }}
                {% endif %}
                {% if i > 0 %}
                </noscript>
                {% endif %}
              </a>

            </div>

            <div class='descr-model-box'>{{ model.dsartn }}</div>
            <div class='code-model-box'>{{ model.cdartn }}</div>
            {% if common['showCatalogPrice'] == 1 %}
              {{ elements.getPriceDiv(model.catalogPrice, model.cust_disc, common['currency'], common['cdvalu']) }}
            {% endif %}

          </div>
        </div>

      {% set i = i - 1 %}

    {% endfor %}
      </div>
    </div>
  </div>
</div>
