{# GLOBAL PRICES/QTY #}
{% set global_qty_total = 0 %}
{% set global_prc_tot = 0 %}
{% set global_prc_net = 0 %}
{% set global_dsc = '' %}

{% set thereAreDoubles = false %}

{# CALCULATE TOTALS FOR CUSTOM SHIPPING/PATYMENT #}
{% for article in articles %}
    {% set global_qty_total = global_qty_total + article["quanti"] %}

    {% set dontCheckPreagg = article['tppers'] != 'PT' or common['modelDetailStyle'] == 2 or article['cdvari'] == '' or common['modelDetailStyle'] == 4 %}

    {# CALCULATE PRICE, DISCOUNTS #}
    {% set price = article['octagl']|length > 0 ? article['octagl'][0].prezzo : 0 %}
    {% set tot_net = 0 %}
    {% set tot_grs = 0 %}

    {% if article['octagl']|length > 0 %}
        {# Discount part #}
        {% set discount_multiplier = 1 %}
        {% set text_discount = '' %}
        {% if common['order_info'].flnosc == 0 %}
            {% if article['promo_scont1'] != 0 or article['promo_scont2'] != 0 or article['promo_scont3'] != 0 %}
                {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont1'] / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont2'] / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont3'] / 100) %}
            {% elseif article['octagl']|length > 0 and article['octagl'][0].scont1 > 0 %}
                {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont1 / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont2 / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont3 / 100) %}
            {% elseif (common['order_info'].anagra_scont1 != 0 or common['order_info'].anagra_scont2 != 0 or common['order_info'].anagra_scont3 != 0) and
                (common['coupon_promo'] != 2 or promos|length == 0) %}
                {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont1 / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont2 / 100) %}
                {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont3 / 100) %}
            {% endif %}
        {% endif %}

        {% for size in article['octagl'] %}
            {% set cur_discount_multiplier = discount_multiplier %}
            {% if size.flprom is defined and size.flprom == 1 %}
                {% set cur_discount_multiplier = 1 %}
            {% endif %}
            {# Price part #}
            {% if dontCheckPreagg %}
                {% if article['promo_prezzo'] != 0 %}
                    {% set tot_grs = tot_grs + (article['promo_prezzo'] * size.quanti) %}
                    {% set tot_net = tot_net + (article['promo_prezzo'] * size.quanti * cur_discount_multiplier) %}
                {% else %}
                    {% set tot_grs = tot_grs + (size.prezzo * size.quanti) %}
                    {% set tot_net = tot_net + (size.prezzo * size.quanti * cur_discount_multiplier) %}
                {% endif %}
            {% else %}
                {% if article['promo_prezzo'] != 0 %}
                    {% set tot_grs = tot_grs + ((article['promo_prezzo'] + article['preagg']) * size.quanti) %}
                    {% set tot_net = tot_net + ((article['promo_prezzo'] + article['preagg']) * size.quanti * cur_discount_multiplier) %}
                {% else %}
                    {% set tot_grs = tot_grs + ((size.prezzo + article['preagg']) * size.quanti) %}
                    {% set tot_net = tot_net + ((size.prezzo + article['preagg']) * size.quanti * cur_discount_multiplier) %}
                {% endif %}
            {% endif %}
        {% endfor %}
    {% endif %}

    {% if article['ocasso'] is defined and article['ocasso']|length > 0 %}
        {% for ocasso in article['ocasso'] %}
            {% set totSingleAssortmentQty = 0 %}
            {% if ocasso.ascorp|length > 0 %}
                {% for ascorp in ocasso.ascorp %}
                    {% set totSingleAssortmentQty = totSingleAssortmentQty + ascorp.qtatgl %}
                {% endfor %}
            {% endif %}
            {% set tot_grs = tot_grs + (ocasso.quanti * totSingleAssortmentQty * price) %}
            {% set tot_net = tot_net + (ocasso.quanti * totSingleAssortmentQty * price) %}
        {% endfor %}
    {% endif %}

    {% set global_prc_tot = global_prc_tot + tot_grs %}
    {% set global_prc_net = global_prc_net + tot_net %}
{% endfor %}

{% set html_tppaga_dsk = '' %}
{% set html_tppaga_mob = '' %}
{% set html_tpport_dsk = '' %}
{% set html_tpport_mob = '' %}
{% set tppaga_preagg = 0 %}
{% set tpport_preagg = 0 %}

{% if payments|length > 0 and (payments[0]['tppaga'] != '' or payments[0]['dspaga'] != '') %}
    {% set just_printed_values = [] %}
    {% set custom_payments_check_value = (customPaymentMethod == 0 ? global_prc_net : global_qty_total) %}
    {% if common['paymentCondition'] != 3 or not common['isOrder'] %}
        {% set addDefault = true %}
        {% set checkRange = common['paymentCondition'] == 4 %}
        {% for el in payments %}
            {% set checked = (common['order_info'].tppaga is empty and loop.first) or common['order_info'].tppaga == el['tppaga'] %}

            {% set addThisCondition = (el['valmin'] == 0 or el['valmin'] < custom_payments_check_value) and (el['valmax'] == 0 or el['valmax'] >= custom_payments_check_value) %}
            {% if checkRange and addThisCondition %}
                {% if el['checkRange'] == 1 %}
                    {% set addDefault = false %}
                {% else %}
                    {% if not addDefault %}
                        {% set addThisCondition = false %}
                    {% endif %}
                {% endif %}
            {% endif %}

            {% if not( el['tppaga'] in just_printed_values ) and addThisCondition %}
                {% if el['tppaga'] == 'payp' %}
                    {% set tppaga_preagg = checked ? 0 : tppaga_preagg %}
                    {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'> PayPal " %}
                    {% set bfr = bfr ~ "<input type='radio' value='payp' data-dspaga='paypal' data-preagg='0' " %}
                    {% set aft = "> " ~ image('assets/img/paypal.png', 'alt': 'PayPal', 'class': 'h20') ~ "<span class='radio-checkmark'></span></label>" %}
                {% elseif el['tppaga'] == 'stri' %}
                    {% set tppaga_preagg = checked ? 0 : tppaga_preagg %}
                    {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'> " ~  mt._('cart.creditcard') %}
                    {% set bfr = bfr ~ " <input type='radio' value='stri' data-dspaga='stripe' data-preagg='0' " %}
                    {% set aft = "> " ~ image('assets/img/stripe.png', 'alt': 'Stripe', 'class': 'h20') ~ "<span class='radio-checkmark'></span></label>" %}
                {% else %}
                    {% set tppaga_preagg = checked ? el['preagg'] : tppaga_preagg %}
                    {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'>" %}
                    {% set bfr = bfr ~ "<input type='radio' value='" ~ el['tppaga'] ~ "' data-dspaga='" ~ el['dspaga'] ~ "' data-preagg='" ~ el['preagg'] ~ "' " %}
                    {% if common['paymentCondition'] == 1 %}
                        {% set bfr = bfr ~ "data-idcuspag='" ~ el['id'] ~ "'" %}
                    {% endif %}
                    {% set aft = "> " ~ el['dspaga'] ~ (el['preagg'] > 0 ? " +(" ~ el['preagg']|currency ~ " " ~ common['currency'] ~ ")" : "") %}
                    {% set aft = aft ~ "<span class='radio-checkmark'></span></label>" %}
                {% endif %}
                {% set html_tppaga_dsk = html_tppaga_dsk ~ bfr ~ "name='tppaga_radio' " ~ (checked ? 'checked="checked"': '') ~ aft %}
                {% set html_tppaga_mob = html_tppaga_mob ~ bfr ~ "name='tppaga_radio_mobile'" ~ (checked ? 'checked="checked"': '') ~ aft %}
                {# {{ array_push(just_printed_values, el['tppaga']) }} #}
                {% set just_printed_values = just_printed_values + [el['tppaga']] %}
            {% endif %}

        {% endfor %}
    {% else %}
        {% set html_tppaga_dsk = '<div class="form-element form-select m-0"><label class="form-custom-select m-0" style="border:0"><select id="select-tppaga" style="border: 2px solid #ededed;">' %}
        {% set html_tppaga_mob = '<div class="form-element form-select m-0"><label class="form-custom-select m-0" style="border:0"><select id="select-tppaga-mobile" style="border: 2px solid #ededed;">' %}
        {% for el in payments if (el['valmin'] == 0 or el['valmin'] < global_prc_net) and (el['valmax'] == 0 or el['valmax'] > global_prc_net) %}
            {% set checked = (common['order_info'].tppaga is empty and loop.first) or el['selected'] == 1 %}

            {% if el['tppaga'] == 'payp' %}
                {% set tppaga_preagg = checked ? 0 : tppaga_preagg %}
                {% set option = "<option value='payp' " ~ (checked ? 'selected' : '') ~ ">PayPal</option>" %}
            {% elseif el['tppaga'] == 'stri' %}
                {% set tppaga_preagg = checked ? 0 : tppaga_preagg %}
                {% set option = "<option value='stri' " ~ (checked ? 'selected' : '') ~ ">" ~ mt._('cart.creditcard') ~ "</option>" %}
            {% else %}
                {% set tppaga_preagg = checked ? el['preagg'] : tppaga_preagg %}
                {% set option = "<option value='" ~ el['tppaga'] ~ "' " ~ (checked ? 'selected' : '') ~ ">" ~ (el['dspaga'] != '' ? el['dspaga'] : el['tppaga']) ~ "</option>" %}
            {% endif %}
            {% set html_tppaga_dsk = html_tppaga_dsk ~ option %}
            {% set html_tppaga_mob = html_tppaga_mob ~ option %}
        {% endfor %}
        {% set html_tppaga_dsk = html_tppaga_dsk ~ "</select></label></div>" %}
        {% set html_tppaga_mob = html_tppaga_mob ~ "</select></label></div>" %}
    {% endif %}
{% else %}
    {% set tppaga_preagg = 0 %}
    {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'>" %}
    {% set bfr = bfr ~ "<input type='radio' value='NOCONDITION' " %}
    {% set aft = "> <span class='font-italic'>" ~ mt._('cart.nopayment') ~ "</span> <span class='radio-checkmark'></span></label>" %}
    {% set html_tppaga_dsk = html_tppaga_dsk ~ bfr ~ "name='tppaga_radio' checked" ~ aft %}
    {% set html_tppaga_mob = html_tppaga_mob ~ bfr ~ "name='tppaga_radio_mobile' checked" ~ aft %}
{% endif %}

{% if nuordc < 0 %}
    {% if common['paypal'] == 1 %}
        {# {% set tppaga_preagg = checked ? 0 : tppaga_preagg %} #}
        {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'> PayPal " %}
        {% set bfr = bfr ~ "<input type='radio' value='payp' data-dspaga='paypal' data-preagg='0' " %}
        {% set aft = "> " ~ image('assets/img/paypal.png', 'alt': 'PayPal', 'class': 'h20') ~ "<span class='radio-checkmark'></span></label>" %}
        {% set html_tppaga_dsk = html_tppaga_dsk ~ bfr ~ "name='tppaga_radio' " ~ aft %}
        {% set html_tppaga_mob = html_tppaga_mob ~ bfr ~ "name='tppaga_radio_mobile'" ~ aft %}

        {% if stripe %}
            {# {% set tppaga_preagg = checked ? 0 : tppaga_preagg %} #}
            {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'> " ~  mt._('cart.creditcard') %}
            {% set bfr = bfr ~ " <input type='radio' value='stri' data-dspaga='stripe' data-preagg='0' " %}
            {% set aft = "> " ~ image('assets/img/stripe.png', 'alt': 'Stripe', 'class': 'h20') ~ "<span class='radio-checkmark'></span></label>" %}
            {% set html_tppaga_dsk = html_tppaga_dsk ~ bfr ~ "name='tppaga_radio' " ~ aft %}
            {% set html_tppaga_mob = html_tppaga_mob ~ bfr ~ "name='tppaga_radio_mobile'" ~ aft %}
        {% endif %}
    {% endif %}
{% endif %}

{% if shipments|length > 0 and (shipments[0]['tpport'] != '' or shipments[0]['dstpor'] != '') %}
    {% set just_printed_values = [] %}
    {% set custom_shipping_check_value = (customShippingMethod == 0 ? global_prc_net : global_qty_total) %}
    {% if common['shippingCondition'] != 3 or not common['isOrder'] %}
        {% set addDefault = true %}
        {% set checkRange = common['shippingCondition'] == 4 %}
        {% for el in shipments %}
            {% set checked = (common['order_info'].tpport is empty and loop.first) or common['order_info'].tpport == el['tpport'] %}

            {% set addThisCondition = (el['valmin'] == 0 or el['valmin'] < custom_shipping_check_value) and (el['valmax'] == 0 or el['valmax'] >= custom_shipping_check_value) %}
            {% if checkRange and addThisCondition %}
                {% if el['checkRange'] == 1 %}
                    {% set addDefault = false %}
                {% else %}
                    {% if not addDefault %}
                        {% set addThisCondition = false %}
                    {% endif %}
                {% endif %}
            {% endif %}

            {% if not( el['tpport'] in just_printed_values ) and addThisCondition %}
                {% set tpport_preagg = checked ? el['preagg'] : tpport_preagg %}
                {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'>" %}
                {% set bfr = bfr ~ "<input type='radio' value='" ~ el['tpport'] ~ "' data-dstpor='" ~ el['dstpor'] ~ "' data-preagg='" ~ el['preagg'] ~ "' data-contra='" ~ (el['contra'] is defined ? el['contra'] : '') ~ "' " %}
                {% if common['shippingCondition'] == 1 %}
                    {% set bfr = bfr ~ "data-idcuspor='" ~ el['id'] ~ "'" %}
                {% endif %}
                {% set aft = "> " ~ el['dstpor'] ~ (el['preagg'] > 0 ? " +(" ~ el['preagg']|currency ~ " " ~ common['currency'] ~ ")" : "") %}
                {% if el['contra'] is defined and el['contra'] > 0 %}
                    {% set aft = aft ~ "<small> " ~ mt._('cart.shipping.contra') ~ " +(" ~ el['contra']|currency ~ " " ~ common['currency'] ~ ")</small>" %}
                {% endif %}
                {% set aft = aft ~ "<span class='radio-checkmark'></span></label>" %}
                {% set html_tpport_dsk = html_tpport_dsk ~ bfr ~ "name='tpport_radio' " ~ (checked ? 'checked="checked"': '') ~ aft %}
                {% set html_tpport_mob = html_tpport_mob ~ bfr ~ "name='tpport_radio_mobile'" ~ (checked ? 'checked="checked"': '') ~ aft %}
                {# {{ array_push(just_printed_values, el['tpport']) ? '' : '' }} #}
                {% set just_printed_values = just_printed_values + [el['tpport']] %}
            {% endif %}

        {% endfor %}
    {% else %}
        {% set html_tpport_dsk = '<div class="form-element form-select m-0"><label class="form-custom-select m-0" style="border:0"><select id="select-tpport" style="border: 2px solid #ededed;">' %}
        {% set html_tpport_mob = '<div class="form-element form-select m-0"><label class="form-custom-select m-0" style="border:0"><select id="select-tpport-mobile" style="border: 2px solid #ededed;">' %}
        {% for el in shipments if (el['valmin'] == 0 or el['valmin'] < global_prc_net) and (el['valmax'] == 0 or el['valmax'] > global_prc_net) %}
            {% set checked = (common['order_info'].tppaga is empty and loop.first) or el['selected'] == 1 %}

            {% set tpport_preagg = checked ? el['preagg'] : tpport_preagg %}
            {% set option = "<option value='" ~ el['tpport'] ~ "' " ~ (checked ? 'selected' : '') ~ ">" ~ (el['dstpor'] != '' ? el['dstpor'] : el['tpport']) ~ "</option>" %}
            {% set html_tpport_dsk = html_tpport_dsk ~ option %}
            {% set html_tpport_mob = html_tpport_mob ~ option %}
        {% endfor %}
        {% set html_tpport_dsk = html_tpport_dsk ~ "</select></label></div>" %}
        {% set html_tpport_mob = html_tpport_mob ~ "</select></label></div>" %}
    {% endif %}
{% else %}
    {% set tpport_preagg = 0 %}
    {% set bfr = "<label class='radio radio-container w-100 mx-0 mt-0 mb-10x fs11'>" %}
    {% set bfr = bfr ~ "<input type='radio' value='NOCONDITION' " %}
    {% set aft = "> <span class='font-italic'>" ~ mt._('cart.noshipping') ~ "</span> <span class='radio-checkmark'></span></label>" %}
    {% set html_tpport_dsk = html_tpport_dsk ~ bfr ~ "name='tpport_radio' checked" ~ aft %}
    {% set html_tpport_mob = html_tpport_mob ~ bfr ~ "name='tpport_radio_mobile' checked" ~ aft %}
{% endif %}

<div class='container container-fluid d-flex h-100 w-100 flex-column mw-100 p-0 m-0'>
    <div class='row cart-row-block pt-20x'>
        {# Header Desktop 1° Row, 1° Col / Mobile 1° Row: Order header info #}
        <div class='col-12 col-lg-6 float-left'>
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('cart.header.generalinfo') }}</div>
            </div>
            <div class='row'>
                <div class='col-auto'>
                    <span class='cart-title'>{{ mt._('_common.order') }}:</span>&nbsp;
                    <span class='cart-text'>{{ common['order_info'].nuordc }}</span>
                </div>
                <div class='col-auto'>
                    <span class='cart-title'>{{ mt._('_common.delivery') }}:</span>&nbsp;
                    <span class='cart-text'>
                        {% if config.release.user === 'bed' %}
                            {{ utility.recuperaDescrizioneConsegnaBed(common['order_info']) }}
                        {% else %}
                            {{ common['order_info'].dtmcli != '' ? common['order_info'].dtmcli : '' }}
                            {{ common['order_info'].dtmcoi != '' and common['order_info'].dtmcof != '' ? common['order_info'].dtmcoi ~ ' - ' ~ common['order_info'].dtmcof : '' }}
                        {% endif %}
          </span>
                </div>
                {% if common['order_info'].cdetic is not null %}
                    <div class='col-auto'>
                        <span class='cart-title'>{{ mt._('_common.label') }}:</span>&nbsp;
                        <span class='cart-text'>{{ common['order_info'].dsetic }}</span>
                    </div>
                {% endif %}
            </div>
            <div class='row'>
                <div class='col-12'>
                    <span class='cart-title'>{{ mt._('_common.customer') }}:</span>&nbsp;
                    <span class='cart-text'>{{ common['order_info'].cdanag }} - {{ common['order_info'].dsanag }}</span>
                </div>
            </div>
            <div class='row'>
                <div class='col-12'>
                    <span class='cart-title'>{{ mt._('_common.shipping') }}:</span>&nbsp;
                    <span class='cart-text'>{{ elements.getCartShippingText(common['order_info']) }}</span>
                </div>
            </div>

            {% if common['coupon_promo'] == 2 and promos|length > 0 %}
                <div class='row'>
                    <div class='col-12'>
          <span class='cart-title' data-toggle='tooltip'>
            {{ promos|length == 1 ? '1 ' ~ mt._('promo.appliedpromo') : promos|length ~ ' ' ~ mt._('promo.appliedpromos') }}
          </span>
                    </div>
                </div>
            {% endif %}
        </div>

        {# Header Dekstop 1° Row, 2° Col / Mobile hidden: Payment conditions #}
        <div class='d-none d-lg-block col-lg-6 float-left'>
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('account.customer.payment') }}</div>
            </div>
            <div class='row mt-8x'>
                <div class='col-12 cart-text'>
                    {{ html_tppaga_dsk }}
                </div>
            </div>
        </div>
    </div>

    <div class='row cart-row-block'>
        {# Header Desktop 2° Row, 1° Col / Mobile 2° Ro2: Notes #}
        <div class='col-12 col-lg-6 float-left'>
            {% if common['enable_cust_note'] == 1 or common['enable_comp_note'] == 1 %}
                <div class='row'>
                    <div class='{{ elements.getHighlightClass() }} model-look p-0-15x mt-10x mx-0 mb-0'>{{ mt._('_common.notes.order') }}</div>
                </div>
            {% endif %}

            {% if common['enable_cust_note'] == 1 %}
                <div class="row">
                    <div class="col-8 cart-title text-uppercase pt-8x">
                        {{ session.get('auth')['type'] == 3 ? mt._('cart.customernotes') : mt._('_common.notes') }}
                    </div>
                    <div class="col-8 form-element mb-0"
                         style="white-space:pre;font-size:.85em">{{ nuordc > 0 ? common['order_info'].notcli|escape : "<textarea rows='2' class='form-control' id='notcli'>" ~ common['order_info'].notcli ~ "</textarea>" }}</div>
                </div>
            {% endif %}

            {% if common['enable_comp_note'] == 1 and session.get('auth')['type'] == 3 %}
                <div class="row {{ common['enable_cust_note'] == 1 ? 'pt-10x' : '' }}">
                    <div class="col-8 cart-title text-uppercase">{{ mt._('cart.companynotes') }}</div>
                    <div class="col-8 form-element mb-0"
                         style="white-space:pre;font-size:.85em">{{ nuordc > 0 ? common['order_info'].notazi|escape : "<textarea rows='2' class='form-control' id='notazi'>" ~ common['order_info'].notazi ~ "</textarea>" }} </div>
                </div>
            {% endif %}
        </div>

        {# Header Desktop 2° Row, 2° Col / Mobile hidden: Shipping conditions #}
        <div class='d-none d-lg-block col-lg-6 float-left'>
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('account.customer.shipment') }}</div>
            </div>
            <div class="row mt-8x mb-30x">
                <div class="col-12 cart-text">
                    {{ html_tpport_dsk }}
                </div>
            </div>
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('_common.email') }}</div>
            </div>
            <div class="row mt-8x mb-30x">
                <div class="col-12 cart-text">
                    {% if common['isOrder'] %}
                        <input type="text" class="form-control" value="{{ common['order_info'].indema }}"
                               id="contact-email"/>
                    {% else %}
                        <span style="text-transform:none!important">{{ common['order_info'].indema }}</span>
                    {% endif %}
                </div>
            </div>
            {% if common['isOrder'] or (common['order_info'].conrif is defined and common['order_info'].conrif != '') %}
                <div class='row'>
                    <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('account.customer.referencecontact') }}</div>
                </div>
                <div class="row mt-8x">
                    <div class="col-12 cart-text">
                        {% if common['isOrder'] %}
                            <input type="text" class="form-control" value="{{ common['order_info'].conrif }}"
                                   id="contact-reference"/>
                        {% else %}
                            <span style="text-transform:none!important">{{ common['order_info'].conrif }}</span>
                        {% endif %}
                    </div>
                </div>
            {% endif %}
        </div>

    </div>

    <div class="row cart-row-block d-block d-lg-none">
        {# Header Mobile 3° Row: Payment conditions #}
        <div class="col-lg-12 float-left">
            <div class="row">
                <div class="{{ elements.getHighlightClass() }} model-look m-0 p-0-15x">{{ mt._('account.customer.payment') }}</div>
            </div>
            <div class="row">
                <div class="col-12 cart-text">
                    {{ html_tppaga_mob }}
                </div>
            </div>
        </div>
    </div>

    <div class="row cart-row-block d-block d-lg-none">
        {# Header Mobile 4° Row: Shipping conditions #}
        <div class="col-lg-12 float-left">
            <div class="row">
                <div class="{{ elements.getHighlightClass() }} model-look m-0 p-0-15x">{{ mt._('account.customer.shipment') }}</div>
            </div>
            <div class="row">
                <div class="col-12 cart-text">
                    {{ html_tpport_mob }}
                </div>
            </div>
        </div>
    </div>

    <div class="row cart-row-block d-block d-lg-none">
        {# Header Mobile 5° Row: Email #}
        <div class="col-lg-12 float-left">
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('_common.email') }}</div>
            </div>
            <div class="row mt-8x">
                <div class="col-12 cart-text">
                    {% if common['isOrder'] %}
                        <input type="text" class="form-control" value="{{ common['order_info'].indema }}"
                               id="contact-mobile-email"/>
                    {% else %}
                        <span style="text-transform:none!important">{{ common['order_info'].indema }}</span>
                    {% endif %}
                </div>
            </div>
        </div>
    </div>

    <div class="row cart-row-block d-block d-lg-none">
        {# Header Mobile 6° Row: Reference contact #}
        <div class="col-lg-12 float-left">
            <div class='row'>
                <div class='{{ elements.getHighlightClass() }} model-look m-0 p-0-15x'>{{ mt._('account.customer.referencecontact') }}</div>
            </div>
            <div class="row mt-8x">
                <div class="col-12 cart-text">
                    {% if common['isOrder'] %}
                        <input type="text" class="form-control" value="{{ common['order_info'].conrif }}"
                               id="contact-mobile-reference"/>
                    {% else %}
                        <span style="text-transform:none!important">{{ common['order_info'].conrif }}</span>
                    {% endif %}
                </div>
            </div>
        </div>
    </div>

    <div class="row cart-divider"></div>

    <div class="row bg-light cart-model-look-filters py-4">
        <div class="col-12 col-lg-8 offset-lg-2">
            <div class="form-inline justify-content-center">
                <label for="cart-list-text-filter" class="mr-3">{{ i18n._('cart.filter.text.label') }}</label>
                <div class="form-group mr-4">
                    <div class="px-2" style="border-bottom:1px black solid;min-width:200px">
                        <input type="image" width="24" name="submit" class="float-right" src="{{ static_url('assets/img/search.png') }}" alt="{{ i18n._('cart.filter.text.search') }}" title="{{ i18n._('cart.filter.text.search') }}" style="margin-top:10px"/>
                        <input type="text" name="search" class="form-control search-product px-2 py-0 mb-0" id="cart-list-text-filter" placeholder="{{ i18n._('cart.filter.text.search') }}" style="border:none!important;width:calc(100% - 30px)">
                    </div>
                </div>
                <div class="filters-divider"></div>
                <label for="cart-list-qty-filter" class="mr-3">{{ i18n._('cart.filter.qty.label') }}</label>
                <div class="form-group" style="min-width:175px">
                    <select class="form-control selectpicker" id="cart-list-qty-filter">
                        <option value="-1">{{ i18n._('cart.filter.qty.all') }}</option>
                        <option value="1">{{ i18n._('cart.filter.qty.gt0') }}</option>
                        <option value="0">{{ i18n._('cart.filter.qty.eq0') }}</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="row cart-model-look">
        <div class="{{ elements.getHighlightClass() }} cart-articles-title">{{ mt._('_common.cart.articles') }}</div>
    </div>

    <div class="row cart-list-header d-none d-lg-block">
        <div class="col-4 pl-25x">{{ mt._('cart.header.articles') }}</div>
        <div class="col-4">{{ mt._('_common.sizes.qty') }}</div>
        <div class="col-4">{{ mt._('_common.info') }}</div>
    </div>

    {# CART ROWS #}
    {% for article in articles %}
        {# LINK TO INSERT QUANTITY #}
        {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
            {% if common['catalogProductType'] == 0 %}
                {% set art_url = url('model/' ~ article['cdartn']) ~ (article['tppers'] == 'PT' ? '/' ~ article['cdpers'] ~ '/' ~ article['cdcolo'] : '') %}
            {% else %}
                {% set art_url = url('model/' ~ article['cdarti']) %}
            {% endif %}
        {% else %}
            {% set art_url = url('model/wizard/' ~ article['cdartn']) %}
        {% endif %}

        {% set dontCheckPreagg = article['tppers'] != 'PT' or common['modelDetailStyle'] == 2 or article['cdvari'] == '' or  common['modelDetailStyle'] == 4 %}

        {# DESCRIPTION - MODAL #}
        {% if article['tppers'] != 'PT' %}
            {% if common['description'] == 0 %}{% set descr_modal1 = article['cdarti'] %}{% set descr_modal2 = article['dsarti'] %}
            {% elseif common['description'] == 1 %}{% set descr_modal1 = article['cdcolo'] %}{% set descr_modal2 = article['dsarti'] %}
            {% elseif common['description'] == 2 %}{% set descr_modal1 = article['cdcolo'] %}{% set descr_modal2 = article['dscolo'] %}
            {% elseif common['description'] == 3 %}{% set descr_modal1 = article['cdarti'] %}{% set descr_modal2 = article['dscolo'] %}
            {% endif %}
        {% else %}
            {% set descr_modal1 = article['cdarti'] %}{% set descr_modal2 = article['cdcolo'] %}
        {% endif %}

        {# DISPLAY INFO #}
        {% set row_info = '&nbsp;' %}
        {% if not dontCheckPreagg %}
            {% set row_info = "<span class='cart-row-delivery'>" ~ mt._('_common.variant') ~ ': ' ~ article['cdvari'] ~ '</span>' %}
        {% elseif common['modelDetailStyle'] == 2 and article['cdvari'] != '' %}
            {% set row_info = "<span class='cart-row-delivery'>" ~ article['dsvari'] ~ '</span>' %}
        {% endif %}

        {% set order_row_info = '' %}
        {% if common['showRowDelivery'] > 0 and article['dtmcli'] != '00/00/0000' and article['dtmcli'] != common['order_info'].dtmcli %}
            {% if common['showRowDelivery'] == 1 %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.delivery') ~ ': ' ~ article['dtmcli'] %}
            {% elseif common['showRowDelivery'] == 2 and article['dsscad'] != '' %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.delivery') ~ ': ' ~ article['dsscad'] %}
            {% endif %}
        {% endif %}

        {% if common['showRowIndicative'] > 0 %}
            {% if common['showRowIndicative'] == 1 and article['indorc'] != '' %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.indicative') ~ ': ' ~ article['indorc'] %}
            {% elseif common['showRowIndicative'] == 2 and article['dsindo'] != '' %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.indicative') ~ ': ' ~ article['dsindo'] %}
            {% endif %}
        {% endif %}

        {% if common['showRowNotes'] > 0 %}
            {% if common['showRowNotes'] == 1 and article['dsnoco'] != '' %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.notes') ~ ': ' ~ article['dsnoco'] %}
            {% elseif common['showRowNotes'] == 2 and article['noccom_dsnoco'] != '' %}
                {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.notes') ~ ': ' ~ article['noccom_dsnoco'] %}
            {% endif %}
        {% endif %}

        {% if common['showRowReference'] > 0 and article['sgrifc'] != '' %}
            {% set order_row_info = order_row_info ~ (order_row_info != '' ? ' - ' : '') ~ mt._('_common.reference') ~ ': ' ~ article['sgrifc'] %}
        {% endif %}

        {#
        {% if article['sgrifc'] != '' or article['tpindo'] != '' or article['indorc'] != '' or
              article['tpnoco'] != '' or article['dsnoco'] != '' %}
          {% set row_info = row_info ~
            " <a href='#' class='info-opener' data-toggle='modal' data-target='.modal-row-info'
                data-sgrifc='" ~ article['sgrifc'] ~ "'
                data-tpindo='" ~ article['tpindo'] ~ "'
                data-indorc='" ~ article['indorc'] ~ "'
                data-tpnoco='" ~ article['tpnoco'] ~ "'
                data-dsnoco='" ~ article['dsnoco'] ~ "'
                data-dsmod1='" ~ descr_modal1 ~ "'
                data-dsmod2='" ~ descr_modal2 ~ "'>
                <i class='fa fa-info-circle info-img pl-0' aria-hidden='true' style='float:none'></i>
              </a>" %}
        {% endif %}
        {% if article['dtmcli'] != '00/00/0000' and article['dtmcli'] != common['order_info'].dtmcli %}
          {% set row_info = row_info ~ "<br/><span class='cart-row-delivery'>" ~ mt._('_common.delivery') ~ ": " ~ article['dtmcli'] ~ "</span>" %}
        {% endif %}
        #}

        {# CALCULATE PRICE, DISCOUNTS #}
        {% set price_for_size = false %}
        {% set price = article['octagl']|length > 0 ? article['octagl'][0].prezzo : 0 %}
        {% set publicPrice = '' %}
        {% set tot_net = 0 %}
        {% set tot_grs = 0 %}

        {% if article['octagl']|length > 0 %}
            {# Discount part #}
            {% set discount_multiplier = 1 %}
            {% set text_discount = '' %}
            {% if common['order_info'].flnosc == 0 %}
                {% if article['promo_scont1'] != 0 or article['promo_scont2'] != 0 or article['promo_scont3'] != 0 %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont1'] / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont2'] / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['promo_scont3'] / 100) %}
                {% elseif article['octagl']|length > 0 and article['octagl'][0].scont1 > 0 %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont1 / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont2 / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - article['octagl'][0].scont3 / 100) %}
                {% elseif (common['order_info'].anagra_scont1 != 0 or common['order_info'].anagra_scont2 != 0 or common['order_info'].anagra_scont3 != 0) and
                    (common['coupon_promo'] != 2 or promos|length == 0) %}
                    {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont1 / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont2 / 100) %}
                    {% set discount_multiplier = discount_multiplier * (1 - common['order_info'].anagra_scont3 / 100) %}
                {% endif %}
            {% endif %}

            {% set tooltip = '' %}
            {% for size in article['octagl'] %}
                {% set tooltip = tooltip ~ '<li>' ~ size.taglia ~ ': ' ~ size.prezzo|currency ~ ' ' ~ common['currency'] ~ '</li>' %}

                {% set cur_discount_multiplier = discount_multiplier %}
                {% if size.flprom is defined and size.flprom == 1 %}
                    {% set cur_discount_multiplier = 1 %}
                {% endif %}
                {# Price part #}
                {% if dontCheckPreagg %}
                    {% if article['promo_prezzo'] != 0 %}
                        {% set tot_grs = tot_grs + (article['promo_prezzo'] * size.quanti) %}
                        {% set tot_net = tot_net + (article['promo_prezzo'] * size.quanti * cur_discount_multiplier) %}
                    {% else %}
                        {% set tot_grs = tot_grs + (size.prezzo * size.quanti) %}
                        {% set tot_net = tot_net + (size.prezzo * size.quanti * cur_discount_multiplier) %}
                    {% endif %}
                {% else %}
                    {% if article['promo_prezzo'] != 0 %}
                        {% set tot_grs = tot_grs + ((article['promo_prezzo'] + article['preagg']) * size.quanti) %}
                        {% set tot_net = tot_net + ((article['promo_prezzo'] + article['preagg']) * size.quanti * cur_discount_multiplier) %}
                    {% else %}
                        {% set tot_grs = tot_grs + ((size.prezzo + article['preagg']) * size.quanti) %}
                        {% set tot_net = tot_net + ((size.prezzo + article['preagg']) * size.quanti * cur_discount_multiplier) %}
                    {% endif %}
                {% endif %}
                {% if price != size.prezzo %}
                    {% set price_for_size = true %}
                {% endif %}
            {% endfor %}
            {% if common['showPublicPrice'] and not price_for_size and article['octagl'][0].prezzo_r is defined and price != article['octagl'][0].prezzo_r and article['octagl'][0].prezzo_r > 0 %}
                {% set publicPrice = "<div class='col-2 cart-public-price cart-info-text'>(RP " ~ article['octagl'][0].prezzo_r|currency ~ " " ~ article['octagl'][0].cdvalu_r ~ ")</div>" %}
            {% endif %}
        {% endif %}

        {% if article['ocasso'] is defined and article['ocasso']|length > 0 %}
            {% for ocasso in article['ocasso'] %}
                {% set totSingleAssortmentQty = 0 %}
                {% if ocasso.ascorp|length > 0 %}
                    {% for ascorp in ocasso.ascorp %}
                        {% set totSingleAssortmentQty = totSingleAssortmentQty + ascorp.qtatgl %}
                    {% endfor %}
                {% endif %}
                {% set tot_grs = tot_grs + (ocasso.quanti * totSingleAssortmentQty * price) %}
                {% set tot_net = tot_net + (ocasso.quanti * totSingleAssortmentQty * price) %}
            {% endfor %}
        {% endif %}

        {% set curr_dsc_val = tot_grs - tot_net %}
        {% if curr_dsc_val > 0 %}
            {% set curr_dsc_per = tot_grs != 0 ? 100 - (tot_net * 100 / tot_grs) : 0 %}
            {% set text_discount = "(-" ~ curr_dsc_per|currency ~ "%) -" ~ curr_dsc_val|currency ~ " " ~ common['currency'] %}
        {% else %}
            {% set text_discount = "-" %}
        {% endif %}

        {# DESKTOP BODY #}
        <div class='row cart-list-row {% if loop.index == 1 %}no-border{% endif %}'
             data-quanti="{{ article['quanti'] }}"
             data-search={{ (article['cdarti']|lower ~ article['dsarti']|lower)|json_encode }}
             data-nurorc="{{ article['nurorc'] }}"
             data-tglini="{{ article['tglini'] }}"
             data-tglfin="{{ article['tglfin'] }}"
             data-cdtagl="{{ article['cdtagl'] }}">
            <div class='col-4 col-md-6 col-lg-4'>
                <div class='row d-none d-md-block pb-10x'>
                    <div class='col-12'>
                        {% set thereAreDoubles = article["doubleCount"] is defined and article["doubleCount"] > 1 %}

                        {% if nuordc < 0 and common['multipleInsert'] == 1 %}
                            <div class="float-left row-selector-container">
                                <input type="checkbox" id="row-selector-{{ article['nurorc'] }}"
                                       class="row-selector checkbox-custom">
                                <label for="row-selector-{{ article['nurorc'] }}" class="checkbox-custom-label"></label>
                            </div>
                        {% endif %}
                        <div class='cart-text {{ thereAreDoubles ? "double-cart-row" : "" }}'>
                            {% if thereAreDoubles %}
                                <i class="fa fa-exclamation font-weight-bold red-mark" data-toggle="tooltip"
                                   title="{{ mt._('order.therearedouble') }}"></i>
                            {% endif %}
                            {% if common['modelDetailStyle'] != 5 %}
                                {{ common['modelDetailStyle'] != 3 ? elements.getCartDescr(article, 2, common['description']) : elements.getCartDescr(article, 1) }}
                            {% else %}
                                {{ article["cdcolo"] == 'CUSTOM' ? article['cdartn'] ~ '-C' : '' }}{{ article["cdarti"] }}
                            {% endif %}
                        </div>
                        <div class='cart-title'>
                            {% if (common['modelDetailStyle'] == 5 and article["cdcolo"] == "CUSTOM") or (common['modelDetailStyle'] == 3 and thereAreDoubles) %}
                            <span class="{{ elements.getHighlightClass() }}">
                            {% endif %}
                                {% if common['modelDetailStyle'] != 5 %}
                                    {{ common['modelDetailStyle'] != 3 ? elements.getCartDescr(article, 1) : elements.getCartDescr(article, 3) }}
                                {% else %}
                                    {% if article["components"]|length > 0 %}
                                        {% for component in article["components"] %}
                                            {{ component.cdmate }}{{ substr(component.tpcomp, 0, 2) == '10' ? ' - ' ~ component.dsmate : '' }}{{ not loop.last ? ' / ' : '' }}
                                        {% endfor %}
                                    {% else %}
                                        {{ article["dsarti"] }}
                                    {% endif %}
                                {% endif %}
                                {% if (common['modelDetailStyle'] == 5 and article["cdcolo"] == "CUSTOM") or (common['modelDetailStyle'] == 3 and thereAreDoubles) %}
                                </span>
                            {% endif %}
                        </div>
                    </div>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-4 p-0'>
                        {# Model image #}
                        {% if common['imagesOnSummary'] == 0 %}
                            <a href='{{ art_url }}'
                               class='model-img nodeco'>{{ elements.getModelImgOrDefault(article["flimag_n"], article['dsartn'], ['class': 'mw-70']) }}</a>
                        {% else %}
                            <a href='{{ art_url }}'
                               class='model-img nodeco'>{{ elements.getModelImgOrDefault(article["flimag_i"], article['dsarti'], ['class': 'mw-70']) }}</a>
                        {% endif %}
                    </div>
                    <div class='d-none d-md-block col-md-6 p-0 pl-5x'>
                        <div class='h-50'>
                            {# Color image - Desktop #}
                            {% if article['tppers'] == 'PT' %}
                                <a href='{{ art_url }}' class='color-img nodeco' style='height:100%;display:flex'>
                                    {{ elements.getModelImgOrDefault(article["flimag_c"], article['dscolo'], ['style': 'max-width:45%;width:auto;object-fit:contain']) }}
                                </a>
                            {% endif %}
                        </div>
                        <div class='h-50'>
                            {% if common['imagesOnSummary'] == 0 %}
                                {# Article/Fabric image - Desktop #}
                                {% if common['modelDetailStyle'] != 2 %}
                                    <a href='{{ art_url }}' class='nodeco' style='height:100%;display:flex'>
                                        {{ elements.getModelImgOrDefault(article["flimag_i"], article['dsarti'], ['style': 'max-width:45%;width:auto;object-fit:contain']) }}
                                    </a>
                                {% endif %}
                            {% endif %}
                        </div>
                    </div>
                    <div class='d-block d-md-none col-12 col-md-4 mob-img'>
                        {% if common['imagesOnSummary'] == 0 %}
                            {# Article/Fabric image - Mobile #}
                            {% if common['modelDetailStyle'] != 2 %}
                                <a href='{{ art_url }}'
                                   class='nodeco'>{{ elements.getModelImgOrDefault(article["flimag_i"], article['dsarti'], ['style': 'width:31%']) }}</a>
                            {% endif %}
                            {# Color image - Mobile #}
                            {% if article['tppers'] == 'PT' %}
                                <a href='{{ art_url }}'
                                   class='nodeco'>{{ elements.getModelImgOrDefault(article["flimag_c"], article['dscolo'], ['style': 'width:31%']) }}</a>
                            {% endif %}
                        {% endif %}
                    </div>
                    <div class='d-block d-md-none col-12 col-md-4 mob-img'>{{ row_info }}</div>
                </div>
            </div>

            <div class='d-none d-lg-block col-lg-4'>

                {# Sizes #}
                {% if article['octagl'] is defined and article['octagl']|length > 0 %}
                    {% for size in article['octagl'] %}
                        {% set css = '' %}
                        {% if nuordc < 0 and common['order_info'].tpordc == 0 and size.quanti > 0 and size.quanti > size.disp %}{% set css = css ~ ' qtyerr_box ' %}{% endif %}
                        {% if size.flprom is defined and size.flprom == 1 and size.quanti > 0 %}{% set css = css ~ ' flprom_box ' %}{% endif %}
                        {% if nuordc < 0 and common['order_info'].tpordc == 0 and size.quanti > 0 and size.quanti == size.disp %}{% set css = css ~ ' end-qty ' %}{% endif %}
                        <div class='cart-qty-container'>
                            <div class='cart-size-title'>{{ size.taglia }}</div>
                            <div class='cart-size-box {{ css }}'>{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                        </div>
                    {% endfor %}
                {% endif %}

                {# Assortments #}
                {% if showAssortments == 1 %}
                    {% if article['ocasso'] is defined and article['ocasso']|length > 0 %}
                        {% for item in article['ocasso'] %}
                            {% set title = '' %}
                            {% for el in item.ascorp if el['qtatgl'] > 0 %}
                                {% if title != '' %}{% set title = title ~ ' - ' %}{% endif %}
                                {% set title = title ~ el['qtatgl'] ~ 'x' ~ el['taglia'] %}
                            {% endfor %}
                            <div class="cart-qty-container">
                                <div class="cart-size-title cart-asso" data-toggle="tooltip"
                                     title="{{ title }}">{{ item.cdasso }}</div>
                                <div class="cart-size-box"
                                     title="{{ title }}">{{ item.quanti > 0 ? item.quanti : '&nbsp;' }}</div>
                            </div>
                        {% endfor %}
                    {% endif %}
                {% endif %}
            </div>

            <div class="col-8 col-md-6 col-lg-4">
                <div class="row d-block d-sm-none pb-10x">
                    <div class="col-12 p-0">
                        <div class="cart-text">{{ elements.getCartDescr(article, 2, common['description']) }}</div>
                        <div class="cart-title">{{ elements.getCartDescr(article, 1) }}</div>
                    </div>
                </div>
                <div class="row pb-5x">
                    <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.total.qty') }}</div>
                    <div class="col-5 col-lg-4 cart-info-text">{{ article["quanti"] }}</div>
                </div>
                <div class="row pb-5x">
                    <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.price.unit') }}</div>
                    {% set colSpan = 'col-5 col-lg-4' %}
                    {% if publicPrice != '' %}
                        {% set colSpan = 'col-3 col-lg-2' %}
                        {{ publicPrice }}
                    {% endif %}
                    {% if price_for_size %}
                        <div class="{{ colSpan }} cart-info-text" data-toggle="tooltip" data-html="true"
                             title="<ul>{{ tooltip }}</ul>">{{ mt._('quantity.priceforsize') }}</div>
                    {% endif %}
                    {% if not price_for_size %}
                        <div class="{{ colSpan }} cart-info-text">{{ dontCheckPreagg ? price|currency : (price + article["preagg"])|currency }} {{ common['currency'] }}</div>
                    {% endif %}
                </div>
                <div class="row pb-5x">
                    <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.amount.gross') }}</div>
                    <div class="col-5 col-lg-4 cart-info-text">{{ tot_grs|currency }} {{ common['currency'] }}</div>
                </div>
                <div class="row pb-5x">
                    <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.discount') }}</div>
                    <div class="col-5 col-lg-4 cart-info-text">{{ text_discount }}</div>
                </div>
                <div class="row pb-5x">
                    <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.taxable') }}</div>
                    <div class="col-5 col-lg-4 cart-info-text">{{ tot_net|currency }} {{ common['currency'] }}</div>
                </div>
                {% set tooltip = '' %}
                {% set isPublicPricePresent = false %}
                {% set isPublicPricePerSize = false %}
                {% set currPublicPrice = article["preven"]|length > 0 ? article["preven"][0].preven : 0 %}
                {% for price in article["preven"] %}
                    {% set tooltip = tooltip ~ '<li>' ~ price.taglia ~ ': ' ~ price.preven|currency ~ ' ' ~ common['currency'] ~ '</li>' %}
                    {% if price.preven > 0 %}
                        {% set isPublicPricePresent = true %}
                    {% endif %}
                    {% if price.preven != currPublicPrice %}
                        {% set isPublicPricePerSize = true %}
                    {% endif %}
                {% endfor %}
                {% if isPublicPricePresent %}
                    <div class="row pb-5x">
                        <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">{{ mt._('_common.price.public') }}</div>
                        <div class="col-5 col-lg-4 cart-info-title text-right"
                                {{ isPublicPricePerSize ? 'data-toggle="tooltip" data-html="true" title="<ul>' ~ tooltip ~ '</ul>"' : '' }} >
                            {% if isPublicPricePerSize %}
                                {{ mt._('quantity.priceforsize.short') }}
                            {% else %}
                                {{ currPublicPrice|currency }} {{ common['currency'] }}
                            {% endif %}
                        </div>
                    </div>
                {% endif %}
                {% if nuordc < 0 %}
                    <div class="row row-cart-btn d-none d-lg-block pt-28x"
                         data-cdarti="{{ article['cdarti'] }}"
                         data-cdcolo="{{ article['cdcolo'] }}"
                         data-cdtagl="{{ article['cdtagl'] }}"
                            {% if common['modelDetailStyle'] == 2 %}
                                data-cdartn="{{ article['cdartn'] }}"
                                data-dsartn="{{ article['dsartn'] }}"
                                data-cdpers="{{ article['cdpers'] }}"
                                data-dscolo="{{ article['dscolo'] }}"
                                data-cdvari="{{ article['cdvari'] }}"
                                data-dsvari="{{ article['dsvari'] }}"
                                data-dtmcli="{{ article['dtmcli'] }}"
                                data-dsnoco="{{ article['dsnoco'] }}"
                                data-regqtm-qtamin="{{ article['rm_qtamin'] is defined ? article['rm_qtamin'] : 0 }}"
                                data-regqtm-qtamul="{{ article['rm_qtamul'] is defined ? article['rm_qtamul'] : 1 }}"
                            {% endif %}
                         data-tppers="{{ article['tppers'] }}"
                         data-tglini="{{ article['tglini'] }}"
                         data-tglfin="{{ article['tglfin'] }}"
                         data-scala-taglie-completa="{{ (common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0') }}"
                         data-nurorc="{{ article['nurorc'] }}">
                        {#  Ho duvuto mettere il del php raw perche' il compilatore volt non scriveva
                            la riga contentent l'else quindi finiva tutto dentro all'if principale #}
                        <?php if ($common['modelDetailStyle'] != 2): ?>
                        <div class="col-lg-5 float-left">
                            <a href="#" class="modify-row btn-custom">{{ mt._('_common.modify') }}</a>
                        </div>
                        <div class="col-lg-5 float-left text-right">
                            <a href="#" class="delete-row float-right btn-custom"
                               data-toggle="modal"
                               data-target="{{ articles|length > 1 ? '.modal-delete-row-order' : '.modal-cancel-order' }}">{{ mt._('_common.delete') }}</a>
                        </div>
                        <?php else : ?>
                        <div class="col-lg-5 float-left">
                            <a href="#" class="delete-row btn-custom"
                               data-toggle="modal"
                               data-target="{{ articles|length > 1 ? '.modal-delete-row-order' : '.modal-cancel-order' }}">{{ mt._('_common.delete') }}</a>
                        </div>
                        <div class="col-lg-5 float-left text-right">
                            <a href="#"
                               class="modify-row-quantity float-right btn-custom">{{ mt._('_common.modify.quantity') }}</a><br/>
                            <a href="#"
                               class="modify-row-variants float-right btn-custom">{{ mt._('_common.modify.variants') }}</a>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <div class="offset-0 col-12 offset-md-2 col-md-10 offset-lg-0 col-lg-10 text-center msg-error w-100">{{ mt._('cart.lastrow.warning') }}</div>
                    </div>
                {% endif %}
            </div>
            {% if common['showRowDelivery'] > 0 or common['showRowIndicative'] > 0 or common['showRowNotes'] > 0 or common['showRowReference'] > 0 %}

                {% if common['showRowDelivery'] == 4 %}
                    <div class="col-12 mt-15x">
                        <div class="offset-0 col-7 offset-md-2 col-md-5 offset-lg-0 col-lg-6 cart-info-title">
                            {{ mt._('_common.delivery') }}: {{ article['dtmcli'] }}
                        </div>
                    </div>
                {% endif %}

                <div class="col-12 mt-15x">
                    {% if nuordc < 0 %}
                        <div><a href="#" class="modify-order-row-info btn-custom">{{ mt._('_common.modify.info') }}</a>
                        </div>
                    {% endif %}
                    <div class="order-row-info" style="font-style:italic">{{ order_row_info }}</div>
                </div>
            {% endif %}

            {% if article['dtdrop'] != '' %}
                <div class="col-12 mt-15x" style="line-height:42px">{{ mt._('_common.delivery') }}
                    : {{ article['dtdrop'] }}</div>
            {% endif %}

            {% if article['cddrop'] != '' %}
                <div class="col-12 mt-15x" style="line-height:42px">{{ mt._('_common.drop') }}
                    : {{ article['cddrop'] }}</div>
            {% endif %}

            {% if common['shippingsOnRows'] > 0 %}
                <div class="col-12 mt-15x">
                    <div class="row">
                        {% if nuordc < 0 %}
                            <div class="col-1 text-right" style="line-height:42px">{{ mt._('_common.shipping') }}</div>
                            <div class="col-4 form-element form-select m-0">
                                <label class="form-custom-select m-0" style="border:0">
                                    <select class="select-cddesm" style="border: 2px solid #ededed;">
                                        <option value="" {{ article['cddesm'] == '' ? 'selected' : '' }}>
                                            {{ common['order_info'].indiri_a }}
                                            {{ common['order_info'].ccitta_a != '' ? ' - ' ~ common['order_info'].ccitta_a : '' }}
                                            {{ common['order_info'].provin_a != '' ? ' (' ~ common['order_info'].provin_a ~ ')': '' }}
                                            {{ common['order_info'].dsnazi_a != '' ? ' - ' ~ common['order_info'].dsnazi_a : '' }}
                                        </option>
                                        {% if rowsShippings|length > 0 %}
                                            {% for shipping in rowsShippings %}
                                                <option value="{{ shipping.cddesm }}" {{ article['cddesm'] == shipping.cddesm ? 'selected' : '' }}>{{ elements.printAddress(shipping) }}</option>
                                            {% endfor %}
                                        {% endif %}
                                    </select>
                                </label>
                            </div>
                        {% else %}
                            <div class="col-1 text-right">{{ mt._('_common.shipping') }}:</div>
                            <div class="col-4">
                                {% if article['cddesm'] == '' %}
                                    {{ common['order_info'].indiri_a }}
                                    {{ common['order_info'].ccitta_a != '' ? ' - ' ~ common['order_info'].ccitta_a : '' }}
                                    {{ common['order_info'].provin_a != '' ? ' (' ~ common['order_info'].provin_a ~ ')': '' }}
                                    {{ common['order_info'].dsnazi_a != '' ? ' - ' ~ common['order_info'].dsnazi_a : '' }}
                                {% else %}
                                    {{ elements.printAddress(article['shipping']) }}
                                {% endif %}
                            </div>
                        {% endif %}
                    </div>
                </div>

            {% endif %}
        </div>

        <div class='row cart-list-row-under d-block d-lg-none row-cart-btn'
             data-cdarti="{{ article['cdarti'] }}"
             data-cdcolo="{{ article['cdcolo'] }}"
             data-cdtagl="{{ article['cdtagl'] }}"
             data-tppers="{{ article['tppers'] }}"
             data-tglini="{{ article['tglini'] }}"
             data-tglfin="{{ article['tglfin'] }}"
             data-scala-taglie-completa="{{ (common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0') }}"
             data-nurorc="{{ article['nurorc'] }}">
            <div class="col-4 float-left text-left"><a href='#' class='delete-row btn-custom' data-toggle='modal'
                                                       data-target='.modal-delete-row-order'>{{ mt._('_common.delete') }}</a>
            </div>
            <div class="col-4 float-left text-center"><u>{{ mt._('_common.sizes.qty') }}</u></div>
            <div class="col-4 float-left text-right"><a href='#'
                                                        class='modify-row btn-custom'>{{ mt._('_common.modify') }}</a>
            </div>
            <div class="col-12 float-left row-opener">
                <div class="row m-0-auto" style="display:table">
                    <div class="col-4 offset-4 text-center article-qty-opener m-0">
                        <i class="fa fa-caret-down" aria-hidden="true" data-row="{{ loop.index }}"></i>
                    </div>
                </div>
            </div>
            <div class="col-12 float-left sizes-detail sm-centering sm-space-footer" style="display:none">
                {# Sizes #}
                {% if article["octagl"] is defined and article["octagl"]|length > 0 %}
                    {% for size in article["octagl"] %}
                        {% set css = "" %}
                        {% if nuordc < 0 and common['order_info'].tpordc == 0 and size.quanti > 0 and size.quanti > size.disp %}{% set css = css ~ " qtyerr_box " %}{% endif %}
                        {% if size.flprom is defined and size.flprom == 1 and size.quanti > 0 %}{% set css = css ~ " flprom_box " %}{% endif %}
                        {% if nuordc < 0 and common['order_info'].tpordc == 0 and size.quanti > 0 and size.quanti == size.disp %}{% set css = css ~ " end-qty " %}{% endif %}
                        <div class="cart-qty-container">
                            <div class="cart-size-title">{{ size.taglia }}</div>
                            <div class="cart-size-box {{ css }}">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                        </div>
                    {% endfor %}
                {% endif %}

                {# Assortments #}
                {% if showAssortments == 1 %}
                    {% if article["ocasso"] is defined and article["ocasso"]|length > 0 %}
                        {% for item in article["ocasso"] %}
                            {% set title = "" %}
                            {% for el in item.ascorp if el['qtatgl'] > 0 %}
                                {% if title != "" %}{% set title = title ~ " - " %}{% endif %}
                                {% set title = title ~ el['qtatgl'] ~ "x" ~ el['taglia'] %}
                            {% endfor %}
                            <div class="cart-qty-container">
                                <div class="cart-size-title cart-asso" data-toggle="tooltip"
                                     title="{{ title }}">{{ item.cdasso }}</div>
                                <div class="cart-size-box"
                                     title="{{ title }}">{{ item.quanti > 0 ? item.quanti : '&nbsp;' }}</div>
                            </div>
                        {% endfor %}
                    {% endif %}
                {% endif %}
            </div>
        </div>

    {% endfor %}

    {% if nuordc < 0 and common['multipleInsert'] == 1 %}
        <div class="offset-4 col-4 offset-lg-5 col-lg-2 mb-30x" id="open-multiple-insert-container"
             style="display:none">
            <button class="btn btn-generic w-100 m-0"
                    id="open-multiple-insert">{{ mt._('_common.header.barcode.bulk') }}</button>
        </div>
    {% endif %}

    <div class="row m-0" style="border-bottom:10px solid #eee"></div>

    {# CART FOOTER #}
    {% set global_dsc = '-' %}
    {% if global_prc_net != global_prc_tot %}
        {% set dsc_val = (global_prc_tot - global_prc_net) %}
        {% set dsc_per = 100 - (global_prc_net * 100 / global_prc_tot) %}
        {% set global_dsc = "(-" ~ dsc_per|currency ~ " %) -" ~ dsc_val|currency ~ " " ~ common['currency'] %}
    {% endif %}

    {% if common['coupon_promo'] == 1 and common['order_info'].cdcoup != "" %}
        {% if common['order_info'].tpcoup == 1 %}
            {% set global_prc_net = global_prc_tot * (1 - common['order_info'].impsco/100) %}
        {% elseif common['order_info'].tpcoup == 2 %}
            {% set global_prc_net = global_prc_tot - common['order_info'].impsco %}
        {% endif %}
        {% set dsc_val = (global_prc_tot - global_prc_net) %}
        {% set dsc_per = 100 - (global_prc_net * 100 / global_prc_tot) %}
        {% set global_dsc = "(-" ~ dsc_per|currency ~ " %) -" ~ dsc_val|currency ~ " " ~ common['currency'] %}
    {% endif %}

    {% if nuordc < 0 or (common['coupon_promo'] == 1 and common['order_info'].cdcoup != "") %}
        <div class="row cart-row-block pt-20x fs11">
            {# Footer 1° Row 1° Col: Coupon #}
            <div class="col-12 col-md-6 float-left sm-space-footer">
                {# Coupon #}
                {% if common['coupon_promo'] == 1 and (nuordc < 0 or common['order_info'].cdcoup != "") %}
                    <div class="row model-look text-left m-0">
                        <span class="{{ elements.getHighlightClass() }} p-0-15x">{{ mt._('admin.menu.coupon') }}</span>
                    </div>
                    {% if common['order_info'].cdcoup != "" %}
                        <div class="row m-0 pb-5x pt-10x">
                            <div class="col-3 cart-info-title">{{ mt._('cart.coupon.applied') }}</div>
                            <div class="col-2 cart-info-text">{{ common['order_info'].dscoup }}</div>
                        </div>
                        <div class="row m-0 pb-5x">
                            <div class="col-3 cart-info-title">{{ mt._('_common.discount') }}</div>
                            <div class="col-2 cart-info-text">
                                {{ common['order_info'].tpcoup == 0 ? mt._('admin.coupon.freedelivery') : common['order_info'].impsco ~ ' ' ~ (common['order_info'].tpcoup == 1 ? '%' : common['currency']) }}
                            </div>
                        </div>
                        <div class="row row-cart-btn m-0 pt-28x">
                            <div class="col-3 p-0"><a href="#" id="remove-coupon"
                                                      class="btn-custom">{{ mt._('_common.remove') }}</a></div>
                        </div>
                    {% else %}
                        <div class="row form-element m-0 pt-10x">
                            <input type="text" name="coupon" id="coupon" class="col-6 form-control fs11"
                                   placeholder="{{ mt._('cart.footer.insertcoupon') }}"/>
                            <div class="col-6 col-lg-4"><a href="#" class="btn btn-generic w-100 m-0"
                                                           id="apply-coupon">{{ mt._('cart.footer.applycoupon') }}</a>
                            </div>
                            <div id="msg-error-coupon" class="col-10 msg-error"
                                 style="text-transform:initial">{{ mt._('cart.coupon.error') }}</div>
                        </div>
                    {% endif %}
                {% endif %}
                {# Discounts #}
                {% if common['coupon_promo'] == 3 and nuordc < 0 %}
                    <div class="row collapse-row">
                        <div class="row model-look text-left m-0">
                            <span class="{{ elements.getHighlightClass() }} p-0-15x"><a
                                        class="label-for-collapse label-no-underline"
                                        data-toggle="collapse" href="#couponlistcollapse"
                                        role="button" aria-expanded="false"
                                        aria-controls="couponlistcollapse">{{ mt._('_common.discounts') }}</a></span>
                        </div>
                        <div class="collapse" id="couponlistcollapse">
                            <div class="row form-element m-0 pt-10x">
                                {% if common['order_info'].flnosc == 0 %}
                                    {% set discount1 = articles|length > 0 and articles[0]['octagl']|length > 0 ? articles[0]['octagl'][0].scont1 : 0 %}
                                    {% set discount2 = articles|length > 0 and articles[0]['octagl']|length > 0 ? articles[0]['octagl'][0].scont2 : 0 %}
                                    {% set discount3 = articles|length > 0 and articles[0]['octagl']|length > 0 ? articles[0]['octagl'][0].scont3 : 0 %}
                                    <div class="col-2 cart-info-title text-right pr-10x"
                                         style="line-height:48px">{{ mt._('_common.discount') }} 1
                                    </div>
                                    <input type="number" min="0" max="100" step="0.01" name="discount1" id="discount1"
                                           class="col-2 form-control fs11" value="{{ discount1 > 0 ? discount1 : '' }}"
                                           data-oldvalue="{{ discount1 }}"/>
                                    <div class="col-2 cart-info-title text-right pr-10x"
                                         style="line-height:48px">{{ mt._('_common.discount') }} 2
                                    </div>
                                    <input type="number" min="0" max="100" step="0.01" name="discount2" id="discount2"
                                           class="col-2 form-control fs11" value="{{ discount2 > 0 ? discount2 : '' }}"
                                           data-oldvalue="{{ discount2 }}"/>
                                    <div class="col-2 cart-info-title text-right pr-10x"
                                         style="line-height:48px">{{ mt._('_common.discount') }} 3
                                    </div>
                                    <input type="number" min="0" max="100" step="0.01" name="discount3" id="discount3"
                                           class="col-2 form-control fs11" value="{{ discount3 > 0 ? discount3 : '' }}"
                                           data-oldvalue="{{ discount3 }}"/>
                                    <div class="col-12 text-center mt-20x"><a href="#" class="cart-info-title"
                                                                              id="apply-discounts"
                                                                              style="display:none">{{ mt._('_common.update') }}</a>
                                    </div>
                                    <div id="msg-error-discount" class="col-12 msg-error"
                                         style="text-transform:initial">{{ mt._('_common.update.error') }}</div>
                                {% endif %}
                                {% if common['order_info'].anagra_scont1 != 0 or
                                    common['order_info'].anagra_scont2 != 0 or
                                    common['order_info'].anagra_scont3 != 0 %}
                                    {% set discount = common['order_info'].anagra_scont1 != 0 ? common['order_info'].anagra_scont1 ~ '%' : '' %}
                                    {% set discount = discount ~ (discount != '' ? '' : ' + ') ~ (common['order_info'].anagra_scont2 != 0 ? common['order_info'].anagra_scont2 ~ '%' : '') %}
                                    {% set discount = discount ~ (discount != '' ? '' : ' + ') ~ (common['order_info'].anagra_scont3 != 0 ? common['order_info'].anagra_scont3 ~ '%' : '') %}
                                    {% set style = common['order_info'].flnosc == 1 ? 'text-decoration:line-through' : '' %}
                                    <div class="col-12" style="font-size:12px;margin:5px;{{ style }}">
                                        {{ mt._('_common.discount.customer') }}: {{ discount }}
                                    </div>
                                    <div class="col-12">
                                        <input type="checkbox" id="disable-discounts"
                                               class="row-selector checkbox-custom" {{ common['order_info'].flnosc == 1 ? 'checked' : '' }}>
                                        <label for="disable-discounts" class="checkbox-custom-label">Disabilita tutti
                                            gli sconti per questo ordine</label>
                                    </div>
                                {% endif %}
                            </div>
                        </div>
                    </div>
                {% endif %}
            </div>
        </div>
    {% endif %}

    {% if common['isOrder'] and common['budgetManagement'] > 0 and common['budget']['line']|length > 0 and common['budget']['drop']|length > 0 %}
        <div class="row cart-row-block pt-20x fs11">
            <div class="col-12 col-md-12 float-left sm-space-footer collapse-row p-0">
                <div class="row model-look text-left m-0">
                    <span class="{{ elements.getHighlightClass() }} p-0-15x"><a
                                class="label-for-collapse label-no-underline"
                                data-toggle="collapse" href="#budgetcollapse"
                                role="button" aria-expanded="false"
                                aria-controls="couponlistcollapse">{{ mt._('cart.analysis') }}</a></span>
                </div>
                <div class="row collapse" id="budgetcollapse">
                    <div class="col-12 mt-10x">
                        <a href="#" id="change-budget-view"
                           data-type="0">{{ mt._('_common.budget.changeview.drop') }}</a>
                    </div>
                    <div class="col-12 mt-10x">
                        <span class="text-capitalize">{{ mt._('_common.season') }}:</span>
                        {{ common['order_info'].dsstag != '' ? common['order_info'].dsstag : common['order_info'].cdstag }}
                        - <span class="text-capitalize">{{ mt._('_common.drop') }}:</span>
                        {{ common['order_info'].tpindo }}
                        {{ common['order_info'].dsindo != '' and common['order_info'].dsindo != common['order_info'].dsindo ? ' - ' ~ common['order_info'].dsindo : '' }}
                    </div>

                    {% set addBrand = false %}
                    {% set currentBrandCode = common['budget']['line'][0].cdtitl %}
                    {% set numOfSeasons = 0 %}
                    {% for item in common['budget']['line'] %}
                        {% if item.cdtitl != currentBrandCode %}
                            {% set addBrand = true %}
                        {% endif %}
                    {% endfor %}

                    {% set lineColumnWidth = 300 %}
                    {% set otherColumnWidth = 150 %}

                    <div id="budget-line-container" style="overflow-x:auto">
                        {% set title = mt._('_common.line') ~ ' - ' ~ mt._('_common.drop') %}
                        {{ elements.getBudgetHeaderHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['line'][0], title, true, false, true) }}
                        {{ elements.getBudgetForCustomerBodyHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['line'], addBrand, common['currency'], true, true, false, true) }}
                    </div>
                    <div id="budget-drop-container" style="overflow-x:auto;display:none">
                        {% set title = mt._('_common.drop') ~ ' - ' ~ mt._('_common.line') %}
                        {{ elements.getBudgetHeaderHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['drop'][0], title, true, false, true) }}
                        {{ elements.getBudgetForCustomerBodyHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['drop'], addBrand, common['currency'], false, true, false, true) }}
                    </div>
                </div>
            </div>
        </div>
    {% endif %}

    {% if common['cartMode'] > 0 %}
        <div class="row m-0" style="border-bottom:10px solid #eee"></div>
        <div class="row cart-row-block pt-20x fs11">
            <div class="col-12 mb-20x">
                <div class="row model-look text-right m-0">
                    <span class="{{ elements.getHighlightClass() }} p-0-15x">{{ mt._('cart.summary') }}</span>
                </div>
            </div>
            <div class="col-12">
                <div class="row cart-summary-lines-header m-0">
                    <div class="col">{{ common['cartMode'] == 1 ? mt._('_common.line') : mt._('_common.modeltype') }}</div>
                    <div class="col">{{ mt._('_common.total.articles') }}</div>
                    <div class="col">{{ mt._('_common.total.qty') }}</div>
                    <div class="col">{{ mt._('_common.amount.gross') }}</div>
                    <div class="col">{{ mt._('_common.discount') }}</div>
                    <div class="col">{{ mt._('_common.amount.net') }}</div>
                </div>
            </div>
            <div class="col-12">
                {% for el in summary %}
                    {% set discount = el['implor'] != el['impnet'] and el['implor'] > 0 ? 100 - ((el['impnet'] * 100) / el['implor']) : '-' %}
                    <div class="row cart-summary-lines-row m-0">
                        <div class="col">{{ el['descri'] }}</div>
                        <div class="col">{{ el['numrow'] }}</div>
                        <div class="col">{{ el['quanti'] }}</div>
                        <div class="col">{{ el['implor']|currency }} {{ common['currency'] }}</div>
                        <div class="col">{{ discount }}</div>
                        <div class="col">{{ el['impnet']|currency }} {{ common['currency'] }}</div>
                    </div>
                {% endfor %}
            </div>
            <div class="col-12">
                <div class="row cart-summary-lines-footer m-0">
                    <div class="col">&nbsp;</div>
                    <div class="col">{{ articles|length }}</div>
                    <div class="col">{{ global_qty_total }}</div>
                    <div class="col">{{ global_prc_tot|currency }} {{ common['currency'] }}</div>
                    <div class="col">{{ global_dsc }}</div>
                    <div class="col">{{ global_prc_net|currency }} {{ common['currency'] }}</div>
                </div>
            </div>
        </div>
    {% endif %}

    <div class="row cart-row-block pt-20x fs11">
        {# Footer 1° Row 3° Col: Summary #}
        <div class="col-12 col-md-6 offset-md-6 float-left sm-space-footer">
            <div class="row model-look text-right m-0">
                <span class="{{ elements.getHighlightClass() }} p-0-15x">{{ mt._('cart.footer.summary') }}</span>
            </div>
            <div class="row m-0 py-10x">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('cart.footer.total') }}</div>
                <div class="col-4 col-lg-4 cart-info-text">{{ articles|length }}</div>
            </div>
            <div class="row m-0 pb-20x">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('_common.total.qty') }}</div>
                <div class="col-4 col-lg-4 cart-info-text" id="footer-tot-qty">{{ global_qty_total }}</div>
            </div>
            <div class="row m-0 pb-5x">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('cart.header.grosstotal') }}</div>
                <div class="col-4 col-lg-4 cart-info-text"
                     id="footer-tot-grs">{{ global_prc_tot|currency }} {{ common['currency'] }}</div>
            </div>
            <div class="row m-0 pb-5x">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('cart.header.discount') }}</div>
                <div class="col-4 col-lg-4 cart-info-text" id="footer-tot-dsc">{{ global_dsc }}</div>
            </div>
            <div class="row m-0 pb-5x">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('_common.taxable') }}</div>
                <div class="col-4 col-lg-4 cart-info-text"
                     id="footer-tot-net">{{ global_prc_net|currency }} {{ common['currency'] }}</div>
            </div>
            {% set tax = "0" %}
            {% set tax_descr = '' %}
            {% set total = global_prc_net %}
            {% if common['applyTax'] == 1 and (common['order_info'].aliquo > 0 or common['order_info'].dsaiva != '') %}
                {% set tax = (global_prc_net * common['order_info'].aliquo)/100 %}
                {% set tax_descr = '(' ~ common['order_info'].dsaiva ~ ')' %}
                {% set total = global_prc_net + tax %}
                <div class="row m-0 pb-5x">
                    <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title">{{ mt._('_common.tax') }} {{ tax_descr }}</div>
                    <div class="col-4 col-lg-4 cart-info-text" id="footer-tax"
                         data-tax="{{ tax }}">{{ tax|currency }} {{ common['currency'] }}</div>
                </div>
            {% endif %}
            <div class="row m-0 pb-5x" style='display:none' id="custom-pay">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title"
                     id="custom-pay-dspaga"></div>
                <div class="col-4 col-lg-4 cart-info-text" id="custom-pay-preagg" data-preagg=""></div>
            </div>
            <div class="row m-0 pb-5x" style='display:none' id="custom-shi">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title"
                     id="custom-shi-dstpor"></div>
                <div class="col-4 col-lg-4 cart-info-text" id="custom-shi-preagg" data-preagg=""></div>
            </div>
            <div class="row m-0 pt-5x fs14">
                <div class="offset-0 col-8 offset-md-3 col-md-5 offset-lg-4 col-lg-4 cart-info-title pt-10x mt-10x"
                     style="border-top:2px solid black">{{ mt._('_common.total') }}</div>
                <div class="col-4 col-lg-4 cart-info-text pt-10x mt-10x" style="border-top:2px solid black">
                    <span class="{{ elements.getHighlightClass() }} py-0 px-10x" id="cart-final-total"
                          data-total="{{ total }}"
                          data-base-price="{{ total }}"
                          style="margin-right:-10px">{{ total|currency }} {{ common['currency'] }}</span>
                </div>
            </div>
        </div>
    </div>

    {% if nuordc < 0 %}
        <div class="row cart-row-block sm-space-footer text-capitalize py-20x px-0 mb-0">
            {# Footer 2° Row 1° Col: continue shopping #}
            <div class="d-none d-md-block col-md-4 col-lg-3 float-left">
                <a href="{{ url(common['homepage'] == 0 ? 'catalog/index' : 'catalog/collection') }}"
                   class="btn btn-generic w-100">{{ mt._('cart.footer.continueshopping') }}</a>
            </div>

            {# Footer 2° Row 2° Col: save order, send order #}
            {% if common['order_info'].tpanag == 'CN' or common['saveOrderType'] == 0 or common['saveOrderType'] == 1 %}
                <div class="offset-0 col-6 col-md-4 col-lg-3 float-left sm-padding sm-space-footer btn-close offset-lg-{{ common['saveOrderType'] == 1 or (common['order_info'].tpanag == 'CN' and not common['CNCanSendOrders']) ? '6' : '3' }}">
                    <a href="#" {{ thereAreDoubles ? 'data-toggle="modal" data-target=".modal-double-rows-confirm"' : 'id="save-order"' }}
                       class="btn btn-generic w-100 {{ thereAreDoubles ? 'btn-double' : '' }}"
                       data-flstat="1">{{ mt._('_common.save') }}</a>
                </div>
            {% endif %}

            {% if (common['order_info'].tpanag != 'CN' or common['CNCanSendOrders']) and (common['saveOrderType'] == 0 or common['saveOrderType'] == 2) %}
                {% if isSendable %}
                    <div class="col-6 col-md-4 col-lg-3 float-left sm-padding sm-space-footer btn-close {{ common['saveOrderType'] == 2 ? 'offset-lg-6 offset-md-4' : '' }}">
                        <a href="#" {{ thereAreDoubles ? 'data-toggle="modal" data-target=".modal-double-rows-confirm"' : 'id="send-order"' }}
                           class="btn btn-main w-100 {{ thereAreDoubles ? 'btn-double' : '' }}"
                           data-flstat="2">{{ mt._('cart.confirmorder') }}</a>
                        <div class="msg-error text-right" id="send-error">{{ mt._('cart.completeandsend.error') }}</div>
                    </div>
                {% elseif common['cart_limit_mode'] > 0 %}
                    <div class="col-6 col-md-4 col-lg-3 float-left sm-padding sm-space-footer btn-close {{ common['saveOrderType'] == 2 ? 'offset-lg-6 offset-md-4' : '' }}">
                        <div class="alert alert-warning" role="alert">
                            <i class="fa fa-fw fa-warning text-warning"></i>
                            <span class="text-notransform text-sm">
                                {% if common['cart_limit_mode'] == 1 %} {# Quantità minima #}
                                    {{ mt._('cart.help.limit.qtamin', ['value': common['cart_limit_min_value']]) }}
                                {% elseif common['cart_limit_mode'] == 2 %} {# Spesa minima #}
                                    {{ mt._('cart.help.limit.spendmin', ['value': common['cart_limit_min_value']]) }}
                                {% endif %}
                            </span>
                        </div>
                    </div>
                {% endif %}
            {% endif %}

            {% if common['paypal'] == 1 and (common['order_info'].tpanag != 'CN' or common['CNCanSendOrders']) %}
                <div class="offset-0 col-6 offset-md-6 col-md-2 float-left sm-padding sm-space-footer"
                     id="paypal-close-order">
                    <div class="msg-error text-right" id="paypal-stripe-error"
                         style="display:none">{{ mt._('cart.completeandsend.error') }}</div>
                    <div id="paypal-button-container" style="display:none">
                        <a id="paypal-checkout"
                           style="display:none">{{ image("https://www.paypalobjects.com/webstatic/en_US/i/btn/png/gold-pill-paypalcheckout-34px.png", "alt": "PayPal Checkout", "class": "float-right pointer") }}</a>
                        <span id="paypal-loading"
                              class="float-right">{{ image("assets/img/preloader.gif", "class": "h40") }}</span>
                    </div>
                    {% if stripe %}
                        <div id="stripe-button-container" style="display:none">
                            <form action="{{ url('cart/payStripe/' ~ common['order_info'].nuordc) }}" method="POST"
                                  class="float-right">
                                <input type="hidden" name="amount" id="amount" value="{{ total * 100 }}"/>
                                <script id="stripe-script"
                                        src="https://checkout.stripe.com/checkout.js" class="stripe-button"
                                        data-key="{{ pub_key }}"
                                        data-amount="{{ total * 100 }}"
                                        data-name="{{ common['company'] }}"
                                        data-description="{{ articles|length }} {{ articles|length > 1 ? mt._('_common.article') : mt._('_common.articles') }} ({{ mt._('cart.header.quantity') }}: {{ global_qty_total }})"
                                        data-image="https://stripe.com/img/documentation/checkout/marketplace.png"
                                        data-locale="auto"
                                        data-zip-code="true"
                                        data-currency="{{ common['order_info'].cdvalu }}">
                                </script>
                            </form>
                        </div>
                    {% endif %}
                </div>
            {% endif %}

            {% if common['modelDetailStyle'] == 3 and nuordc < 0 %}
                <div class="d-none d-md-block col-md-4 col-lg-3 float-left">
                    <button class="btn btn-generic w-100" data-toggle="modal"
                            data-target=".modal-delete-no-qty">{{ mt._('admin.order.deletenoqtyarticles') }}</button>
                </div>
            {% endif %}

            <div class="offset-0 col-12 offset-md-6 col-md-6 offset-lg-{{ common['modelDetailStyle'] == 3 and nuordc < 0 ? '5' : '8' }} col-lg-4 float-left sm-space-footer cart-disclaimer">
                {{ mt._('cart.disclaimer') }} <a href="{{ url('info/salesconditions') }}"
                                                 target="_blank">{{ mt._('_common.salesconditions') }}</a>
            </div>

            <div class="d-block d-md-none col-md-4 col-lg-2 float-left">
                <a href="{{ url(common['homepage'] == 0 ? 'catalog/index' : 'catalog/collection') }}"
                   class="fs11">{{ mt._('cart.footer.continueshopping') }}</a>
            </div>

            {% if common['modelDetailStyle'] == 3 and nuordc < 0 %}
                <div class="d-block d-md-none col-md-4 col-lg-2 float-left">
                    <a href="#" class="fs11 w-100" data-toggle="modal"
                       data-target=".modal-delete-no-qty">{{ mt._('admin.order.deletenoqtyarticles') }}</a>
                </div>
            {% endif %}
        </div>
    {% else %}
        <div class="row cart-row-block sm-space-footer text-capitalize py-20x px-0 mb-0">
            <div class="offset-0 col-6 offset-md-6 col-md-6 float-left sm-padding sm-space-footer">
                <a href="{{ url('account/info/ord') }}"
                   class="btn btn-main w-100">{{ mt._('cart.footer.backtoorderlist') }}</a>
            </div>
        </div>
    {% endif %}

</div>
