{% if router.getControllerName() != 'b2c' %}

{{ get_doctype() }}
<html xmlns="https://www.w3.org/1999/xhtml" xml:lang="it" lang="it">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta http-equiv="Content-language" content="it" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

{% if (router.getControllerName() == 'admin' and router.getActionName() == 'sendOrder') or
      (router.getControllerName() == 'cart' and router.getActionName() != 'index' and (router.getActionName() in ['sendOrder', 'completeOrder', 'executePayment', 'payStripe'])) or
      router.getControllerName() == 'pdf' %}
{#
  {{ stylesheet_link("css/pdf.min.css") }}
  #}
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/css/bootstrap.min.css" integrity="sha384-9gVQ4dYFwwWSjIDZnLEWnxCjeSWFphJiwGPXr1jddIhOegiu1FwO5qRGvFXOdJZ4" crossorigin="anonymous">
  {% include "layouts/widgets/pdf_style.volt" %}

{% else %}

  <!-- Meta, title, CSS, favicons, etc. -->
  <link rel="shortcut icon" type="image/png" href="{{ url('assets/img/favicon.ico') }}"/>

  <!-- Google Analytics -->
  {% if googleanalytics is not empty %}
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ config.param.googleanalytics }}"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', '{{ config.param.googleanalytics }}');
    </script>
  {% endif %}

  {{ get_title() }}

  {% include "layouts/head_content.volt" %}

  {% include "scripts/common/common_data.volt" %}

{% endif %}
</head>
{% endif %}

{% block body %}

{% endblock %}


{% if router.getControllerName() != 'b2c' %}
</html>
{% endif %}
