<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>{{ mt._('admin.menu.users') }}</h2>
                <div class="clearfix"></div>
            </div>

            <div class="x_content">

                {% if isSuperAdmin %}
                    <div class="row mt-10x">
                        <div class="col-md-4 col-sm-4 col-xs-12"></div>
                        <div class="col-md-4 col-sm-4 col-xs-12 text-center">
                            <button type="button" class="btn btn-primary m-0 w-30"
                                    data-toggle="modal"
                                    data-target=".modal-add-user">
                                {{ mt._('_common.add') }}
                            </button>
                        </div>
                    </div>
                {% endif %}

                {% if users is defined and users|length > 0 %}
                    <div class="row pt-25x">
                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <table id="table-users" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>{{ mt._('admin.username') }}</th>
                                    <th>{{ mt._('_common.code') }}</th>
                                    <th>{{ mt._('admin.customers.name') }}</th>
                                    <th>{{ mt._('admin.customer.canlogin') }}</th>
                                    <th>{{ mt._('admin.customer.canorder') }}</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                {% for el in users %}
                                    <tr data-id="{{ el.id }}" data-username="{{ el.username }}" data-enabled="{{ el.enabled }}"  data-orders-enabled="{{ el.orders_enabled }}">
                                        <th><span>{{ el.id }}</span></th>
                                        <td><span>{{ el.username }}</span></td>
                                        <td><span>{# {{ el.tpanag }} - {{ el.cdanag }} #}</span></td>
                                        <td><span>{# {{ el.name }} #}</span></td>
                                        <td>
                                            <span class="{{ el.enabled ? 'text-success' : 'text-danger' }}">
                                                {{ el.enabled ? mt._('admin.enabled') : mt._('admin.disabled') }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="{{ el.orders_enabled ? 'text-success' : 'text-danger' }}">
                                                {{ el.orders_enabled ? mt._('admin.enabled') : mt._('admin.disabled') }}
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            {% if isSuperAdmin %}
                                                <span class="pr-20x" data-toggle="modal"
                                                      data-target=".modal-switch-user">
                                                    <a href="#" class="switch-user"
                                                       title="{{ mt._('_common.switchuser') }}">
                                                        <span class="glyphicon glyphicon-user"
                                                              aria-hidden="true"></span>
                                                    </a>
                                                </span>
                                            {% endif %}
                                            <span data-toggle='modal' data-target='.modal-edit-user'>
                                                <a href="#"
                                                   class="edit-user {{ isSuperAdmin or el.type > loggeduserType ? '' : 'disabled' }}"
                                                   title="{{ mt._('_common.edit') }}">
                                                    <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                                                </a>
                                            </span>
                                            {% if isSuperAdmin %}
                                                <span class="pl-20x" data-toggle="modal"
                                                      data-target=".modal-delete-user">
                                                    <a href="#" class="delete-user"
                                                       title="{{ mt._('_common.delete') }}">
                                                        <span class="glyphicon glyphicon-remove"
                                                              aria-hidden="true"></span>
                                                    </a>
                                                </span>
                                            {% endif %}
                                        </td>
                                    </tr>
                                {% endfor %}
                                </tbody>
                            </table>

                        </div>
                    </div>
                {% else %}
                    <div class="row pt-25x">
                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <table id="table-users-ajax" class="table table-striped table-bordered">

                            </table>
                        </div>
                    </div>
                {% endif %}
            </div>
        </div>
    </div>
</div>

{# <!-- Modal for bulk reset users password -->
<div id="modal-bulk-reset" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true"
     aria-labelledby="modal-bulk-reset-label">
    <div class="modal-dialog modal-sm w-50">
        <div class="modal-content">

            <div class="modal-header">
                <h4 class="modal-title" id="modal-bulk-reset-label">{{ mt._('admin.enabledisable') }}</h4>
                <div class="modal-close"
                     data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
            </div>
            <div class="modal-body">
                <div class="modal-section">
                    <div class="row py-10x" style="line-height:18px">
                        <h4>{{ mt._('admin.resetpassword.disclaimer') }}</h4>
                    </div>
                    <div class="row py-10x" style="line-height:18px">
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.send.email') }}</div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <label class="checkbox-customer checkbox-container">
                                <input type="checkbox" name="sendMail" value="1"/>
                                <span class="checkbox-checkmark"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50"
                                data-dismiss="modal">{{ mt._('_common.close') }}</button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-primary right-btn w-50" id="bulk-reset"
                                data-action="">{{ mt._('_common.save') }}</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="msg-form-error"></div>
                        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
                        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for bulk login status edit -->
<div id="modal-bulk-login-status" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true"
     aria-labelledby="modal-bulk-status-label">
    <div class="modal-dialog modal-sm w-50">
        <div class="modal-content">

            <div class="modal-header">
                <h4 class="modal-title" id="modal-bulk-status-label">{{ mt._('admin.enabledisable') }}</h4>
                <div class="modal-close"
                     data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
            </div>
            <div class="modal-body">
                <div class="modal-section">
                    <div class="row py-10x" style="line-height:18px">
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canlogin') }}</div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <select class="modal-bulk-login-status form-control muted" data-type="enabled">
                                <option value="-1" class="muted">{{ mt._('admin.nomutate') }}</option>
                                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="row py-10x" style="line-height:18px">
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canorder') }}</div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <select class="modal-bulk-login-status form-control" data-type="orders_enabled">
                                <option value="-1" class="text-muted">{{ mt._('admin.nomutate') }}</option>
                                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50"
                                data-dismiss="modal">{{ mt._('_common.close') }}</button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-primary right-btn w-50" id="bulk-login-update"
                                data-action="">{{ mt._('_common.save') }}</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="msg-form-error"></div>
                        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
                        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for modify user -->
<div class="modal fade modal-modify-user" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-50">
        <div class="modal-content">

            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.customers.modifycustomer') }}</h4>
                <div class="modal-close"
                     data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
            </div>
            <div class="modal-body">
                <div class="modal-section">
                    <div class="row py-10x">
                        <div class="col-md-4 col-sm-4 col-xs-4 modal-section-title right" style="line-height:23px">
                            {{ mt._('session.register.username') }}
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-4">
                            <input type="text" value="" id="modal-username"  class="form-control"/>
                        </div>
                        <div class="col-md-4 col-sm-4 col-xs-4 fs11" id="modal-edit-password-box">
                            <label class="checkbox-container">
                                <input type="checkbox" id="modal-edit-password" checked/>
                                {{ mt._('admin.dontmodifypassword') }}
                                <span class="checkbox-checkmark"></span>
                            </label>
                        </div>
                    </div>
                    <div class="row pb-10x" id="modal-password-box" style="line-height:18px">
                        <div class="col-md-4 col-sm-4 col-xs-4 modal-section-title right">
                            {{ mt._('session.register.password') }}
                        </div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <input type="password" value="" id="modal-password" class="form-control"/>
                        </div>
                    </div>
                    <div class="row pb-10x" id="modal-repeatpassword-box" style="line-height:18px">
                        <div class="col-md-4 col-sm-4 col-xs-4 modal-section-title right">
                            {{ mt._('session.register.confirmpassword') }}
                        </div>
                        <div class="col-md-8 col-sm-8 col-xs-8">
                            <input type="password" value="" id="modal-repeatpassword" class="form-control"/>
                        </div>
                    </div>
                    <div class="row py-10x" style="line-height:18px">
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>
                            {{ mt._('admin.customer.canlogin') }}
                        </div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <select class="modal-login-status form-control" data-type="enabled">
                                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
                            </select>
                            <div class="msg-form-error-row left" id="modal-login-enabled-error"></div>
                        </div>
                    </div>
                    <div class="row py-10x" style="line-height:18px">
                        <div class="col-md-4 col-sm-4 col-xs-4 modal-section-title right">
                            {{ mt._('admin.customer.canorder') }}
                        </div>
                        <div class='col-md-8 col-sm-8 col-xs-8'>
                            <select class="modal-login-status form-control" data-type="orders_enabled">
                                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50"
                                data-dismiss="modal">{{ mt._('_common.close') }}</button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-primary right-btn w-50" id="save-user"
                                data-action="">{{ mt._('_common.save') }}</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="msg-form-error"></div>
                        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
                        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> #}


{% if isSuperAdmin %}
    <!-- Modal for add user admin -->
    <div class="modal fade modal-add-user" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm w-50">
            <div class="modal-content">

                <div class="modal-header">
                    <h4 class="modal-title">{{ mt._('_common.add') }}</h4>
                    <div class="modal-close"
                         data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
                </div>
                <div class="modal-body">
                    <div class="modal-section">
                        <div class="row py-10x">
                            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('admin.username') }}</div>
                            <div class='col-md-4 col-sm-4 col-xs-4'>
                                <input type="text" class="form-control" id="add-user-username"
                                       name="add-user-username" autocomplete="new-username"/>
                            </div>
                        </div>
                        <div class="row pb-10x">
                            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.password') }}</div>
                            <div class='col-md-8 col-sm-8 col-xs-8'>
                                <input type="password" class="form-control" id="add-user-new-password"
                                       name="add-user-new-password" autocomplete="new-password"/>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.confirmpassword') }}</div>
                            <div class='col-md-8 col-sm-8 col-xs-8'>
                                <input type="password" class="form-control" id="add-user-rpt-password"
                                       name="add-user-rpt-password" autocomplete="new-rpt-password"/>
                            </div>
                        </div>
                        <div class="row pb-10x">
                            <div class='col-md-4 col-sm-4 col-xs-4'></div>
                            <div class='col-md-8 col-sm-8 col-xs-8 msg-error text-left'>
                                {{ mt._('session.register.errorconfirm') }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">
                                {{ mt._('_common.close') }}
                            </button>
                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <button type="button" class="btn btn-primary right-btn w-50" id="add-user" disabled>
                                {{ mt._('_common.add') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{% endif %}

<!-- Modal for edit user -->
<div class="modal fade modal-edit-user" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-50">
        <div class="modal-content">

            <div class="modal-header">
                <h4 class="modal-title">{{ mt._('_common.edit') }}</h4>
                <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
            </div>
            <div class="modal-body">
                <div class="modal-section">
                    <input type="hidden" id="edit-user-id" name="edit-user-id"/>
                    <div class="row py-10x">
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('admin.username') }}</div>
                        <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" class="form-control" id="edit-user-username" name="edit-user-username" autocomplete="new-username"/></div>
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-edit-password-box'>
                            <label class='checkbox-container' style='margin-top:5px'>
                                <input type='checkbox' name='edit-user-edit-password' id='edit-user-edit-password' checked /> {{ mt._('admin.dontmodifypassword') }}
                                <span class='checkbox-checkmark'></span>
                            </label>
                        </div>
                    </div>
                    <div class="row pb-10x modal-password-box" style='display:none'>
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.password') }}</div>
                        <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="edit-user-new-password" name="edit-user-new-password" autocomplete="new-password"/></div>
                    </div>
                    <div class="row modal-password-box" style='display:none'>
                        <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.confirmpassword') }}</div>
                        <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="edit-user-rpt-password" name="edit-user-rpt-password" autocomplete="new-rpt-password"/></div>
                    </div>
                    <div class="row pb-10x modal-password-box" style='display:none'>
                        <div class='col-md-4 col-sm-4 col-xs-4'></div>
                        <div class='col-md-8 col-sm-8 col-xs-8 msg-error text-left'>{{ mt._('session.register.errorconfirm') }}</div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-primary right-btn w-50" id="edit-user">{{ mt._('_common.edit') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for delete user -->
<div class="modal fade modal-delete-user" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-30">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
                <div class="modal-close" data-dismiss="modal">
                    {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
                </div>
            </div>
            <div class="modal-body">
                <input type="hidden" id="delete-user-id" name="delete-user-id"/>
                <div class="row center">
                    <div class='col-md-12 modal-section-title'>
                        {{ mt._('admin.admin.deletewarning') }}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">
                            {{ mt._('_common.close') }}
                        </button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-user">
                            {{ mt._('_common.delete') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for switch user -->
<div class="modal fade modal-switch-user" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-30">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ mt._('_common.switchuser') }}</h4>
                <div class="modal-close" data-dismiss="modal">
                    {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
                </div>
            </div>
            <div class="modal-body">
                <div class="row center">
                    <div class='col-md-12 modal-section-title'>
                        {{ mt._('admin.user.switchwarning') }}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="row">
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">
                            {{ mt._('_common.close') }}
                        </button>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-6">
                        <form action="{{ url('session/switch') }}" method="post">
                            <button type="submit" name="id_user" class="btn btn-primary right-btn w-50 capitalize"
                                    id="switch-to-user">
                                {{ mt._('_common.continue') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

