<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>{{ i18n._('admin.translation.strings') }}</h2>
                <div class="clearfix"></div>
            </div>

            <div class="msg-success-model-info hidden"></div>
            <div class="msg-error-model-info hidden"></div>

            <div class="x_content">
                <div class="row">
                    <div class="col-xs-12">
                        <h4 class="card-title">
                            {{ i18n._('admin.translation.strings') }}
                            <label class="pull-right text-nowrap">
                                {{ i18n._('_common.language') }}
                                <select id="translation-strings-language" class="form-control"
                                        data-placeholder="{{ i18n._('_common.language') }}">
                                    <option {{ currentLanguage == 'it' ? 'selected="selected"' : '' }}
                                            value="it">{{ i18n._('_common.lang.it') }}</option>
                                    <option {{ currentLanguage == 'en' ? 'selected="selected"' : '' }}
                                            value="en">{{ i18n._('_common.lang.en') }}</option>
                                    <option {{ currentLanguage == 'de' ? 'selected="selected"' : '' }}
                                            value="de">{{ i18n._('_common.lang.de') }}</option>
                                    <option {{ currentLanguage == 'es' ? 'selected="selected"' : '' }}
                                            value="es">{{ i18n._('_common.lang.es') }}</option>
                                    <option {{ currentLanguage == 'fr' ? 'selected="selected"' : '' }}
                                            value="fr">{{ i18n._('_common.lang.fr') }}</option>
                                </select>
                            </label>
                            {% if config.environment.isDev %}
                            <button id="translation-strings-search" type="button" class="btn btn-accent-1"
                                    title="{{ i18n._('admin.translation.search') }}" data-toggle="tooltip">
                                <i class="fa fa-search-plus"></i>
                            </button>
                            {% endif %}
                        </h4>
                    </div>
                </div>
                <div class="row py-25x">
                    <div id="translation-strings" class="col-md-12 col-sm-12 col-xs-12">
                        <table id="translation-strings-table" class="table table-striped table-bordered">
                            <thead>
                            <tr class='capitalize'>
                                <th></th>
                                <th>{{ i18n._('admin.translation.string') }}</th>
                                <th>{{ i18n._('admin.translation.value') }}</th>
                                <th></th>
                            </tr>
                            </thead>

                            <tbody>
                            {% if translationStrings is not empty %}
                                {% for translationString in translationStrings %}
                                    <tr data-ts-id="{{ translationString.id|escape_attr }}"
                                        data-ts-key="{{ translationString.key|escape_attr }}"
                                        data-ts-value="{{ translationString.value|escape_attr }}">
                                        <td class="text-center">
                                            <i class="fa fa-2x {{ translationString.value is not empty ? 'fa-check-circle text-success' : 'fa-exclamation-circle text-danger' }}"></i>
                                            <span class="hidden">{{ translationString.value is not empty ? 1 : 0 }}</span>
                                        </td>
                                        <td>
                                            <label for="{{ translationString.id|escape_attr }}">{{ translationString.key }}</label>
                                        </td>
                                        <td>
                                            <div style="display:flex">
                                                        <textarea class="form-control form-control-sm" style="flex:1 0 auto"
                                                                  id="{{ translationString.id|escape_attr }}"
                                                                  rows="1">{{ translationString.value|escape_attr }}</textarea>
                                                <a class="btn btn-sm btn-flat btn-translation-help {{ translationString.mlv === '' ? 'disabled' : '' }}" tabindex="-1"
                                                   title="{{ i18n._("admin.translation.help.google") }}"
                                                   data-toggle="tooltip"
                                                   href="https://translate.google.com/?hl={{ translationString.ml|escape_attr }}&sl={{ translationString.ml|escape_attr }}&tl={{ currentLanguage|escape_attr }}&text={{ translationString.mlv|url_encode|escape_attr }}&op=translate"
                                                   target="_blank">
                                                    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" x="0"
                                                         y="0" viewBox="0 0 998.1 998.3" xml:space="preserve"
                                                         height="18">
                                                            <path fill="#DBDBDB"
                                                                  d="M931.7 998.3c36.5 0 66.4-29.4 66.4-65.4V265.8c0-36-29.9-65.4-66.4-65.4H283.6l260.1 797.9h388z"/>
                                                        <path fill="#DCDCDC"
                                                              d="M931.7 230.4c9.7 0 18.9 3.8 25.8 10.6 6.8 6.7 10.6 15.5 10.6 24.8v667.1c0 9.3-3.7 18.1-10.6 24.8-6.9 6.8-16.1 10.6-25.8 10.6H565.5L324.9 230.4h606.8m0-30H283.6l260.1 797.9h388c36.5 0 66.4-29.4 66.4-65.4V265.8c0-36-29.9-65.4-66.4-65.4z"/>
                                                        <polygon fill="#4352B8"
                                                                 points="482.3,809.8 543.7,998.3 714.4,809.8"/>
                                                        <path fill="#607988"
                                                              d="M936.1 476.1V437H747.6v-63.2h-61.2V437H566.1v39.1h239.4c-12.8 45.1-41.1 87.7-68.7 120.8-48.9-57.9-49.1-76.7-49.1-76.7h-50.8s2.1 28.2 70.7 108.6c-22.3 22.8-39.2 36.3-39.2 36.3l15.6 48.8s23.6-20.3 53.1-51.6c29.6 32.1 67.8 70.7 117.2 116.7l32.1-32.1c-52.9-48-91.7-86.1-120.2-116.7 38.2-45.2 77-102.1 85.2-154.2H936v.1z"/>
                                                        <path fill="#4285F4"
                                                              d="M66.4 0C29.9 0 0 29.9 0 66.5v677c0 36.5 29.9 66.4 66.4 66.4h648.1L454.4 0h-388z"/>
                                                        <linearGradient id="a" gradientUnits="userSpaceOnUse"
                                                                        x1="534.3" y1="433.2" x2="998.1"
                                                                        y2="433.2">
                                                            <stop offset="0" stop-color="#fff"
                                                                  stop-opacity=".2"/>
                                                            <stop offset="1" stop-color="#fff"
                                                                  stop-opacity=".02"/>
                                                        </linearGradient>
                                                        <path fill="url(#a)"
                                                              d="M534.3 200.4h397.4c36.5 0 66.4 29.4 66.4 65.4V666L534.3 200.4z"/>
                                                        <path fill="#EEEEEE"
                                                              d="M371.4 430.6c-2.5 30.3-28.4 75.2-91.1 75.2-54.3 0-98.3-44.9-98.3-100.2s44-100.2 98.3-100.2c30.9 0 51.5 13.4 63.3 24.3l41.2-39.6c-27.1-25-62.4-40.6-104.5-40.6-86.1 0-156 69.9-156 156s69.9 156 156 156c90.2 0 149.8-63.3 149.8-152.6 0-12.8-1.6-22.2-3.7-31.8h-146v53.4l91 .1z"/>
                                                        <radialGradient id="b" cx="65.208" cy="19.366"
                                                                        r="1398.271"
                                                                        gradientUnits="userSpaceOnUse">
                                                            <stop offset="0" stop-color="#fff"
                                                                  stop-opacity=".1"/>
                                                            <stop offset="1" stop-color="#fff"
                                                                  stop-opacity="0"/>
                                                        </radialGradient>
                                                        <path fill="url(#b)"
                                                              d="M931.7 200.4H518.8L454.4 0h-388C29.9 0 0 29.9 0 66.5v677c0 36.5 29.9 66.4 66.4 66.4h415.9l61.4 188.4h388c36.5 0 66.4-29.4 66.4-65.4V265.8c0-36-29.9-65.4-66.4-65.4z"/>
</svg>
                                                </a>
                                                <a class="btn btn-sm btn-flat btn-translation-help {{ translationString.mlv === '' ? 'disabled' : '' }}" tabindex="-1"
                                                   title="{{ i18n._("admin.translation.help.deepl") }}"
                                                   data-toggle="tooltip"
                                                   href="https://www.deepl.com/translator#{{ translationString.ml|escape_attr }}/{{ currentLanguage|escape_attr }}/{{ translationString.mlv|url_encode|escape_attr }}"
                                                   target="_blank">
                                                    <svg height="18" viewBox="0 0 54 68" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M0.1875 17.2741V44.0848C0.1875 45.4775 0.917813 46.7542 2.10938 47.4506L25.1719 60.8366C26.3634 61.533 27.8241 61.533 29.0156 60.8366L52.0781 47.4506C53.2697 46.7542 54 45.4775 54 44.0848V17.2741C54 15.8813 53.2697 14.6046 52.0781 13.9083L29.0156 0.522285C27.8241 -0.174095 26.3634 -0.174095 25.1719 0.522285L2.10938 13.947C0.917813 14.6433 0.1875 15.92 0.1875 17.2741Z"
                                                              fill="#0F2B46"/>
                                                        <path d="M36.7031 67.5303L36.6647 61.7271L36.7031 56.3882L23.25 59.7153"
                                                              fill="#0F2B46"/>
                                                        <path d="M36.0879 55.9238L38.6248 55.2661L37.6638 55.8077C37.0873 56.1559 36.7029 56.7749 36.7029 57.4713V58.5546L36.0879 55.9238Z"
                                                              fill="#142C46"/>
                                                        <path d="M17.7904 18.4744C19.3279 16.9656 21.7879 16.9656 23.3254 18.4744C24.9782 20.0606 24.9782 22.6914 23.3254 24.2776C21.7879 25.7864 19.3279 25.7864 17.7904 24.2776C16.1376 22.6914 16.1376 20.0606 17.7904 18.4744Z"
                                                              fill="white"/>
                                                        <path d="M35.0873 28.5716C36.6248 27.0627 39.0848 27.0627 40.6223 28.5716C42.2751 30.1578 42.2751 32.7885 40.6223 34.3747C39.0848 35.8836 36.6248 35.8836 35.0873 34.3747C33.4345 32.7885 33.4345 30.1578 35.0873 28.5716Z"
                                                              fill="white"/>
                                                        <path d="M17.7904 39.2498C19.3279 37.741 21.7879 37.741 23.3254 39.2498C24.9782 40.836 24.9782 43.4668 23.3254 45.053C21.7879 46.5618 19.3279 46.5618 17.7904 45.053C16.1376 43.4668 16.1376 40.836 17.7904 39.2498Z"
                                                              fill="white"/>
                                                        <path d="M22.4805 23.5419L34.0117 30.2349L35.9336 29.1516L24.4023 22.4199L22.4805 23.5419Z"
                                                              fill="white"/>
                                                        <path d="M34.7805 35.1482L24.4023 41.1835L22.4805 40.0616L32.8586 34.0649L34.7805 35.1482Z"
                                                              fill="white"/>
                                                    </svg>
                                                </a>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-sm btn-flat btn-save"
                                                    title="{{ i18n._("_common.save") }}" data-toggle="tooltip" disabled>
                                                <i class="fa fa-save"></i>
                                            </button>
                                        </td>
                                    </tr>
                                {% endfor %}
                            {% endif %}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
