<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('_common.modellist') }}</h2>
        <div class="clearfix"></div>
      </div>

    {% if success >= 0 %}
      {% if success > 0 %}
      <div class="msg-success-model-info">{{ mt._('_common.generic.db.success') }}</div>
      {% else %}
      <div class="msg-error-model-info">{{ mt._('_common.generic.db.error') }}</div>
      {% endif %}
    {% endif %}

      {% set colMd = enableDescriptionLoading ? 4 : 6 %}

      <div class="x_content">
        <div class="row">
          <div class="col-md-{{ colMd }} col-sm-6 col-xs-6">
            <form action="{{ url('admin/uploadTemplate') }}"  method="post" enctype="multipart/form-data">
              <input type="submit" id="upload-template" class="btn btn-default left-btn w-30 capitalize" value="{{ mt._('_common.template.upload') }}"/>
              <input type="file" name="template" id="template" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" style="padding-top:7px;padding-left:10px">
            </form>
          </div>
          {% if enableDescriptionLoading %}
          <div class="col-md-4 col-sm-6 col-xs-6">
            <form action="{{ url('admin/uploadProductDescriptions') }}"  method="post" enctype="multipart/form-data">
              <input type="submit" id="upload-descriptions" class="btn btn-default left-btn w-30 capitalize" value="{{ mt._('_common.load.xls.descriptions') }}"/>
              <input type="file" name="descriptions" id="descriptions" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" style="padding-top:7px;padding-left:10px">
            </form>
          </div>
          {% endif %}
          <div class="col-md-{{ colMd }} col-sm-6 col-xs-6">
            <a href="{{ url('admin/downloadModinfXlsTemplate') }}" target="_blank"
              class="btn btn-primary right-btn {{ enableDescriptionLoading ? '' : 'w-30' }} capitalize">{{ mt._('_common.template.download') }}</a>
          </div>
        </div>
        {% if models|length > 0 %}
        <div class="row py-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-models" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th class='capitalize'>{{ mt._('_common.brand') }}</th>
                  <th class='capitalize'>{{ mt._('_common.line') }}</th>
                  <th class='capitalize'>{{ mt._('_common.series') }}</th>
                  <th class='capitalize'>{{ mt._('_common.type') }}</th>
                  <th class='capitalize'>{{ mt._('_common.genre') }}</th>
                  <th class='capitalize'>{{ mt._('_common.season') }}</th>
                  <th class='capitalize'>{{ mt._('admin.seqrap.short') }}</th>
                  <th class='capitalize'>{{ mt._('admin.visiblefrom') }}</th>
                  <th class='capitalize'>{{ mt._('admin.visibleto') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for tipolo in models %}
                <tr>
                  <td>{{ tipolo.cdartn }}</td>
                  <td>{{ tipolo.dsartn }}</td>
                  <td>{{ tipolo.cdtitl }}</td>
                  <td>{{ tipolo.cdlinm }}</td>
                  <td>{{ tipolo.cdserm }}</td>
                  <td>{{ tipolo.tpmode }}</td>
                  <td>{{ tipolo.tpgene }}</td>
                  <td>{{ tipolo.cdstag }}</td>
                  <td>{{ tipolo.seqrap }}</td>
                  <td><span style='display:none'>{{ tipolo.dtiniz_sort }}</span>{{ tipolo.dtiniz }}</td>
                  <td><span style='display:none'>{{ tipolo.dtfine_sort }}</span>{{ tipolo.dtfine }}</td>
                  <td class="center" style="vertical-align:middle">
                    <a href="{{ url('admin/modifyModelInfo/' ~ tipolo.cdartn) }}" class="modify-model" title="{{ mt._('admin.modifymodelinfo') }}">
                      <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                    </a>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}
      </div>

    </div>
  </div>
</div>
