
<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel" id="type-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.typology') }}</h2>
        <div class="clearfix"></div>
      </div>

      {% set isLatest = cookieType == '' or cookieType == 'latest' %}
      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-6">
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="type" value="latest" {{ isLatest ? 'checked' : '' }}> {{ mt._('admin.orders.latest') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="type" value="periodagent" {{ not isLatest ? 'checked' : '' }}> {{ mt._('admin.orders.periodagent') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
          </div>
        </div>
      </div>
    </div>

    <div class="x_panel" id="period-panel" {{ isLatest ? 'style="display:none"' : '' }}>
      <div class="x_title">
        <h2>{{ mt._('_common.period') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-4">
            <input type="hidden" style="width:200px" name="season-period" id="season-period" class="form-control"
              value="{{ not isLatest and cookieDtiniz != '' and cookieDtfine != '' ? cookieDtiniz ~ ' - ' ~ cookieDtfine : '' }}"/>
            <div id="season-period-box" class="row py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
              <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
              <div class='col-md-9 px-0'><span></span></div>
              <div class='col-md-1 px-0'><b class="caret"></b></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="x_panel" id="agentscustomers-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.agents') }} / {{ mt._('_common.customers') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-6">
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="whose" value="agents" {{ cookieWhose == 'agents' ? 'checked' : '' }}> {{ mt._('_common.agents') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="whose" value="customers" {{ cookieWhose == '' or cookieWhose == 'customers' ? 'checked' : '' }}> {{ mt._('_common.customers') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
          </div>
        </div>
        {% set isAllWhose = cookieWhoseSet == -1 or cookieWhoseSet == '' %}
        <div class="row mt-10x">
          <div class="col-md-6">
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="whose-set" id="whose-set-all" value="all" {{ isAllWhose ? 'checked' : '' }}> {{ mt._('_common.allp') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="whose-set" id="whose-set-selection" value="selection" {{ not isAllWhose ? 'checked' : '' }}> {{ mt._('_common.selection') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <button type="button" class="btn btn-primary waves-effect waves-light m-0" id="select-whose-set" {{ isAllWhose ? 'style="display:none"' : '' }}>
              {{ mt._('_common.select') }}
            </button>
          </div>
        </div>
        <div class="row mt-10x ml-10x" id="total-selected" {{ isAllWhose ? 'style="display:none"' : '' }}>
          <div class="col-md-6" id="tot-selected-agents" {{ cookieWhose == 'agents' ? '' : 'style="display:none"' }}>
            {{ mt._('statistics.selected.age') }}: <span id="num-agents">{{ cookieWhose == 'agents' ? cookieWhoseSetCount : 0 }}</span>
          </div>
          <div class="col-md-6" id="tot-selected-customers" {{ cookieWhose == '' or cookieWhose == 'customers' ? '' : 'style="display:none"' }}>
            {{ mt._('statistics.selected.cus') }}: <span id="num-customers">{{ cookieWhose == '' or cookieWhose == 'customers' ? cookieWhoseSetCount : 0 }}</span>
          </div>
        </div>
      </div>
    </div>

    {% if seasons|length > 0 %}
    <div class="x_panel" id="season-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.seasons') }}</h2>
        <div class="clearfix"></div>
      </div>

      {% set isAllSeason = cookieWhichSeason == -1 or cookieWhichSeason == '' %}

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-6">
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="which-season-set" id="which-season-set-all" value="all" {{ isAllSeason ? 'checked' : '' }}> {{ mt._('_common.allf') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <label class="radio-container" style="height:34px;line-height:34px">
              <input type="radio" name="which-season-set" id="which-season-set-selection" value="selection"  {{ not isAllSeason ? 'checked' : '' }}> {{ mt._('_common.selection') }}
              <span class="radio-checkmark" style="margin-top:7px"></span>
            </label>
            <button type="button" class="btn btn-primary waves-effect waves-light m-0"
              id="select-which-season-set" {{ isAllSeason ? 'style="display:none"' : '' }} data-toggle="modal" data-target=".modal-which-season-set">
              {{ mt._('_common.select') }}
            </button>
          </div>
        </div>
        <div class="row mt-10x ml-10x" id="total-selected-seasons" {{ isAllSeason ? 'style="display:none"' : '' }}>
          <div class="col-md-6" id="tot-selected-seasons">{{ mt._('statistics.selected.sea') }}: <span id="num-seasons">{{ cookieWhichSeasonCount }}</span></div>
        </div>
      </div>
    </div>
    {% endif %}

    <div class="x_panel" id="orderstatus-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.status') }}</h2>
        <div class="clearfix"></div>
      </div>

      {% set has1 = false %}
      {% set has2 = false %}
      {% set has3 = false %}
      {% set has4 = false %}
      {% set has5 = false %}
      {% set has6 = false %}
      {% if cookieStatus|length > 0 %}
        {% for st in cookieStatus %}
          {% if st == 1 %}{% set has1 = true %}
            {% elseif st == 2 %}{% set has2 = true %}
            {% elseif st == 3 %}{% set has3 = true %}
            {% elseif st == 4 %}{% set has4 = true %}
            {% elseif st == 5 %}{% set has5 = true %}
            {% elseif st == 6 %}{% set has6 = true %}
          {% endif %}
        {% endfor %}
      {% endif %}
      <div class="x_content">
        <div class="row mt-10x">
          <div class="form-group">
            <label class="checkbox checkbox-container status-type sts5">
              <input type="checkbox" value="5" name="status-type[]" {{ has5 ? 'checked' : '' }}> {{ mt._('account.order.waitingquantity') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container status-type sts1">
              <input type="checkbox" value="1" name="status-type[]" {{ has1 ? 'checked' : '' }}> {{ mt._('account.order.provisional') }}
              <span class="checkbox-checkmark"></span>
            </label>
            {% if orderStateMgmt %}
            <label class="checkbox checkbox-container status-type sts6">
              <input type="checkbox" value="6" name="status-type[]" {{ has6 ? 'checked' : '' }}> {{ mt._('account.order.customerconfirmed') }}
              <span class="checkbox-checkmark"></span>
            </label>
            {% endif %}
            <label class="checkbox checkbox-container status-type sts2">
              <input type="checkbox" value="2" name="status-type[]" {{ has2 ? 'checked' : '' }}> {{ orderStateMgmt ? mt._('account.order.processed') : mt._('account.order.sent') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container status-type sts3">
              <input type="checkbox" value="3" name="status-type[]" {{ has3 ? 'checked' : '' }}> {{ mt._('account.order.accepted') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container status-type sts4">
              <input type="checkbox" value="4" name="status-type[]" {{ has4 ? 'checked' : '' }}> {{ mt._('account.order.rejected') }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
      </div>
    </div>

    <div class="x_panel" id="ordertype-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.ordertype') }}</h2>
        <div class="clearfix"></div>
      </div>

      {% set hasAva = false %}
      {% set hasRes = false %}
      {% if cookieTypes|length > 0 %}
        {% for tp in cookieTypes %}
          {% if tp == 'ava' %}{% set hasAva = true %}
          {% elseif tp == 'res' %}{% set hasRes = true %}
          {% endif %}
        {% endfor %}
      {% endif %}

      <div class="x_content">
        <div class="row mt-10x">
          <div class="form-group">
            <label class="checkbox checkbox-container status-type">
              <input type="checkbox" value="ava" name="order-type[]" {{ hasAva ? 'checked' : '' }}> {{ mt._('order.availability') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container status-type">
              <input type="checkbox" value="res" name="order-type[]" {{ hasRes ? 'checked' : '' }}> {{ mt._('order.reservation') }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
      </div>
    </div>

    {% if checkOrderPrices %}
    <div class="x_panel" id="prices-panel">
      <div class="x_title">
        <h2>{{ mt._('_common.prices') }}</h2>
        <div class="clearfix"></div>
      </div>

      {% set hasY = false %}
      {% set hasN = false %}
      {% if cookiePrices|length > 0 %}
        {% for pr in cookiePrices %}
          {% if pr == 'Y' %}{% set hasY = true %}
          {% elseif pr == 'N' %}{% set hasN = true %}
          {% endif %}
        {% endfor %}
      {% endif %}

      <div class="x_content">
        <div class="row mt-10x">
          <div class="form-group">
            <label class="checkbox checkbox-container status-type">
              <input type="checkbox" value="Y" name="prices[]" {{ hasY ? 'checked' : '' }}> {{ mt._('order.price.all') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container status-type">
              <input type="checkbox" value="N" name="prices[]" {{ hasN ? 'checked' : '' }}> {{ mt._('order.price.no') }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
      </div>
    </div>
    {% endif %}

    <div class="row">
      <div class="col-md-12 my-20x text-center">
        <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" id="load">{{ mt._('_common.load') }}</button>
      </div>
    </div>

    <div class="x_panel" id="orderresults-panel" style="display:none">
      <div class="x_title capitalize">
        <h2>{{ mt._('_common.orders') }}</h2>
        {% if enableExport %}
        <button type="button" class="btn btn-default waves-effect waves-light m-0 fr" id="export-all-orders">{{ mt._('admin.orders.exportall') }}</button>
        {% endif %}
        <div class="clearfix"></div>
      </div>

      <div class="x_content" id="orders-filter">
        <div class="row mt-10x">
          <table id="datatable-filter-orders" class="table table-striped table-bordered">
            <thead class="capitalize">
              <tr>
                <th>{{ mt._('_common.ordernumber') }}</th>
                <th>{{ mt._('_common.customer') }}</th>
                <th>{{ mt._('admin.username') }}</th>
                <th>{{ mt._('_common.agent') }}</th>
                <th>{{ mt._('_common.orderdate') }}</th>
                <th>{{ mt._('_common.delivery') }}</th>
                <th>{{ mt._('_common.catalog') }}</th>
                <th>{{ mt._('_common.quantity') }}</th>
                <th>{{ mt._('_common.amount.net') }}</th>
                <th>{{ mt._('_common.status') }}</th>
                <th></th>
                <th></th>
              </tr>
            </thead>
            <tbody>

            </tbody>
          </table>
          <div class="pt-10x" style="display:none" id="orders-error">{{ mt._('admin.orders.noorders') }}</div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for select agent/customer -->
<div class="modal fade modal-whose-set" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title"></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <input type="hidden" id="selected-whose-list" value="{{ cookieWhoseSet != -1 ? cookieWhoseSet : '' }}"/>

      <div class="modal-body">
        <div class="modal-section font-weight-bold">
          <div class="row pb-20x">
            <div class="col-md-4"><input type="text" style="line-height:28px;padding:0 5px" id="whose-search-field"/></div>
          </div>
        </div>
        <div id="whose-modal-content" class="pt-10x" style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>

        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-whose">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

{% if seasons|length > 0 %}
<!-- Modal for select season -->
<div class="modal fade modal-which-season-set" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.seasons') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <input type="hidden" id="selected-which-season-list" value=""/>

      <div class="modal-body">
        <div id="which-season-modal-content" class="pt-10x" style='min-height:200px;max-height:400px;overflow:hidden;overflow-y:auto'>
          <div class="row text-capitalize">
            <div class="col-md-1"></div>
            <div class="col-md-3">{{ mt._('_common.code') }}</div>
            <div class="col-md-8">{{ mt._('_common.name') }}</div>
          </div>
          {% for season in seasons %}
          <div class="row whose-row" style="line-height:25px">
            <div class="col-md-1">
              <label class="checkbox-whose checkbox-container">
                <input type="checkbox" name="which-season-checkbox[]" value="{{ season.cdstag }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="col-md-3 code">{{ season.cdstag }}</div>
            <div class="col-md-8 desc">{{ season.dsstag }}</div>
          </div>
          {% endfor %}
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-which-season">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% if enableDuplicate > 0 %}
<!-- Modal for duplicate order -->
<div class="modal fade modal-duplicate-order" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('order.duplicate') }} <span id="order-to-duplicate"></span></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <input type="hidden" id="duplicate-order-nuordc" value=""/>

      <div class="modal-body">
        <div class="row mb-20x">
          <div class="col-12 col-lg-3 new-order-label" style="line-height:34px">{{ mt._('order.selectcustomer') }}</div>
          <div class="col-12 col-lg-9">
            <select name="customer" id="customer-selector" class="form-control selectpicker" data-live-search="true">
              {% for anagra in customers %}
              {{ elements.getCustomerOptionForNewOrder(loop.index, anagra) }}
              {% endfor %}
            </select>
          </div>
        </div>
        <div class="row mb-20x" id="destination-container" style="display:none">
          <div class="col-12 col-lg-3 new-order-label" style="line-height:34px">{{ mt._('order.selectdestination') }}</div>
          <div class="col-12 col-lg-9">
            <select name="destination" id="destination-selector" class="form-control selectpicker" data-live-search="true">

            </select>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" data-dismiss="modal" id="confirm-duplicate-order">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

<!-- Modal for detail order -->
<div class="modal fade modal-order" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" id="modal-order-detail">
  <div class="modal-dialog modal-sm" style="width:75%">
    <div class="modal-content">

      <div class="modal-header">
        <button id="close-modal" type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" id="myModalLabel">{{ mt._('_common.order') }} <span id="md-nuordc"></span></h4>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.orderdate') }}:</span> <span id="md-dtmcli"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.agent') }}:</span> <span id="md-dsagen"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.pricelist') }}:</span> <span id="md-dslist"></span></div>
            <div class="order-detail-box col-md-12"><span class="order-md-title">{{ mt._('_common.customer') }}:</span> <span id="md-dsanag"></span></div>
            <div class="order-detail-box col-md-12"><span class="order-md-title">{{ mt._('_common.shipping') }}:</span> <span id="md-dsdesm"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.catalog') }}:</span> <span id="md-dscata"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('admin.condition.payment') }}:</span> <span id="md-dspaga"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('admin.condition.shipment') }}:</span> <span id="md-dstpor"></span></div>
            <div class="order-notes-box col-md-12"><span class="order-md-title">{{ mt._('_common.notes') }}:</span> <span id="md-dsnota"></span></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="first-row-order-detail">
            <div class="row-emprow">&nbsp;</div>
            <div class="row-ordrow">{{ mt._("rows") }}: <span id="tot-ordrow"></span></div>
            <div class="row-dtmcli"><span id="tot-dtmcli"></span></div>
            <div class="row-quanti"><span id="tot-quanti"></span></div>
            <div class="row-prezzo"><span id="tot-prezzo"></span></div>
            <div class="row-sconto"><span id="tot-sconto"></span></div>
            <div class="row-totale"><span id="tot-totale"></span></div>
          </div>
          <div class="header-row-order-detail">
            <div class="row-cdarti">{{ mt._("_common.code") }}</div>
            <div class="row-dsarti">{{ mt._("_common.description") }} / {{ mt._("_common.color") }}</div>
            <div class="row-dtmcli">{{ mt._("_common.delivery") }}</div>
            <div class="row-quanti">{{ mt._("_common.quantity") }}</div>
            <div class="row-prezzo">{{ mt._("cart.header.grosstotal") }}</div>
            <div class="row-sconto">{{ mt._("_common.discount") }}</div>
            <div class="row-totale">{{ mt._("_common.total") }}</div>
          </div>
          <div id="order-detail-rows"></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" id="btn-print-order">{{ mt._('_common.print') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Modal for xls -->
<div class="modal fade modal-xls-order px-0" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-sm" style="width:40%">
    <div class="modal-content" >
      <div class="modal-header">
        <h4 class="xls-order-title">{{ mt._('_common.modifyorder.xls') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body modal-body-xls-order">
        <div class="row mt-50x">
          <div class="col-md-6 xls-order-title left mb-20x">{{ mt._('_common.ordernumber.short') }} <span id="modal-xls-nuordc"></span></div>
          <div class="col-md-6">
            <div class="form-element form-select">
              <select name="xls-action" id="xls-action" class="form-control">
                <option value="0">{{ mt._('_common.template.download') }}</option>
                <option value="1">{{ mt._('_common.template.upload') }}</option>
              </select>
            </div>
          </div>
        </div>

        <div class="row xls-upload-info" style="opacity:0">
          <div class="col-md-12" style="margin-top:20px;font-size:13px">
            <form action="{{ url('excel/uploadCompiledXlsTemplateFromAdmin') }}" method="post" enctype="multipart/form-data" id="load-xls-template">
              <input type="file" name="file" id="xls_file">
            </form>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary left-btn w-50" id="xls-download-template">{{ mt._('order.template.download') }}</button>
            <button type="button" class="btn btn-primary left-btn w-50" id="xls-load-order" style="display:none">{{ mt._('order.upload') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for send order -->
<div class="modal fade modal-send-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-send" name="order-to-send" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.sendorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        {{ mt._('_common.sendorder.warning1') }} <span id="order-to-send-txt"></span>.<br/>{{ mt._('_common.sendorder.warning2') }}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row">
            <div class="col-md-6"><button type="button" class="btn btn-default w-50 left-btn text-capitalize" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-md-6"><button type="button" class="btn btn-primary w-50 right-btn text-capitalize" id="confirm-send-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
            <div class="col-md-6 right" id="confirm-send-order-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader", "style": "height:39px") }}</div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Modal for delete order -->
<div class="modal fade modal-delete-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-delete" name="order-to-delete" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.deleteorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        {{ mt._('_common.deleteorder.warning1') }} <span id="order-to-delete-txt"></span>.<br/>{{ mt._('_common.deleteorder.warning2') }}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row">
            <div class="col-md-6"><button type="button" class="btn btn-default w-50 left-btn text-capitalize" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-md-6"><button type="button" class="btn btn-primary w-50 right-btn text-capitalize" id="confirm-delete-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
