
<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title capitalize">
        <h2>{{ mt._('admin.menu.openorders') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content" id="orders-filter">
        <div class="row mt-10x">
          {% if orders|length > 0 %}
          <table id="datatable-orders" class="table table-striped table-bordered">
            <thead class="capitalize">
              <tr>
                <th>{{ mt._('_common.ordernumber') }}</th>
                <th>username</th>
                <th>{{ mt._('_common.agent') }}</th>
                <th>{{ mt._('_common.customer') }}</th>
                <th>{{ mt._('_common.orderdate') }}</th>
                <th>{{ mt._('_common.delivery') }}</th>
                <th>{{ mt._('_common.catalog') }}</th>
                <th>{{ mt._('_common.quantity') }}</th>
                <th>{{ mt._('_common.value') }}</th>
                <th>{{ mt._('_common.currency') }}</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
            {% for order in orders %}
              <tr data-nuordc="{{ order.nuordc }}">
                <td>{{ order.nuordc }}</td>
                <td>{{ order.username }}</td>
                <td>{{ order.dsagen }}</td>
                <td>{{ order.descri }}</td>
                <td>{{ order.dtcrea }}</td>
                <td>{{ order.dtmcoi != null and order.dtmcof != null ? order.dtmcoi ~ ' - ' ~ order.dtmcof : order.dtmcli }}</td>
                <td>{{ order.cdcata }}</td>
                <td>{{ order.quanti }}</td>
                <td>{{ order.valore|currency }}</td>
                <td>{{ order.cdvalu }}</td>
                <td class="text-center">
                  <a href="#" class="no-deco" data-toggle="modal" data-target=".modal-delete-order">
                    {{ image('assets/img/delete.jpg', "title": mt._('_common.delete'), "class": "delete-order", "style": "cursor:pointer") }}
                  </a>
                </td>
              </tr>
            {% endfor %}
            </tbody>
          </table>
          {% else %}
          <div class="pt-10x">{{ mt._('admin.orders.noorders') }}</div>
          {% endif %}
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete order -->
<div class="modal fade modal-delete-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-delete" name="order-to-delete" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.deleteorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        {{ mt._('_common.deleteorder.warning1') }} <span id="order-to-delete-txt"></span>.<br/>{{ mt._('_common.deleteorder.warning2') }}
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row">
            <div class="col-md-6"><button type="button" class="btn btn-default w-50 left-btn text-capitalize" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-md-6"><button type="button" class="btn btn-primary w-50 right-btn text-capitalize" id="confirm-delete-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
