{%- macro toDropdownTree(list, lang, level = 0, prevlabel = '', disabled = false) %}
    {% for _el in list %}
        {% set isDisabled = disabled or not _el['element'].enabled %}
        {% set label = ((prevlabel is not empty ? prevlabel ~ ' ⇒ ' : '') ~ _el['element'].getLabel())|trim %}
        <li class="{{ isDisabled ? 'disabled' : '' }}">
            <a href="#" data-value="{{ _el['element'].id|escape_attr }}" data-label="{{ label }}"
               class="{{ isDisabled ? 'disabled' : '' }}">
                {% if (level > 0) %}
                    {% if (level > 1) %}
                        {% for index in 1..level %}
                            {{ (loop.first ? '│' : '') }}&nbsp;
                        {% endfor %}
                    {% endif %}
                    {{ loop.last ? '└─' : '├─' }}
                {% endif %}
                {{ _el['element'].getLabel(lang) }}
            </a>
        </li>

        {% if _el['sub'] is defined and _el['sub'] is not empty %}
            {{ toDropdownTree(_el['sub'], lang, level + 1, label, isDisabled) }}
        {% endif %}

        {% if not loop.last and _el['element'].isRoot() %}
            <li role="separator" class="divider"></li>
        {% endif %}
    {% endfor %}
{% endmacro %}

<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title" style="margin-bottom:0">
                <h2>{{ mt._('_common.model') }}</h2>
                <div class="clearfix"></div>
            </div>

            {% if success >= 0 %}
                {% if success > 0 %}
                    <div class="msg-success-model-info">{{ mt._('_common.generic.db.success') }}</div>
                {% else %}
                    <div class="msg-error-model-info">{{ mt._('_common.generic.db.error') }}</div>
                {% endif %}
            {% endif %}

            <form action="{{ url('admin/updateModelInfo') }}" method="post" enctype="multipart/form-data">
                <div class="x_content" style="margin-top:0">
                    <div class="row info-model">
                        <div class="col-md-2 col-sm-12 col-xs-12">
                            <span class="pr-10x">{{ mt._('_common.code') }}:</span>
                            <span style="color:#333">{{ model.cdartn }}</span>
                            <input type="hidden" id="cdartn" name="cdartn" value="{{ model.cdartn }}"/>
                        </div>
                        <div class="col-md-10 col-sm-12 col-xs-12">
                            <span class="pr-10x">{{ mt._('_common.description') }}:</span>
                            <span style="color:#333">{{ model.dsartn }}</span>
                        </div>
                    </div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <span class="pr-10x bold">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }}{{ model.dsserm != '' ? ' / ' ~ mt._('_common.series') : '' }}:</span>
                            <span style="color:#333">{{ model.dstitl }} / {{ model.dslinm }}{{ model.dsserm != '' ? ' / ' ~ model.dsserm : '' }}</span>
                        </div>
                    </div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-6 col-sm-12 col-xs-12">
                            <span class="pr-10x bold capitalize">{{ mt._('_common.type') }}:</span>
                            <span class="pr-25x" style="color:#333333">{{ model.dstmod }}</span>
                            <span class="pr-10x bold capitalize">{{ mt._('_common.genre') }}:</span>
                            <span class="pr-25x" style="color:#333333">{{ model.dsgene }}</span>
                            <span class="pr-10x bold capitalize">{{ mt._('_common.season') }}:</span>
                            <span class="pr-25x" style="color:#333333">{{ model.dsstag }}</span>
                        </div>
                    </div>
                    <div class="row pt-20x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;border-bottom:2px solid #E6E9ED">
                        <div class="col-md-6 col-sm-12 col-xs-12" style="line-height:34px">
                            <div class="fl pr-10x bold capitalize">{{ mt._('admin.seqrap') }}:</div>
                            <div class="fl"><input type="number" class="form-control" min="0" value="{{ model.seqrap }}"
                                                   name="seqrap" id="seqrap"/></div>
                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <input type="submit" class="btn btn-primary right-btn w-30"
                                   value="{{ mt._('_common.save') }}"/>
                            <div id="error-fill" class="msg-error"
                                 style="clear:both">{{ mt._('admin.discount.fillallfields') }}</div>
                            <div id="error-present" class="msg-error"
                                 style="clear:both">{{ mt._('admin.discount.alreadypresent') }}</div>
                        </div>
                    </div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.visibility') }}</div>
                    </div>
                    <div class="row pt-25x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;border-bottom:2px solid #E6E9ED">
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class='pr-20x fl bold' style="line-height:40px">{{ mt._('admin.visiblefrom') }}</div>
                            <input type="hidden" style="width:200px" name="dtiniz" id="dtiniz" class="form-control"
                                   value="{{ model.dtiniz }}"/>
                            <div id="dtiniz-box" class="row fl py-5x px-10x"
                                 style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:150px">
                                <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                                </div>
                                <div class='col-md-9 px-0'><span></span></div>
                                <div class='col-md-1 px-0'><b class="caret"></b></div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class='pr-20x fl bold' style="line-height:40px">{{ mt._('admin.visibleto') }}</div>
                            <input type="hidden" style="width:200px" name="dtfine" id="dtfine" class="form-control"
                                   value="{{ model.dtfine }}"/>
                            <div id="dtfine-box" class="row pull-left py-5x px-10x"
                                 style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:150px">
                                <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                                </div>
                                <div class='col-md-9 px-0'><span></span></div>
                                <div class='col-md-1 px-0'><b class="caret"></b></div>
                            </div>
                        </div>
                    </div>

                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.description') }}</div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.it') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="descit"
                                      name="descit">{{ model.descit }}</textarea>
                        </div>

                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.en') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="descen"
                                      name="descen">{{ model.descen }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.es') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="desces"
                                      name="desces">{{ model.desces }}</textarea>
                        </div>

                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.fr') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="descfr"
                                      name="descfr">{{ model.descfr }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.de') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="descde"
                                      name="descde">{{ model.descde }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-25x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;border-bottom:2px solid #E6E9ED"></div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.details') }}</div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.it') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="dettit"
                                      name="dettit">{{ model.dettit }}</textarea>
                        </div>

                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.en') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="detten"
                                      name="detten">{{ model.detten }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.es') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="dettes"
                                      name="dettes">{{ model.dettes }}</textarea>
                        </div>

                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.fr') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="dettfr"
                                      name="dettfr">{{ model.dettfr }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-10x mb-20x">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.lang.de') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <textarea rows="4" class="form-control jqte-test" id="dettde"
                                      name="dettde">{{ model.dettde }}</textarea>
                        </div>
                    </div>
                    <div class="row pt-25x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;border-bottom:2px solid #E6E9ED"></div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.classifications') }}</div>
                    </div>
                    <div class="row pt-25x pb-15x" style="margin-left:-5px;margin-right:-5px;line-height:35px">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('admin.classification.1') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <div class="input-group classification-path">
                                <input type="hidden" name="clsfz[1]"
                                       value="{{ model.clsfz1 is not empty ? model.clsfz1 : '' }}">
                                <input type="text" class="form-control" list="classification1-list" value="">
                                <datalist id="classification1-list"></datalist>
                                <div class="input-group-btn">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"><span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        {{ toDropdownTree(classifications, session.get('language')) }}
                                    </ul>
                                </div><!-- /btn-group -->
                            </div><!-- /input-group -->
                        </div>
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('admin.classification.2') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <div class="input-group classification-path">
                                <input type="hidden" name="clsfz[2]"
                                       value="{{ model.clsfz2 is not empty ? model.clsfz2 : '' }}">
                                <input type="text" class="form-control" list="classification2-list" value="">
                                <datalist id="classification2-list"></datalist>
                                <div class="input-group-btn">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"><span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        {{ toDropdownTree(classifications, session.get('language')) }}
                                    </ul>
                                </div><!-- /btn-group -->
                            </div><!-- /input-group -->
                        </div>
                    </div>
                    <div class="row pt-25x pb-15x" style="margin-left:-5px;margin-right:-5px;line-height:35px">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('admin.classification.3') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <div class="input-group classification-path">
                                <input type="hidden" name="clsfz[3]"
                                       value="{{ model.clsfz3 is not empty ? model.clsfz3 : '' }}">
                                <input type="text" class="form-control" list="classification3-list" value="">
                                <datalist id="classification3-list"></datalist>
                                <div class="input-group-btn">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"><span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        {{ toDropdownTree(classifications, session.get('language')) }}
                                    </ul>
                                </div><!-- /btn-group -->
                            </div><!-- /input-group -->
                        </div>
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('admin.classification.4') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element">
                            <div class="input-group classification-path">
                                <input type="hidden" name="clsfz[4]"
                                       value="{{ model.clsfz4 is not empty ? model.clsfz4 : '' }}">
                                <input type="text" class="form-control" list="classification4-list" value="">
                                <datalist id="classification4-list"></datalist>
                                <div class="input-group-btn">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false"><span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        {{ toDropdownTree(classifications, session.get('language')) }}
                                    </ul>
                                </div><!-- /btn-group -->
                            </div><!-- /input-group -->
                        </div>
                    </div>
                    <div class="row pt-25x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;border-bottom:2px solid #E6E9ED"></div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.notes') }}</div>
                    </div>
                    <div class="row pt-25x pb-15x" style="margin-left:-5px;margin-right:-5px;line-height:35px">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.madein') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element"><input type="text" class="form-control"
                                                                                      id="madein" name="madein"
                                                                                      value="{{ model.madein }}"/></div>
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.composition') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element"><input type="text" class="form-control"
                                                                                      id="compos" name="compos"
                                                                                      value="{{ model.compos }}"/></div>
                    </div>
                    <div class="row pt-25x pb-25x"
                         style="margin-left:-5px;margin-right:-5px;line-height:35px;border-bottom:2px solid #E6E9ED">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.fit') }}</div>
                        <div class="col-md-5 col-sm-12 col-xs-12 form-element"><input type="text" class="form-control"
                                                                                      id="vestib" name="vestib"
                                                                                      value="{{ model.vestib }}"/></div>
                    </div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px">
                        <div class="col-md-12 col-sm-12 col-xs-12 capitalize bold">{{ mt._('_common.upload') }}</div>
                    </div>
                    <div class="row pt-25x" style="margin-left:-5px;margin-right:-5px;line-height:20px">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">pdf</div>
                        <div class="col-md-11 col-sm-12 col-xs-12 form-element">
                            <input type="file" name="filpdf" id="filpdf" accept="application/pdf">
                        </div>
                        {% if model.filpdf != '' %}
                            <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.currentfile') }}</div>
                            <div class="col-md-11 col-sm-12 col-xs-12 pt-10x">
                                <embed width="210" height="297" name="plugin"
                                       src="../../upload/products/{{ model.filpdf }}" type="application/pdf">
                            </div>
                        {% endif %}
                    </div>
                    <div class="row pt-25x pb-25x" style="margin-left:-5px;margin-right:-5px;line-height:20px">
                        <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">video</div>
                        <div class="col-md-11 col-sm-12 col-xs-12 form-element"><input type="file" name="filvid"
                                                                                       id="filvid" accept="video/*">
                        </div>
                        {% if model.filvid != '' %}
                            <div class="col-md-1 col-sm-12 col-xs-12 capitalize bold right">{{ mt._('_common.currentfile') }}</div>
                            <div class="col-md-11 col-sm-12 col-xs-12 pt-10x">
                                <video style="max-width:500px;max-height:200px" controls>
                                    <source src="../../upload/products/{{ model.filvid }}" type="video/mp4"/>
                                    <source src="../../upload/products/{{ model.filvid }}" type="video/ogg"/>
                                    <source src="../../upload/products/{{ model.filvid }}" type="video/webm"/>
                                    <object data="../../upload/products/{{ model.filvid }}">
                                        <embed src="../../upload/products/{{ model.filvid }}">
                                    </object>
                                </video>
                            </div>
                        {% endif %}
                    </div>
                    <div class="row pt-25x pb-25x">
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <a href="{{ url('admin/productinfo') }}"
                               class="btn btn-default left-btn w-30">{{ mt._('_common.close') }}</a>
                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <input type="submit" class="btn btn-primary right-btn w-30"
                                   value="{{ mt._('_common.save') }}"/>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>
