<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('_common.gallery') }} {{ title }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row pb-10x">
      <div class="col-md-6 col-sm-6 col-xs-6">
        <a href="{{ url('admin/galleries') }}" class="btn btn-default left-btn w-30">{{ mt._('_common.close') }}</a>
      </div>
    </div>
    <div class="row">
      <div class="col-md-9 col-sm-12 col-xs-12 gallery-image p-0" id="wrapper">
        {{ image("upload/galleries/" ~ gallery.flimag, "style": "margin:0 auto;width:100%;height:auto", "alt": title, "title": title, "id": "canvas") }}
        {% for point in points %}
        <div class='circle' id='point-{{ loop.index }}'
          data-perc-old-coordx='{{ point.coordx }}' data-perc-coordx='{{ point.coordx }}'
          data-perc-old-coordy='{{ point.coordy }}' data-perc-coordy='{{ point.coordy }}'
          data-perc-old-radius='{{ point.radius }}' data-perc-radius='{{ point.radius }}'
          data-old-des-it='{{ point.des_it }}' data-des-it='{{ point.des_it }}'
          data-old-des-en='{{ point.des_en }}' data-des-en='{{ point.des_en }}'
          data-old-des-es='{{ point.des_es }}' data-des-es='{{ point.des_es }}'
          data-old-des-fr='{{ point.des_fr }}' data-des-fr='{{ point.des_fr }}'
          data-old-des-de='{{ point.des_de }}' data-des-de='{{ point.des_de }}'
          data-old-code='{{ point.codice }}' data-code='{{ point.codice }}' title='{{ point.des_it }}'>+</div>
        {% endfor %}
      </div>
      <div class="col-md-3 col-sm-12 col-xs-12 pl-20x">
        <div class="row">
          <div class="col-md-12">
            <i class="fa fa-pencil gallery-tool-button"></i>
            <i class="fa fa-eraser gallery-tool-button"></i>
            <i class="fa fa-floppy-o gallery-tool-button"></i>
            <div class="fl ml-10x not-saved-warning" style="line-height:50px;display:none">* {{ mt._('admin.galleries.notsaved') }}</div>
          </div>
        </div>
        <div class="row" id="info-container" style="margin-top:60px;display:none">
          <input type="hidden" id="removed-elements" value="0"/>
          <div class="col-md-4">
    				<label for="coord-x" class="control-label bold">X</label>
    				<input type="number" id="coord-x" name="coord-x" class="form-control" value="0" min="0" title="X">
          </div>
          <div class="col-md-4">
    				<label for="coord-y" class="control-label bold">Y</label>
    				<input type="number" id="coord-y" name="coord-y" class="form-control" value="0" min="0" title="Y">
          </div>
          <div class="col-md-4">
    				<label for="coord-x" class="control-label bold">{{ mt._('admin.galleries.radius') }}</label>
    				<input type="number" id="coord-radius" name="coord-radius" class="form-control" value="0" min="0" title="{{ mt._('admin.galleries.radius') }}">
          </div>
          <div class="col-md-12 mt-10x">
            <label for="circle-product" class="bold" style="width:100%">{{ mt._('_common.product') }}</label>
            <select id="circle-product" name="circle-product" class="form-control selectpicker" title="{{ mt._('_common.products') }}" data-live-search="true">
              {% for product in products %}
              {% if galleryType == 1 %}
              <option value="{{ product.cdartn }}" data-description="{{ product.dsartn }}">{{ product.cdartn }} - {{ product.dsartn }}</option>
              {% else %}
              <option value="{{ product.cdarti }}" data-description="{{ product.dsarti }}">{{ product.cdarti }} - {{ product.dsarti }}</option>
              {% endif %}
              {% endfor %}
            </select>
          </div>
          <div class="col-md-12 mt-10x">
    				<label for="circle-des-it" class="control-label bold">{{ mt._('_common.description') }} IT</label>
    				<input type="text" id="circle-des-it" name="circle-title" class="form-control" title="{{ mt._('_common.description') }} IT" style="width:280px">
          </div>
          <div class="col-md-12 mt-10x">
    				<label for="circle-des-en" class="control-label bold">{{ mt._('_common.description') }} EN</label>
    				<input type="text" id="circle-des-en" name="circle-title" class="form-control" title="{{ mt._('_common.description') }} EN" style="width:280px">
          </div>
          <div class="col-md-12 mt-10x">
    				<label for="circle-des-es" class="control-label bold">{{ mt._('_common.description') }} ES</label>
    				<input type="text" id="circle-des-es" name="circle-title" class="form-control" title="{{ mt._('_common.description') }} ES" style="width:280px">
          </div>
          <div class="col-md-12 mt-10x">
    				<label for="circle-des-fr" class="control-label bold">{{ mt._('_common.description') }} FR</label>
    				<input type="text" id="circle-des-fr" name="circle-title" class="form-control" title="{{ mt._('_common.description') }} FR" style="width:280px">
          </div>
          <div class="col-md-12 mt-10x">
    				<label for="circle-des-de" class="control-label bold">{{ mt._('_common.description') }} DE</label>
    				<input type="text" id="circle-des-de" name="circle-title" class="form-control" title="{{ mt._('_common.description') }} DE" style="width:280px">
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
