<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.galleries') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="col-md-12 form-group">
        <label class="control-label col-md-3 col-sm-3 col-xs-12" style="text-align:right;line-height:34px">{{ mt._('admin.selectcatalog') }}</label>
        <div class="col-md-6 col-sm-6 col-xs-12">
          <select class="select2_single form-control" id="select-catalog" tabindex="-1">
            <option value="none"> </option>
            {% for catalog in catalogs %}
            <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
            {% endfor %}
          </select>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="x_panel" id="galleries-panel" style="display:none">
  <div class="x_title">
    <h2>{{ mt._('admin.galleries') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row mt-20x">
      <div class="col-md-6"><button class="btn btn-primary w-30 left-btn" data-toggle="modal" data-target=".modal-add-gallery">{{ mt._('admin.galleries.add') }}</button></div>
    </div>

    <div class="row mt-20x" id="galleries-container">

    </div>

    <div class="row mt-20x">
      <div class="col-md-6"><button class="btn btn-primary w-30 left-btn" data-toggle="modal" data-target=".modal-add-gallery">{{ mt._('admin.galleries.add') }}</button></div>
    </div>
  </div>
</div>

<!-- Modal for add gallery -->
<div class="modal fade modal-add-gallery" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm" style="width:30%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.galleries.new') }}</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-12 bold text-center mb-30x">{{ mt._('_common.description') }}</div>
          <label for="new-des-it" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.it') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="new-des-it" name="new-des-it" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-en" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.en') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="new-des-en" name="new-des-en" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-es" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.es') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="new-des-es" name="new-des-es" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-fr" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.fr') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="new-des-fr" name="new-des-fr" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-de" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.de') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="new-des-de" name="new-des-de" class="form-control" maxlength="60" size="60"></div>
        </div>
        <div class="row center" style="padding-bottom:10px">
          <div class="col-md-12 col-sm-12 col-xs-12 bold">{{ mt._('_common.image') }}</div>
          <div class="col-md-12 col-sm-12 col-xs-12 form-group">
            <form action="{{ url('admin/uploadImage/galleries') }}" class="dropzone" id="dropzone-add-image" style="min-height:200px"></form>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-gallery">{{ mt._('_common.save') }}</button>
          </div>
          <div class="col-md-12 msg-error">{{ mt._('_common.missingfields') }}</div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for change image -->
<div class="modal fade modal-change-image" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('_common.image.change') }}</h4>
      </div>
      <div class="modal-body">
        <input type="hidden" id="current-id"/>
        <input type="hidden" id="new-image"/>
        <div class="row center" style="padding-bottom:10px">
          <div class="col-md-2 col-sm-2 col-xs-12">
            <div>{{ mt._('_common.image.current') }}</div>
            <div><img id="current-image" class="w-100"/></div>
          </div>
          <div class="col-md-10 col-sm-10 col-xs-12 form-group">
            <form action="{{ url('admin/uploadImage/galleries') }}" class="dropzone" id="dropzone-change-image"></form>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12 bold">
            {{ mt._('admin.galleries.warning') }}
          </div>
          <div class="col-md-12 col-sm-12 col-xs-12">
            <label class="checkbox-container">
              <input type="checkbox" name="confirm-delete-checkbox" id="confirm-delete-checkbox"/>{{ mt._('admin.galleries.confirm') }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="change-image">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for change description -->
<div class="modal fade modal-change-description" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm" style="width:30%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('_common.description.change') }}</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-12 bold text-center mb-30x">{{ mt._('_common.description') }}</div>
          <label for="new-des-it" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.it') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="change-des-it" name="change-des-it" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-en" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.en') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="change-des-en" name="change-des-en" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-es" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.es') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="change-des-es" name="change-des-es" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-fr" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.fr') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="change-des-fr" name="change-des-fr" class="form-control" maxlength="60" size="60"></div>
          <label for="new-des-de" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize text-right mb-10x" style="line-height:34px">{{ mt._('_common.lang.de') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 mb-10x"><input type="text" id="change-des-de" name="change-des-de" class="form-control" maxlength="60" size="60"></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="change-description">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete gallery -->
<div class="modal fade modal-delete-gallery" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-gltest-nugall" name="modal-gltest-nugall"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.galleries.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.galleries.deleteconfirm') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-nugall">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
