{% set sel_tl = false %}
{% set sel_lm = false %}
{% set sel_sm = false %}
{% set sel_tm = false %}
{% set sel_an = false %}
{% set sel_ar = false %}
{% if discount is not null %}
  {% set curr_tpdisc = discount.tpdisc %}
  {% if curr_tpdisc > 31 %}{% set sel_tl = true %}{% set curr_tpdisc = curr_tpdisc - 32 %}{% endif %}
  {% if curr_tpdisc > 15 %}{% set sel_lm = true %}{% set curr_tpdisc = curr_tpdisc - 16 %}{% endif %}
  {% if curr_tpdisc > 7 %}{% set sel_sm = true %}{% set curr_tpdisc = curr_tpdisc - 8 %}{% endif %}
  {% if curr_tpdisc > 3 %}{% set sel_tm = true %}{% set curr_tpdisc = curr_tpdisc - 4 %}{% endif %}
  {% if curr_tpdisc > 1 %}{% set sel_an = true %}{% set curr_tpdisc = curr_tpdisc - 2 %}{% endif %}
  {% if curr_tpdisc > 0 %}{% set sel_ar = true %}{% set curr_tpdisc = curr_tpdisc - 1 %}{% endif %}
{% endif %}

<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ discount is not null ? mt._('admin.discount.modifydiscount') : mt._('admin.newdiscount') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row">
          <div class="col-xs-12 col-sm-3">
            <div class="row">
              {{ discount is not null ? '<div class="col-xs-12"><span class="bold">' ~ mt._('_common.id') ~ ' ' ~ discount.numdis ~ '</span></div>' : '' }}
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.code') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                {% if discount is not null %}
                  <span class="form-control text-input">{{ discount.cddisc }}</span>
                {% else %}
                  <input type="text" id="cddisc" value="" class="text-input"/>
                {% endif %}
              </div>
            </div>
          </div>
          <div class="col-sm-9 col-xs-12">
            <div class="row">
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.description') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <input type="text" id="dsdisc" value="{{ discount is not null ? discount.dsdisc : '' }}" class="text-input"/>
              </div>
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.validity') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <span class="add-on input-group-addon fl" style="width:26px;height:35px;padding:6px 0px 0px 0px"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span>
                <input type="text" name="validity" id="validity" class="form-control fl" value="{{ discount is not null ? discount.validity : '' }}"/>
              </div>
            </div>
            <div class="row pt-10x">
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.catalogs') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <select class="selectpicker form-control" id="catalogs-select" name="catalogs" multiple data-actions-box="true">
                {% for catalog in catalogs %}
                  {% set selected = false %}
                  {% if discount is not null %}
                    {% for el in sel_ctlg if el.cdcata == catalog.cdcata %}{% set selected = true %}{% endfor %}
                  {% endif %}
                  <option value="{{ catalog.cdcata }}" {{ selected ? 'selected' : '' }}>{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
                {% endfor %}
                </select>
              </div>
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.pricelists') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <select class="selectpicker form-control" id="pricelists-select" name="pricelists" multiple data-actions-box="true">
                {% for list in pricelists %}
                  {% set selected = false %}
                  {% if discount is not null %}
                    {% for el in sel_list if el.nulist == list.nulist %}{% set selected = true %}{% endfor %}
                  {% endif %}
                  <option value="{{ list.nulist }}" {{ selected ? 'selected' : '' }}>{{ list.nulist }} - {{ list.dslist }}</option>
                {% endfor %}
                </select>
              </div>
            </div>
            <div class="row pt-10x">
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('admin.condition.port') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <select class="selectpicker form-control" id="ports-select" name="ports" multiple data-actions-box="true">
                  {% for port in ports %}
                    {% set selected = false %}
                    {% if discount is not null %}
                      {% for el in sel_ports if el.tpport == port.tpport %}{% set selected = true %}{% endfor %}
                    {% endif %}
                    <option value="{{ port.tpport }}" {{ selected ? 'selected' : '' }}>{{ port.tpport }} - {{ port.dstpor }}</option>
                  {% endfor %}
                </select>
                <label class="checkbox-container">
                  <input type="checkbox" id="flpora" {% if discount is not null %}{{ (discount.flpora ? 'checked' : '') }} disabled{% endif %}>{{ mt._('statistics.selected.ports.all') }}
                  <span class="checkbox-checkmark"></span>
                </label>
              </div>
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('admin.condition.payment') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                <select class="selectpicker form-control" id="payments-select" name="payments" multiple data-actions-box="true">
                  {% for payment in payments %}
                    {% set selected = false %}
                    {% if discount is not null %}
                      {% for el in sel_payments if el.tppaga == payment.tppaga %}{% set selected = true %}{% endfor %}
                    {% endif %}
                    <option value="{{ payment.tppaga }}" {{ selected ? 'selected' : '' }}>{{ payment.tppaga }} - {{ payment.dspaga }}</option>
                  {% endfor %}
                </select>
                <label class="checkbox-container">
                  <input type="checkbox" id="flpaga" {% if discount is not null %}{{ (discount.flpaga ? 'checked' : '') }} disabled{% endif %}>{{ mt._('statistics.selected.paga.all') }}
                  <span class="checkbox-checkmark"></span>
                </label>
              </div>
            </div>
            <div class="row pt-10x">
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.type') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12" style="text-transform:capitalize!important">
                <select class="selectpicker form-control" id="types-select" name="types" multiple data-actions-box="true">
                  <option value="32" {{ sel_tl ? 'selected' : '' }}>{{ mt._('_common.brand') }}</option>
                  <option value="16" {{ sel_lm ? 'selected' : '' }}>{{ mt._('_common.line') }}</option>
                  <option value="8" {{ sel_sm ? 'selected' : '' }}>{{ mt._('_common.series') }}</option>
                  <option value="4" {{ sel_tm ? 'selected' : '' }}>{{ mt._('_common.modeltype') }}</option>
                  <option value="2" {{ sel_an ? 'selected' : '' }}>{{ mt._('_common.models') }}</option>
                  <option value="1" {{ sel_ar ? 'selected' : '' }}>{{ mt._('_common.articles') }}</option>
                </select>
              </div>
              <div class="col-md-2 col-sm-12 col-xs-12 right bold capitalize pt-10x">{{ mt._('_common.customers') }}</div>
              <div class="col-md-4 col-sm-12 col-xs-12">
                {% if discount is not null %}
                  {% set inputValue = '' %}
                  {% if discount.fltota %}
                    {% set inputValue = mt._('statistics.selected.cus.all') %}
                  {% elseif sel_anag|length == 1 %}
                    {% set inputValue = "1 " ~  mt._('_common.customer') %}
                  {% else %}
                    {% set inputValue = sel_anag|length ~ " " ~ mt._('_common.customers') %}
                  {% endif %}
                <input type="text" class="text-input" id="customers" disabled="disabled" value="{{ inputValue }}"/>
                {% else %}
                <select class="selectpicker form-control" id="customers-select" name="customers" multiple data-actions-box="true">
                {% for customer in customers %}
                  {% set selected = false %}
                  {% if discount is not null %}
                    {% for el in sel_anag if el.tpanag == customer.tpanag and el.cdanag == customer.cdanag %}{% set selected = true %}{% endfor %}
                  {% endif %}
                  <option class="cus_opt" data-tpanag="{{ customer.tpanag }}" data-cdanag="{{ customer.cdanag }}"
                  value="{{ customer.tpanag }}_{{ customer.cdanag }}"
                  {{ selected ? 'selected' : '' }}>{{ customer.cdanag }} - {{ customer.descri }}</option>
                {% endfor %}
                </select>
                {% endif %}
                <label class="checkbox-container">
                  <input type="checkbox" id="fltota">{{ mt._('statistics.selected.cus.all') }}
                  <span class="checkbox-checkmark"></span>
                </label>
              </div>
            </div>
          </div>
        </div>

        <div class="row pt-25x">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <a href="{{ url('admin/customdiscountlist') }}" class="btn btn-default left-btn w-30">{{ mt._('_common.close') }}</a>
          </div>
          {% if discount is null %}
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-30" id="create-discount">{{ mt._('admin.newdiscount') }}</button>
            <div id="error-fill" class="msg-error" style="clear:both">{{ mt._('admin.discount.fillallfields') }}</div>
            <div id="error-present" class="msg-error" style="clear:both">{{ mt._('admin.discount.alreadypresent') }}</div>
          </div>
          {% endif %}
        </div>

        <div class="row pt-25x" id="discount-body" data-numdis="{{ discount is not null ? discount.numdis : '' }}" {{ discount is null ? 'style="display:none"' : '' }}>
          <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
            <li role="presentation">
              <a href="#tab_content_brand" data-anchor="tab_content_brand" id="tab_brand" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.brand') }}</a>
            </li>
            <li role="presentation">
              <a href="#tab_content_line" data-anchor="tab_content_line" id="tab_line" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.line') }}</a>
            </li>
            <li role="presentation">
              <a href="#tab_content_series" data-anchor="tab_content_series" id="tab_series" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.series') }}</a>
            </li>
            <li role="presentation">
              <a href="#tab_content_modeltype" data-anchor="tab_content_modeltype" id="tab_modeltype" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.modeltype') }}</a>
            </li>
            <li role="presentation">
              <a href="#tab_content_models" data-anchor="tab_content_models" id="tab_models" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.models') }}</a>
            </li>
            <li role="presentation">
              <a href="#tab_content_articles" data-anchor="tab_content_articles" id="tab_articles" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.articles') }}</a>
            </li>
          </ul>

          <div class="row py-10x">
            <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-primary right-btn w-30 save-rules">{{ mt._('_common.save') }}</button>
            </div>
          </div>

          <div id="myTabContent" class="tab-content">
            <div role="tabpanel" class="tab-pane fade" id="tab_content_brand" aria-labelledby="tab_brand">
              <table id="table-brand" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['titlin'] : '' }}</tbody>
              </table>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab_content_line" aria-labelledby="tab_line">
              <table id="table-line" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['linmod'] : '' }}</tbody>
              </table>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab_content_series" aria-labelledby="tab_series">
              <table id="table-series" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('_common.line') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['sermod'] : '' }}</tbody>
              </table>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab_content_modeltype" aria-labelledby="tab_modeltype">
              <table id="table-modeltype" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['tpmode'] : '' }}</tbody>
              </table>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab_content_models" aria-labelledby="tab_models">
              <table id="table-model" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['tipolo'] : '' }}</tbody>
              </table>
            </div>

            <div role="tabpanel" class="tab-pane fade" id="tab_content_articles" aria-labelledby="tab_articles">
              <table id="table-article" class="table table-striped table-bordered w-100">
                <thead>
                  <tr>
                    <th>{{ mt._('_common.code.short') }}</th>
                    <th>{{ mt._('_common.description') }}</th>
                    <th>{{ mt._('_common.model') }}</th>
                    <th>{{ mt._('admin.discount.condition') }}</th>
                  </tr>
                </thead>
                <tbody>{{ discount is not null ? rules['anaart'] : '' }}</tbody>
              </table>
            </div>
          </div>

          <div class="row pt-25x">
            <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-primary right-btn w-30 save-rules">{{ mt._('_common.save') }}</button>
            </div>
          </div>

        </div>

      </div>
    </div>
  </div>
</div>
