
<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.dashboard') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row mb-20x ml-0 mr-0">
      <div class="stats-box" style="margin-left:8.8%;width:16%">
        <div class="stats-box-title">{{ mt._('admin.dashboard.totactivecus') }}</div>
        <div class="stats-box-value" style="color:#00a9cc">{{ tot['cus'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('admin.dashboard.totactiveage') }}</div>
        <div class="stats-box-value" style="color:#00a9cc">{{ tot['age'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('admin.dashboard.totactivecat') }}</div>
        <div class="stats-box-value" style="color:#00a9cc">{{ tot['cat'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('admin.dashboard.totmodels') }}</div>
        <div class="stats-box-value">{{ tot['mod'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('admin.dashboard.totarticles') }}</div>
        <div class="stats-box-value">{{ tot['art'] }}</div>
      </div>
    </div>

    <div class="row mt-40x">
      <div class="col-md-12 bold">{{ mt._('statistics.overallanalysis') }}</div>
      <div class="col-md-2 mb-10x" style="line-height:40px">{{ mt._('statistics.selectperiod') }}</div>
      <div class="col-md-10 mb-10x">
        <input type="hidden" style="width:200px" name="period" id="period" class="form-control" value=""/>
        <div id="period-box" class="row py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
          <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
          <div class='col-md-9 px-0'><span></span></div>
          <div class='col-md-1 px-0'><b class="caret"></b></div>
        </div>
      </div>
      <div class="col-md-2 mb-10x" style="line-height:40px">{{ mt._('admin.analysis.select.season') }}</div>
      <div class="col-md-4 mb-10x p-0 form-element form-select">
        <select id="season-box" class="form-control">
          <option value="-1">{{ mt._('_common.allf') }}</option>
          {% if seasons|length > 0 %}
          {% for season in seasons %}
          <option value="{{ season.cdstag }}">{{ season.dsstag }}</option>
          {% endfor %}
          {% endif %}
        </select>
      </div>
    </div>

    <div class="row">
      <div class="stats-box" style="margin-left:0;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.totorders') }}</div>
        <div class="stats-box-value" id="ord" style="color:#00a9cc">{{ anl['ord'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.soldqty') }}</div>
        <div class="stats-box-value" id="qty" style="color:#00a9cc">{{ anl['qty'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.avgqtyorder') }}</div>
        <div class="stats-box-value" id="aqo">{{ anl['aqo']|currency }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.soldvalue') }}</div>
        <div class="stats-box-value" id="val" style="color:#00a9cc">{{ anl['val'] > 0 ? anl['val']|currency ~ ' €' : '-' }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.avgvalorder') }}</div>
        <div class="stats-box-value" id="avo">{{ anl['avo'] != '-' ? anl['avo']|currency ~ ' €' : anl['avo'] }}</div>
      </div>
      <div class="stats-box" style="margin-left:0.8%;width:16%">
        <div class="stats-box-title">{{ mt._('statistics.avgvalproduct') }}</div>
        <div class="stats-box-value" id="avp">{{ anl['avp'] != '-' ? anl['avp']|currency ~ ' €' : anl['avp'] }}</div>
      </div>
    </div>

    <div class="row mt-40x" id="trend">
      <div class="col-md-12" id="trend-container">
        <div class="bold mb-20x">{{ mt._('statistics.salestrend') }}</div>
        <canvas id="canvas-trn"></canvas>
      </div>
    </div>

    <div class="row mt-40x">
      <div class="col-md-12 bold">{{ mt._('admin.dashboard.latest10orders') }}</div>
      <div class="col-md-12 mt-20x">
      {% if orders|length > 0 %}
        <table id="datatable-latest-orders" class="table table-striped table-bordered">
          <thead class="capitalize">
            <tr>
              <th>{{ mt._('_common.ordernumber') }}</th>
              <th>{{ mt._('_common.customer') }} / {{ mt._('_common.agent') }}</th>
              <th>{{ mt._('_common.orderdate') }}</th>
              <th>{{ mt._('_common.delivery') }}</th>
              <th>{{ mt._('_common.catalog') }}</th>
              <th>{{ mt._('_common.quantity') }}</th>
              <th>{{ mt._('_common.value') }}</th>
              <th>{{ mt._('_common.currency') }}</th>
              <th>{{ mt._('_common.status') }}</th>
            </tr>
          </thead>
          <tbody>
          {% for order in orders %}
            <tr>
              <td>{{ order.nuordc }}</td>
              <td>{{ order.descri }}{{ order.dsagen != '' ? ' / ' ~ order.dsagen : '' }}</td>
              <td>{{ order.dtcrea }}</td>
              <td>{{ order.dtmcoi != null and order.dtmcof != null ? order.dtmcoi ~ ' - ' ~ order.dtmcof : order.dtmcli }}</td>
              <td>{{ order.cdcata }}</td>
              <td>{{ order.quanti }}</td>
              <td>{{ order.valore|currency }}</td>
              <td>{{ order.cdvalu }}</td>
              <td>
                <div class="bold"><span class="sts{{ order['flstat'] }}">&#9679; </span>
                {% if order['flstat'] == 1 %}{{ mt._('account.order.provisional') }}
                {% elseif order['flstat'] == 2 %}{{ mt._(orderStateMgmt ? 'account.order.processed' : 'account.order.sent') }}
                {% elseif order['flstat'] == 3 %}{{ mt._('account.order.accepted') }}
                {% elseif order['flstat'] == 4 %}{{ mt._('account.order.rejected') }}
                {% elseif order['flstat'] == 5 %}{{ mt._('account.order.waitingquantity') }}
                {% elseif order['flstat'] == 6 %}{{ mt._('account.order.customerconfirmed') }}
                {% endif %}
                </div>
              </td>
            </tr>
          {% endfor %}
          </tbody>
        </table>
      {% else %}
        <div class="pt-10x">{{ mt._('admin.orders.noorders') }}</div>
      {% endif %}
      </div>
    </div>

    <div class="row mt-40x">
      <div class="col-md-12 bold">{{ mt._('admin.dashboard.latest10openorders') }}</div>
      <div class="col-md-12 mt-20x">
      {% if openOrders|length > 0 %}
        <table id="datatable-latest-open-orders" class="table table-striped table-bordered">
          <thead class="capitalize">
            <tr>
              <th>{{ mt._('_common.ordernumber') }}</th>
              <th>{{ mt._('_common.customer') }} / {{ mt._('_common.agent') }}</th>
              <th>{{ mt._('_common.orderdate') }}</th>
              <th>{{ mt._('_common.delivery') }}</th>
              <th>{{ mt._('_common.catalog') }}</th>
              <th>{{ mt._('_common.quantity') }}</th>
              <th>{{ mt._('_common.value') }}</th>
              <th>{{ mt._('_common.currency') }}</th>
              <th>{{ mt._('_common.status') }}</th>
            </tr>
          </thead>
          <tbody>
          {% for order in openOrders %}
            <tr>
              <td>{{ order.nuordc }}</td>
              <td>{{ order.descri }}{{ order.dsagen != '' ? ' / ' ~ order.dsagen : '' }}</td>
              <td>{{ order.dtcrea }}</td>
              <td>{{ order.dtmcoi != null and order.dtmcof != null ? order.dtmcoi ~ ' - ' ~ order.dtmcof : order.dtmcli }}</td>
              <td>{{ order.cdcata }}</td>
              <td>{{ order.quanti }}</td>
              <td>{{ order.valore|currency }}</td>
              <td>{{ order.cdvalu }}</td>
              <td>
                <div class="bold">
                  <span class="sts{{ order['flstat'] }}">&#9679; </span>{{ mt._('account.order.open') }}
                </div>
              </td>
            </tr>
          {% endfor %}
          </tbody>
        </table>
      {% else %}
        <div class="pt-10x">{{ mt._('admin.orders.noorders') }}</div>
      {% endif %}
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-order" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" id="modal-order-detail">
  <div class="modal-dialog modal-sm" style="width:75%">
    <div class="modal-content">

      <div class="modal-header">
        <button id="close-modal" type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" id="myModalLabel">{{ mt._('_common.order') }} <span id="md-nuordc"></span></h4>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.orderdate') }}:</span> <span id="md-dtmcli"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.agent') }}:</span> <span id="md-dsagen"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.pricelist') }}:</span> <span id="md-dslist"></span></div>
            <div class="order-detail-box col-md-12"><span class="order-md-title">{{ mt._('_common.customer') }}:</span> <span id="md-dsanag"></span></div>
            <div class="order-detail-box col-md-12"><span class="order-md-title">{{ mt._('_common.shipping') }}:</span> <span id="md-dsdesm"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('_common.catalog') }}:</span> <span id="md-dscata"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('admin.condition.payment') }}:</span> <span id="md-dspaga"></span></div>
            <div class="order-detail-box col-md-4"><span class="order-md-title">{{ mt._('admin.condition.shipment') }}:</span> <span id="md-dstpor"></span></div>
            <div class="order-notes-box col-md-12"><span class="order-md-title">{{ mt._('_common.notes') }}:</span> <span id="md-dsnota"></span></div>
          </div>
        </div>
        <div class="modal-section mb-10x" style="border-bottom:1px #eee solid">
          <div class="first-row-order-detail">
            <div class="row-emprow">&nbsp;</div>
            <div class="row-ordrow">{{ mt._("rows") }}: <span id="tot-ordrow"></span></div>
            <div class="row-dtmcli"><span id="tot-dtmcli"></span></div>
            <div class="row-quanti"><span id="tot-quanti"></span></div>
            <div class="row-prezzo"><span id="tot-prezzo"></span></div>
            <div class="row-sconto"><span id="tot-sconto"></span></div>
            <div class="row-totale"><span id="tot-totale"></span></div>
          </div>
          <div class="header-row-order-detail">
            <div class="row-cdarti">{{ mt._("_common.code") }}</div>
            <div class="row-dsarti">{{ mt._("_common.description") }} / {{ mt._("_common.color") }}</div>
            <div class="row-dtmcli">{{ mt._("_common.delivery") }}</div>
            <div class="row-quanti">{{ mt._("_common.quantity") }}</div>
            <div class="row-prezzo">{{ mt._("cart.header.grosstotal") }}</div>
            <div class="row-sconto">{{ mt._("_common.discount") }}</div>
            <div class="row-totale">{{ mt._("_common.total") }}</div>
          </div>
          <div id="order-detail-rows"></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" id="btn-print-order">{{ mt._('_common.print') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<div id="order-detail-printable" style="display:none"></div>
