<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.customfamily.customs') }} {{ mt._('_common.for') }} {{ family.dstvar }} ({{ family.cdregv }} - {{ family.dsregv }})</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row py-10x">
          <div class="col-md-4 text-left text-capitalize">
            <a href="{{ url('admin/customfamily/' ~ family.cdregv) }}" class="btn btn-default w-70">{{ mt._('_common.back') }}</a>
          </div>
          <div class="col-md-4">&nbsp;</div>
          <div class="col-md-4 text-right">
            <a href="#" id="new-custom" class="btn btn-primary w-70" data-toggle='modal' data-target='.modal-modify-cdvari'>{{ mt._('admin.customfamily.createcustom') }}</a>
          </div>
        </div>
        {% if customs|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-custom" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th class='capitalize'>{{ mt._('_common.sorting') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.group') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.family') }}</th>
                  <th class='capitalize'>{{ mt._('_common.price') }}</th>
                  <th class='capitalize'>{{ mt._('_common.image') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.generic') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.canceled') }}</th>
                  <th class='capitalize'>{{ mt._('_common.notes') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for custom in customs %}
                <tr data-cdvari="{{ custom.cdvari }}" data-dsvari="{{ custom.dsvari }}" data-seqrap="{{ custom.seqrap }}"
                  data-prezzo="{{ custom.prezzo }}" data-flgene="{{ custom.flgene }}" data-flbloc="{{ custom.flbloc }}"
                  data-ntvari="{{ custom.ntvari }}" data-flimag="{{ custom.flimag }}">
                  <td class="cdvari">{{ custom.cdvari }}</td>
                  <td>{{ custom.dsvari }}</td>
                  <td>{{ custom.seqrap }}</td>
                  <td>{{ custom.cdregv }} - {{ custom.dsregv }}</td>
                  <td>{{ custom.tpvari }} - {{ custom.dstvar }}</td>
                  <td>{{ custom.prezzo|currency }} €</td>
                  <td>{{ custom.flimag }}</td>
                  <td>{{ custom.flgene == 1 ? mt._('_common.yes') : mt._('_common.no') }}</td>
                  <td>{{ custom.flbloc == 1 ? mt._('_common.yes') : mt._('_common.no') }}</td>
                  <td{{ custom.ntvari != '' ? " title='" ~ custom.ntvari ~ "'>" ~ mt._('_common.yes') : ">" ~ mt._('_common.no') }}</td>
                  <td class="center" style="vertical-align:middle">
                    <a href="#" class="modify-custom pr-10x" title="{{ mt._('admin.customfamily.modifycustom') }}" data-toggle='modal' data-target='.modal-modify-cdvari'>
                      <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                    </a>
                    <a href="#" class="see-custom pr-10x" title="{{ mt._('admin.customfamily.manage') }}" data-toggle='modal' data-target='.modal-manage-custom'>
                      <span class="glyphicon glyphicon-eye-open" aria-hidden="true"></span>
                    </a>
                    <a href="#" class="delete-custom" title="{{ mt._('admin.customfamily.deletecustom') }}" data-toggle='modal' data-target='.modal-delete-cdvari'>
                      <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                    </a>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
      </div>

    </div>

  </div>
</div>

<!-- Modal for modify custom -->
<div class="modal fade modal-modify-cdvari" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-modify-mode" name="modal-modify-mode"/>
      <input type="hidden" id="modal-modify-old-flimag" name="modal-modify-old-flimag"/>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-modify-title"></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.code') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="text" value="" id="modal-modify-cdvari" class="form-control"/></div>
        </div>
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="text" value="" id="modal-modify-dsvari" class="form-control"/></div>
        </div>
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.sorting') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="number" value="" id="modal-modify-seqrap" class="form-control" step="1"/></div>
        </div>
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.price') }} (€)</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="number" value="" id="modal-modify-prezzo" class="form-control" step="0.01"/></div>
        </div>
        <div class="row pb-10x" style="line-height:26px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customfamily.generic') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'>
            <label class="checkbox-container">
              <input type="checkbox" class="catalog-checkbox" id="modal-modify-flobbl" value=""/>
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
        <div class="row pb-10x" style="line-height:26px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customfamily.canceled') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'>
            <label class="checkbox-container">
              <input type="checkbox" class="catalog-checkbox" id="modal-modify-flbloc" value=""/>
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
        <div class="row pb-10x text-capitalize" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.notes') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8 form-element'>
            <textarea rows="4" class="form-control" id="modal-modify-ntvari"></textarea>
          </div>
        </div>
        <div class="row pb-10x text-capitalize" style="line-height:20px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.image') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8 form-element'>
            <input type="file" name="modal-modify-flimag" id="modal-modify-flimag" accept="image/x-png,image/gif,image/jpeg">
            <div style="text-transform:none" id="modal-modify-current-flimag"></div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="modify-custom" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete custom -->
<div class="modal fade modal-delete-cdvari" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-cdvari" name="modal-delete-cdvari"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customfamily.deletecustom') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.customfamily.deletewarning.c') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-custom" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for manage custom -->
<div class="modal fade modal-manage-custom" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg w-50">
    <input type="hidden" id="modal-manage-cdvari" name="modal-manage-cdvari"/>
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customfamily.manage') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center pb-20x">
          <div class='col-md-6 pb-10x' style='font-weight:bold'>{{ mt._('admin.customfamily.dbl.tpm.ntl') }}</div>
          <div class='col-md-6 pb-10x' style='font-weight:bold'>{{ mt._('admin.customfamily.dbl.tpm.lnk') }}</div>
          <div class='col-md-12'>
            <select multiple="multiple" size='20' name="duallistbox_tpmode" id="tpmvar" style="height:130px"></select>
          </div>
        </div>
        <div class="row center py-20x" style='border-top:1px solid #73879C'>
          <div class='col-md-6 pb-10x' style='font-weight:bold'>{{ mt._('admin.customfamily.dbl.mod.ntl') }}</div>
          <div class='col-md-6 pb-10x' style='font-weight:bold'>{{ mt._('admin.customfamily.dbl.mod.lnk') }}</div>
          <div class='col-md-12'>
            <select multiple="multiple" size='20' name="duallistbox_cdartn" id="modvar" style="height:130px"></select>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="save-custom" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
