<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.customfamily') }} {{ mt._('_common.for') }} {{ group.dsregv }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row py-10x">
          <div class="col-md-4 text-left text-capitalize">
            <a href="{{ url('admin/customgroup') }}" class="btn btn-default w-70">{{ mt._('_common.back') }}</a>
          </div>
          <div class="col-md-4">&nbsp;</div>
          <div class="col-md-4 text-right">
            <a href="#" id="new-family" class="btn btn-primary w-70" data-toggle='modal' data-target='.modal-modify-tpvari'>{{ mt._('admin.customfamily.createfamily') }}</a>
          </div>
        </div>

        {% if families|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-family" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th class='capitalize'>{{ mt._('_common.sorting') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.group') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.mandatory') }}</th>
                  <th class='capitalize'>{{ mt._('admin.customfamily.canceled') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for family in families %}
                <tr data-tpvari="{{ family.tpvari }}" data-dstvar="{{ family.dstvar }}" data-seqrap="{{ family.seqrap }}"
                  data-flobbl="{{ family.flobbl }}" data-flbloc="{{ family.flbloc }}">
                  <td class="tpvari">{{ family.tpvari }}</td>
                  <td>{{ family.dstvar }}</td>
                  <td>{{ family.seqrap }}</td>
                  <td>{{ family.cdregv }} - {{ family.dsregv }}</td>
                  <td>{{ family.flobbl == 1 ? mt._('_common.yes') : mt._('_common.no') }}</td>
                  <td>{{ family.flbloc == 1 ? mt._('_common.yes') : mt._('_common.no') }}</td>
                  <td class="center" style="vertical-align:middle">
                    <a href="#" class="modify-family pr-10x" title="{{ mt._('admin.customfamily.modifyfamily') }}" data-toggle='modal' data-target='.modal-modify-tpvari'>
                      <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                    </a>
                    <a href="{{ url('admin/customvar/' ~ group.cdregv ~ '/' ~ family.tpvari)}}" class="see-family pr-10x" title="{{ mt._('admin.customfamily.managecustoms') }}">
                      <span class="glyphicon glyphicon-eye-open" aria-hidden="true"></span>
                    </a>
                    <a href="#" class="delete-family" title="{{ mt._('admin.customfamily.deletefamily') }}" data-toggle='modal' data-target='.modal-delete-tpvari'>
                      <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                    </a>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
      </div>

    </div>
  </div>
</div>

<!-- Modal for modify family -->
<div class="modal fade modal-modify-tpvari" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-modify-mode" name="modal-modify-mode"/>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-modify-title"></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.code') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="text" value="" id="modal-modify-tpvari" class="form-control"/></div>
        </div>
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="text" value="" id="modal-modify-dstvar" class="form-control"/></div>
        </div>
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.sorting') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="number" value="" id="modal-modify-seqrap" class="form-control" step="1"/></div>
        </div>
        <div class="row pb-10x" style="line-height:26px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customfamily.mandatory') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'>
            <label class="checkbox-container">
              <input type="checkbox" class="catalog-checkbox" id="modal-modify-flobbl" value=""/>
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
        <div class="row pb-10x" style="line-height:26px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customfamily.canceled') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'>
            <label class="checkbox-container">
              <input type="checkbox" class="catalog-checkbox" id="modal-modify-flbloc" value=""/>
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="modify-family" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete family -->
<div class="modal fade modal-delete-tpvari" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-tpvari" name="modal-delete-tpvari"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customfamily.deletefamily') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.customfamily.deletewarning.f') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-family" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
