<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
      <div class="x_panel">
        <div class="x_title">
          <h2>{{ mt._('admin.menu.custompayment') }}</h2>
          <div class="clearfix"></div>
        </div>

        <div class="x_content">
          <div class="row">
            <div class="col-md-8 col-sm-8 col-xs-8">
              <span class="inline-menu-title">{{ mt._('admin.actions') }}:</span>
              <span class="inline-menu-title"><a href="#" id="new-cond" data-toggle='modal' data-target='.modal-edit-cond'>{{ mt._('admin.condition.new') }}</a></span>
              <span class="inline-menu-title"><a href="#" id="del-cond" data-toggle='modal' data-target='.modal-delete-cond'>{{ mt._('admin.condition.delete') }}</a></span>
            </div>
            <div class="col-md-4 col-sm-4 col-xs-4 right p-0"></div>
          </div>
          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="msg-bulk-error left fl" id="bulk-error"></div>
            </div>
          </div>

          {% if cus_payments|length > 0 %}
          <div class="row pt-25x">
            <div class="col-md-12 col-sm-12 col-xs-12">

              {% if customPayment == 0 %}
              <label style="font-size: 14px;margin-left: 10px; margin-bottom: 20px;">Hai parametrizzzato gli scaglioni per PREZZO</label>
           {% elseif customPayment == 1 %}
              <label style="font-size: 14px;margin-left: 10px; margin-bottom: 20px;">Hai parametrizzzato gli scaglioni per QUANTITA'</label>
            {% endif %}

              <table id="table-cond" class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th class="no-sort"></th>
                    <th>{{ mt._('admin.condition.payment') }}</th>
                    <th>{{ mt._('admin.condition.conditions') }}</th>
                    <th>{{ mt._('_common.countries') }}</th>
                    <th></th>

                  </tr>
                </thead>

                <tbody>
                  {% for cond in cus_payments %}
                    {% set datacdnazi = '' %}
                    {% if cond.countries|length == 1 %}
                      {% set datacdnazi = cond.countries[0].cdnazi %}
                    {% else %}
                      {% for country in cond.countries %}
                        {% if loop.index != 1 %}
                          {% set datacdnazi = datacdnazi ~ ',' %}
                        {% endif %}
                        {% set datacdnazi = datacdnazi ~ country.cdnazi %}
                      {% endfor %}
                    {% endif %}
                  <tr data-numpag="{{ cond.numpag|escape_attr }}"
                     data-tppaga="{{ cond.tppaga|escape_attr }}"
                     data-config="{{ cond.config|escape_attr }}"
                     data-cdnazi="{{ datacdnazi|escape_attr }}">
                    <td class="cb">
                      <label class="checkbox-container">
                        <input type="checkbox" name="status-checkbox[]" value=""/>
                        <span class="checkbox-checkmark"></span>
                      </label>
                    </td>
                    <td><span>{{ cond.tppaga }} - {{ cond.dspaga }}</span></td>
                    <td><small>{{ cond.configuration|length > 0 ? mt._('admin.conditions.count',  ['count': cond.configuration|length]) : mt._('admin.conditions.no') }}</small></td>

                    <td>
                      {% if cond.countries|length == 1 %}
                        {% if cond.countries[0].cdnazi == 'ALL' %}
                        <span>{{ mt._('_common.allf') }}</span>
                        {% else %}
                        <span data-toggle='tooltip' title="{{ cond.countries[0].dsnazi }}">1 {{ mt._('_common.country') }}</span>
                        {% endif %}
                      {% else %}
                        <span data-toggle='tooltip' title="{% for country in cond.countries %}{% if loop.index != 1 %} - {% endif %}{{ country.dsnazi }}{% endfor %}">
                          {{ cond.countries|length ~ ' ' ~ mt._('_common.countries') }}
                        </span>
                      {% endif %}
                      </td>
                    <td>
                      <a href="#" class="modify-cond" title="{{ mt._('admin.condition.edit') }}"
                        data-toggle='modal' data-target='.modal-edit-cond'>
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </td>
                    <!--
                    <td>
                      <a href="#" class="delete-cond" title="{{ mt._('admin.condition.delete') }}"
                        data-toggle='modal' data-target='.modal-delete-cond'>
                        <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                      </a>
                    </td -->
                  {% endfor %}
                </tbody>
              </table>

            </div>
          </div>
          {% endif %}

        </div>

      </div>
    </div>
  </div>

  <!-- Modal for new/edit condition -->
  <div class="modal fade modal-edit-cond" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-30">
      <div class="modal-content">

        <div class="modal-header">
          <h4 class="modal-title" id="myModalLabel2"></h4>
          <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
        </div>
        <div class="modal-body">
          <div class="modal-section">
            <input type="hidden" value="" id="modal-edit-numpag"/>

            <div class="row pb-10x">
              <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right pt-5x'>{{ mt._('admin.condition.payment') }}</div>
              <div class='col-md-8 col-sm-8 col-xs-8'>
                {% if def_payments|length > 0 %}
                <select class="p-5x w-80" id="modal-edit-tppaga">
                  {% for cond in def_payments %}
                  <option value="{{ cond.tppaga }}" data-dspaga="{{ cond.dspaga }}">{{ cond.tppaga }} - {{ cond.dspaga }}</option>
                  {% endfor %}
                </select>
                {% endif %}
              </div>
            </div>
          </div>
          <div class="modal-section">

            <div class="row pb-10x">
              {#<div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right pt-5x'>{{ mt._('admin.condition.payment') }}</div>#}
              <div class='col-xs-12'>
                <input type="hidden" value="" id="modal-edit-config"/>
              </div>
            </div>
          </div>
         {# <div class="modal-section" id="modal-section-status">
            <div class="row py-10x">
              <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-7x'>{{ mt._('_common.countries') }}</div>
              <div class='col-md-8 col-sm-8 col-xs-8'>
                {% if countries|length > 0 %}
                <select class="select2_multiple p-5x" multiple="multiple" style="width:200px;height:200px" id="modal-edit-countries">
                  <option value="ALL" class="italic">{{ mt._('_common.allf') }}</option>
                  {% for country in countries %}
                  <option value="{{ country.cdnazi }}">{{ country.dsnazi }}</option>
                  {% endfor %}
                </select>
                {% endif %}
              </div>
            </div>
          </div> #}
          <div class="modal-section" id="modal-section-status">
            <div class="row py-10x">
              <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-7x'>{{ mt._('_common.countries') }}</div>
              <div class='col-md-8 col-sm-8 col-xs-8'>
                {% if countries|length > 0 %}
                  <select id="modal-edit-countries" class="selectpicker" multiple required
                          data-actions-box="true"
                          data-live-search="true" data-selected-text-format="count > 2" data-size="5">
                    <option value="ALL" class="italic">{{ mt._('_common.allf') }}</option>
                    {% for country in countries %}
                      <option value="{{ country.cdnazi }}">{{ country.dsnazi }}</option>
                    {% endfor %}
                  </select>
                {% endif %}
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-primary right-btn w-50" id="save-cond" data-action="">{{ mt._('_common.save') }}</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal for delete coupon -->
  <div class="modal fade modal-delete-cond" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm w-30">
      <div class="modal-content">
      <input type="hidden" id="modal-delete-numpag" name="modal-delete-numpag"/>
      <input type="hidden" id="modal-delete-multi-numpag" name="modal-delete-multi-numpag"/>
      <div class="modal-header">
          <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.condition.delete') }}</h4>
          <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
        </div>
        <div class="modal-body">



          <div class="row center">
            <div class='col-md-12 modal-section-title'>{{ mt._('admin.condition.deletewarning') }}</div></div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-cond" data-action="">{{ mt._('_common.delete') }}</button>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
              <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
