<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.custommenu') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('admin.selectcatalog') }}</div>
      {% if catalogs|length > 0 %}
      <div class="col-md-4 form-element form-select">
        <select class="form-control" id="catalog-selector">
          {% for catalog in catalogs %}
          <option value="{{ str_replace('/', '_', catalog.cdcata) }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
          {% endfor %}
        </select>
      </div>
      {% else %}
      {{ mt._('admin.custommenu.warning') }}
      {% endif %}
    </div>

    {% if catalogs|length > 0 %}
    <div class="row mt-20x">
      <div class="col-md-12">
        <button type="button" class="btn btn-primary waves-effect waves-light" id="load-custommenu">{{ mt._('_common.load') }}</button>
      </div>
    </div>
    {% endif %}

    <div class="mt-20x" id="custom-menu-container">

    </div>
  </div>
</div>

<div class="modal fade modal-new-item-features" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.custommenu.new') }}</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12 bold">{{ mt._('_common.select') }}</div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-6 form-element form-select">
            <select class="form-control" id="item-category-selector">
              <option value=""></option>
              {% if brands|length > 0 %}
              <option value="BR">{{ mt._('_common.brand') }}</option>
              {% endif %}
              {% if lines|length > 0 %}
              <option value="LM">{{ mt._('_common.line') }}</option>
              {% endif %}
              {% if series|length > 0 %}
              <option value="SM">{{ mt._('_common.series') }}</option>
              {% endif %}
              {% if genres|length > 0 %}
              <option value="TG">{{ mt._('_common.genre') }}</option>
              {% endif %}
              {% if modelTypes|length > 0 %}
              <option value="TM">{{ mt._('_common.modeltype') }}</option>
              {% endif %}
              {% if selections|length > 0 %}
              <option value="SS">{{ mt._('admin.menu.specialselections') }}</option>
              {% endif %}
              {#
              <option value="LK">{{ mt._('_common.lookbook') }}</option>
              <option value="SL">{{ mt._('_common.onsale') }}</option>
              #}
            </select>
          </div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-6 form-element form-select">
            {% if brands|length > 0 %}
            <select class="form-control" id="BR-selector" style="display:none">
              {% for item in brands %}
              <option value="{{ item.cdtitl }}" data-descr="{{ item.dstitl }}" data-fulldescr="{{ mt._('_common.brand') }}: {{ item.dstitl }}"
                data-codic1="{{ item.cdtitl }}"
                data-des-it="{{ item.dstitl }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
              {{ item.dstitl }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
            {% if lines|length > 0 %}
            <select class="form-control" id="LM-selector" style="display:none">
              {% for item in lines %}
              <option value="{{ item.cdlinm }}" data-descr="{{ item.dslinm }}" data-fulldescr="{{ mt._('_common.line') }}: {{ item.dstitl }} - {{ item.dslinm }}"
                data-codic1="{{ item.cdlinm }}"
                data-des-it="{{ item.dslinm }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
                {{ item.dstitl }} - {{ item.dslinm }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
            {% if series|length > 0 %}
            <select class="form-control" id="SM-selector" style="display:none">
              {% for item in series %}
              <option data-descr="{{ item.dsserm }}" data-fulldescr="{{ mt._('_common.serie') }}: {{ item.dstitl }} - {{ item.dslinm }} - {{ item.dsserm }}"
                data-codic1="{{ item.cdlinm }}"
                data-codic2="{{ item.cdserm }}"
                data-des-it="{{ item.dsserm }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
                {{ item.dstitl }} - {{ item.dslinm }} - {{ item.dsserm }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
            {% if genres|length > 0 %}
            <select class="form-control" id="TG-selector" style="display:none">
              {% for item in genres %}
              <option value="{{ item.tpgene }}" data-descr="{{ item.dsgene }}" data-fulldescr="{{ mt._('_common.genre') }}: {{ item.dsgene }}"
                data-codic1="{{ item.tpgene }}"
                data-des-it="{{ item.dsgene }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
                {{ item.dsgene }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
            {% if modelTypes|length > 0 %}
            <select class="form-control" id="TM-selector" style="display:none">
              {% for item in modelTypes %}
              <option value="{{ item.tpmode }}" data-descr="{{ item.dstmod }}" data-fulldescr="{{ mt._('_common.modeltype') }}: {{ item.dstmod }}"
                data-codic1="{{ item.tpmode }}"
                data-des-it="{{ item.dstmod }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
                {{ item.dstmod }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
            {% if selections|length > 0 %}
            <select class="form-control" id="SS-selector" style="display:none">
              {% for item in selections if item.flbloc == 0 %}
                {% if session.get('language') == 'en' %}
                  {% set description = item.des_en %}
                {% elseif session.get('language') == 'es' %}
                  {% set description = item.des_es %}
                {% elseif session.get('language') == 'fr' %}
                  {% set description = item.des_fr %}
                {% elseif session.get('language') == 'de' %}
                  {% set description = item.des_de %}
                {% else %}
                  {% set description = item.des_it %}
                {% endif %}
              <option value="{{ item.cdspsl }}" data-descr="{{ description }}" data-fulldescr="{{ mt._('admin.menu.specialselections') }}: {{ description }}"
                data-cdcata="{{ item.cdcata }}"
                data-codic1="{{ item.cdspsl }}"
                data-des-it="{{ item.des_it }}"
                data-des-en="{{ item.des_en }}"
                data-des-es="{{ item.des_es }}"
                data-des-fr="{{ item.des_fr }}"
                data-des-de="{{ item.des_de }}">
                {{ description }}
              </option>
              {% endfor %}
            </select>
            {% endif %}
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary add-new-item">{{ mt._('_common.add') }}</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade modal-displayed-text" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.custommenu.text') }}</h4>
      </div>
      <div class="modal-body">
        <input type="hidden" value="-1" id="displayed-text-index"/>
        <div class="row mt-10x">
          <div class="col-md-4 bold text-right capitalize" style="line-height:34px">{{ mt._('_common.lang.it') }}</div>
          <div class="col-md-8"><input class="form-control" type="text" id="displayed-text-it"/></div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-4 bold text-right capitalize" style="line-height:34px">{{ mt._('_common.lang.en') }}</div>
          <div class="col-md-8"><input class="form-control" type="text" id="displayed-text-en"/></div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-4 bold text-right capitalize" style="line-height:34px">{{ mt._('_common.lang.es') }}</div>
          <div class="col-md-8"><input class="form-control" type="text" id="displayed-text-es"/></div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-4 bold text-right capitalize" style="line-height:34px">{{ mt._('_common.lang.fr') }}</div>
          <div class="col-md-8"><input class="form-control" type="text" id="displayed-text-fr"/></div>
        </div>
        <div class="row mt-10x">
          <div class="col-md-4 bold text-right capitalize" style="line-height:34px">{{ mt._('_common.lang.de') }}</div>
          <div class="col-md-8"><input class="form-control" type="text" id="displayed-text-de"/></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-text" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
