<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.assigncolors') }}</h2>
        <div class="clearfix"></div>
      </div>
      <div class="x_content">
        <div class="row">
          <div class="col-md-2 col-sm-2 col-xs-12">
            <button class="btn btn-default save-btn fl w-100">{{ mt._('_common.save') }}</button>
            <div class="msg-error" style="text-align:left;float:left">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success" style="text-align:left;float:left">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>

      {% if colors|length > 0 %}
        {% for color in colors %}
          {% set optionSelected = 0 %}
          {% if color.rgbcd1 != '' or color.rgbcd2 != '' or color.rgbcd3 != '' %}
            {% set optionSelected = 1 %}
          {% elseif color.flimag != '' %}
            {% set optionSelected = 2 %}
          {% elseif color.flmult == 1 %}
            {% set optionSelected = 3 %}
          {% endif %}

        <div class="row color-picker-row" style="line-height:34px;margin-bottom:40px" data-codice="{{ color.codice }}">
          <div class="col-md-2 text-right" title="{{ color.codice }}">{{ color.codice }}</div>
          <div class="col-md-2">
            <select class="form-control source-picker">
              <option value="0" {{ optionSelected == 0 ? 'selected' : '' }}>&nbsp;</option>
              <option value="1" {{ optionSelected == 1 ? 'selected' : '' }}>{{ mt._('admin.colorpicker.choosecolor') }}</option>
              <option value="2" {{ optionSelected == 2 ? 'selected' : '' }}>{{ mt._('admin.colorpicker.loadimage') }}</option>
              <option value="3" {{ optionSelected == 3 ? 'selected' : '' }}>{{ mt._('admin.colorpicker.multicolor') }}</option>
            </select>
          </div>
          {# Color picker #}
          <div class="col-md-8 color-picker-section" {{ optionSelected != '1' ? 'style="display:none"' : ''}}>
            <div class="fl pl-20x">{{ mt._('_common.color') }} 1</div>
            <div class="fl pl-10x">
              <input type="text" class="form-control color-picker color-picker1" value="{{ color.rgbcd1 }}" style="width:90px"/>
            </div>
            <div class="fl pr-20x color-picker-preview1"
              style="{{ color.rgbcd1 != '' ? "background-color:#" ~ color.rgbcd1 : '' }};border-right:1px solid #999">&nbsp;</div>

            <div class="fl pl-20x">
              <label class="checkbox-container mt-5x">
                <input type="checkbox" class="color color2" {{ color.rgbcd2 != '' ? 'checked' : '' }}/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="fl pl-10x">{{ mt._('_common.color') }} 2</div>
            <div class="fl pl-10x">
              <input type="text" class="form-control color-picker color-picker2 disabled" value="{{ color.rgbcd2 }}" style="width:90px" disabled/>
            </div>
            <div class="fl pr-20x color-picker-preview2"
              style="{{ color.rgbcd2 != '' ? "background-color:#" ~ color.rgbcd2 : '' }};border-right:1px solid #999">&nbsp;</div>

            <div class="fl pl-20x">
              <label class="checkbox-container mt-5x">
                <input type="checkbox" class="color color3" {{ color.rgbcd3 != '' ? 'checked' : '' }}/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            <div class="fl pl-10x">{{ mt._('_common.color') }} 3</div>
            <div class="fl pl-10x">
              <input type="text" class="form-control color-picker color-picker3 disabled" value="{{ color.rgbcd3 }}" style="width:90px" disabled/>
            </div>
            <div class="fl pr-20x color-picker-preview3"
              style="{{ color.rgbcd3 != '' ? "background-color:#" ~ color.rgbcd3 : '' }}">&nbsp;</div>
          </div>

          {# Load image #}
          <div class="col-md-8 load-image-section" {{ optionSelected != '2' ? 'style="display:none"' : ''}}>
            <div class="color-image-loader-file">{{ color.flimag != '' ? color.flimag : '&nbsp;' }}</div>
            {% set imgPreviewStyle = color.flimag != '' ? 'style="background-image:url(' ~ "'../upload/colors/" ~ color.flimag ~ "')" ~ '"' : '' %}
            <div class="color-image-preview" {{ imgPreviewStyle }}>&nbsp;</div>
            <form action="{{ url('admin/uploadColorImage') }}" class="fl"  method="post" enctype="multipart/form-data" id="color-file-form{{ loop.index }}"
              name="color-file-form{{ loop.index }}">
              <input type="file" class="color-image-loader-input" name="colorFile" id="colorFile{{ loop.index }}" accept="image/x-png,image/gif,image/jpeg">
              <div class="color-image-loader-button">{{ mt._('_common.load') }}</div>
            </form>
          </div>

        </div>
        {% endfor %}
      {% endif %}

        <div class="row">
          <div class="col-md-2 col-sm-2 col-xs-12 w-100">
            <button class="btn btn-default save-btn fl w-100">{{ mt._('_common.save') }}</button>
            <div class="msg-error" style="text-align:left;float:left">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success" style="text-align:left;float:left">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
