<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h2>{{ mt._('_common.classificationslist') }}</h2>
                <div class="clearfix"></div>
            </div>

            {% if success >= 0 %}
                {% if success > 0 %}
                    <div class="msg-success-model-info">{{ mt._('_common.generic.db.success') }}</div>
                {% else %}
                    <div class="msg-error-model-info">{{ mt._('_common.generic.db.error') }}</div>
                {% endif %}
            {% endif %}

            <div class="x_content">
                <div class="row">
                    <div class="col-xs-12">
                        {% if breadcrumbs is defined and breadcrumbs|length > 0 %}
                            <ul class="breadcrumb">
                                <li><a href="{{ url('/admin/classifications') }}">
                                        <i class="fa fa-home" aria-hidden="true"></i>
                                    </a></li>
                                {% for crumb in breadcrumbs %}
                                    {% if loop.last %}
                                        <li class="active">{{ crumb['label'] }}</li>
                                    {% else %}
                                        <li><a href="{{ crumb['url'] }}">{{ crumb['label'] }}</a></li>
                                    {% endif %}
                                {% endfor %}
                            </ul>
                        {% endif %}
                    </div>
                </div>

                <div class="row py-25x">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <form action="" method="post">
                            <table id="table-classifications" class="table table-striped table-bordered">
                                <thead>
                                <tr class='capitalize'>
                                    <th></th>
                                    <th>{{ mt._('_common.code') }}</th>
                                    <th>{{ mt._('_common.lang.it') }}</th>
                                    <th>{{ mt._('_common.lang.en') }}</th>
                                    <th>{{ mt._('_common.lang.es') }}</th>
                                    <th>{{ mt._('_common.lang.fr') }}</th>
                                    <th>{{ mt._('_common.lang.de') }}</th>
                                    <th>{{ mt._('admin.enabled') }}</th>
                                    <th></th>
                                </tr>
                                </thead>

                                <tbody>
                                {% for classification in classifications %}
                                    <tr class="level-{{ (currentPath is not empty ? currentPath : 'root') }}">
                                        <td class="text-right" style="vertical-align:middle">
                                            {{ classification.id }}.
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][slug]" required
                                                   value="{{ classification.slug|escape_attr }}"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][desc_it]" required
                                                   value="{{ classification.desc_it|escape_attr }}"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][desc_en]"
                                                   value="{{ classification.desc_en|escape_attr }}"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][desc_es]"
                                                   value="{{ classification.desc_es|escape_attr }}"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][desc_fr]"
                                                   value="{{ classification.desc_fr|escape_attr }}"/>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control"
                                                   name="classifications[{{ classification.id }}][desc_de]"
                                                   value="{{ classification.desc_de|escape_attr }}"/>
                                        </td>
                                        <td class="text-center" style="vertical-align:middle">
                                            <label class="checkbox-container">
                                                <input type="checkbox" value="1"
                                                       name="classifications[{{ classification.id }}][enabled]" {{ classification.enabled == 1 ? 'checked' : '' }}>
                                                <span class="checkbox-checkmark"></span>
                                            </label>
                                        </td>
                                        <td class="text-right">
                                            <a href="{{ url('admin/classifications/' ~ (currentPath is not empty ? currentPath ~ '-' : '') ~ classification.id) }}"
                                               class="edit btn btn-sm btn-default"
                                               title="{{ mt._('admin.classification.edit') }}">
                                                <span class="fa fa-list" aria-hidden="true"></span>
                                            </a>
                                        </td>
                                    </tr>
                                {% endfor %}
                                <tr class="level-{{ (currentPath is not empty ? currentPath : 'root') }}">
                                    {% set new_id = 'newel1' %}
                                    <td class="text-right" style="vertical-align:middle">
                                        new
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][slug]" value=""/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][desc_it]" value=""/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][desc_en]"
                                               value=""/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][desc_es]"
                                               value=""/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][desc_fr]"
                                               value=""/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control"
                                               name="classifications[{{ new_id }}][desc_de]"
                                               value=""/>
                                    </td>
                                    <td class="text-center" style="vertical-align:middle">
                                        <label class="checkbox-container">
                                            <input type="checkbox" value="1"
                                                   name="classifications[{{ new_id }}][enabled]" checked>
                                            <span class="checkbox-checkmark"></span>
                                        </label>
                                    </td>
                                    <td class="text-right">

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <div class="col-sm-6 col-xs-12">
                                {#<a href="#" id="add-classification" class="btn btn-sm btn-primary w-30 capitalize">
                                    {{ mt._('admin.classification.add') }}
                                </a>#}
                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <button type="submit" class="btn btn-sm btn-success right-btn w-30 capitalize"
                                        title="{{ mt._('_common.save') }}" {# disabled #}>
                                    <span class="fa fa-floppy-o" aria-hidden="true"></span>
                                    {{ mt._('_common.save') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
