<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.budget') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content" id="budget-page-container">
    <div class="row mb-20x">
      <div class='col-md-2 bold'>{{ mt._('admin.budget.type') }}</div>
      <div class='col-md-1'>
        <label class="radio-container">
          <input type="radio" checked name="radio-bdg-type" value="0"> {{ mt._('admin.budget.type.total') }}
          <span class="radio-checkmark"></span>
        </label>
      </div>
      <div class='col-md-2'>
        <label class="radio-container">
          <input type="radio" name="radio-bdg-type" value="1"> {{ mt._('admin.budget.type.customer') }}
          <span class="radio-checkmark"></span>
        </label>
      </div>
    </div>

    <div class="row" id="customer-section" style="display:none">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('account.budget.selectcustomer') }}</div>
      {% if customers|length > 0 %}
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="customer-budget-selector" data-live-search="true">
          {% for customer in customers %}
          <option id="customer-budget-{{ loop.index }}" data-tpanag="{{ customer.tpanag }}" data-cdanag="{{ customer.cdanag }}"
            value="{{ loop.index }}" {{ customer.tpanag == 'CN' ? 'style="font-style:italic"' : '' }}>
            {{ customer.tpanag }} - {{ customer.cdanag }} - {{ customer.descri }}
          </option>
          {% endfor %}
        </select>
      </div>
      {% else %}
      <div class="fl pl-10x" style="line-height:34px">{{ mt._('account.customer.nocustomers') }}</div>
      {% endif %}
    </div>

    <div class="row mt-20x">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('account.budget.selectseason') }}</div>
      {% if refSeasons|length > 0 %}
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="ref-season-budget-selector">
          {% for season in refSeasons %}
          <option value="{{ season.cdstag }}">{{ season.cdstag }}{{ season.dsstag != '' ? ' - ' ~ season.dsstag : '' }}</option>
          {% endfor %}
        </select>
      </div>
      {% else %}
      <div class="fl pl-10x" style="line-height:34px">{{ mt._('account.customer.noseasons') }}</div>
      {% endif %}
    </div>

    <div class="row mt-20x">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('admin.budget.selectseason') }}</div>
      {% if cmpSeasons|length > 0 %}
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="cmp-season-budget-selector" multiple data-max-options="4">
          {% for season in cmpSeasons %}
          <option value="{{ season.cdstag }}">{{ season.cdstag }}{{ season.dsstag != '' ? ' - ' ~ season.dsstag : '' }}</option>
          {% endfor %}
        </select>
      </div>
      {% else %}
      <div class="fl pl-10x" style="line-height:34px">{{ mt._('account.customer.noseasons') }}</div>
      {% endif %}
    </div>

    <div class="row mt-20x">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('admin.budget.selectcolumns') }}</div>
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="columns-budget-selector" multiple>
          <option value="0">{{ mt._('_common.budget') }}</option>
          <option value="1">{{ mt._('_common.target') }}</option>
        </select>
      </div>
    </div>

    <div class="row mt-20x" id="grouping-section" style="display:none">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('account.budget.selectgrouping') }}</div>
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="grouping-budget-selector">
          <option value="0">{{ mt._('_common.budget.grouping.line') }}</option>
          <option value="1">{{ mt._('_common.budget.grouping.drop') }}</option>
        </select>
      </div>
    </div>

    <div class="row mt-20x" id="line-section">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('admin.budget.selectline') }}</div>
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="line-budget-selector">
          <option value="-1">{{ mt._('_common.allf') }}</option>
          {% if lines|length > 0 %}
            {% for line in lines %}
            <option value="{{ line.cdlinm }}">{{ line.cdlinm }}{{ line.dstitl != '' ? ' - ' ~ line.dstitl : '' }} - {{ line.dslinm }}</option>
            {% endfor %}
          {% endif %}
        </select>
      </div>
    </div>

    <div class="row mt-20x" id="drop-section">
      <div class="col-md-2 bold" style="line-height:34px">{{ mt._('admin.budget.selectdrop') }}</div>
      <div class="col-md-4 form-element form-select">
        <select class="form-control selectpicker" id="drop-budget-selector">
          <option value="-1">{{ mt._('_common.allf') }}</option>
          {% if drops|length > 0 %}
            {% for drop in drops %}
            <option value="{{ drop.cduscc }}">{{ drop.cduscc }}{{ drop.dsuscc != '' ? ' - ' ~ drop.dsuscc : '' }}</option>
            {% endfor %}
          {% endif %}
        </select>
      </div>
    </div>

    {% if customers|length > 0 and refSeasons|length > 0 and cmpSeasons|length > 0 %}
    <div class="row mt-20x">
      <div class="col-md-6">
        <button type="button" class="btn btn-primary waves-effect waves-light" id="load-budget">{{ mt._('account.budget.load') }}</button>
      </div>
      <div class="col-md-6 text-right">
        <button type="button" class="btn btn-default waves-effect waves-light" id="export-xls" style="display:none">{{ mt._('admin.exportxls') }}</button>
      </div>
    </div>
    {% endif %}

    <div class="row mt-40x" id="budget-box" style="overflow-x:auto">

    </div>
  </div>
</div>
