<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.blockeditems') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        {% if fabrics|length > 0 %}
        <div class="row py-10x">
          <div class="col-md-12 col-sm-12 col-xs-12"><h2>{{ mt._('_common.tissues') }}</h2></div>
        </div>
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-fabrics" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th class='capitalize'>{{ mt._('admin.blockeditems') }}</th>
                  <th class='capitalize'></th>
                </tr>
              </thead>
              <tbody>
                {% for fabric in fabrics %}
                <tr data-cdpers="{{ fabric.cdpers }}" data-tot="{{ fabric.blocked + fabric.not_blocked }}">
                  <td>{{ fabric.cdpers }}</td>
                  <td>{{ fabric.dspers }}</td>
                  <td class="blocked-items-num">{{ fabric.blocked }} / {{ fabric.blocked + fabric.not_blocked }}</td>
                  <td class="center" style="vertical-align:middle">
                    <span class="pr-20x">
                      <a href="#" class="block-items" title="{{ mt._('admin.blockeditems.block') }}">
                        <i class="fa fa-lock" aria-hidden="true"></i>
                      </a>
                    </span>
                    <span>
                      <a href="#" class="unblock-items" title="{{ mt._('admin.blockeditems.unblock') }}">
                        <i class="fa fa-unlock" aria-hidden="true"></i>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
        {% if colors|length > 0 %}
        <div class="row py-10x">
          <div class="col-md-12 col-sm-12 col-xs-12"><h2>{{ mt._('_common.colors') }}</h2></div>
        </div>
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-colors" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.tissue') }}</th>
                  <th class='capitalize'>{{ mt._('_common.color') }}</th>
                  <th class='capitalize'>{{ mt._('admin.blockeditems') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for color in colors %}
                <tr data-cdpers="{{ color.cdpers }}" data-cdcolo="{{ color.cdcolo }}" data-tot="{{ color.blocked + color.not_blocked }}">
                  <td>{{ color.cdpers }}</td>
                  <td>{{ color.cdcolo }}</td>
                  <td class="blocked-items-num">{{ color.blocked }} / {{ color.blocked + color.not_blocked }}</td>
                  <td class="center" style="vertical-align:middle">
                    <span class="pr-20x">
                      <a href="#" class="block-items" title="{{ mt._('admin.blockeditems.block') }}">
                        <i class="fa fa-lock" aria-hidden="true"></i>
                      </a>
                    </span>
                    <span>
                      <a href="#" class="unblock-items" title="{{ mt._('admin.blockeditems.unblock') }}">
                        <i class="fa fa-unlock" aria-hidden="true"></i>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
      </div>

    </div>
  </div>
</div>
