<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.analysis') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
        <li role="presentation" class="active">
          <a href="#tab_content_cus" data-anchor="tab_content_cus" id="tab_cus" role="tab" data-toggle="tab" aria-expanded="true">
            {{ mt._('_common.customer') }}
          </a>
        </li>
        <li role="presentation">
          <a href="#tab_content_age" data-anchor="tab_content_age" id="tab_age" role="tab" data-toggle="tab" aria-expanded="false">
            {{ mt._('_common.agent') }}
          </a>
        </li>
        <li role="presentation">
          <a href="#tab_content_com" data-anchor="tab_content_com" id="tab_com" role="tab" data-toggle="tab" aria-expanded="false">
            {{ mt._('admin.analysis.comparestats') }}
          </a>
        </li>
        {% if enableSpecialStats %}
        <li role="presentation">
          <a href="#tab_content_sps" data-anchor="tab_content_sps" id="tab_sps" role="tab" data-toggle="tab" aria-expanded="false">
            {{ mt._('admin.analysis.specialstats') }}
          </a>
        </li>
        {% endif %}
      </ul>

      <div id="myTabContent" class="tab-content">
        <!-- Customers Tab Content -->
        <div role="tabpanel" class="tab-pane fade active in" id="tab_content_cus" aria-labelledby="tab_cus">
          <div class="row mt-20x">
            <div class="col-md-12 bold">{{ mt._('admin.analysis.selectparams') }}</div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-3" style="line-height:40px">
              <div class="capitalize right fl pr-10x bold" id="lbl-cus-cat">{{ mt._('_common.catalogs') }}</div>
              <div class="fl w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-cus-cat'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="capitalize right fl pr-10x bold" id="lbl-cus-cus">{{ mt._('_common.customers') }}</div>
              <div class="fl w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-cus-cus'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
            </div>
            <div class="col-md-6">
              <div class='pr-20x fl bold' style="line-height:40px">{{ mt._('_common.period') }}</div>
              <input type="hidden" style="width:200px" name="period-cus" id="period-cus" class="form-control fl" value=""/>
              <div id="period-cus-box" class="row fl py-5x px-10x">
                <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                <div class='col-md-9 px-0'><span></span></div>
                <div class='col-md-1 px-0'><b class="caret"></b></div>
              </div>
            </div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-12">
              <button type="button" class="btn btn-primary waves-effect waves-light fr" id="get-stats-cus">
                {{ mt._('statistics.elaborate') }}
              </button>
            </div>
          </div>

          <div class="loader center" id="cus-analysis-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>

          <div id="cus-analysis" style="display:none">
            <div class="row mt-40x mb-20x" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold">{{ mt._('statistics.overallanalysis') }}</div>
            </div>

            <!-- Overall analyis -->
            <div class="row ml-0 mr-0">
              <div class="stats-box" style="margin-left:0;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.totorders') }}</div>
                <div class="stats-box-value" id="cus-ord" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.soldqty') }}</div>
                <div class="stats-box-value" id="cus-qty" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgqtyorder') }}</div>
                <div class="stats-box-value" id="cus-aqo"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.soldvalue') }}</div>
                <div class="stats-box-value" id="cus-val" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgvalorder') }}</div>
                <div class="stats-box-value" id="cus-avo"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgvalproduct') }}</div>
                <div class="stats-box-value" id="cus-avp"></div>
              </div>
            </div>

            <!-- Donuts -->
            <div class="row mt-40x">
              <div class="col-md-4" style="line-height:34px">
                <div class="pr-20x bold fl" >{{ mt._('admin.analysis.group') }}</div>
                <div class="fl form-element form-select">
                  <select class="form-control" id="analysis-grp-cus" name="analysis-grp-cus">
                    <option value="1">{{ mt._('_common.brand') }}</option>
                    <option value="2">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} </option>
                    <option value="3">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} / {{ mt._('_common.series') }}</option>
                  </select>
                </div>
              </div>
            </div>

            <div class="row mt-40x" id="gr1-cus">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforbrand') }}</div>
                <div id="echart_donut_gr1_cus" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr1-cus" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x" id="gr2-cus">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforline') }}</div>
                <div id="echart_donut_gr2_cus" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr2-cus" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }} / {{ mt._('_common.line') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x" id="gr3-cus">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforseries') }}</div>
                <div id="echart_donut_gr3_cus" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr3-cus" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} / {{ mt._('_common.series') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revformodeltype') }}</div>
                <div id="echart_donut_tip_cus" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-tip-cus" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.modeltype') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforgenre') }}</div>
                <div id="echart_donut_gen_cus" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gen-cus" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.genre') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>

            <!-- Top customers -->
            <div class="row mt-40x">
              <div class="col-md-6" id="top-10-qty-cus">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top10cust.qty') }}</div>
                <canvas id="canvas-qty-cus" class="px-20x"></canvas>
              </div>
              <div class="col-md-6" id="top-10-val-cus">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top10cust.val') }}</div>
                <canvas id="canvas-val-cus" class="px-20x"></canvas>
              </div>
            </div>
            <div class="row mt-40x">
              <div class="col-md-6">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top20cust.qty') }}</div>
                <table id="datatable-qty-cus" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.code') }}</th>
                      <th>{{ mt._('_common.customer') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
              <div class="col-md-6">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top20cust.val') }}</div>
                <table id="datatable-val-cus" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.code') }}</th>
                      <th>{{ mt._('_common.customer') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>

            <!-- Trends -->
            <div class="row mt-40x" id="trend-cus">
              <div class="col-md-12" id="trend-container-cus">
                <div class="bold mb-20x">{{ mt._('statistics.salestrend') }}</div>
                <canvas id="canvas-trn-cus"></canvas>
              </div>
            </div>

            <!-- Map -->
            <div class="row mt-40x">
              <div class="col-md-12 bold">{{ mt._('admin.analysis.geo') }}</div>
            </div>
            <div class="row mt-40x">
              <div id="world-map-cus" class="col-md-8 col-sm-12 col-xs-12" style="height:560px;"></div>
              <div class="col-md-4">
                <table id="datatable-naz-cus" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.country') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <!-- Agents Tab Content -->
        <div role="tabpanel" class="tab-pane fade" id="tab_content_age" aria-labelledby="tab_age">
          <div class="row mt-20x">
            <div class="col-md-12 bold">{{ mt._('admin.analysis.selectparams') }}</div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-3" style="line-height:40px">
              <div class="capitalize right fl pr-10x bold" id="lbl-age-cat">{{ mt._('_common.catalogs') }}</div>
              <div class="fl w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-age-cat'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="capitalize right fl pr-10x bold" id="lbl-age-age">{{ mt._('_common.agents') }}</div>
              <div class="fl w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-age-age'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
            </div>
            <div class="col-md-6">
              <div class='pr-20x fl bold' style="line-height:40px">{{ mt._('_common.period') }}</div>
              <input type="hidden" style="width:200px" name="period-age" id="period-age" class="form-control fl" value=""/>
              <div id="period-age-box" class="row fl py-5x px-10x">
                <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                <div class='col-md-9 px-0'><span></span></div>
                <div class='col-md-1 px-0'><b class="caret"></b></div>
              </div>
            </div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-12">
              <button type="button" class="btn btn-primary waves-effect waves-light fr" id="get-stats-age">
                {{ mt._('statistics.elaborate') }}
              </button>
            </div>
          </div>

          <div class="loader center" id="age-analysis-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>

          <div id="age-analysis" style="display:none">
            <div class="row mt-40x mb-20x" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold">{{ mt._('statistics.overallanalysis') }}</div>
            </div>

            <!-- Overall analyis -->
            <div class="row ml-0 mr-0">
              <div class="stats-box" style="margin-left:0;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.totorders') }}</div>
                <div class="stats-box-value" id="age-ord" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.soldqty') }}</div>
                <div class="stats-box-value" id="age-qty" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgqtyorder') }}</div>
                <div class="stats-box-value" id="age-aqo"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.soldvalue') }}</div>
                <div class="stats-box-value" id="age-val" style="color:#00a9cc"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgvalorder') }}</div>
                <div class="stats-box-value" id="age-avo"></div>
              </div>
              <div class="stats-box" style="margin-left:0.8%;width:16%">
                <div class="stats-box-title">{{ mt._('statistics.avgvalproduct') }}</div>
                <div class="stats-box-value" id="age-avp"></div>
              </div>
            </div>

            <!-- Donuts -->
            <div class="row mt-40x">
              <div class="col-md-4" style="line-height:34px">
                <div class="pr-20x bold fl" >{{ mt._('admin.analysis.group') }}</div>
                <div class="fl form-element form-select">
                  <select class="form-control" id="analysis-grp-age" name="analysis-grp-age">
                    <option value="1">{{ mt._('_common.brand') }}</option>
                    <option value="2">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} </option>
                    <option value="3">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} / {{ mt._('_common.series') }}</option>
                  </select>
                </div>
              </div>
            </div>

            <div class="row mt-40x" id="gr1-age">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforbrand') }}</div>
                <div id="echart_donut_gr1_age" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr1-age" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x" id="gr2-age">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforline') }}</div>
                <div id="echart_donut_gr2_age" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr2-age" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }} / {{ mt._('_common.line') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x" id="gr3-age">
              <div class="col-md-6">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforseries') }}</div>
                <div id="echart_donut_gr3_age" style="height:350px;"></div>
              </div>
              <div class="col-md-6">
                <table id="datatable-gr3-age" class="table table-striped table-bordered" style="min-width:50%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} / {{ mt._('_common.series') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
            <div class="row mt-40x">
              <div class="col-md-3">
                <div class="uppercase bold">{{ mt._('admin.analysis.revformodeltype') }}</div>
                <div id="echart_donut_tip_age" style="height:350px;"></div>
              </div>
              <div class="col-md-3">
                <table id="datatable-tip-age" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.modeltype') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
              <div class="col-md-3">
                <div class="uppercase bold">{{ mt._('admin.analysis.revforgenre') }}</div>
                <div id="echart_donut_gen_age" style="height:350px;"></div>
              </div>
              <div class="col-md-3">
                <table id="datatable-gen-age" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.genre') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>

            <!-- Agents -->
            <div class="row mt-40x">
              <div class="col-md-12">
                <div class="capitalize bold mb-20x">{{ mt._('_common.agent') }}</div>
                <table id="datatable-age" class="table table-striped table-bordered" style="width:100%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.code') }}</th>
                      <th>{{ mt._('_common.agent') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.totorders') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.soldqty') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.avgqtyorder') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.soldvalue') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.avgvalorder') }}</th>
                      <th class="pr-30x">{{ mt._('statistics.avgvalproduct') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>

            <!-- Top 20 agents -->
            <div class="row mt-40x">
              <div class="col-md-6">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top20agen.qty') }}</div>
                <table id="datatable-qty-age" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.code') }}</th>
                      <th>{{ mt._('_common.agent') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
              <div class="col-md-6">
                <div class="capitalize bold mb-20x">{{ mt._('statistics.top20agen.val') }}</div>
                <table id="datatable-val-age" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.code') }}</th>
                      <th>{{ mt._('_common.agent') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>

            <!-- Trends -->
            <div class="row mt-40x" id="trend-age">
              <div class="col-md-12" id="trend-container-age">
                <div class="bold mb-20x">{{ mt._('statistics.salestrend') }}</div>
                <canvas id="canvas-trn-age"></canvas>
              </div>
            </div>

            <!-- Map -->
            <div class="row mt-40x">
              <div class="col-md-12 bold">{{ mt._('admin.analysis.geo') }}</div>
            </div>
            <div class="row mt-40x">
              <div id="world-map-age" class="col-md-8 col-sm-12 col-xs-12" style="height:560px;"></div>
              <div class="col-md-4">
                <table id="datatable-naz-age" class="table table-striped table-bordered" style="min-width:70%">
                  <thead class="capitalize">
                    <tr>
                      <th>{{ mt._('_common.country') }}</th>
                      <th>{{ mt._('_common.quantity') }}</th>
                      <th>{{ mt._('_common.value') }}</th>
                    </tr>
                  </thead>
                  <tbody>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <!-- Compare Tab Content -->
        <div role="tabpanel" class="tab-pane fade" id="tab_content_com" aria-labelledby="tab_com">
          <div class="mt-20x" id="analysis-select">
            <!-- Grouping -->
            <div class="row" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold capitalize">{{ mt._('statistics.group.title') }}</div>
            </div>
            <div class="row mt-20x">
              <div class="col-md-6 form-element form-select">
                <select class="form-control" id="grouping" name="grouping">
                  <option value="1">{{ mt._('statistics.group.modtype') }}</option>
                  <option value="2">{{ mt._('statistics.group.modtypebrandline') }}</option>
                  <option value="3">{{ mt._('statistics.group.brandline') }}</option>
                  <option value="4">{{ mt._('statistics.group.brandlineserie') }}</option>
                  <option value="5">{{ mt._('statistics.group.brandlinemodel') }}</option>
                  <option value="6">{{ mt._('statistics.group.brandlinearticle') }}</option>
                  <option value="7">{{ mt._('statistics.group.brandlinemodtype') }}</option>
                  <option value="8">{{ mt._('statistics.group.cust') }}</option>
                  <option value="9">{{ mt._('statistics.group.custmodtype') }}</option>
                  <option value="10">{{ mt._('statistics.group.custbrandline') }}</option>
                  <option value="11">{{ mt._('statistics.group.custbrandlinemod') }}</option>
                  <option value="12">{{ mt._('statistics.group.custbrandlineart') }}</option>
                  <option value="13">{{ mt._('statistics.group.agecust') }}</option>
                  <option value="14">{{ mt._('statistics.group.agecustmodtype') }}</option>
                  <option value="15">{{ mt._('statistics.group.agecustbrandline') }}</option>
                  <option value="16">{{ mt._('statistics.group.agemodtype') }}</option>
                  <option value="17">{{ mt._('statistics.group.agebrandline') }}</option>
                </select>
              </div>
            </div>

            <!-- Elements -->
            <div class="row mt-40x" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold capitalize">{{ mt._('statistics.selectelements') }}</div>
            </div>
            <div class="row mt-20x">
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.catalog') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary waves-effect waves-light" id="btn-cat" data-toggle='modal' data-target='.modal-cat'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.cat') }}</div>
                  <div id="sel-cat" style="font-size:9px" data-default="{{ mt._('statistics.selected.cat.all') }}">
                    {{ mt._('statistics.selected.cat.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.agent') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary waves-effect waves-light" id="btn-age" data-toggle='modal' data-target='.modal-age'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.age') }}</div>
                  <div id="sel-age" style="font-size:9px" data-default="{{ mt._('statistics.selected.age.all') }}">
                    {{ mt._('statistics.selected.age.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.brand') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-brn'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.brn') }}</div>
                  <div id="sel-brn" style="font-size:9px" data-default="{{ mt._('statistics.selected.brn.all') }}">
                    {{ mt._('statistics.selected.brn.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.customer') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-cus'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.cus') }}</div>
                  <div id="sel-cus" style="font-size:9px" data-default="{{ mt._('statistics.selected.cus.all') }}">
                    {{ mt._('statistics.selected.cus.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.line') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-lin'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.lin') }}</div>
                  <div id="sel-lin" style="font-size:9px" data-default="{{ mt._('statistics.selected.lin.all') }}">
                    {{ mt._('statistics.selected.lin.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.country') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-cou'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.cou') }}</div>
                  <div id="sel-cou" style="font-size:9px" data-default="{{ mt._('statistics.selected.cou.all') }}">
                    {{ mt._('statistics.selected.cou.all') }}
                  </div>
                </div>
              </div>
              {% if elements['series']|length > 1 and elements['series'][0] != "" %}
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.series') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-ser'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.ser') }}</div>
                  <div id="sel-ser" style="font-size:9px" data-default="{{ mt._('statistics.selected.ser.all') }}">
                    {{ mt._('statistics.selected.ser.all') }}
                  </div>
                </div>
              </div>
              {% endif %}
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.ordertype') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-ort'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.ort') }}</div>
                  <div id="sel-ort" style="font-size:9px" data-default="{{ mt._('statistics.selected.ort.all') }}">
                    {{ mt._('statistics.selected.ort.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.modeltype') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-mot'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.mot') }}</div>
                  <div id="sel-mot" style="font-size:9px" data-default="{{ mt._('statistics.selected.mot.all') }}">
                    {{ mt._('statistics.selected.mot.all') }}
                  </div>
                </div>
              </div>
              <div class="col-md-6 mb-20x">
                <div class="col-md-3 pt-10x capitalize bold">{{ mt._('_common.genre') }}</div>
                <div class="col-md-3">
                  <button type="button" class="btn btn-primary" data-toggle='modal' data-target='.modal-gen'>
                    {{ mt._('_common.select') }}
                  </button>
                </div>
                <div class="col-md-6">
                  <div class="bold">{{ mt._('statistics.selected.gen') }}</div>
                  <div id="sel-gen" style="font-size:9px" data-default="{{ mt._('statistics.selected.gen.all') }}">
                    {{ mt._('statistics.selected.gen.all') }}
                  </div>
                </div>
              </div>
            </div>

            <!-- Period -->
            <div class="row mt-40x" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold capitalize">{{ mt._('statistics.selectperiod') }}</div>
            </div>
            <div class="row mt-20x">
              <div class="col-md-3">
                <div class="capitalize bold pt-10x pr-10x fl">{{ mt._('_common.period') }} 1</div>
                <div class="control-group fl w-80">
                  <div class="controls">
                    <input type="hidden" style="width:200px" name="period-com-1" id="period-com-1" class="form-control" value=""/>
                    <div id="period-com-1-box" class="row pull-right py-5x px-10x">
                      <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                      <div class='col-md-9 px-0'><span></span></div>
                      <div class='col-md-1 px-0'><b class="caret"></b></div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="capitalize bold pt-10x pr-10x fl">{{ mt._('_common.period') }} 2</div>
                <div class="control-group fl w-80">
                  <div class="controls">
                    <input type="hidden" style="width:200px" name="period-com-2" id="period-com-2" class="form-control" value=""/>
                    <div id="period-com-2-box" class="row pull-right py-5x px-10x">
                      <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                      <div class='col-md-9 px-0'><span></span></div>
                      <div class='col-md-1 px-0'><b class="caret"></b></div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="capitalize bold pt-10x pr-10x fl">{{ mt._('_common.period') }} 3</div>
                <div class="control-group fl w-80">
                  <div class="controls">
                    <input type="hidden" style="width:200px" name="period-com-3" id="period-com-3" class="form-control" value=""/>
                    <div id="period-com-3-box" class="row pull-right py-5x px-10x">
                      <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                      <div class='col-md-9 px-0'><span></span></div>
                      <div class='col-md-1 px-0'><b class="caret"></b></div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3 right">
                <button type="button" class="btn btn-primary" id="elaborate">{{ mt._('statistics.elaborate') }}</button>
                <div class="msg-error">{{ mt._('statistics.period.error') }}</div>
              </div>
            </div>
          </div>

          <div class="mt-20x" id="analysis-detail" style="display:none">
            <div class="row" style="border-bottom:1px solid #eee">
              <div class="col-md-12 bold capitalize">{{ mt._('_common.detail') }}</div>
            </div>

            <div class="row mt-20x">
              <div class="col-md-12">
                <button type="button" class="btn btn-default" id="close-detail">{{ mt._('_common.close') }}</button>
              </div>
              <div class="col-md-12" id="stats_content">

              </div>

            </div>
          </div>
        </div>

        {% if enableSpecialStats %}
        <!-- Special Stats Tab Content -->
        <div role="tabpanel" class="tab-pane fade" id="tab_content_sps" aria-labelledby="tab_sps">

          <div class="row mt-20x">
            <div class="col-md-12 bold">{{ mt._('admin.analysis.selectparams') }}</div>
          </div>
          <input type="hidden" id="sps-is-article" value="1"/>

          <div class="row mt-20x">
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-ctg'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-ctg">{{ mt._('_common.catalogs') }} <span id="sps-ctg-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-ssn'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-ssn">{{ mt._('_common.seasons') }} <span id="sps-ssn-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-chn'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-chn">{{ mt._('_common.channel') }} <span id="sps-chn-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-drp'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-drp">{{ mt._('_common.drop') }} <span id="sps-drp-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-brn'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-brn">{{ mt._('_common.brand') }} <span id="sps-brn-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-lin'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-lin">{{ mt._('_common.line') }} <span id="sps-lin-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-ser'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-ser">{{ mt._('_common.series') }} <span id="sps-ser-selected"></span></div>
            </div>
            <div class="col-md-3" style="line-height:40px">
              <div class="fr w-50">
                <button type="button" class="btn btn-primary waves-effect waves-light" data-toggle='modal' data-target='.modal-sps-mty'>
                  {{ mt._('_common.select') }}
                </button>
              </div>
              <div class="capitalize right fr pr-10x bold" id="lbl-sps-mty">{{ mt._('_common.modeltype') }} <span id="sps-mty-selected"></span></div>
            </div>
          </div>

          <div class="row mt-50x">
            <div class='col-md-2 col-sm-2 col-xs-2 modal-section-title right mt-7x'>{{ mt._('admin.analysis.viewtype') }}</div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" checked name="radio-sps-viewtype" value="0"> {{ mt._('_common.model') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-2 col-sm-8 col-xs-8 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-sps-viewtype" value="1"> {{ mt._('_common.article') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-3 col-sm-3 col-xs-3 right'>
              <button type="button" class="btn btn-default capitalize" id="reset-filters">{{ mt._('_common.resetfilter') }}</button>
            </div>
            <div class='col-md-3 col-sm-3 col-xs-3 right'>
              <button type="button" class="btn btn-primary" id="elaborate-sps">{{ mt._('statistics.elaborate') }}</button>
            </div>
          </div>

          <div class="loader center" id="sps-analysis-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>

          <div class="row mt-20x" id="sps-content" style="border-top:1px solid #eee">

          </div>
        </div>
        {% endif %}
      </div>
    </div>
  </div>
</div>
