<div x-data="orderTab" role="tabpanel" class="orders-listtab-pane account-tab fade {% if active_ord %}show active{% endif %}"
     id="tab_ord">
    {% if error == 'e' %}
        <div class="unsuccess-box mb-10x">
            <div>{{ mt._('_common.regqtm.fileerror') }}</div>
        </div>
    {% endif %}
    {% if common['orders']|length > 0 %}
        {# {% if session.get('auth')['type'] == 3 %} #}
        {% if true %}
            <div class="filter-container">
                <div class='d-flex'>
                    <div class="col flex-grow-1">
                        <div class='account-title text-capitalize'>{{ mt._('_common.filter') }}</div>
                        <div class='account-field form-element'>
                            <input x-ref="clientFilter" @keydown.enter="filters.client = $event.target.value" type='text'
                                   class='form-control' name='order-filter' value="{{ request.get('c') }}" />
                        </div>
                    </div>
                    <div class="col flex-grow-1">
                        <div class='account-title text-capitalize ml-20x'>{{ mt._('_common.status') }}</div>
                        <div class="form-element form-select m-0">
                            <label class="form-custom-select">
                                <select x-model="filters.status" id="status_type" name="status_type">
                                    <option value="0" selected>{{ mt._('_common.allp') }}</option>
                                    <option value="5">{{ mt._('account.order.waitingquantity') }}</option>
                                    <option value="1">{{ mt._('account.order.provisional') }}</option>
                                    {% if common['orderStateMgmt'] %}
                                        <option value="6">{{ mt._('account.order.customerconfirmed') }}</option>
                                    {% endif %}
                                    <option value="2">{{ mt._('account.order.sent') }}</option>
                                    <option value="3">{{ mt._('account.order.accepted') }}</option>
                                    <option value="4">{{ mt._('account.order.rejected') }}</option>
                                </select>
                            </label>
                        </div>
                    </div>
                    <div class="col flex-grow-1">
                        <div class='account-title text-capitalize'>{{ mt._('_common.date') }}</div>
                        <div class='account-field form-element'>
                            <input type='text' id='date-filter'
                                   class='form-control' name='order-filter'/>
                        </div>
                    </div>
                </div>
                <div class="text-right pr-4">
                    <div class="account-field form-element">
                        <a @click="resetFilters" href="#">
                            {{ mt._('account.orders.clearFilters') }}
                        </a>
                    </div>
                </div>
            </div>
        {% endif %}
        <div class="filter-container">
            <!-- <div class="row header-acc-ord">
                <div class="col-ord-nuordc col-ord">
                    <div class='d-none d-lg-block float-left pr-5x'>{{ mt._('_common.order') }} </div>
                    #
                </div>
                <div class="col-ord-anagra">{{ mt._('_common.customer') }}</div>
                <div class="col-ord-nuordc">&nbsp;</div>
                <div class="col-ord-nuordc">{{ mt._('_common.typeOrder') }}</div>
                <div class="col-ord-dtcrea col-ord">{{ mt._('_common.date') }}</div>
                <div class="col-ord-status col-ord">{{ mt._('_common.status') }}</div>
                <div class="col-ord-numrow col-ord">{{ mt._('_common.rows') }}</div>
                <div class="col-ord-status col-ord">{{ mt._('_common.marchio') }}</div>
                <div class="col-ord-totqty col-ord">{{ mt._('_common.quantity') }}</div>
                <div class="col-ord-totprc col-ord">{{ mt._('_common.total') }}</div>
                <div class="col-ord-btntls col-ord">{{ mt._('_common.actions') }}</div>
                <div class="col-ord-btnrem col-ord">&nbsp;</div>
            </div> -->

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th class="d-none d-lg-block pr-5x">{{ mt._('_common.order') }}</th>
                            <th>{{ mt._('_common.customer') }}</th>
                            <th>{{ mt._('_common.user') }}</th>
                            <th class="text-center">{{ mt._('_common.typeOrder') }}</th>
                            <th class="text-center">{{ mt._('_common.date') }}</th>
                            <th class="text-center">{{ mt._('_common.status') }}</th>
                            <th class="text-center">{{ mt._('_common.rows') }}</th>
                            <th class="text-center">{{ mt._('_common.marchio') }}</th>
                            <th class="text-center">{{ mt._('_common.quantity') }}</th>
                            <th class="text-center">{{ mt._('_common.total') }}</th>
                            <th class="text-center">{{ mt._('_common.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template :key="order.nuordc" x-for="order in filteredOrders()">
                            <tr x-data="orderListItem(order)" x-cloak
                                 x-show="isVisible()"
                                 x-bind:data-nuordc="order.nuordc"
                                 x-bind:data-filter="`${order.codice_ordine} ${order.descri1}`" x-bind:data-status="order.flstat">
                                <td x-text="order.codice_ordine"></td>
                                <td x-text="order.chmod === 'read' ? `${order.descri1} ${order.descri2}` : order.descri1"></td>
                                <td x-text="order.owner_order + '-' + order.owner_name"></td>
                                <td class="col-ord" x-text="newOrderTypes?.find((v) => v.codice === order.cdtipord)?.descri"></td>
                                <td class="col-ord" x-text="order.dtcrea"></td>
                                <td class=" status col-ord" :class="`sts${order.flstat}`"
                                     x-text="getOrderStatus(order.flstat)"></td>
                                <td class="col-ord" x-text="order.num_rows"></td>
                                <td class="col-ord" x-text="order.cdtitl"></td>
                                <td class="col-ord" x-text="order.tot_qty"></td>
                                <td class="col-ord" x-text="getOrderPrice(order)"></td>
                                <td class="nuordc col-ord" x-bind:data-nuordc="order.nuordc">
                                    <div class="order-list-btn text-center d-block d-lg-none">
                                        <a href="#" class="no-deco show-tool-box">
                                            <span class="icon"><i class="fa fa-caret-down"></i></span>
                                        </a>
                                    </div>
                                    <div class="row-tool-box">
                                        <div class="order-list-btn text-center">
                                            <a :href="`/cart/index/${order.nuordc}`" class="no-deco">
                                                <img src="/assets/img/eye.jpg" :alt="transSeeorder" :title="transSeeorder"/>
                                            </a>
                                        </div>
                                        <div :class="order.owner_code !== commonData.auth.code || isDisabled ? 'disabled' : ''" class="order-list-btn text-center">
                                            <a href="#" class="no-deco modify-order"
                                               x-bind:data-toggle="order.owner_code === commonData.auth.code && !isDisabled ? 'modal' : ''"
                                               x-bind:data-target="order.owner_code === commonData.auth.code && !isDisabled ? '.modal-modify-order' : ''">
                                                <img src="/assets/img/edit.jpg" :alt="transModifyOrder" :title="transModifyOrder"/>
                                            </a>
                                        </div>
                                        <div :class="order.owner_code === commonData.auth.code && isNotDisabled ? '' : 'disabled'" class="order-list-btn text-center">
                                            <template x-if="order.is_sendable">
                                                <a x-show="order.is_available || [2,3,4].includes(order.flstat)" href="#"
                                                   class="no-deco send-order" x-bind:data-toggle="order.owner_code === commonData.auth.code && isNotDisabled ? 'modal' : ''"
                                                   x-bind:data-target="order.owner_code === commonData.auth.code && isNotDisabled ? '.modal-send-order' : ''">
                                                    {{ image("assets/img/send.jpg", "title": mt._(common['orderStateMgmt'] ? '_common.confirm' : '_common.sendorder')) }}
                                                </a>
                                                <i x-show="!(order.is_sendable || [2,3,4].includes(order.flstat))"
                                                   class="fa fa-exclamation font-weight-bold red-mark" data-toggle="tooltip"
                                                   title="{{ mt._('order.nolongeravailable') }}"></i>
                                            </template>
                                            <template x-if="!order.is_sendable">
                                                <i class="fa fa-exclamation font-weight-bold red-mark" data-toggle="tooltip"
                                                   x-bind:title="transNorPrices"></i>
                                            </template>
                                        </div>
                                        <template x-if="common.canEditXls && order.owner_code === commonData.auth.code">
                                            <div class="order-list-btn text-center">
                                                {#{% if isDisabled %}#}
                                                    <a x-show="isDisabled" href="#" class="no-deco download-xls-order">
                                                        <img src="/assets/img/xls.jpg" :title="transOrderXlsDownload"
                                                             :alt="transOrderXlsDownload">
                                                    </a>
                                                {#{% else %}#}
                                                    <a x-show="!isDisabled" href="#" class="no-deco xls-order" data-toggle='modal'
                                                       data-target='.modal-xls-order'>
                                                        <img src="/assets/img/xls.jpg" :alt="transModifyOrder"
                                                             :title="transModifyOrder">
                                                    </a>
                                                {#{% endif %}#}
                                            </div>
                                        </template>
                                        <div class="order-list-btn text-center">
                                            <button :disabled="pdfLoading" @click="createPdf()" class="no-deco link-pdf btn-reset" target="_blank" style="height: 25px">
                                                <template x-if="!pdfLoading">
                                                    <img src="/assets/img/pdf.jpg" :alt="pdfName" :title="pdfName">
                                                </template>
                                                <template x-if="pdfLoading">
                                                    <i class="fa fa-spinner fa-spin fa-fw"></i>
                                                </template>
                                            </button>

                                        </div>
                                        <div :class="order.flstat != 1 || order.chmod !== 'all' ? 'hide-toll' : ''"
                                             class="order-list-btn text-center delete-order-mobile">
                                            <template x-if="['1','5'].includes(order.flstat) && order.chmod === 'all'">
                                                <a href="#" class="no-deco delete-order" data-toggle='modal'
                                                   data-target='.modal-cancel-order' x-bind:data-nuordc="order.nuordc">
                                                <span class="icon" data-toggle="tooltip" :title="transCancelOrder"><i
                                                            class="fa fa-times"></i></span>
                                                </a>
                                            </template>
                                        </div>
                                    </div>
                                </td>
                                <td class="col-ord-btnrem delete-order-desktop">
                                    <template x-if="['1','5'].includes(order.flstat) && order.chmod === 'all' && order.owner_code === commonData.auth.code">
                                        <a href="#" class="no-deco delete-order" data-toggle='modal'
                                           data-target='.modal-cancel-order'
                                           x-bind:data-nuordc="order.nuordc">
                                        <span class="icon" data-toggle="tooltip" :title="transCancelOrder"><i
                                                    class="fa fa-times"></i></span>
                                        </a>
                                    </template>
                                    <template x-if="!(['1','5'].includes(order.flstat) && order.chmod === 'all')">
                                        <span>&nbsp;</span>
                                    </template>
                                </td>
                            </div>
                        </template>
                        <tr>
                            <td colspan="12" x-show="noOrders">
                                {{ mt._('account.orders.noOrders') }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- <p class="text-center mt-4" x-show="noOrders">
                {{ mt._('account.orders.noOrders') }}
            </p> -->

            <!-- <template :key="order.nuordc" x-for="order in filteredOrders()">
                <div x-data="orderListItem(order)" x-cloak
                     x-show="isVisible()"
                     class="row order-row" x-bind:data-nuordc="order.nuordc"
                     x-bind:data-filter="`${order.nuordc} ${order.descri1}`" x-bind:data-status="order.flstat">
                    <div class="col-ord-nuordc" x-text="order.nuordc"></div>
                    <div class="col-ord-anagra"
                         x-text="order.chmod === 'read' ? `${order.descri1} ${order.descri2}` : order.descri1"></div>
                    <div class="col-ord-nuordc" x-text="order.owner_order"></div>
                    <div class="col-ord-nuordc" x-text="order.type"></div>
                    <div class="col-ord-dtcrea col-ord col-ord" x-text="order.dtcrea"></div>
                    <div class="col-ord-status status col-ord" :class="`sts${order.flstat}`"
                         x-text="getOrderStatus(order.flstat)"></div>
                    <div class="col-ord-numrow col-ord" x-text="order.num_rows"></div>
                    <div class="col-ord-status col-ord" x-text="order.cdtitl"></div>
                    <div class="col-ord-totqty col-ord" x-text="order.tot_qty"></div>
                    <div class="col-ord-totprc col-ord" x-text="getOrderPrice(order)"></div>
                    <div class="col-ord-btntls nuordc col-ord" x-bind:data-nuordc="order.nuordc">
                        <div class="order-list-btn text-center d-block d-lg-none">
                            <a href="#" class="no-deco show-tool-box">
                                <span class="icon"><i class="fa fa-caret-down"></i></span>
                            </a>
                        </div>
                        <div class="row-tool-box">
                            <div class="order-list-btn text-center">
                                <a :href="`/cart/index/${order.nuordc}`" class="no-deco">
                                    <img src="/assets/img/eye.jpg" :alt="transSeeorder" :title="transSeeorder"/>
                                </a>
                            </div>
                            <div :class="isDisabled ? 'disabled' : ''" class="order-list-btn text-center">
                                <a href="#" class="no-deco modify-order"
                                   x-bind:data-toggle=" !isDisabled ? 'modal' : ''"
                                   x-bind:data-target="!isDisabled ? '.modal-modify-order' : ''">
                                    <img src="/assets/img/edit.jpg" :alt="transModifyOrder" :title="transModifyOrder"/>
                                </a>
                            </div>
                            <div :class="isNotDisabled ? '' : 'disabled'" class="order-list-btn text-center">
                                <template x-if="order.is_sendable">
                                    <a x-show="order.is_available || [2,3,4].includes(order.flstat)" href="#"
                                       class="no-deco send-order" x-bind:data-toggle="isNotDisabled ? 'modal' : ''"
                                       x-bind:data-target="isNotDisabled ? '.modal-send-order' : ''">
                                        {{ image("assets/img/send.jpg", "title": mt._(common['orderStateMgmt'] ? '_common.confirm' : '_common.sendorder')) }}
                                    </a>
                                    <i x-show="!(order.is_sendable || [2,3,4].includes(order.flstat))"
                                       class="fa fa-exclamation font-weight-bold red-mark" data-toggle="tooltip"
                                       title="{{ mt._('order.nolongeravailable') }}"></i>
                                </template>
                                <template x-if="!order.is_sendable">
                                    <i class="fa fa-exclamation font-weight-bold red-mark" data-toggle="tooltip"
                                       x-bind:title="transNorPrices"></i>
                                </template>
                            </div>
                            <template x-if="common.canEditXls">
                                <div class="order-list-btn text-center">
                                   {# {% if isDisabled %}#}
                                        <a x-show="isDisabled" href="#" class="no-deco download-xls-order">
                                            <img src="/assets/img/xls.jpg" :title="transOrderXlsDownload"
                                                 :alt="transOrderXlsDownload">
                                        </a>
                                   {# {% else %}#}
                                        <a x-show="!isDisabled" href="#" class="no-deco xls-order" data-toggle='modal'
                                           data-target='.modal-xls-order'>
                                            <img src="/assets/img/xls.jpg" :alt="transModifyOrder"
                                                 :title="transModifyOrder">
                                        </a>
                                   {# {% endif %}#}
                                </div>
                            </template>
                            <div class="order-list-btn text-center">
                                <button @click="createPdf()" class="no-deco link-pdf btn-reset" target="_blank">
                                    <img src="/assets/img/pdf.jpg" :alt="pdfName" :title="pdfName">
                                </button>

                            </div>
                            <div :class="order.flstat != 1 || order.chmod !== 'all' ? 'hide-toll' : ''"
                                 class="order-list-btn text-center delete-order-mobile">
                                <template x-if="['1','5'].includes(order.flstat) && order.chmod === 'all'">
                                    <a href="#" class="no-deco delete-order" data-toggle='modal'
                                       data-target='.modal-cancel-order' x-bind:data-nuordc="order.nuordc">
                                    <span class="icon" data-toggle="tooltip" :title="transCancelOrder"><i
                                                class="fa fa-times"></i></span>
                                    </a>
                                </template>
                            </div>
                        </div>
                    </div>
                    <div class="col-ord-btnrem delete-order-desktop">
                        <template x-if="['1','5'].includes(order.flstat) && order.chmod === 'all'">
                            <a href="#" class="no-deco delete-order" data-toggle='modal'
                               data-target='.modal-cancel-order'
                               x-bind:data-nuordc="order.nuordc">
                            <span class="icon" data-toggle="tooltip" :title="transCancelOrder"><i
                                        class="fa fa-times"></i></span>
                            </a>
                        </template>
                        <template x-if="!(['1','5'].includes(order.flstat) && order.chmod === 'all')">
                            <span>&nbsp;</span>
                        </template>
                    </div>
                </div>
            </template> -->
        </div>
    {% endif %}
</div>

<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('orderTab', () => ({
            orders: {{ common['orders']|json_encode() }},
            selectedCustomer: {{ selectedCustomer|json_encode() }},
            lang: {{ lang|json_encode() }},
            common: {{ common|json_encode() }},
            formatter: null,
            transSeeorder: {{ mt._('_common.seeorder')|json_encode() }},
            transModifyOrder: {{ mt._('_common.modifyorder')|json_encode() }},
            transNorPrices: {{ mt._('order.noprices')|json_encode() }},
            transOrderXlsDownload: {{ mt._('order.xls.download')|json_encode }},
            transCancelOrder: {{ mt._('_common.cancelorder')|json_encode() }},
            tab: {{ tab|json_encode() }},
            noOrders: false,
            clients: [],
            filters: {
                client: '',
                status: '0',
                startDate: '',
                endDate: '',
            },
            init() {
                this.init_daterangepicker()
                this.clients = [...new Set(this.orders.map(order => order.descri1))]
            },
            resetFilters(e) {
                e.preventDefault()
                this.$refs.clientFilter.value = ''
                this.filters.client = ''
                this.filters.status = '0'
                this.filters.startDate = ''
                this.filters.endDate = ''
                const filterOnGet = {{ request.get('c') ? 'true' : 'false' }};

                if(filterOnGet !==""){
                    window.location.href = '/account/info/ord';
                    return true;
                }

                $('#date-filter').val('')
            },
            filteredOrders() {
                const filteredOrders = this.orders.filter(order => {
                    const orderDate = moment(order.dtcrea, 'DD/MM/YYYY', true); // Parsing e validazione della data
                    return (
                            this.filters.client === '' || order.descri1.toLowerCase().includes(this.filters.client.toLowerCase()) || order.nuordc.includes(this.filters.client)
                        )
                        && (this.filters.status === '0' || order.flstat == this.filters.status)
                        && (this.filters.startDate === '' || orderDate.isSame(this.filters.startDate) || orderDate.isAfter(this.filters.startDate))
                        && (this.filters.endDate === '' || orderDate.isSame(this.filters.endDate) || orderDate.isBefore(this.filters.endDate))
                });

                if (filteredOrders.length === 0) {
                    this.noOrders = true;
                } else {
                    this.noOrders = false;
                }

                return filteredOrders
            },
            init_daterangepicker() {
                {% include "scripts/common/daterangepicker_config.volt" %}
                if (typeof ($.fn.daterangepicker) === 'undefined') {
                    return;
                }

                $('#date-filter').daterangepicker({
                    ...drpConfig,
                    autoUpdateInput: false,
                    locale: {
                        cancelLabel: '{{ mt._('quantity.empty') }}'
                    }
                })

                $('#date-filter').on('apply.daterangepicker', (ev, picker) => {
                    this.filters.startDate = picker.startDate.format('YYYY-MM-DD')
                    this.filters.endDate = picker.endDate.format('YYYY-MM-DD')
                    picker.element.val(`${this.filters.startDate} - ${this.filters.endDate}`);
                });

                $('#date-filter').on('cancel.daterangepicker', (ev, picker) => {
                    this.filters.startDate = ''
                    this.filters.endDate = ''
                    picker.element.val('');
                });
            },
            getOrderStatus(flstat) {
                switch (parseInt(flstat)) {
                    case 1:
                        return {{ mt._('account.order.provisional')|json_encode }};
                    case 2:
                        return {{ mt._(common['orderStateMgmt'] ? 'account.order.processed' : 'account.order.sent')|json_encode }};
                    case 3:
                        return {{ mt._('account.order.accepted')|json_encode }};
                    case 4:
                        return {{ mt._('account.order.rejected')|json_encode }};
                    case 5:
                        return {{ mt._('account.order.waitingquantity')|json_encode }};
                    case 6:
                        return {{ mt._('account.order.customerconfirmed')|json_encode }};
                    default:
                        return '';
                }
            },
            getLanguageCode() {
                switch (this.lang) {
                    case 'it':
                        return 'it-IT'
                    case 'en':
                        return 'en-GB'
                    case 'es':
                        return 'es-ES'
                    case 'de':
                        return 'de-DE'
                    case 'fr':
                        return 'fr-FR'
                }
            },
            getKeyByValue(object, value) {
                return Object.keys(object).find(key => object[key] === value);
            },
            getOrderPrice(order) {
                const currencyData = Object.values(window.currencies).find(cur => cur.symbol_native === order.currency)
                const currencyCode = this.getKeyByValue(window.currencies, currencyData)
                const formatter = new Intl.NumberFormat(this.getLanguageCode(), {
                    style: 'currency',
                    currency: currencyCode,
                });
                return formatter.format(order.tot_prc)
            },
        }))

        Alpine.data('orderListItem', (order) => ({
            order: order,
            isDisabled: null,
            isNotDisabled: null,
            orderDate: null,
            pdfName: null,
            pdfUrl: null,
            pdfLoading: false,
            init() {
                this.isDisabled = !['1', '5'].includes(order.flstat) || order.chmod !== 'all'
                this.isNotDisabled = !order.is_disabled && (order.tpanag !== 'CN' || this.common.CNCanSendOrders)
                this.orderDate = order.dtcrea.split('/');
                this.pdfName = `order-${order.nuordc}-${this.orderDate[2]}${this.orderDate[1]}${this.orderDate[0]}.pdf`
                this.pdfUrl = `${this.tab !== '' ? '../' : ''}../pdf/${this.pdfName}`
            },
            createPdf() {
                this.pdfLoading = true;
                $.ajax({
                    type: "POST",
                    url: "{{ url('pdf/order') }}",
                    dataType: "json",
                    data: {
                        nuordc: this.order.nuordc,
                    }
                }).done((data) => {
                    window.open(this.pdfUrl, '_blank');
                    this.pdfLoading = false;
                }).error((x, t, m) => {
                    printAjaxError(x, t, m);
                    this.pdfLoading = false;
                });
            },
            isVisible() {
                const basicVisibility = this.selectedCustomer === '' || (this.order.tpanag === this.selectedCustomer.tpanag && this.order.cdanag === this.selectedCustomer.cdanag);
                return basicVisibility
            },
        }))
    })
</script>
