{% set num_tabs = 10 %}
{% set width_to_add = 0 %}

{% if common['showProfile'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 7 %}{% endif %}
{% if common['showCustomer'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 12 %}{% endif %}
{% if common['budgetManagement'] == 0 or session.get('auth')['type'] != 3 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 7 %}{% endif %}
{% if common['showDestinations'] == 0 or common['customers']|length > 1 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 14 %}{% endif %}
{% if common['showOrders'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 8 %}{% endif %}
{% if common['showOrdersHistory'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 10 %}{% endif %}
{% if common['showInvoicesHistory'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 10 %}{% endif %}
{% if common['showTransDocHistory'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 10 %}{% endif %}
{% if common['returnsmngmt'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 12 %}{% endif %}
{% if common['showDeadlines'] == 0 %}{% set num_tabs = num_tabs - 1 %}{% set width_to_add = width_to_add + 10 %}{% endif %}

<div class="container mw-100" style="padding-top:22rem;">
  <div class="row w-100 ml-0 mr-0">
  {% if num_tabs > 0 %}
    {% set active_pro = tab == 'pro' or tab == '' %}
    {% set condition = common['showProfile'] == 0 %}
    {% set active_cus = tab == 'cus' or condition %}
    {% set condition = condition and (common['showCustomer'] == 0) %}
    {% set active_bud = tab == 'bud' or condition %}
    {% set condition = condition and (common['budgetManagement'] == 0 or session.get('auth')['type'] != 3) %}
    {% set active_shi = tab == 'shi' or condition %}
    {% set condition = condition and (common['showDestinations'] == 0 or common['customers']|length > 1) %}
    {% set active_ord = tab == 'ord' or condition %}
    {% set condition = condition and (common['showOrders'] == 0) %}
    {% set active_orh = tab == 'orh' or condition %}
    {% set condition = condition and (common['showOrdersHistory'] == 0) %}
    {% set active_inh = tab == 'inh' or condition %}
    {% set condition = condition and (common['showInvoicesHistory'] == 0) %}
    {% set active_tdh = tab == 'tdh' or condition %}
    {% set condition = condition and (common['showTransDocHistory'] == 0) %}
    {% set active_exc = tab == 'exc' or condition %}
    {% set condition = condition and (common['returnsmngmt'] == 0) %}
    {% set active_tic = tab == 'tic' or condition %}

    {% set width_pro = 7 + (width_to_add / num_tabs) %}
    {% set width_cus = 12 + (width_to_add / num_tabs) %}
    {% set width_bud = 7 + (width_to_add / num_tabs) %}
    {% set width_shi = 14 + (width_to_add / num_tabs) %}
    {% set width_ord = 8 + (width_to_add / num_tabs) %}
    {% set width_orh = 10 + (width_to_add / num_tabs) %}
    {% set width_inh = 10 + (width_to_add / num_tabs) %}
    {% set width_tdh = 10 + (width_to_add / num_tabs) %}
    {% set width_exc = 12 + (width_to_add / num_tabs) %}
    {% set width_tic = 10 + (width_to_add / num_tabs) %}

    <!-- Nav Tabs -->
    <ul class="nav nav-tabs d-none d-md-block" role="tablist">
    {% if common['showProfile'] == 1 %}
      <li class="nav-item" style="width:{{ width_pro }}%"><a {% if active_pro %}class="active"{% endif %} href="#tab_pro" role="tab" data-toggle="tab">{{ mt._('account.tab.profile') }}</a></li>
    {% endif %}
    {% if common['showCustomer'] == 1 %}
      <li class="nav-item" style="width:{{ width_cus }}%"><a {% if active_cus %}class="active"{% endif %} href="#tab_cus" role="tab" data-toggle="tab">{{ mt._('account.tab.customercard') }}</a></li>
    {% endif %}
    {% if common['budgetManagement'] > 0 %}
      <li class="nav-item" style="width:{{ width_bud }}%"><a {% if active_bud %}class="active"{% endif %} href="#tab_bud" role="tab" data-toggle="tab">{{ mt._('account.tab.budget') }}</a></li>
    {% endif %}
    {% if common['showDestinations'] == 1 and common['customers']|length == 1 %}
      <li class="nav-item" style="width:{{ width_shi }}%"><a {% if active_shi %}class="active"{% endif %} href="#tab_shi" role="tab" data-toggle="tab">{{ mt._('account.tab.shippings') }}</a></li>
    {% endif %}
    {% if common['showOrders'] == 1 %}
      <li class="nav-item" style="width:{{ width_ord }}%"><a {% if active_ord %}class="active"{% endif %} href="#tab_ord" role="tab" data-toggle="tab">{{ mt._('account.tab.orders') }}</a></li>
    {% endif %}
    {% if common['showOrdersHistory'] == 1 %}
      <li class="nav-item" style="width:{{ width_orh }}%"><a {% if active_orh %}class="active"{% endif %} href="#tab_orh" role="tab" data-toggle="tab">{{ mt._('account.tab.orders.history') }}</a></li>
    {% endif %}
    {% if common['showTransDocHistory'] == 1 %}
      <li class="nav-item" style="width:{{ width_tdh }}%"><a {% if active_tdh %}class="active"{% endif %} href="#tab_tdh" role="tab" data-toggle="tab">{{ mt._('account.tab.transdoc.history') }}</a></li>
    {% endif %}
    {% if common['showInvoicesHistory'] == 1 %}
      <li class="nav-item" style="width:{{ width_inh }}%"><a {% if active_inh %}class="active"{% endif %} href="#tab_inh" role="tab" data-toggle="tab">{{ mt._('account.tab.invoices.history') }}</a></li>
    {% endif %}
    {% if common['returnsmngmt'] == 1 %}
      <li class="nav-item" style="width:{{ width_exc }}%"><a {% if active_exc %}class="active"{% endif %} href="#tab_exc" role="tab" data-toggle="tab">{{ mt._('account.tab.goodsexchange') }}</a></li>
    {% endif %}
    {% if common['showDeadlines'] == 1 %}
      <li class="nav-item" style="width:{{ width_tic }}%"><a {% if active_tic %}class="active"{% endif %} href="#tab_tic" role="tab" data-toggle="tab">{{ mt._('account.tab.deadlines') }}</a></li>
    {% endif %}
    </ul><!-- .nav-tabs -->

    <div class="change_tab_container d-block d-md-none">
      <div class="form-element form-select">
        <label class="form-custom-select">
          <select id="change_tab" name="change_tab">
            {% if common['showProfile'] == 1 %}
            <option value="tab_pro" {% if active_pro %}selected{% endif %}>{{ mt._('account.tab.profile') }}</option>
            {% endif %}
            {% if common['showCustomer'] == 1 %}
            <option value="tab_cus" {% if active_cus %}selected{% endif %}>{{ mt._('account.tab.customercard') }}</option>
            {% endif %}
            {% if common['showDestinations'] == 1 and common['customers']|length == 1 %}
            <option value="tab_shi" {% if active_shi %}selected{% endif %}>{{ mt._('account.tab.shippings') }}</option>
            {% endif %}
            {% if common['showOrders'] == 1 %}
            <option value="tab_ord" {% if active_ord %}selected{% endif %}>{{ mt._('account.tab.orders') }}</option>
            {% endif %}
            {% if common['showOrdersHistory'] == 1 %}
            <option value="tab_orh" {% if active_orh %}selected{% endif %}>{{ mt._('account.tab.orders.history') }}</option>
            {% endif %}
            {% if common['returnsmngmt'] == 1 %}
            <option value="tab_exc" {% if active_exc %}selected{% endif %}>{{ mt._('account.tab.goodsexchange') }}</option>
            {% endif %}
            {% if common['showDeadlines'] == 1 %}
            <option value="tab_tic" {% if active_tic %}selected{% endif %}>{{ mt._('account.tab.deadlines') }}</option>
            {% endif %}
          </select>
          <span class="pointer"><i class="fa fa-caret-down"></i></span>
        </label>
      </div>
    </div>

    <!-- Tab panes -->
    <div class="tab-content account-info w-100">

    {% if common['showProfile'] == 1 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_pro %}show active{% endif %}" id="tab_pro">
        <div class="row account-section bottom-border">
          <div class="col-12 col-md-4 mrg-btm-30">
            <div class="account-title">{{ mt._('session.register.username') }}</div>
            <div>{{ session.get('auth')['username'] }}</div>
          </div>
          <div class="col-12 col-md-5">
            <div class="account-title">{{ mt._('account.currentpassword') }}</div>
            <div class="account-field form-element" id="div-error-old"><input type="password" class="form-control" id="old-password" name="old-password" /></div>
            <div id="error-old" class="msg-error msg-pos">{{ mt._('account.currentpassword.warning') }}</div>
            <div class="account-title">{{ mt._('account.newpassword') }}</div>
            <div class="account-field form-element" id="div-error-new"><input type="password" class="form-control" id="new-password" name="new-password" /></div>
            <div id="error-new" class="msg-error msg-pos">{{ mt._('account.newpassword.warning') }}</div>
            <div class="account-title">{{ mt._('account.repeatnewpassword') }}</div>
            <div class="account-field form-element" id="div-error-repeat"><input type="password" class="form-control" id="rpt-password" name="rpt-password" /></div>
            <div id="error-repeat" class="msg-error msg-pos">{{ mt._('session.register.errorconfirm') }}</div>
          </div>
          <div class="col-12 col-md-3">
            <div class="save-box"><a href="#" id="save-password" class="btn btn-generic mt-28x">{{ mt._('account.savepassword') }}</a></div>
            <div id="success" class="msg-success msg-pos">{{ mt._('account.changepassword.success') }}</div>
          </div>
        </div>
        <div class="row account-section py-20x">
          <div class="col-12"><div class="account-title">{{ mt._('account.activecatalogs') }}</div></div>
        {% for cttest in common['catalogs'] %}
          <div class="col-12 col-md-4 col-lg-3"><div class="account-field">{{ cttest.dscata }}</div></div>
        {% endfor %}
        </div>
      </div>
    {% endif %}

    {% if common['showCustomer'] == 1 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_cus %}show active{% endif %}" id="tab_cus">
      {% if session.get('auth')['type'] == 4 %}
        {% set thisCustomer = common['customers'][0] %}
        {% set thisPrefix = thisCustomer.tpanag ~ "-" ~ thisCustomer.cdanag %}

        <div class="customer-card">
          <input type="hidden" id="{{ thisPrefix }}-tpanag" name="{{ thisPrefix }}-tpanag" value="{{ thisCustomer.tpanag }}" />
          <div class="row account-section bottom-border">
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.code') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-cdanag" name="{{ thisPrefix }}-cdanag"
                  value="{{ thisCustomer.cdanag }}" data-oldvalue="{{ thisCustomer.cdanag }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.businessname') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-descri" name="{{ thisPrefix }}-descri"
                  value="{{ thisCustomer.descri }}" data-oldvalue="{{ thisCustomer.descri }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.signboard') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-desvid" name="{{ thisPrefix }}-desvid"
                  value="{{ thisCustomer.desvid }}" data-oldvalue="{{ thisCustomer.desvid }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.taxcode') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-codfis" name="{{ thisPrefix }}-codfis"
                  value="{{ thisCustomer.codfis }}" data-oldvalue="{{ thisCustomer.codfis }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.vatcode') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-pariva" name="{{ thisPrefix }}-pariva"
                  value="{{ thisCustomer.pariva }}" data-oldvalue="{{ thisCustomer.pariva }}" disabled />
              </div>
            </div>
          </div>
          <div class="row account-section bottom-border pt-20x">
            <div class="col-12 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.address') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ thisPrefix }}-indiri" name="{{ thisPrefix }}-indiri"
                  value="{{ thisCustomer.indiri }}" data-oldvalue="{{ thisCustomer.indiri }}" disabled />
              </div>
            </div>
            <div class="col-12 col-lg-4">
              <div style="width:50%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.city') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-ccitta" name="{{ thisPrefix }}-ccitta"
                    value="{{ thisCustomer.ccitta }}" data-oldvalue="{{ thisCustomer.ccitta }}" disabled />
                </div>
              </div>
              <div style="width:18%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.province') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-provin" name="{{ thisPrefix }}-provin"
                    value="{{ thisCustomer.provin }}" data-oldvalue="{{ thisCustomer.provin }}" disabled />
                </div>
              </div>
              <div style="width:24%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.capzip') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-codcap" name="{{ thisPrefix }}-codcap"
                    value="{{ thisCustomer.codcap }}" data-oldvalue="{{ thisCustomer.codcap }}" disabled />
                </div>
              </div>
            </div>
            <div class="col-6 col-lg-2">
              <div class="account-title">{{ mt._('account.customer.country') }}</div>
              <div class="account-field form-element form-select">
                <div class="form-element form-select">
                  <label class="form-custom-select">
                    <select class="readonly" id="{{ thisPrefix }}-cdnazi" name="{{ thisPrefix }}-cdnazi"
                      data-oldvalue="{{ thisCustomer.cdnazi }}" disabled>
                      <option value="null" {% if thisCustomer.cdnazi == "" %}selected{% endif%} >&nbsp;</option>
                      {% for ananaz in common['countries'] %}
                      <option value="{{ ananaz.cdnazi }}" {% if thisCustomer.cdnazi == ananaz.cdnazi %}selected{% endif%} >{{ ananaz.dsnazi }}</option>
                      {% endfor %}
                    </select>
                  </label>
                </div>
              </div>
            </div>
            <div class="col-6 col-lg-2">
              <div class="account-title">{{ mt._('account.customer.zone') }}</div>
              <div class="account-field form-element form-select">
                <div class="form-element form-select">
                  <label class="form-custom-select">
                    <select class="readonly" id="{{ thisPrefix }}-cdzona" name="{{ thisPrefix }}-cdzona"
                      data-oldvalue="{{ thisCustomer.cdzona }}" disabled>
                      <option value="null" {% if thisCustomer.cdzona == "" %}selected{% endif%} >&nbsp;</option>
                      {% for anazon in common['zones'] %}
                      <option value="{{ anazon.cdzona }}" {% if thisCustomer.cdzona == anazon.cdzona %}selected{% endif%} >{{ anazon.dszona }}</option>
                      {% endfor %}
                    </select>
                  </label>
                </div>
              </div>
            </div>
            <div class="col-12 col-lg-4">
              <div style="width:20%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.countrycode') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-intern" name="{{ thisPrefix }}-intern"
                    value="{{ thisCustomer.intern }}" data-oldvalue="{{ thisCustomer.intern }}" disabled />
                </div>
              </div>
              <div style="width:36%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.telephone') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-numtel" name="{{ thisPrefix }}-numtel"
                    value="{{ thisCustomer.numtel }}" data-oldvalue="{{ thisCustomer.numtel }}" disabled />
                </div>
              </div>
              <div style="width:36%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.telephone.other') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-numte2" name="{{ thisPrefix }}-numte2"
                    value="" data-oldvalue="" disabled />
                </div>
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.referent.main') }}</div>
              <div class="account-field form-element"><input type="text" class="form-control readonly" disabled /></div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.referent.other') }}</div>
              <div class="account-field form-element"><input type="text" class="form-control readonly" disabled /></div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.mobilephone') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ thisPrefix }}-numcel" name="{{ thisPrefix }}-numcel"
                  value="{{ thisCustomer.numcel }}" data-oldvalue="{{ thisCustomer.numcel }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.fax') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ thisPrefix }}-numfax" name="{{ thisPrefix }}-numfax"
                  value="{{ thisCustomer.numfax }}" data-oldvalue="{{ thisCustomer.numfax }}" disabled />
              </div>
            </div>
          </div>
          <div class="row account-section pt-20x pb-40x">
            <div class="col-12 col-lg-4">
              <div style="width:20%;margin-right:4%" class="float-left">
                <div class="account-title">ABI</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-codabi" name="{{ thisPrefix }}-codabi"
                    value="{{ thisCustomer.codabi }}" data-oldvalue="{{ thisCustomer.codabi }}" disabled />
                </div>
              </div>
              <div style="width:20%;margin-right:4%" class="float-left">
                <div class="account-title">CAB</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-codcab" name="{{ thisPrefix }}-codcab"
                    value="{{ thisCustomer.codcab }}" data-oldvalue="{{ thisCustomer.codcab }}" disabled />
                </div>
              </div>
              <div style="width:52%" class="float-left">
                <div class="account-title">IBAN</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ thisPrefix }}-cdiban" name="{{ thisPrefix }}-cdiban"
                    value="{{ thisCustomer.cdiban }}" data-oldvalue="{{ thisCustomer.cdiban }}" disabled />
                </div>
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.payment') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-tppaga" name="{{ thisPrefix }}-tppaga"
                  value="{{ thisCustomer.dspaga }}" data-oldvalue="{{ thisCustomer.dspaga }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.shipment') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-tpport" name="{{ thisPrefix }}-tpport"
                  value="{{ thisCustomer.dstpor }}" data-oldvalue="{{ thisCustomer.dstpor }}" disabled />
              </div>
            </div>
            {% if session.get('auth')['type'] == 3 %}
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title text-capitalize">{{ mt._('_common.pricelist') }}  <span style="color:red">*</span> </div>
              <div class="account-field form-element form-select">
                <div class="form-element form-select">
                  <label class="form-custom-select">
                    <select class="readonly" id="{{ thisPrefix }}-nulist" name="{{ thisPrefix }}-nulist"
                      data-oldvalue="{{ thisCustomer.nulist }}" disabled>
                      <option value="null" {% if thisCustomer.nulist == "" %}selected{% endif%} >&nbsp;</option>
                      {% for lstest in common['priceLists'] %}
                      <option value="{{ lstest.nulist }}" {% if thisCustomer.nulist == lstest.nulist %}selected{% endif%} >{{ lstest.dslist }}</option>
                      {% endfor %}
                    </select>
                  </label>
                </div>
              </div>
            </div>
            {% else %}
            <div class="col-12 col-md-6 col-lg-4">&nbsp;</div>
            {% endif %}
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.carrier') }}</div>
              <div class="account-field form-element form-select">
                <div class="form-element form-select">
                  <label class="form-custom-select">
                    <select class="readonly" id="{{ thisPrefix }}-cdvett" name="{{ thisPrefix }}-cdvett"
                      data-oldvalue="{{ thisCustomer.cdvett }}" disabled>
                      <option value="null" {% if thisCustomer.cdvett == "" %}selected{% endif%} >&nbsp;</option>
                      {% for anavet in common['carriers'] %}
                      <option value="{{ anavet.cdvett }}" {% if thisCustomer.cdvett == anavet.cdvett %}selected{% endif%} >{{ anavet.dsvett }}</option>
                      {% endfor %}
                    </select>
                  </label>
                </div>
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.agent') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control" id="{{ thisPrefix }}-cdagen" name="{{ thisPrefix }}-cdagen"
                  value="{{ thisCustomer.dsagen }}" data-oldvalue="{{ thisCustomer.dsagen }}" disabled />
              </div>
            </div>
            {% if common['sendmaildatavar'] == 1 %}
            <div class="col-12 offset-0 col-md-6 offset-md-6 col-lg-4 offset-lg-0">
              <div style="margin-top:19px;margin-right:-7px">
                <a href="#" data-tpanag="{{ thisCustomer.tpanag }}" data-cdanag="{{ thisCustomer.cdanag }}"
                  class="btn btn-generic anagra-require-modify">{{ mt._('account.customer.requiremodify') }}</a>
              </div>
            </div>
          {% endif %}
          </div>
        </div>
      {% else %}

        <div class="row account-section w-80" id="anagra-selector-header">
          <div class="col-12 col-md-6 p-0">
            {% if common['customers']|length > 0 %}
            <div class="form-element form-select">
              <label class="form-custom-select">
                <select id="multi-anagra-selector" class="selectpicker" data-live-search="true">
                  {% for anagra in common['customers'] %}
                  <option id="multi-anagra-{{ loop.index }}" data-tpanag="{{ anagra.tpanag }}" data-cdanag="{{ anagra.cdanag }}"
                    value="{{ loop.index }}" {{ anagra.tpanag == 'CN' ? 'style="font-style:italic"' : '' }}>
                    {{ anagra.tpanag }} - {{ anagra.cdanag }} - {{ anagra.descri }}
                  </option>
                  {% endfor %}
                </select>
              </label>
            </div>

            <div class="text-left" style="margin-top:19px">
              <a href="#" class="btn btn-generic" id="load-anagra">{{ mt._('account.customer.load') }}</a>
            </div>

            {% else %}

            {{ mt._('account.customer.nocustomers') }}

            {% endif %}
          </div>

          {% if session.get('auth')['type'] == 3 %}
          <div class="col-12 col-md-6 p-0">
            <div class="text-right">
              <a href="#" class="btn btn-generic" id="new-anagra" style="margin-top:-4px">{{ mt._('account.customer.new') }}</a>
            </div>
            {# codice bottone nuova destinazione, TODO da spostare #}
            {% if common['customers']|length > 0 %}
            <div class="text-left" style="margin-top:-4px; float:right">
              <a href="#" class="btn btn-generic d-none" id="new-desmer">{{ mt._('admin.customers.newshipping') }}</a>
            </div>
            {% endif %}

          </div>
          {% endif %}
        </div>

        {% if common['customers']|length > 0 %}
        <div class="customer-card pt-20x"></div>
        <div id="anagra-desmer" class="pt-20x"></div>
        <div id="new-desmer-form" class="pt-20x"></div>
        {% endif %}

        {% if session.get('auth')['type'] == 3 %}
        <div id="new-anagra-box" style="display:none">

          <div class="row account-section w-80 mb-20x">
            <div class="col-12 col-md-6 p-0 text-left">
              <a href="#" class="btn btn-generic cancel-new-anagra">{{ mt._('_common.cancel') }}</a>
            </div>
            <div class="col-12 col-md-6 p-0 text-right">
              <a href="#" class="btn btn-generic save-new-anagra float-right">{{ mt._('_common.save') }}</a>
              <div class="text-right unsuccess-box empty-fields float-right" style="display:none">
                <div style="line-height:26px">{{ mt._('admin.featured.homepage.error') }}</div>
              </div>
              <div class="text-right unsuccess-box already-present float-right" style="display:none">
                <div style="line-height:26px">{{ mt._('account.customer.alreadypresent') }}</div>
              </div>
            </div>
          </div>

          {% if tab_newclient == 0 %}
          {% include "account/customer.volt" %}
          {% else %}
          {% include "account/customerKOC.volt" %}
          {% endif %}

        </div>
        {% endif %}

      {% endif %}
      </div>
    {% endif %}

    {% if common['budgetManagement'] > 0 and session.get('auth')['type'] == 3 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_bud %}show active{% endif %}" id="tab_bud">
        <div class="row account-section w-80">
          <div class="col-12 col-md-2 p-0" style="line-height:42px">{{ mt._('account.budget.selectcustomer') }}</div>
          <div class="col-12 col-md-6 p-0">
            {% if common['customers']|length > 0 %}
            <select id="customer-budget-selector" class="selectpicker" data-live-search="true">
              {% for anagra in common['customers'] %}
              <option id="customer-budget-{{ loop.index }}" data-tpanag="{{ anagra.tpanag }}" data-cdanag="{{ anagra.cdanag }}"
                value="{{ loop.index }}" {{ anagra.tpanag == 'CN' ? 'style="font-style:italic"' : '' }}>
                {{ anagra.tpanag }} - {{ anagra.cdanag }} - {{ anagra.descri }}
              </option>
              {% endfor %}
            </select>
            {% else %}
            {{ mt._('account.customer.nocustomers') }}
            {% endif %}
          </div>
          <div class="d-none d-md-block col-md-4">&nbsp;</div>

          <div class="col-12 col-md-2 p-0" style="line-height:42px">{{ mt._('account.budget.selectseason') }}</div>
          <div class="col-12 col-md-6 p-0">
            {% if seasons|length > 0 %}
            <select id="season-budget-selector" class="selectpicker">
              {% for season in seasons %}
              <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
              {% endfor %}
            </select>
            {% else %}
            {{ mt._('account.customer.noseason') }}
            {% endif %}
          </div>

          {% if common['customers']|length > 0 and seasons|length > 0 %}
          <div class="col-12 col-md-6 p-0">
            <div class="text-left" style="margin-top:19px">
              <a href="#" class="btn btn-generic" id="load-budget">{{ mt._('account.budget.load') }}</a>
            </div>
          </div>
          {% endif %}
        </div>
        <div class="row account-section w-80" id="budget-box" style="overflow-x:auto;display:none">

        </div>
      </div>
    {% endif %}

    {% if common['showDestinations'] == 1 and common['customers']|length == 1 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_shi %}show active{% endif %}" id="tab_shi">
      {% if destinations|length > 0 %}
        {% for desmer in destinations %}
        <div class="destination-card-title">
          <div class="row account-section bottom-border pb-10x">{{ desmer.cddesm }} - {{ desmer.desvid }}</div>
        </div>
        <div class="destination-card">
          <div class="row account-section pt-20x pb-40x">
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.address') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-indiri" name="{{ desmer.cddesm }}-indiri" value="{{ desmer.indiri }}" disabled />
              </div>
            </div>
            <div class="col-12 col-lg-4">
              <div style="width:50%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.city') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-ccitta" name="{{ desmer.cddesm }}-ccitta" value="{{ desmer.ccitta }}" disabled />
                </div>
              </div>
              <div style="width:18%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.province') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-provin" name="{{ desmer.cddesm }}-provin" value="{{ desmer.provin }}" disabled />
                </div>
              </div>
              <div style="width:24%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.capzip') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-codcap" name="{{ desmer.cddesm }}-codcap" value="{{ desmer.codcap }}" disabled />
                </div>
              </div>
            </div>
            <div class="col-6 col-md-4 col-lg-2">
              <div class="account-title">{{ mt._('account.customer.country') }}</div>
              <div class="account-field">
                <label class="form-custom-select">
                  <select class="readonly" id="{{ desmer.cddesm }}-cdnazi" name="{{ desmer.cddesm }}-cdnazi" disabled>
                    <option value="null" {% if desmer.cdnazi == "" %}selected{% endif%} >&nbsp;</option>
                    {% for ananaz in common['countries'] %}
                    <option value="{{ ananaz.cdnazi }}" {% if desmer.cdnazi == ananaz.cdnazi %}selected{% endif%} >{{ ananaz.dsnazi }}</option>
                    {% endfor %}
                  </select>
                </label>
              </div>
            </div>
            <div class="col-6 col-md-4 col-lg-2">
              <div class="account-title">{{ mt._('account.customer.zone') }}</div>
              <div class="account-field form-element form-select">
                <label class="form-custom-select">
                  <select class="readonly" id="{{ desmer.cddesm }}-cdzona" name="{{ desmer.cddesm }}-cdzona" disabled>
                    <option value="null" {% if desmer.cdzona == "" %}selected{% endif%} >&nbsp;</option>
                    {% for anazon in common['zones'] %}
                    <option value="{{ anazon.cdzona }}" {% if desmer.cdzona == anazon.cdzona %}selected{% endif%} >{{ anazon.dszona }}</option>
                    {% endfor %}
                  </select>
                </label>
              </div>
            </div>
            <div class="col-12 col-lg-4">
              <div style="width:20%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.countrycode') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-intern" name="{{ desmer.cddesm }}-intern" value="{{ desmer.intern }}" disabled />
                </div>
              </div>
              <div style="width:36%;margin-right:4%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.telephone') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-numtel" name="{{ desmer.cddesm }}-numtel" value="{{ desmer.numtel }}" disabled />
                </div>
              </div>
              <div style="width:36%" class="float-left">
                <div class="account-title">{{ mt._('account.customer.telephone.other') }}</div>
                <div class="account-field form-element">
                  <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-numte2" name="{{ desmer.cddesm }}-numte2" value="" disabled />
                </div>
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.referent.main') }}</div>
              <div class="account-field form-element"><input type="text" class="form-control readonly" disabled /></div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.referent.other') }}</div>
              <div class="account-field form-element"><input type="text" class="form-control readonly" disabled /></div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.mobilephone') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-numcel" name="{{ desmer.cddesm }}-numcel" value="{{ desmer.numcel }}" disabled />
              </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
              <div class="account-title">{{ mt._('account.customer.fax') }}</div>
              <div class="account-field form-element">
                <input type="text" class="form-control readonly" id="{{ desmer.cddesm }}-numfax" name="{{ desmer.cddesm }}-numfax" value="{{ desmer.numfax }}" disabled />
              </div>
            </div>
          {% if common['sendmaildatavar'] == 1 %}
            <div class="col-12 offset-0 col-md-6 offset-md-6 col-lg-4 offset-lg-0">
              <div class="text-right" style="margin-top:19px;margin-right:-7px">
                <a href="#"
                  data-cddesm="{{ desmer.cddesm }}" data-desvid="{{ desmer.desvid }}" data-tpanag="{{ desmer.tpanag }}" data-cdanag="{{ desmer.cdanag }}"
                  class="btn btn-generic desmer-require-modify">{{ mt._('account.customer.requiremodify') }}</a>
              </div>
            </div>
          {% endif %}
          </div>
        </div>
        {% endfor %}
      {% else %}
        <div class="row account-section">{{ mt._('account.customer.nodestinations') }}</div>
      {% endif %}
      </div>
    {% endif %}

    {% if common['showOrders'] == 1 %}
      {% include 'account/orderTab.volt' %}
    {% endif %}

    {% if common['showOrdersHistory'] == 1 %}
      <div id="tab_orh" role="tabpanel" class="tab-pane account-tab fade {% if active_orh %}show active{% endif %}">
        {% if error == 'e' %}
          <div class="unsuccess-box mb-10x">
            <div>{{ mt._('_common.regqtm.fileerror')}}</div>
          </div>
        {% endif %}
        <div class='row account-section pb-20x w-100'>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.filter') }}</div>
            <div class='account-field form-element'><input type='text' class='form-control' id='order-history-filter' name='order-history-filter' /></div>
          </div>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.date') }}</div>
            <div class='account-field row'>
              <div class="col-6 px-0">
                <input type="text" class="form-control" id="date-flt-orh" value="" style="border-radius: 4px 0 0 4px; font-size: 14px;">
              </div>
              <div class="col-2 history-calendar"><i class="glyphicon glyphicon-calendar fa fa-calendar" style="margin-top:18%;" ></i></div>
            </div>
          </div>
          <div class='col-3'>
            <div class='account-field row mt-4'>
              <div class="col-6 px-0">
                <input type="checkbox" class="form-check-input" id="daf-flt-orh" onclick="filterOrdersHistoryChecks()">
                <label class="account-title text-capitalize mx-2" for="daf-flt-orh">{{ mt._('_common.invoiced.tb.only') }}</label>
              </div>
            </div>
            <div class='account-field row'>
              <div class="col-6 px-0">
                <input type="checkbox" class="form-check-input" id="das-flt-orh" onclick="filterOrdersHistoryChecks()">
                <label class="account-title text-capitalize mx-2" for="das-flt-orh">{{ mt._('_common.ship.tb.only') }}</label>
              </div>
            </div>
          </div>
        </div>
        <div class="row header-history header-acc-orh w-max">
          <div class="col-orh-numdoc"><div class='d-none d-lg-block float-left pr-5x'>{{ mt._('_common.order') }} </div> #</div>
          <div class="col-orh-datdoc">{{ mt._('_common.date') }}</div>
          <div class="col-orh-datspe">{{ mt._('account.customer.shipment') }}</div>
          <div class="col-orh-cdanag">{{ mt._('admin.customers.customercode') }}</div>
          <div class="col-orh-ragsoc">{{ mt._('admin.customers.name') }}</div>
          <div class="col-orh-qtaord">{{ mt._('_common.qty') }}</div>
          <div class="col-orh-qtafat">{{ mt._('_common.qty.inv') }}</div>
          <div class="col-orh-qtadaf">{{ mt._('_common.qty.inv.tb') }}</div>
          <div class="col-orh-qtaspe">{{ mt._('_common.qty.ship') }}</div>
          <div class="col-orh-qtadas">{{ mt._('_common.qty.ship.tb') }}</div>
          <div class="col-orh-impord">{{ mt._('_common.amount') }}</div>
          <div class="col-orh-impfat">{{ mt._('_common.amount.inv') }}</div>
          <div class="col-orh-impdaf">{{ mt._('_common.amount.inv.tb') }}</div>
          <div class="col-orh-impspe">{{ mt._('_common.amount.ship') }}</div>
          <div class="col-orh-impdas">{{ mt._('_common.amount.ship.tb') }}</div>
        </div>
        <div id="orh-content" class="w-max" style="margin: 0">
          {% for order in ordersHistory if (selectedCustomer == '' or (order['tpanag'] == selectedCustomer['tpanag'] and order['cdanag'] == selectedCustomer['cdanag'])) %}
            <div class="row order-history-row" style="cursor:pointer"  data-numdoc="{{ order['numdoc'] }}" data-filter=" {{ order['numdoc'] }} {{ order['cdanag'] }} {{ order['ragsoc'] }}">
              <div class="col-orh-numdoc">{{ order['numdoc'] }}</div>
              <div class="col-orh-datdoc">{{ order['datdoc'] }}</div>
              <div class="col-orh-datspe">{{ order['datspe'] }}</div>
              <div class="col-orh-cdanag">{{ order['cdanag'] }}</div>
              <div class="col-orh-ragsoc">{{ order['ragsoc'] }}</div>
              <div class="col-orh-qtaord">{{ order['qtaord'] }}</div>
              <div class="col-orh-qtafat">{{ order['qtafat'] }}</div>
              <div class="col-orh-qtadaf">{{ order['qtadaf'] }}</div>
              <div class="col-orh-qtaspe">{{ order['qtaspe'] }}</div>
              <div class="col-orh-qtadas">{{ order['qtadas'] }}</div>
              <div class="col-orh-impord">{{ order['impord']|currency }}</div>
              <div class="col-orh-impfat">{{ order['impfat']|currency }}</div>
              <div class="col-orh-impdaf">{{ order['impdaf']|currency }}</div>
              <div class="col-orh-impspe">{{ order['impspe']|currency }}</div>
              <div class="col-orh-impdas">{{ order['impdas']|currency }}</div>
            </div>
          {% endfor %}
        </div>
      </div>
    {% endif %}

    {% if common['showTransDocHistory'] == 1 %}
      <div id="tab_tdh" role="tabpanel" class="tab-pane account-tab fade {% if active_tdh %}show active{% endif %}">
        {% if error == 'e' %}
          <div class="unsuccess-box mb-10x">
            <div>{{ mt._('_common.regqtm.fileerror')}}</div>
          </div>
        {% endif %}
        <div class='row account-section pb-20x w-100'>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.filter') }}</div>
            <div class='account-field form-element'><input type='text' class='form-control' id='transdoc-history-filter' name='transdoc-history-filter' /></div>
          </div>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.date') }}</div>
            <div class='account-field row'>
              <div class="col-6 px-0">
                <input type="text" class="form-control" id="date-flt-tdh" value="" style="border-radius: 4px 0 0 4px; font-size: 14px;">
              </div>
              <div class="col-2 history-calendar"><i class="glyphicon glyphicon-calendar fa fa-calendar" style="margin-top:18%;" ></i></div>
            </div>
          </div>
          <div class='col-3'>
            <div class='account-field row mt-4'>
              <div class="col-6 px-0">
                <input type="checkbox" class="form-check-input" id="daf-flt-tdh" onclick="filterOrdersHistoryChecks()">
                <label class="account-title text-capitalize mx-2" for="daf-flt-tdh">{{ mt._('_common.invoiced.tb.only') }}</label>
              </div>
            </div>
          </div>
        </div>
        <div class="row header-history header-acc-tdh w-max">
          <div class="col-tdh-numdoc"><div class='d-none d-lg-block float-left pr-5x'>{{ mt._('_common.transdoc') }} </div> #</div>
          <div class="col-tdh-cdanag">{{ mt._('admin.customers.customercode') }}</div>
          <div class="col-tdh-ragsoc">{{ mt._('admin.customers.name') }}</div>
          <div class="col-tdh-datdoc">{{ mt._('_common.date') }}</div>
          <div class="col-tdh-datspe">{{ mt._('account.customer.shipment') }}</div>
          <div class="col-tdh-qtafat">{{ mt._('_common.qty.inv') }}</div>
          <div class="col-tdh-qtadaf">{{ mt._('_common.qty.inv.tb') }}</div>
          <div class="col-tdh-qtaspe">{{ mt._('_common.qty.ship') }}</div>
          <div class="col-tdh-impfat">{{ mt._('_common.amount.inv') }}</div>
          <div class="col-tdh-impdaf">{{ mt._('_common.amount.inv.tb') }}</div>
          <div class="col-tdh-impspe">{{ mt._('_common.amount.ship') }}</div>
        </div>
        <div id="tdh-content" class="w-max" style="margin: 0">
          {% for transdoc in transDocHistory if (selectedCustomer == '' or (transdoc['tpanag'] == selectedCustomer['tpanag'] and transdoc['cdanag'] == selectedCustomer['cdanag'])) %}
            <div class="row transdoc-history-row"  data-numdoc="{{ transdoc['numdoc'] }}" data-filter=" {{ transdoc['numdoc'] }} {{ transdoc['cdanag'] }} {{ transdoc['ragsoc'] }}">
              <div class="col-tdh-numdoc">{{ transdoc['numdoc'] }}</div>
              <div class="col-tdh-cdanag">{{ transdoc['cdanag'] }}</div>
              <div class="col-tdh-ragsoc">{{ transdoc['ragsoc'] }}</div>
              <div class="col-tdh-datdoc">{{ transdoc['datdoc'] }}</div>
              <div class="col-tdh-datspe">{{ transdoc['datspe'] }}</div>
              <div class="col-tdh-qtafat">{{ transdoc['qtafat'] }}</div>
              <div class="col-tdh-qtadaf">{{ transdoc['qtadaf'] }}</div>
              <div class="col-tdh-qtaspe">{{ transdoc['qtaspe'] }}</div>
{#              <div class="col-tdh-qtadas">{{ transdoc['qtadas'] }}</div>#}
              <div class="col-tdh-impfat">{{ transdoc['impfat']|currency }}</div>
              <div class="col-tdh-impdaf">{{ transdoc['impdaf']|currency }}</div>
              <div class="col-tdh-impspe">{{ transdoc['impspe']|currency }}</div>
{#              <div class="col-tdh-impdas">{{ transdoc['impdas']|currency }}</div>#}
            </div>
          {% endfor %}
        </div>
      </div>
    {% endif %}

    {% if common['showInvoicesHistory'] == 1 %}
      <div id="tab_inh" role="tabpanel" class="tab-pane account-tab fade {% if active_inh %}show active{% endif %}">
        {% if error == 'e' %}
          <div class="unsuccess-box mb-10x">
            <div>{{ mt._('_common.regqtm.fileerror')}}</div>
          </div>
        {% endif %}
        <div class='row account-section pb-20x w-100'>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.filter') }}</div>
            <div class='account-field form-element'><input type='text' class='form-control' id='invoices-history-filter' name='invoices-history-filter' /></div>
          </div>
          <div class='col-3'>
            <div class='account-title text-capitalize'>{{ mt._('_common.date') }}</div>
            <div class='account-field row'>
              <div class="col-6 px-0">
                <input type="text" class="form-control" id="date-flt-inh" value="" style="border-radius: 4px 0 0 4px; font-size: 14px;">
              </div>
              <div class="col-2 history-calendar"><i class="glyphicon glyphicon-calendar fa fa-calendar" style="margin-top:18%;" ></i></div>
            </div>
          </div>
        </div>
        <div class="row header-history header-acc-inh"  style='width:95%'>
          <div class="col-inh-numdoc"><div class='d-none d-lg-block float-left pr-5x'>{{ mt._('_common.invoice') }} </div> #</div>
          <div class="col-inh-cdanag">{{ mt._('admin.customers.customercode') }}</div>
          <div class="col-inh-ragsoc">{{ mt._('admin.customers.name') }}</div>
          <div class="col-inh-datdoc">{{ mt._('_common.date') }}</div>
          <div class="col-inh-datspe">{{ mt._('account.customer.shipment') }}</div>
          <div class="col-inh-qtafat">{{ mt._('_common.qty') }}</div>
          <div class="col-inh-impfat">{{ mt._('_common.amount') }}</div>
        </div>
        <div id="inh-content" class="w-100" style="margin: 0">
          {% for invoice in invoicesHistory if (selectedCustomer == '' or (invoice['tpanag'] == selectedCustomer['tpanag'] and invoice['cdanag'] == selectedCustomer['cdanag'])) %}
            <div class="row invoice-history-row"  data-numdoc="{{ invoice['numdoc'] }}" data-filter=" {{ invoice['numdoc'] }} {{ invoice['cdanag'] }} {{ invoice['ragsoc'] }}{#   #}">
              <div class="col-inh-numdoc">{{ invoice['numdoc'] }}</div>
              <div class="col-inh-cdanag">{{ invoice['cdanag'] }}</div>
              <div class="col-inh-ragsoc">{{ invoice['ragsoc'] }}</div>
              <div class="col-inh-datdoc">{{ invoice['datdoc'] }}</div>
              <div class="col-inh-datspe">{{ invoice['datspe'] }}</div>
              <div class="col-inh-qtafat">{{ invoice['qtafat'] }}</div>
              <div class="col-inh-impfat">{{ invoice['impfat']|currency }}</div>
            </div>
          {% endfor %}
        </div>
      </div>
    {% endif %}

    {% if common['returnsmngmt'] == 1 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_exc %}show active{% endif %}" id="tab_exc">CAMBIO MERCI -- puoi farlo? {{ common['returnsmngmt'] }}</div>
    {% endif %}

    {% if common['showDeadlines'] == 1 %}
      <div role="tabpanel" class="tab-pane account-tab fade {% if active_tic %}show active{% endif %}" id="tab_tic">

      {% if common['deadlines']|length > 0 %}
        {% if session.get('auth')['type'] == 3 %}
          {% set numdoc = 0 %}
          {% set totdoc = 0 %}
          {% set scadra = 0 %}
          {% set scadut = 0 %}
          {% for gopart in common['deadlines'] %}
            {% set numdoc = numdoc + gopart['numdoc'] %}
            {% set totdoc = totdoc + gopart['totdoc'] %}
            {% set scadra = scadra + gopart['scadra'] %}
            {% set scadut = scadut + gopart['scadut'] %}
          {% endfor %}
        <div id="deadlines-list-container">
          <div class="row font-weight-bold m-0 pb-20x">
            <div class="col-tic-hdr"><span class="text-custom">{{ mt._('_common.total') }}:</span> {{ totdoc|currency }} {{ common['currency'] }}</div>
            <div class="col-tic-hdr"><span class="text-custom">{{ mt._('account.expiring') }}:</span> {{ scadra|currency }} {{ common['currency'] }}</div>
            <div class="col-tic-hdr"><span class="text-custom">{{ mt._('account.expired') }}:</span> <span class="text-danger">{{ scadut|currency }} {{ common['currency'] }}</span></div>
            <div class="col-tic-hdr"><span class="text-custom">{{ mt._('_common.document.num') }}:</span> {{ numdoc }}</div>
            <div class="col-tic-hdr"><span class="text-custom">{{ mt._('_common.customers') }}:</span> {{ common['deadlines']|length }}</div>
          </div>

          <div class='row account-section pb-20x'>
            <div class='col-6 col-lg-4'>
              <div class='account-title text-capitalize'>{{ mt._('_common.filter') }}</div>
              <div class='account-field form-element'><input type='text' class='form-control' id='deadline-filter' name='deadline-filter' /></div>
            </div>
          </div>

          <div class="row header-acc-tic">
            <div class="col-tic-cus">{{ mt._('_common.customer') }}</div>
            <div class="col-tic-num">{{ mt._('_common.document.num') }}</div>
            <div class="col-tic-tot">{{ mt._('_common.amount') }}</div>
            <div class="col-tic-top">{{ mt._('_common.topay') }}</div>
            <div class="col-tic-exp">{{ mt._('_common.expired') }}</div>
            <div class="col-tic-det"></div>
          </div>
          {% for gopart in common['deadlines'] %}
          <div class="row deadline-row {{ loop.last ? 'mb-50x' : '' }}" data-filter="{{ gopart['descri'] }}">
            <div class="col-tic-cus">{{ gopart['cdanag'] }} - {{ gopart['descri'] }}</div>
            <div class="col-tic-num">{{ gopart['numdoc'] }}</div>
            <div class="col-tic-tot">{{ gopart['totdoc']|currency }} {{ common['currency'] }}</div>
            <div class="col-tic-top">{{ gopart['scadra']|currency }} {{ common['currency'] }}</div>
            <div class="col-tic-exp">{{ gopart['scadut']|currency }} {{ common['currency'] }}</div>
            <div class="col-tic-det"><a href="#" class="detail-deadline" data-tpanag="{{ gopart['tpanag'] }}" data-cdanag="{{ gopart['cdanag'] }}" data-descri="{{ gopart['descri'] }}">{{ mt._('_common.detail') }}</a></div>
          </div>
          {% endfor %}
        </div>

        <div id="detail-deadline-container" style="display:none">
          <div class="row m-0 pb-20x">
            <div class="col-8 font-weight-bold">{{ mt._('_common.customer') }}<br/><span class="text-custom" id="detail-customer"></span></div>
            <div class="col-4 text-right"><a href="#" class="pointer" style="color:black" id="back-to-tickler">{{ mt._('account.backtotickler') }}</a></div>
          </div>

          <div class="row m-0 pb-20x">
            <div class="col-12 col-md-8 col-lg-9 font-weight-bold text-uppercase">
              <div>{{ mt._('account.openitems') }}</div>
              <div class="col-tic-hdr2"><span class="text-custom">{{ mt._('_common.total') }}:</span> <span id="detail-total"></span></div>
              <div class="col-tic-hdr2"><span class="text-custom">{{ mt._('account.expiring') }}:</span> <span id="detail-expiring"></span></div>
              <div class="col-tic-hdr2"><span class="text-custom">{{ mt._('account.expired') }}:</span> <span id="detail-expired" class="text-danger"></span></div>
              <div class="title-separator"></div>
            </div>
            <div class="d-none d-md-block col-md-4 col-lg-3 text-right">
              <a id="pdf-tickler" href="{{ url('pdf/tickler') }}" target="_blank" class="btn btn-generic mt-0">{{ mt._('account.pdftickler') }}</a>
            </div>
          </div>

          <div class="row header-acc-tic">
            <div class="col-det-dct">{{ mt._('_common.documenttype') }}</div>
            <div class="col-det-doc">{{ mt._('_common.document') }} #</div>
            <div class="col-det-dat">{{ mt._('_common.date') }}</div>
            <div class="col-det-not">{{ mt._('_common.notes') }}</div>
            <div class="col-det-pay">{{ mt._('_common.payment.cond') }}</div>
            <div class="col-det-amt">{{ mt._('_common.amount') }}</div>
            <div class="col-det-top">{{ mt._('_common.topay') }}</div>
            <div class="col-det-ddl">{{ mt._('_common.deadline') }}</div>
            <div class="col-det-exp">{{ mt._('_common.expired.by') }}</div>
          </div>

          <div id="detail-deadlines-list">
          </div>

        </div>

        {% else %}
          {% set toExpire = 0 %}
          {% set expired = 0 %}
          {% for gopart in common['deadlines'] %}
            {% if gopart.expired > 0 %}
              {% set expired = expired + gopart.impsca %}
            {% else %}
              {% set toExpire = toExpire + gopart.impsca %}
            {% endif %}
          {% endfor %}
        <div class="row m-0">

          <div class="col-9 font-weight-bold text-uppercase">
            <div>{{ mt._('account.openitems') }}</div>
            <div class="float-left mr-50x"><span class="text-custom">{{ mt._('_common.total') }}:</span> {{ (expired + toExpire)|currency }} {{ common['deadlines'][0].valuta }}</div>
            <div class="float-left mr-50x"><span class="text-custom">{{ mt._('account.expiring') }}:</span> {{ toExpire|currency }} {{ common['deadlines'][0].valuta }}</div>
            <div class="float-left mr-50x"><span class="text-custom">{{ mt._('account.expired') }}:</span> <span class="text-danger">{{ expired|currency }} {{ common['deadlines'][0].valuta }}</span></div>
            <div class="title-separator"></div>
          </div>
          <div class="col-3 text-right">
            <a href="{{ url('pdf/tickler') }}" target="_blank" class="btn btn-generic mt-0">{{ mt._('account.pdftickler') }}</a>
          </div>
        </div>

        <div class="row header-acc-tic">
          <div class="col-det-dct">{{ mt._('_common.documenttype') }}</div>
          <div class="col-det-dot">{{ mt._('_common.document') }} #</div>
          <div class="col-det-dat">{{ mt._('_common.date') }}</div>
          <div class="col-det-not">{{ mt._('_common.notes') }}</div>
          <div class="col-det-pay">{{ mt._('_common.payment.cond') }}</div>
          <div class="col-det-amt">{{ mt._('_common.amount') }}</div>
          <div class="col-det-top">{{ mt._('_common.topay') }}</div>
          <div class="col-det-ddl">{{ mt._('_common.deadline') }}</div>
          <div class="col-det-exp">{{ mt._('_common.expired.by') }}</div>
        </div>
          {% set prev_gopart = '' %}
          {% for gopart in common['deadlines'] %}
        <div class="row detail-row"
          style="{% if loop.index != 1 and gopart.numdoc != prev_gopart.numdoc %}border-top:1px #eee solid;{% endif %}
          {% if loop.last %}border-bottom:1px #eee solid;margin-bottom:50px{% endif %}">
          <div class="col-det-dct">{{ loop.index == 1 or gopart.numdoc != prev_gopart.numdoc ? gopart.tipdoc : '&nbsp;' }}</div>
          <div class="col-det-dot">
            {% if loop.index == 1 or gopart.numdoc != prev_gopart.numdoc %}
            <span class="my-tooltip" data-toggle="tooltip"
              title="{% if session.get('language') == 'it' %}{{ gopart.des_it }}
              {% elseif session.get('language') == 'en' %}{{ gopart.des_en }}
              {% elseif session.get('language') == 'fr' %}{{ gopart.des_fr }}
              {% elseif session.get('language') == 'es' %}{{ gopart.des_es }}{% elseif session.get('language') == 'de' %}{{ gopart.des_de }}{% endif %}">
              {{ gopart.numdoc }}</span>
            {% else %}
            &nbsp;
            {% endif %}
          </div>
          <div class="col-det-dat">{{ loop.index == 1 or gopart.numdoc != prev_gopart.numdoc ? gopart.datdoc : '&nbsp;' }}</div>
          <div class="col-det-not">
            {% if gopart.notpar != '' and gopart.notpar != ' ' %}
            <span class="my-tooltip" data-toggle="tooltip" title="{{ gopart.notpar }}">{{ mt._('_common.see') }}</span>
            {% else %}
            &nbsp;
            {% endif %}
          </div>
          <div class="col-det-pay">{{ loop.index == 1 or gopart.numdoc != prev_gopart.numdoc ? gopart.despag : '&nbsp;' }}</div>
          <div class="col-det-amt">{{ loop.index == 1 or gopart.numdoc != prev_gopart.numdoc ? gopart.impdoc|currency ~ ' ' ~ gopart.valuta : '&nbsp;' }}</div>
          <div class="col-det-top {{ gopart.expired > 0 ? 'text-danger' : '' }}">{{ gopart.impsca|currency }} {{ gopart.valuta }}</div>
          <div class="col-det-ddl">{ gopart.datsca }}</div>
          <div class="col-det-exp text-danger">{{ gopart.expired > 0 ? gopart.expired ~ ' ' ~ mt._('_common.days') : '&nbsp;' }}</div>
        </div>
            {% set prev_gopart = gopart %}
          {% endfor %}
        {% endif %}
      {% endif %}
      </div>
    {% endif %}
    </div><!-- .tab-content -->
  {% endif %}
  </div>
</div>

<!-- Modal for send order -->
<div class="modal fade modal-send-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-send" name="order-to-send" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.sendorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">
          {{ mt._('_common.sendorder.warning1') }} <span id="order-to-send-txt"></span>.<br/>{{ mt._('_common.sendorder.warning2') }}
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="confirm-send-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Modal for modify order -->
<div class="modal fade modal-modify-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-modify" name="order-to-modify" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.modifyorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">
          {{ mt._('_common.modifyorder.warning1') }} <span id="order-to-modify-txt"></span>.<br/>{{ mt._('_common.modifyorder.warning2') }}
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="confirm-modify-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Modal for cancel order -->
<div class="modal fade modal-cancel-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="order-to-delete" name="order-to-delete" value="">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.cancelorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">
          {{ mt._('_common.cancelorder.warning1') }} <span id="order-to-delete-txt"></span>.<br/>{{ mt._('_common.cancelorder.warning2') }}
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="confirm-cancel-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
