<?php

namespace Go2B\Tasks;

use Go2B\Controllers\Utility;
use Go2B\Models\Anagra;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bUsrana;
use Go2B\Models\Cttest;
use Go2B\Models\Imgart;
use Phalcon\CLI\Task;
use Phalcon\Config;
use Phalcon\Db;

/**
 * @property-read Config $config
 * @property-read Utility $utility
 */
class ToolsTask extends Task
{

    /**
     * Azione da eseguire quando si vuole riparare i duplicati con spazi
     * da trimmare nei codici cliente all'interno dell'anagrafica utenti
     *
     * @return void
     */
    public function repairCustomerWithSpaceInCodeAction($params)
    {
        $limit = intval(!empty($params[0]) ? $params[0] : 100);

        /*
         * Query ricerca duplicati
         * SELECT * FROM `anagra` WHERE `cdanag` LIKE '% %' OR CONCAT(tpanag, TRIM(cdanag)) IN (
         *   SELECT CONCAT(tpanag, TRIM(cdanag)) FROM `anagra` GROUP BY CONCAT(tpanag, TRIM(cdanag)) HAVING COUNT(*) > 1
         * ) ORDER BY tpanag, TRIM(cdanag);
         */

        $isDev = $this->config->environment->isDev ?: 0;
        $withSpaces = $this->db->query('SELECT `anagra`.*, `b2b_sysusr`.* FROM `anagra`
              LEFT JOIN `b2b_usrana`
                       ON `anagra`.`tpanag` = `b2b_usrana`.`tpanag` AND `anagra`.`cdanag` = `b2b_usrana`.`cdanag`
              LEFT JOIN `b2b_sysusr` ON `b2b_usrana`.`id_usr` = `b2b_sysusr`.`id`
            WHERE `anagra`.`cdanag`!=TRIM(`anagra`.`cdanag`)')->fetchAll(Db::FETCH_ASSOC);
        echo 'Trovati n.' . count($withSpaces) . ' elementi con uno spazio all\'interno del codice anagrafica.' . PHP_EOL;

        $uncommitted = [];
        // Cicliamo tutti gli elementi presenti per rimuovere gli spazi
        foreach ($withSpaces as $idx => $item) {
            // TRANSACTION - start
            $this->db->begin();

            try {
                $newAnagra = Anagra::findFirstByPrimaryKey($item['tpanag'], trim($item['cdanag']));

                if ($isDev) {
                    echo 'Elemento n.' . ($idx + 1) . ': "' . $item['cdanag'] . '" ';
                }

                $anagraParams = [
                    'trimmed_cdanag' => trim($item['cdanag']),
                    'tpanag' => $item['tpanag'],
                    'cdanag' => $item['cdanag'],
                ];

                if ($newAnagra && $item['cdanag'] !== $newAnagra->cdanag) { // Dobbiamo sostituire gli id utente dei duplicati
                    if ($isDev) {
                        echo ' DUPLICATO ';
                    }
                    $userAssoc = B2bUsrana::findFirst([
                        'tpanag = :tpanag: AND cdanag = :cdanag:',
                        'bind' => [
                            'tpanag' => $item['tpanag'],
                            'cdanag' => $item['cdanag'],
                        ]
                    ]);
                    $newUserAssoc = B2bUsrana::findFirst([
                        'tpanag = :tpanag: AND cdanag = :cdanag:',
                        'bind' => [
                            'tpanag' => $newAnagra->tpanag,
                            'cdanag' => $newAnagra->cdanag,
                        ]
                    ]);

                    if ($userAssoc && $newUserAssoc && $userAssoc->id_usr !== $newUserAssoc->id_usr) {
                        if ($isDev) {
                            echo ' - id_usr effettivamente diversi ';
                        }
                        // Se gli id sono effettivamente diversi procediamo alla sostituzione
                        $userParams = [
                            'new_id_usr' => $newUserAssoc->id_usr,
                            'id_usr' => $userAssoc->id_usr,
                        ];

                        // Sostituiamo sull'associazione ai cataloghi
                        $this->db->execute("DELETE b2b_usrctl FROM b2b_usrctl INNER JOIN b2b_usrctl as test ON test.cdcata = b2b_usrctl.cdcata and test.id_usr = :new_id_usr WHERE b2b_usrctl.id_usr = :id_usr; UPDATE b2b_usrctl SET id_usr = :new_id_usr WHERE id_usr = :id_usr;", $userParams);

                        // Sostituiamo sull'associazione agli agenti
                        $this->db->execute("DELETE b2b_usrage FROM b2b_usrage INNER JOIN b2b_usrage as test ON test.cdagen = b2b_usrage.cdagen and test.id_usr = :new_id_usr WHERE b2b_usrage.id_usr = :id_usr; UPDATE b2b_usrage SET id_usr = :new_id_usr WHERE id_usr = :id_usr;", $userParams);

                        // Sostituiamo sull'associazione delle destinazioni merci
                        $this->db->execute("DELETE b2b_usrdsm FROM b2b_usrdsm INNER JOIN b2b_usrdsm as test ON test.cddesm = b2b_usrdsm.cddesm and test.id_usr = :new_id_usr WHERE b2b_usrdsm.id_usr = :id_usr; UPDATE b2b_usrdsm SET id_usr = :new_id_usr WHERE id_usr = :id_usr;", $userParams);

                        // Sostituiamo sull'associazione dei coupon
                        $this->db->execute("DELETE b2b_usrcpn FROM b2b_usrcpn INNER JOIN b2b_usrcpn as test ON test.cdcoup = b2b_usrcpn.cdcoup and test.id_usr = :new_id_usr WHERE b2b_usrcpn.id_usr = :id_usr; UPDATE b2b_usrcpn SET id_usr = :new_id_usr WHERE id_usr = :id_usr;", $userParams);

                        // Sostituiamo negli ordini effettuati direttamente dall'utente
                        $this->db->execute("UPDATE octest SET id_usr = :new_id_usr WHERE id_usr = :id_usr", $userParams);

                        // Eliminiamo l'utente duplicato
                        $this->db->execute("DELETE FROM b2b_sysusr WHERE id = :id_usr", ['id_usr' => $userAssoc->id_usr]);
                    } else if ($userAssoc) {
                        if ($isDev) {
                            echo ' - id_usr coincidenti ';
                        }
                        // Se due codici associati allo stesso id utente
                        // nessuna operazione da fare per allineare gli utenti
                        // basta buttare quello errato
                        $this->db->execute("DELETE FROM b2b_usrana WHERE id_usr = :id_usr", ['id_usr' => $userAssoc->id_usr]);
                    }

                    // Sostituiamo il codice anagrafico del destinatario negli ordini
                    $this->db->execute("UPDATE octest SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);

                    // Sostituiamo il codice anagrafico del destinatario nelle destinazioni merci
                    $this->db->execute("UPDATE desmer SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);


                    unset($anagraParams['trimmed_cdanag']);
                    // Eliminiamo il duplicato nella relazione con l'anagrafica
                    $this->db->execute("DELETE FROM b2b_usrana WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);

                    // Eliminiamo il duplicato nell'anagrafica
                    $this->db->execute("DELETE FROM anagra WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);

                    if ($isDev) {
                        echo ' | CORRETTO ';
                    }
                } else if ($item['cdanag'] !== trim($item['cdanag'])) { // Dobbiamo solo aggiustare il codice
                    if ($isDev) {
                        echo ' ERRATO ';
                    }
                    // Sostituiamo il codice anagrafico del destinatario negli ordini
                    $this->db->execute("UPDATE octest SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);
                    // Sostituiamo il codice anagrafico del destinatario nelle destinazioni merci
                    $this->db->execute("UPDATE desmer SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);
                    // Sostituiamo il codice anagrafico nella relazione con l'utente
                    $this->db->execute("UPDATE b2b_usrana SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);
                    // Sostituiamo il codice anagrafico
                    $this->db->execute("UPDATE anagra SET cdanag = :trimmed_cdanag WHERE tpanag = :tpanag AND cdanag = :cdanag", $anagraParams);
                    if ($isDev) {
                        echo ' | CORRETTO ';
                    }
                } else {
                    echo 'Non so cosa fare!!!';
                    $uncommitted["{$item['tpanag']}{$item['cdanag']}"] = [$item['tpanag'], $item['cdanag']];
                }
                if ($isDev) {
                    echo PHP_EOL;
                }

                if ($idx > 0 && $idx % 100 == 0 ) {
                    echo 'Elaborati n.' . $idx . ' elementi.' . PHP_EOL;
                }

                // TRANSACTION - end
                $this->db->commit();
            } catch (\Exception $exception) {
                // TRANSACTION - end
                $this->db->rollback();
                if ($isDev) {
                    echo (PHP_EOL . $exception->getMessage() . PHP_EOL);
                    echo ($exception->getTraceAsString());
                }
                $uncommitted["{$item['tpanag']}{$item['cdanag']}"] = [$item['tpanag'], $item['cdanag']];
            }

            if ($idx >= $limit - 1) {
                if ($isDev) {
                    echo ' Limite "' . $limit . '" raggiunto ' . PHP_EOL;
                }
                break;
            }
        }

        echo 'Elaborazione completata';
        if (empty($uncommitted)) {
            echo ' senza errori.' . PHP_EOL;
        } else {
            echo '. NB Sono stati riscontrati ' . count($uncommitted) . ' errori nel processo' . PHP_EOL;
            var_dump($uncommitted);
        }
    }

    public function updatesettingsAction()
    {
        echo "\n*** UPDATE SETTINGS starting ... ***\n\n";

        $to_time = strtotime(date("Y-m-d H:i:s"));

        echo "START " . date("Y-m-d H:i:s") . "\n";

        set_time_limit(0);

        $utility = new Utility();
        $utility->updateSettings();

        set_time_limit(30);

        $from_time = strtotime(date("Y-m-d H:i:s"));
        echo "END " . date("Y-m-d H:i:s") . "\n";

        echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute\n";
    }

    public function newCustomersEmailAction($params)
    {
        echo "\n*** NEW CUSTOMERS EMAIL starting ... ***\n\n";

        $to_time = strtotime(date("Y-m-d H:i:s"));

        echo "START " . date("Y-m-d H:i:s") . "\n";

        $language = count($params) > 0 && in_array($params[0], ['it', 'en', 'de', 'fr', 'es']) ? $params[0] : 'it';

        set_time_limit(0);

        $utility = new Utility();
        $utility->sendNewCustomersEmail($language);

        set_time_limit(30);

        $from_time = strtotime(date("Y-m-d H:i:s"));
        echo "END " . date("Y-m-d H:i:s") . "\n";

        echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute\n";
    }

    public function customVariantsEmailAction($params)
    {
        echo "\n*** CUSTOM VARIANTS EMAIL starting ... ***\n\n";

        $to_time = strtotime(date("Y-m-d H:i:s"));

        echo "START " . date("Y-m-d H:i:s") . "\n";

        $language = count($params) > 0 && in_array($params[0], ['it', 'en', 'de', 'fr', 'es']) ? $params[0] : 'it';

        set_time_limit(0);

        $utility = new Utility();
        $utility->getCustomVariantsCsv(true, $language);

        set_time_limit(30);

        $from_time = strtotime(date("Y-m-d H:i:s"));
        echo "END " . date("Y-m-d H:i:s") . "\n";

        echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute\n";
    }

    public function manageImagesAction()
    {
        echo "\n*** MANAGE IMAGES starting ... ***\n\n";

        $to_time = strtotime(date("Y-m-d H:i:s"));

        echo "START " . date("Y-m-d H:i:s") . "\n";

        set_time_limit(0);
        ini_set('max_execution_time', 0);

        $utility = new Utility();
        $syncType = $utility->getAppSettings('SyncType');

        if ($syncType == 2) {
            Imgart::emptyTable();
        }

        $catalogs = Cttest::find();

        $controller = new GomanagementController();
        foreach ($catalogs as $el) {
            $controller->assignImagesSpecial($el->cdcata, $syncType, true);
        }

        ini_set('max_execution_time', 300);
        set_time_limit(30);

        $from_time = strtotime(date("Y-m-d H:i:s"));
        echo "END " . date("Y-m-d H:i:s") . "\n";

        echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute\n";
    }
}
