<?php

namespace Go2B\Tasks\Sync;

use Phalcon\DI as Di;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ExcelSync
{
  const IMPORT_FOLDER = '../public/io/import';
  const IMAGES_FOLDER = '../public/img';
  const MAX_LINES = 15000;

  const XLS_NAMES = array(
    'LST' => 'B2GoListini',
    'CUS' => 'B2GoClienti',
    'ART' => 'Articoli_Go2B'
  );

  const LSTEST_COUNT = 6;
  const LSCORP_COUNT = 6;
  const LST_NULIST = 'A';
  const LST_DSLIST = 'B';
  const LST_CDVALU = 'C';
  const LST_CDARTI = 'D';
  const LST_PREZZO = 'E';
  const LST_PREVEN = 'F';

  const ANAGRA_COUNT = 55;
  const ANANAZ_COUNT = 3;
  const ANAVET_COUNT = 3;
  const TPPAGA_COUNT = 8;
  const TPPORT_COUNT = 4;
  const CUS_CDANAG = 'A';
  const CUS_CDDESM = 'B';
  const CUS_DESCRI = 'C';
  const CUS_DESVID = 'C';
  const CUS_INDIRI = 'D';
  const CUS_CODCAP = 'E';
  const CUS_CCITTA = 'F';
  const CUS_PROVIN = 'G';
  const CUS_CDNAZI = 'H';
  const CUS_DSNAZI = 'I';
  const CUS_PARIVA = 'J';
  const CUS_CODFIS = 'K';
  const CUS_NUMTEL = 'L';
  const CUS_INDEMA = 'M';
  const CUS_INDPEC = 'N';
  const CUS_WEBSIT = 'O';
  const CUS_NULIST = 'Q';
  const CUS_CDVALU = 'S';
  const CUS_SCONT1 = 'T';
  const CUS_SCONT2 = 'U';
  const CUS_SCONT3 = 'V';
  const CUS_TPPORT = 'W';
  const CUS_DSTPOR = 'X';
  const CUS_TPPAGA = 'Y';
  const CUS_DSPAGA = 'Z';
  const CUS_CDIBAN = 'AA';
  const CUS_CDVETT = 'AB';
  const CUS_DSVETT = 'AC';
  const CUS_CDAGEN = 'AD';
  const CUS_CODUPR = 'AE';

  const ANAART_COUNT = 10;
  const ANAPER_COUNT = 4;
  const ANATGL_COUNT = 3;
  const B2B_MODINF_COUNT = 11;
  const DESART_COUNT = 5;
  const DESLIN_COUNT = 5;
  const LINMOD_COUNT = 5;
  const SERMOD_COUNT = 5;
  const TABSTG_COUNT = 3;
  const TIPOLO_COUNT = 17;
  const TITLIN_COUNT = 4;
  const TPGENE_COUNT = 3;
  const TPMODE_COUNT = 3;
  const ART_CDARTI = 'A';
  const ART_CDARTN = 'B';
  const ART_DSARTI = 'C';
  const ART_DESLIN_DESCRI = 'D';
  const ART_CDSTAG = 'E';
  const ART_DSSTAG = 'F';
  const ART_CDTITL = 'G';
  const ART_DSTITL = 'H';
  const ART_CDLINM = 'I';
  const ART_DSLINM = 'J';
  const ART_CDSERM = 'K';
  const ART_DSSERM = 'L';
  const ART_TPGENE = 'M';
  const ART_DSGENE = 'N';
  const ART_TPMODE = 'O';
  const ART_DSTMOD = 'P';
  const ART_UMMAGA = 'Q';
  const ART_CDTAGL = 'R';
  const ART_CDPERS = 'U';
  const ART_DSPERS = 'V';
  const ART_COMPOS = 'W';
  const ART_CDCOLO = 'X';
  const ART_DSCOLO = 'Y';
  const ART_VESTIB = 'Z';
  const ART_DESART_COMM_IT = 'AA';
  const ART_DESART_COMM_EN = 'AB';
  const ART_DESART_TECN_IT = 'AC';
  const ART_DESART_TECN_EN = 'AD';

  public static function sync($echo) {
    foreach (self::XLS_NAMES as $key => $filename) {
      // Get sync file
      $file = self::getSyncFile($filename);

      echo $file . "\n";

      // Check if temp folder exists
      $targetPath = self::IMPORT_FOLDER . '/temp';
      if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)){
        die("Error creating folder $targetPath");
      }

      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($file);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($file);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($file);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        switch ($key) {
          case 'LST':
            self::syncPriceLists($sheetData, $targetPath);
            break;
          case 'CUS':
            self::syncCustomers($sheetData, $targetPath);
            break;
          case 'ART':
            self::syncProducts($sheetData, $targetPath);
            break;
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }
  }

  private static function getSyncFile($table) {
    $files = glob(self::IMPORT_FOLDER . '/*' . $table . '*.xls*');

    if (count($files) > 0) {
      return $files[0];
    }

    return '';
  }

  private static function createTempFile($targetPath, $table) {
    $file = $targetPath . '/' . $table . '.csv';
    file_put_contents($file, "");
    chmod($file, 0777);
    return $file;
  }

  private static function getClassPropertyCount($class) {
    $class = '\Go2B\Models\\' . ucfirst($class);
    return count(get_object_vars(new $class));
  }

  private static function loadFile($table, $file) {
    $path = str_replace('\\', '/', realpath($file));
    $query =
      'LOAD DATA LOCAL INFILE "' . $path . '"
      IGNORE INTO TABLE ' . $table . '
      FIELDS TERMINATED BY ","
      ENCLOSED BY \'"\'
      LINES TERMINATED BY "\n" ';
    $result = Di::getDefault()->get('db')->query($query);
    //print_r($result);
  }

  private static function syncPriceLists($sheetData, $targetPath) {
    $lstestFile = self::createTempFile($targetPath, 'lstest');
    $lscorpFile = self::createTempFile($targetPath, 'lscorp');
    $lstestFieldCount = self::getClassPropertyCount('Lstest');
    $lscorpFieldCount = self::getClassPropertyCount('Lscorp');

    // Skip first row
    $counter = 0;
    for ($i = 1; $i < count($sheetData); $i++) {
      $currRow = $sheetData[$i + 1];

      $nulist = $currRow[self::LST_NULIST];
      $dslist = $currRow[self::LST_DSLIST];
      $cdvalu = $currRow[self::LST_CDVALU];
      $cdarti = $currRow[self::LST_CDARTI];
      $prezzo = $currRow[self::LST_PREZZO];
      $preven = $currRow[self::LST_PREVEN];

      if ($nulist != '' && $cdarti != '') {
        // Get lstest with empty fields for unknown new fields
        $lstestRow = '"' . $nulist . '","' . $dslist . '",0,"' . $cdvalu . '","0000-00-00","0000-00-00"';
        for ($j = self::LSTEST_COUNT; $j < $lstestFieldCount; $j++) {
          $lstestRow .= ',""';
        }

        // Get lscorp with empty fields for unknown new fields
        $lscorpRow = '"' . $nulist . '","' . $cdarti . '","","' . $cdvalu . '","' . $prezzo . '","' . $preven . '"';
        for ($j = self::LSCORP_COUNT; $j < $lscorpFieldCount; $j++) {
          $lscorpRow .= ',""';
        }

        file_put_contents($lstestFile, file_get_contents($lstestFile) . $lstestRow . "\n");
        file_put_contents($lscorpFile, file_get_contents($lscorpFile) . $lscorpRow . "\n");

        if ($counter < self::MAX_LINES) {
          $counter++;
        } else {
          self::loadFile('lstest', $lstestFile);
          self::loadFile('lscorp', $lscorpFile);
          $counter = 0;
        }
      }
    }

    if ($counter != 0) {
      // There are some remaining rows
      self::loadFile('lstest', $lstestFile);
      self::loadFile('lscorp', $lscorpFile);
    }

    // Update currencies on rows
    $query = 'UPDATE lscorp lc
      INNER JOIN lstest lt ON lt.nulist = lc.nulist
      SET lc.cdvalu = lt.cdvalu';
    Di::getDefault()->get('db')->query($query);

    unlink($lstestFile);
    unlink($lscorpFile);
  }

  private static function syncCustomers($sheetData, $targetPath) {
    $anagraFile = self::createTempFile($targetPath, 'anagra');
    $ananazFile = self::createTempFile($targetPath, 'ananaz');
    $anavetFile = self::createTempFile($targetPath, 'anavet');
    $tppagaFile = self::createTempFile($targetPath, 'tppaga');
    $tpportFile = self::createTempFile($targetPath, 'tpport');
    $anagraFieldCount = self::getClassPropertyCount('Anagra');
    $ananazFieldCount = self::getClassPropertyCount('Ananaz');
    $anavetFieldCount = self::getClassPropertyCount('Anavet');
    $tppagaFieldCount = self::getClassPropertyCount('Tppaga');
    $tpportFieldCount = self::getClassPropertyCount('Tpport');

    // Skip first row
    $counter = 0;
    for ($i = 1; $i < count($sheetData); $i++) {
      $currRow = $sheetData[$i + 1];

      $cdanag = $currRow[self::CUS_CDANAG];
      $cddesm = $currRow[self::CUS_CDDESM];
      $descri = $currRow[self::CUS_DESCRI];
      $desvid = $currRow[self::CUS_DESVID];
      $indiri = $currRow[self::CUS_INDIRI];
      $codcap = $currRow[self::CUS_CODCAP];
      $ccitta = $currRow[self::CUS_CCITTA];
      $provin = $currRow[self::CUS_PROVIN];
      $cdnazi = $currRow[self::CUS_CDNAZI];
      $dsnazi = $currRow[self::CUS_DSNAZI];
      $pariva = $currRow[self::CUS_PARIVA];
      $codfis = $currRow[self::CUS_CODFIS];
      $numtel = $currRow[self::CUS_NUMTEL];
      $indema = $currRow[self::CUS_INDEMA];
      $indpec = $currRow[self::CUS_INDPEC];
      $websit = $currRow[self::CUS_WEBSIT];
      $nulist = $currRow[self::CUS_NULIST];
      $cdvalu = $currRow[self::CUS_CDVALU];
      $scont1 = $currRow[self::CUS_SCONT1];
      $scont2 = $currRow[self::CUS_SCONT2];
      $scont3 = $currRow[self::CUS_SCONT3];
      $tpport = $currRow[self::CUS_TPPORT];
      $dstpor = $currRow[self::CUS_DSTPOR];
      $tppaga = $currRow[self::CUS_TPPAGA];
      $dspaga = $currRow[self::CUS_DSPAGA];
      $cdiban = $currRow[self::CUS_CDIBAN];
      $cdvett = $currRow[self::CUS_CDVETT];
      $dsvett = $currRow[self::CUS_DSVETT];
      $cdagen = $currRow[self::CUS_CDAGEN];
      $codupr = $currRow[self::CUS_CODUPR];

      if ($cdanag != '') {
        // Get anagra with empty fields for unknown new fields
        $anagraRow = '"CN","' . $cdanag . '","' . $descri . '","' . $desvid  .
          '","' . $indiri . '","' . $codcap . '","' . $ccitta . '","' .
          $provin . '","' . $cdnazi . '","","","' . $pariva . '","' . $codfis .
          '","' . $numtel . '","","","","' . $indema . '","","","' . $cdvalu .
          '","","' . $nulist . '","","","' . $scont1 . '","' . $scont2 . '","' .
          $scont3 . '","' . $tpport . '","' . $tppaga . '","","0","0","' .
          $cdiban . '","' . $cdvett . '","' . $cdagen . '","0","0000-00-00","0","' .
          $cddesm . '","0000-00-00","0","","","0","0","","0","0","0","0","' .
          $indpec . '","","' . $codupr . '","' . $websit . '"';
        for ($j = self::ANAGRA_COUNT; $j < $anagraFieldCount; $j++) {
          $anagraRow .= ',""';
        }
        file_put_contents($anagraFile, file_get_contents($anagraFile) . $anagraRow . "\n");

        if ($cdnazi != '') {
          // Get ananaz with empty fields for unknown new fields
          $ananazRow = '"' . $cdnazi . '","' . $dsnazi . '","0"';
          for ($j = self::ANANAZ_COUNT; $j < $ananazFieldCount; $j++) {
            $ananazRow .= ',""';
          }
          file_put_contents($ananazFile, file_get_contents($ananazFile) . $ananazRow . "\n");
        }

        if ($cdvett != '') {
          // Get anavet with empty fields for unknown new fields
          $anavetRow = '"' . $cdvett . '","' . $dsvett . '","0"';
          for ($j = self::ANAVET_COUNT; $j < $anavetFieldCount; $j++) {
            $anavetRow .= ',""';
          }
          file_put_contents($anavetFile, file_get_contents($anavetFile) . $anavetRow . "\n");
        }

        if ($tppaga != '') {
          // Get tppaga with empty fields for unknown new fields
          $tppagaRow = '"' . $tppaga . '","' . $dspaga . '","0","","0","0",""';
          for ($j = self::TPPAGA_COUNT; $j < $tppagaFieldCount; $j++) {
            $tppagaRow .= ',""';
          }
          file_put_contents($tppagaFile, file_get_contents($tppagaFile) . $tppagaRow . "\n");
        }

        if ($tpport != '') {
          // Get tpport with empty fields for unknown new fields
          $tpportRow = '"' . $tpport . '","' . $dstpor . '","0",""';
          for ($j = self::TPPORT_COUNT; $j < $tpportFieldCount; $j++) {
            $tpportRow .= ',""';
          }
          file_put_contents($tpportFile, file_get_contents($tpportFile) . $tpportRow . "\n");
        }

        if ($counter < self::MAX_LINES) {
          $counter++;
        } else {
          self::loadFile('anagra', $anagraFile);
          self::loadFile('ananaz', $ananazFile);
          self::loadFile('anavet', $anavetFile);
          self::loadFile('tppaga', $tppagaFile);
          self::loadFile('tpport', $tpportFile);
          $counter = 0;
        }
      }
    }

    if ($counter != 0) {
      // There are some remaining rows
      self::loadFile('anagra', $anagraFile);
      self::loadFile('ananaz', $ananazFile);
      self::loadFile('anavet', $anavetFile);
      self::loadFile('tppaga', $tppagaFile);
      self::loadFile('tpport', $tpportFile);
    }

    unlink($anagraFile);
    unlink($ananazFile);
    unlink($anavetFile);
    unlink($tppagaFile);
    unlink($tpportFile);
  }

  private static function syncProducts($sheetData, $targetPath) {
    $anaartFile = self::createTempFile($targetPath, 'anaart');
    $anaperFile = self::createTempFile($targetPath, 'anaper');
    $anatglFile = self::createTempFile($targetPath, 'anatgl');
    $b2bModinfFile = self::createTempFile($targetPath, 'b2b_modinf');
    $desartFile = self::createTempFile($targetPath, 'desart');
    $deslinFile = self::createTempFile($targetPath, 'deslin');
    $linmodFile = self::createTempFile($targetPath, 'linmod');
    $sermodFile = self::createTempFile($targetPath, 'sermod');
    $tabstgFile = self::createTempFile($targetPath, 'tabstg');
    $tipoloFile = self::createTempFile($targetPath, 'tipolo');
    $titlinFile = self::createTempFile($targetPath, 'titlin');
    $tpgeneFile = self::createTempFile($targetPath, 'tpgene');
    $tpmodeFile = self::createTempFile($targetPath, 'tpmode');
    $anaartFieldCount = self::getClassPropertyCount('Anaart');
    $anaperFieldCount = self::getClassPropertyCount('Anaper');
    $anatglFieldCount = self::getClassPropertyCount('Anatgl');
    $b2bModinfFieldCount = self::createTempFile($targetPath, 'B2bModinf');
    $desartFieldCount = self::getClassPropertyCount('Desart');
    $deslinFieldCount = self::getClassPropertyCount('Deslin');
    $linmodFieldCount = self::getClassPropertyCount('Linmod');
    $sermodFieldCount = self::getClassPropertyCount('Sermod');
    $tabstgFieldCount = self::getClassPropertyCount('Tabstg');
    $tipoloFieldCount = self::getClassPropertyCount('Tipolo');
    $titlinFieldCount = self::getClassPropertyCount('Titlin');
    $tpgeneFieldCount = self::getClassPropertyCount('Tpgene');
    $tpmodeFieldCount = self::getClassPropertyCount('Tpmode');

    // Skip first row
    $counter = 0;
    for ($i = 1; $i < count($sheetData); $i++) {
      $currRow = $sheetData[$i + 1];

      $cdarti = $currRow[self::ART_CDARTI];
      $cdartn = $currRow[self::ART_CDARTN];
      $dsarti = $currRow[self::ART_DSARTI];
      $deslinDescri = $currRow[self::ART_DESLIN_DESCRI];
      $cdstag = $currRow[self::ART_CDSTAG];
      $dsstag = $currRow[self::ART_DSSTAG];
      $cdtitl = $currRow[self::ART_CDTITL];
      $dstitl = $currRow[self::ART_DSTITL];
      $cdlinm = $currRow[self::ART_CDLINM];
      $dslinm = $currRow[self::ART_DSLINM];
      $cdserm = $currRow[self::ART_CDSERM];
      $dsserm = $currRow[self::ART_DSSERM];
      $tpgene = $currRow[self::ART_TPGENE];
      $dsgene = $currRow[self::ART_DSGENE];
      $tpmode = $currRow[self::ART_TPMODE];
      $dstmod = $currRow[self::ART_DSTMOD];
      $ummaga = $currRow[self::ART_UMMAGA];
      $cdtagl = $currRow[self::ART_CDTAGL];
      $cdpers = $currRow[self::ART_CDPERS];
      $dspers = $currRow[self::ART_DSPERS];
      $compos = $currRow[self::ART_COMPOS];
      $cdcolo = $currRow[self::ART_CDCOLO];
      $dscolo = $currRow[self::ART_DSCOLO];
      $vestib = $currRow[self::ART_VESTIB];
      $desartCommIt = $currRow[self::ART_DESART_COMM_IT];
      $desartCommEn = $currRow[self::ART_DESART_COMM_EN];
      $desartTecnIt = $currRow[self::ART_DESART_TECN_IT];
      $desartTecnEn = $currRow[self::ART_DESART_TECN_EN];

      if ($cdarti != '' && $cdartn != '') {
        // Get anaart with empty fields for unknown new fields
        $anaartRow = '"' . $cdarti . '","' . $dsarti . '","' . $cdartn  . '","' . $cdpers . '","0","' . $cdcolo . '","' . $dscolo . '","","",""';
        for ($j = self::ANAART_COUNT; $j < $anaartFieldCount; $j++) {
          $anaartRow .= ',""';
        }
        file_put_contents($anaartFile, file_get_contents($anaartFile) . $anaartRow . "\n");

        // Get tipolo with empty fields for unknown new fields
        $tipoloRow = '"' . $cdartn . '","' . $dsarti . '","' . $cdstag  . '","' .
          $cdlinm . '","' . $cdserm . '","' . $tpgene . '","' . $tpmode . '","' .
          $ummaga . '","' . $cdtagl . '","0","0","","0","0","","","0"';
        for ($j = self::TIPOLO_COUNT; $j < $tipoloFieldCount; $j++) {
          $tipoloRow .= ',""';
        }

        if ($cdtagl != '') {
          // Get anatgl with empty fields for unknown new fields
          $anatglRow = '"' . $cdtagl . '","' . $cdtagl . '","0"';
          for ($j = self::ANATGL_COUNT; $j < $anatglFieldCount; $j++) {
            $anatglRow .= ',""';
          }
          file_put_contents($anatglFile, file_get_contents($anatglFile) . $anatglRow . "\n");
        }

        if ($cdpers != '') {
          // Get anaper with empty fields for unknown new fields
          $anaperRow = '"' . $cdpers . '","' . $dspers . '","' . $compos . '","0"';
          for ($j = self::ANAPER_COUNT; $j < $anaperFieldCount; $j++) {
            $anaperRow .= ',""';
          }
          file_put_contents($anaperFile, file_get_contents($anaperFile) . $anaperRow . "\n");
        }

        if ($tpgene != '') {
          // Get tpgene with empty fields for unknown new fields
          $tpgeneRow = '"' . $tpgene . '","' . $dsgene . '","0"';
          for ($j = self::TPGENE_COUNT; $j < $tpgeneFieldCount; $j++) {
            $tpgeneRow .= ',""';
          }
          file_put_contents($tpgeneFile, file_get_contents($tpgeneFile) . $tpgeneRow . "\n");
        }

        if ($tpmode != '') {
          // Get tpmode with empty fields for unknown new fields
          $tpmodeRow = '"' . $tpmode . '","' . $dstmod . '","0"';
          for ($j = self::TPMODE_COUNT; $j < $tpmodeFieldCount; $j++) {
            $tpmodeRow .= ',""';
          }
          file_put_contents($tpmodeFile, file_get_contents($tpmodeFile) . $tpmodeRow . "\n");
        }

        if ($cdtitl != '') {
          // Get titlin with empty fields for unknown new fields
          $titlinRow = '"' . $cdtitl . '","' . $dstitl . '","0",""';
          for ($j = self::TITLIN_COUNT; $j < $titlinFieldCount; $j++) {
            $titlinRow .= ',""';
          }
          file_put_contents($titlinFile, file_get_contents($titlinFile) . $titlinRow . "\n");
        }

        if ($cdlinm != '') {
          // Get linmod with empty fields for unknown new fields
          $linmodRow = '"' . $cdlinm . '","' . $dslinm . '","' . $cdtitl . '","0",""';
          for ($j = self::LINMOD_COUNT; $j < $linmodFieldCount; $j++) {
            $linmodRow .= ',""';
          }
          file_put_contents($linmodFile, file_get_contents($linmodFile) . $linmodRow . "\n");

          if ($cdserm != '') {
            // Get sermod with empty fields for unknown new fields
            $sermodRow = '"' . $cdlinm . '","' . $cdserm . '","' . $dsserm . '","0",""';
            for ($j = self::SERMOD_COUNT; $j < $sermodFieldCount; $j++) {
              $sermodRow .= ',""';
            }
            file_put_contents($sermodFile, file_get_contents($sermodFile) . $sermodRow . "\n");
          }
        }

        if ($cdstag != '') {
          // Get tpport with empty fields for unknown new fields
          $tabstgRow = '"' . $cdstag . '","' . $dssatg . '","0"';
          for ($j = self::TABSTG_COUNT; $j < $tabstgFieldCount; $j++) {
            $tabstgRow .= ',""';
          }
          file_put_contents($tabstgFile, file_get_contents($tabstgFile) . $tabstgRow . "\n");
        }

        if ($deslinDescri != '') {
          // Get deslin with empty fields for unknown new fields
          $deslinRow = '"dsartn","' . $cdartn . '","","EN","' . $deslinDescri . '"';
          for ($j = self::DESLIN_COUNT; $j < $deslinFieldCount; $j++) {
            $deslinRow .= ',""';
          }
          file_put_contents($deslinFile, file_get_contents($deslinFile) . $deslinRow . "\n");
          $deslinRow = '"dsarti","' . $cdarti . '","","EN","' . $deslinDescri . '"';
          for ($j = self::DESLIN_COUNT; $j < $deslinFieldCount; $j++) {
            $deslinRow .= ',""';
          }
          file_put_contents($deslinFile, file_get_contents($deslinFile) . $deslinRow . "\n");
        }

        if ($desartCommIt != '') {
          // Get desart with empty fields for unknown new fields
          $desartRow = '"AN","' . $cdartn . '","COMM","IT","' . $desartCommIt . '"';
          for ($j = self::DESART_COUNT; $j < $desartFieldCount; $j++) {
            $desartRow .= ',""';
          }
          file_put_contents($desartFile, file_get_contents($desartFile) . $desartRow . "\n");
        }

        if ($desartCommEn != '') {
          // Get desart with empty fields for unknown new fields
          $desartRow = '"AN","' . $cdartn . '","COMM","EN","' . $desartCommEn . '"';
          for ($j = self::DESART_COUNT; $j < $desartFieldCount; $j++) {
            $desartRow .= ',""';
          }
          file_put_contents($desartFile, file_get_contents($desartFile) . $desartRow . "\n");
        }

        if ($desartTecnIt != '') {
          // Get desart with empty fields for unknown new fields
          $desartRow = '"AN","' . $cdartn . '","TECN","IT","' . $desartTecnIt . '"';
          for ($j = self::DESART_COUNT; $j < $desartFieldCount; $j++) {
            $desartRow .= ',""';
          }
          file_put_contents($desartFile, file_get_contents($desartFile) . $desartRow . "\n");
        }

        if ($desartTecnEn != '') {
          // Get desart with empty fields for unknown new fields
          $desartRow = '"AN","' . $cdartn . '","TECN","EN","' . $desartTecnEn . '"';
          for ($j = self::DESART_COUNT; $j < $desartFieldCount; $j++) {
            $desartRow .= ',""';
          }
          file_put_contents($desartFile, file_get_contents($desartFile) . $desartRow . "\n");
        }

        if ($compos != '' || $vestib != '') {
          // Get desart with empty fields for unknown new fields
          $b2bModinfRow = '"' . $cdartn . '","","","","","","","' . $compos . '","' . $vestib . '","",""';
          for ($j = self::B2B_MODINF_COUNT; $j < $b2bModinfFieldCount; $j++) {
            $b2bModinfRow .= ',""';
          }
          file_put_contents($b2bModinfFile, file_get_contents($b2bModinfFile) . $b2bModinfRow . "\n");
        }

        if ($counter < self::MAX_LINES) {
          $counter++;
        } else {
          self::loadFile('anaart', $anaartFile);
          self::loadFile('anaper', $anaperFile);
          self::loadFile('anatgl', $anatglFile);
          self::loadFile('b2b_modinf', $b2bModinfFile);
          self::loadFile('desart', $desartFile);
          self::loadFile('deslin', $deslinFile);
          self::loadFile('linmod', $linmodFile);
          self::loadFile('sermod', $sermodFile);
          self::loadFile('tabstg', $tabstgFile);
          self::loadFile('tipolo', $tipoloFile);
          self::loadFile('titlin', $titlinFile);
          self::loadFile('tpgene', $tpgeneFile);
          self::loadFile('tpmode', $tpmodeFile);
          $counter = 0;
        }
      }
    }

    if ($counter != 0) {
      // There are some remaining rows
        self::loadFile('anaart', $anaartFile);
        self::loadFile('anaper', $anaperFile);
        self::loadFile('anatgl', $anatglFile);
        self::loadFile('b2b_modinf', $b2bModinfFile);
        self::loadFile('desart', $desartFile);
        self::loadFile('deslin', $deslinFile);
        self::loadFile('linmod', $linmodFile);
        self::loadFile('sermod', $sermodFile);
        self::loadFile('tabstg', $tabstgFile);
        self::loadFile('tipolo', $tipoloFile);
        self::loadFile('titlin', $titlinFile);
        self::loadFile('tpgene', $tpgeneFile);
        self::loadFile('tpmode', $tpmodeFile);
    }

    unlink($anaartFile);
    unlink($anaperFile);
    unlink($anatglFile);
    unlink($b2bModinfFile);
    unlink($desartFile);
    unlink($deslinFile);
    unlink($linmodFile);
    unlink($sermodFile);
    unlink($tabstgFile);
    unlink($tipoloFile);
    unlink($titlinFile);
    unlink($tpgeneFile);
    unlink($tpmodeFile);
  }
}

?>
