<?php

namespace Go2B\Tasks\Sync;

use Go2B\Controllers\Utility;
use Go2B\Models\Lstest;
use Phalcon\DI as Di;

class CsvLardini
{
    const IMPORT_FOLDER = '../public/io/import';
    const IMAGES_FOLDER = '../public/img';

    public static function sync($echo)
    {
        $fileDsp = [
            "DISPSTOCK" => self::IMPORT_FOLDER . '/DISPSTOCK.TXT',
            "DISPMAG" => self::IMPORT_FOLDER . '/DISPMAG.TXT',
        ];
        $fileMod = self::IMPORT_FOLDER . '/MODELLI.TXT';
        $fileCom = self::IMPORT_FOLDER . '/DESCOMM.TXT';
        $fileTec = self::IMPORT_FOLDER . '/DESTECN.TXT';
        $fileLst = self::IMPORT_FOLDER . '/LISTPRE.TXT';
        $fileCol = self::IMPORT_FOLDER . '/CARTTXT.TXT';
        $fileCus = self::IMPORT_FOLDER . '/CLIENTI.TXT';
        $fileFbr = self::IMPORT_FOLDER . '/TESSUTI.TXT';
        $file360 = self::IMPORT_FOLDER . '/FILE360.TXT';
        $fileDat = self::IMPORT_FOLDER . '/DATDROP.TXT';
        $fileImg = self::IMPORT_FOLDER . '/IMGTESS.TXT';
        $fileBud = self::IMPORT_FOLDER . '/BUDGETS.TXT';
        $fileTag = self::IMPORT_FOLDER . '/ARTITAG.TXT';
        $fileBcd = self::IMPORT_FOLDER . '/BARCODE.TXT';
        $newFileDsp = [
            "DISPSTOCK" => self::IMPORT_FOLDER . '/processed/DISPSTOCK.TXT',
            "DISPMAG" => self::IMPORT_FOLDER . '/processed/DISPMAG.TXT',
        ];
        $newFileMod = self::IMPORT_FOLDER . '/processed/MODELLI.TXT';
        $newFileCom = self::IMPORT_FOLDER . '/processed/DESCOMM.TXT';
        $newFileTec = self::IMPORT_FOLDER . '/processed/DESTECN.TXT';
        $newFileLst = self::IMPORT_FOLDER . '/processed/LISTPRE.TXT';
        $newFileCol = self::IMPORT_FOLDER . '/processed/CARTTXT.TXT';
        $newFileCus = self::IMPORT_FOLDER . '/processed/CLIENTI.TXT';
        $newFileFbr = self::IMPORT_FOLDER . '/processed/TESSUTI.TXT';
        $newFile360 = self::IMPORT_FOLDER . '/processed/FILE360.TXT';
        $newFileDat = self::IMPORT_FOLDER . '/processed/DATDROP.TXT';
        $newFileImg = self::IMPORT_FOLDER . '/processed/IMGTESS.TXT';
        $newFileBud = self::IMPORT_FOLDER . '/processed/BUDGETS.TXT';
        $newFileTag = self::IMPORT_FOLDER . '/processed/ARTITAG.TXT';
        $newFileBcd = self::IMPORT_FOLDER . '/processed/BARCODE.TXT';

        try {

            // Titlin
            $query = "INSERT IGNORE INTO titlin (cdtitl, dstitl, seqrap, flimag)
      VALUES ('LAR', 'Lardini', 0, '')";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
                echo "Titlin synchronized!\n";
            }

            // Tipolo, Tabstg, Tpgene, Deslin, Desart (TECN)
            if (file_exists($fileMod) && ($handle = fopen($fileMod, 'r')) !== false) {
                $i = 1;
                \Go2B\Models\Tipolo::blockAllModels();
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    // Tpgene
                    $tpgene = '';
                    if (trim($data[0]) != '' && trim($data[8]) != '') {
                        $query = "SELECT *
            FROM tpgene
            WHERE dsgene = :dsgene ";
                        $params = array('dsgene' => trim($data[8]));
                        $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

                        if (empty($result)) {
                            $query = "SELECT COALESCE(MAX(CONVERT(tpgene, SIGNED INTEGER)),0) AS currentTpgene
              FROM tpgene ";
                            $params = array('dsgene' => trim($data[8]));
                            $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

                            $tpgene = $result[0]['currentTpgene'] + 1;

                            $query = "INSERT INTO tpgene (tpgene, dsgene, seqrap)
              VALUES (:tpgene, :dsgene, :seqrap)
              ON DUPLICATE KEY UPDATE dsgene = :dsgene, seqrap = :seqrap ";
                            $params = array(
                                'tpgene' => $tpgene,
                                'dsgene' => trim($data[8]),
                                'seqrap' => 0,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        } else {
                            $tpgene = $result[0]['tpgene'];
                        }
                    }

                    // Tipolo
                    $query = "INSERT INTO tipolo (cdartn, dsartn, cdstag, cdlinm, cdserm,
          tpgene, tpmode, ummaga, cdtagl, tglini, tglfin, tppers, flbloc,
          flasso, flimag, flvide)
          VALUES (:cdartn, :dsartn, :cdstag, :cdlinm, :cdserm, :tpgene, :tpmode,
          :ummaga, :cdtagl, :tglini, :tglfin, :tppers, :flbloc, :flasso,
          :flimag, :flvide)
          ON DUPLICATE KEY UPDATE dsartn = :dsartn, cdstag = :cdstag,
          cdlinm = :cdlinm, cdserm = :cdserm, tpgene = :tpgene,
          tpmode = :tpmode, ummaga = :ummaga, cdtagl = :cdtagl,
          tglini = :tglini, tglfin = :tglfin, tppers = :tppers,
          flbloc = :flbloc, flasso = :flasso, flimag = :flimag,
          flvide = :flvide";
                    $params = array(
                        'cdartn' => trim($data[0]),
                        'dsartn' => trim($data[4]),
                        'cdstag' => trim($data[2]),
                        'cdlinm' => trim($data[1]),
                        'cdserm' => '',
                        'tpgene' => $tpgene,
                        'tpmode' => trim($data[7]),
                        'ummaga' => trim($data[6]),
                        'cdtagl' => trim($data[3]),
                        'tglini' => 0,
                        'tglfin' => 0,
                        'tppers' => 'PT',
                        'flbloc' => 0,
                        'flasso' => 0,
                        'flimag' => '',
                        'flvide' => '',
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    // Tabstg
                    $query = "INSERT IGNORE INTO tabstg (cdstag, dsstag, collez)
          VALUES (:cdstag, :dsstag, :collez)";
                    $params = array(
                        'cdstag' => trim($data[2]),
                        'dsstag' => trim($data[2]),
                        'collez' => 0,
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    // Deslin
                    if (trim($data[0]) != '' && trim($data[5]) != '') {
                        $query = "INSERT INTO deslin (tpdato, codic1, codic2, idlang, descri)
            VALUES (:tpdato, :codic1, :codic2, :idlang, :descri)
            ON DUPLICATE KEY UPDATE descri = :descri";
                        $params = array(
                            'tpdato' => 'dsartn',
                            'codic1' => trim($data[0]),
                            'codic2' => '',
                            'idlang' => 'EN',
                            'descri' => trim($data[5]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);
                    }

                    // Desart
                    if (trim($data[0]) != '') {
                        $tecnDescription = trim($data[9]) . ' ' . trim($data[10]) . ' ' . trim($data[11]) . ' ' . trim($data[12]) . ' ' . trim($data[13]) . ' ' . trim($data[14]);
                        if (!empty($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'IT',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        $tecnDescription = trim($data[15]) . ' ' . trim($data[16]) . ' ' . trim($data[17]) . ' ' . trim($data[18]) . ' ' . trim($data[19]) . ' ' . trim($data[20]);
                        if (!empty($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'EN',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                    }

                    if ($echo) {
                        echo "$fileMod Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileMod, $newFileMod);

                if ($echo) {
                    echo "Tipolo, Tpgene, Deslin, Desart (TECN) synchronized!\n";
                }
            }

            // Desart (COMM)
            if (file_exists($fileCom) && ($handle = fopen($fileCom, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // Italian
                        $commDescription = trim($data[2]);
                        if (!empty($commDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdartn = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'IT',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'IT',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // English
                        $commDescription = trim($data[3]);
                        if (!empty($commDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdartn = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'EN',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'EN',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // German
                        $commDescription = trim($data[4]);
                        if (!empty($commDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdartn = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'DE',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'DE',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // Spanish
                        $commDescription = trim($data[5]);
                        if (!empty($commDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdartn = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'ES',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'ES',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // French
                        $commDescription = trim($data[6]);
                        if (!empty($commDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdartn = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'FR',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              VALUES (:tpinpu, :codice, :tpdesc, :idlang, :descri)
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AN',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'COMM',
                                'idlang' => 'FR',
                                'descri' => $commDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                    }

                    if ($echo) {
                        echo "$fileCom Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileCom, $newFileCom);

                if ($echo) {
                    echo "Desart (COMM) synchronized!\n";
                }
            }

            // Desart (TECN)
            if (file_exists($fileTec) && ($handle = fopen($fileTec, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // Italian
                        $tecnDescription = trim($data[2]);
                        if (trim($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdpers = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'IT',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // English
                        $tecnDescription = trim($data[3]);
                        if (trim($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdpers = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'EN',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // German
                        $tecnDescription = trim($data[4]);
                        if (trim($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdpers = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'DE',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // Spanish
                        $tecnDescription = trim($data[5]);
                        if (trim($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdpers = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'ES',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        // French
                        $tecnDescription = trim($data[6]);
                        if (trim($tecnDescription)) {
                            $query = "INSERT INTO desart (tpinpu, codice, tpdesc, idlang, descri)
              SELECT :tpinpu, cdarti, :tpdesc, :idlang, :descri
              FROM anaart
              WHERE cdpers = :codice
              ON DUPLICATE KEY UPDATE descri = :descri";
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpdesc' => 'TECN',
                                'idlang' => 'FR',
                                'descri' => $tecnDescription,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                    }

                    if ($echo) {
                        echo "$fileTec Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileTec, $newFileTec);

                if ($echo) {
                    echo "Desart (TECN) synchronized!\n";
                }
            }

            // Tpmode
            $query = "DELETE tm.*
      FROM tpmode tm
      WHERE tm.tpmode NOT IN
        (SELECT DISTINCT tp.tpmode
        FROM tipolo tp)";
            Di::getDefault()->get('db')->query($query);

            $query = "INSERT IGNORE INTO tpmode (tpmode, dstmod, seqrap)
      SELECT DISTINCT tpmode, tpmode, 0
      FROM tipolo
      WHERE tpmode != '' ";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
                echo "Tpmode synchronized!\n";
            }

            // Linmod
            $query = "INSERT IGNORE INTO linmod (cdlinm, dslinm, cdtitl, seqrap, flimag)
      VALUES
      ('0002','LARDINI UOMO','LAR',0,''),
      ('002C','LARDINI UOMO CAMP','LAR',0,''),
      ('0004','LARDINI DONNA','LAR',0,''),
      ('004C','LARDINI DONNA CAMP','LAR',0,''),
      ('0050','GABRIELE PASINI','LAR',0,''),
      ('050C','GABRIELE PASINI CAMP','LAR',0,''),
      ('0064','YOSUKE AIZAWA','LAR',0,''),
      ('LCRA','CAPSULE LUIGI LARDINI','LAR',0,'')";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
                echo "Linmod synchronized!\n";
            }

            // Dscorp
            foreach ($fileDsp as $key => $file) {
                if (file_exists($file) && ($handle = fopen($file, 'r')) !== false) {
                    $j = 1;

                    $query = "TRUNCATE dscorp";
                    Di::getDefault()->get('db')->query($query);

                    while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                        for ($i = 0; $i < 10; $i++) {
                            if (trim($data[16 + $i]) != '') {

                                // Dscorp
                                $query = "INSERT INTO dscorp (cdarti, cdcolo, cdvari, cdasso,
                taglia, dtdisp, quanti)
                VALUES (:cdarti, :cdcolo, :cdvari, :cdasso, :taglia, :dtdisp,
                :quanti)
                ON DUPLICATE KEY UPDATE quanti = :quanti";
                                $params = array(
                                    'cdarti' => trim($data[0]) . ' ' . trim($data[1]),
                                    'cdcolo' => trim($data[2]),
                                    'cdvari' => '',
                                    'cdasso' => '',
                                    'taglia' => trim($data[16 + $i]),
                                    'dtdisp' => date('Y-m-d'),
                                    'quanti' => trim($data[6 + $i]),
                                );
                                Di::getDefault()->get('db')->query($query, $params);
                            }
                        }

                        if ($echo) {
                            echo "$file Row $j \n";
                            $j++;
                        }
                    }
                    fclose($handle);
                    rename($fileDsp[$key], $newFileDsp[$key]);

                    if ($echo) {
                        echo "Dscorp synchronized!\n";
                    }
                }
            }
            /*
            // Postgl
            $query = "INSERT IGNORE INTO postgl (cdtagl, postgl, taglia)
            VALUES
            ('2',1,'XS'), ('2',2,'S'), ('2',3,'M'), ('2',4,'L'), ('2',5,'XL'),
            ('2',6,'XXL'), ('2',7,'XXXL'),
            ('10',1,'44'), ('10',2,'46'), ('10',3,'48'), ('10',4,'50'), ('10',5,'52'),
            ('10',6,'54'), ('10',7,'56'), ('10',8,'58'), ('10',9,'60'), ('10',10,'62'),
            ('11',1,'38'), ('11',2,'40'), ('11',3,'42'), ('11',4,'44'), ('11',5,'46'),
            ('11',6,'48'), ('11',7,'50'), ('11',8,'52'), ('11',9,'54'), ('11',10,'56'),
            ('A*',1,'7'),
            ('AD',1,'29'), ('AD',2,'30'), ('AD',3,'31'), ('AD',4,'32'), ('AD',5,'34'),
            ('AD',6,'36'), ('AD',7,'38'), ('AD',8,'39'),
            ('AJ',1,'42'), ('AJ',2,'44'), ('AJ',3,'46'), ('AJ',4,'48'), ('AJ',5,'50'),
            ('AJ',6,'52'), ('AJ',7,'54'), ('AJ',8,'56'), ('AJ',9,'58'), ('AJ',10,'60'),
            ('AP',1,'28'), ('AP',2,'29'), ('AP',3,'30'), ('AP',4,'31'), ('AP',5,'32'),
            ('AP',6,'34'), ('AP',7,'36'), ('AP',8,'38'), ('AP',9,'39'), ('AP',10,'41'),
            ('B.',2,'M'), ('B.',3,'L'),
            ('B0',1,'S/55'), ('B0',2,'M/57'), ('B0',3,'L/59'), ('B0',4,'XL/61'),
            ('C1',1,'UNICA'),
            ('C2',1,'57'), ('C2',2,'59'), ('C2',3,'61'),
            ('C4',1,'M'),
            ('C8',1,'56'), ('C8',2,'58'), ('C8',3,'60'), ('C8',4,'62'),
            ('CC',1,'XS'), ('CC',2,'S'), ('CC',3,'M'), ('CC',4,'L'), ('CC',5,'XL'),
            ('CC',6,'XXL'),
            ('CG',1,'38/4'), ('CG',2,'39/5'), ('CG',3,'40/6'), ('CG',4,'41/7'), ('CG',5,'42/8'),
            ('CG',6,'43/9'), ('CG',7,'44/10'), ('CG',8,'45/11'), ('CG',9,'46/12'), ('CG',10,'47/13'),
            ('CI',1,'80'), ('CI',2,'85'), ('CI',3,'90'), ('CI',4,'95'), ('CI',5,'100'),
            ('CI',6,'105'), ('CI',7,'110'), ('CI',8,'115'), ('CI',9,'120'), ('CI',10,'125'),
            ('CJ',1,'37'), ('CJ',2,'38'), ('CJ',4,'39'), ('CJ',3,'40'), ('CJ',5,'41'),
            ('CJ',6,'42'), ('CJ',7,'43'), ('CJ',8,'44'), ('CJ',9,'45'), ('CJ',10,'46'),
            ('CL',1,'39-42'), ('CL',2,'43-45'),
            ('CM',1,'38'), ('CM',2,'39'), ('CM',3,'40'), ('CM',4,'41'), ('CM',5,'42'),
            ('CM',6,'43'), ('CM',7,'44'), ('CM',8,'45'), ('CM',9,'46'), ('CM',10,'47'),
            ('CN',1,'80'), ('CN',2,'85'), ('CN',3,'90'), ('CN',4,'95'), ('CN',5,'100'),
            ('CN',6,'105'), ('CN',7,'110'), ('CN',8,'115'), ('CN',9,'120'), ('CN',10,'125'),
            ('CQ',1,'38'), ('CQ',2,'39'), ('CQ',3,'40'), ('CQ',4,'40,5'), ('CQ',5,'41'),
            ('CQ',6,'41,5'), ('CQ',7,'42'), ('CQ',8,'42,5'), ('CQ',9,'43'), ('CQ',10,'43,5'),
            ('CV',1,'S'), ('CV',2,'M'), ('CV',3,'L'), ('CV',4,'XL'),
            ('CW',1,'37'), ('CW',2,'38'), ('CW',3,'39'), ('CW',4,'40'), ('CW',5,'41'),
            ('CW',6,'42'), ('CW',7,'43'), ('CW',8,'44'), ('CW',9,'45'), ('CW',10,'46'),
            ('DB',1,'39/41'), ('DB',2,'42/43'), ('DB',3,'44/45'),
            ('DL',2,'44'), ('DL',3,'46'), ('DL',4,'48'), ('DL',5,'50'), ('DL',6,'52'),
            ('DL',7,'54'), ('DL',8,'56'), ('DL',9,'58'), ('DL',10,'60'),
            ('DM',2,'XXS'), ('DM',3,'XS'), ('DM',4,'S'), ('DM',5,'M'), ('DM',6,'L'),
            ('DM',7,'XL'), ('DM',8,'XXL'), ('DM',9,'XXXL'),
            ('DN',3,'XS'), ('DN',4,'S'), ('DN',5,'M'), ('DN',6,'L'), ('DN',7,'XL'),
            ('DN',8,'XXL'), ('DN',9,'XXXL'),
            ('DO',4,'S/55'), ('DO',5,'M/57'), ('DO',6,'L/59'), ('DO',7,'XL/61'),
            ('DP',4,'S'), ('DP',5,'M'), ('DP',6,'L'), ('DP',7,'XL'), ('DP',8,'XXL'),
            ('DP',9,'XXXL'),
            ('DQ',3,'XS'), ('DQ',4,'S'), ('DQ',5,'M'), ('DQ',6,'L'), ('DQ',7,'XL'),
            ('DQ',8,'XXL'),
            ('DU',1,'42'), ('DU',2,'44'), ('DU',3,'46'), ('DU',4,'48'), ('DU',5,'50'),
            ('DU',6,'52'),
            ('FG',1,'39-42'), ('FG',2,'43-45'),
            ('GC',1,'38/4'), ('GC',2,'39/5'), ('GC',3,'40/6'), ('GC',4,'41/7'), ('GC',5,'42/8'),
            ('GC',6,'43/9'), ('GC',7,'44/10'), ('GC',8,'45/11'), ('GC',9,'46/12'), ('GC',10,'47/13'),
            ('L1',1,'S'), ('L1',2,'M'), ('L1',3,'L'), ('L1',4,'XL'), ('L1',5,'XXL'),
            ('L4',1,'XXS'), ('L4',2,'XS'), ('L4',3,'S'), ('L4',4,'M'), ('L4',5,'L'),
            ('L4',6,'XL'), ('L4',7,'XXL'),
            ('L5',1,'XXXS'), ('L5',2,'XXS'), ('L5',3,'XS'), ('L5',4,'S'), ('L5',5,'M'),
            ('L5',6,'L'), ('L5',7,'XL'), ('L5',8,'XXL'), ('L5',9,'XXXL'),
            ('LB',1,'XS'), ('LB',2,'S'), ('LB',3,'M'), ('LB',4,'L'), ('LB',5,'XL'),
            ('LB',6,'XXL'), ('LB',7,'XXXL'),
            ('P1',1,'XXS'), ('P1',2,'XS'), ('P1',3,'S'), ('P1',4,'M'), ('P1',5,'L'),
            ('P1',6,'XL'), ('P1',7,'XXL'), ('P1',8,'XXXL'),
            ('P3',1,'29'), ('P3',2,'30'), ('P3',3,'31'), ('P3',4,'32'), ('P3',5,'33'),
            ('P3',6,'34'), ('P3',7,'35'), ('P3',8,'36'), ('P3',9,'37'), ('P3',10,'38'),
            ('P5',1,'28/42'), ('P5',2,'30/44'), ('P5',3,'31/45'), ('P5',4,'32/46'), ('P5',5,'33/47'),
            ('P5',6,'34/48'), ('P5',7,'36/50'), ('P5',8,'38/52'), ('P5',9,'40/54'), ('P5',10,'42/56'),
            ('PC',4,'120'),
            ('PD',1,'29'), ('PD',2,'30'), ('PD',3,'31'), ('PD',4,'32'), ('PD',5,'33'),
            ('PD',6,'34'), ('PD',7,'35'), ('PD',8,'36'), ('PD',9,'37'), ('PD',10,'38'),
            ('PI',1,'37'), ('PI',2,'38'), ('PI',3,'39'), ('PI',4,'40'), ('PI',5,'41'),
            ('PI',6,'42'), ('PI',7,'43'), ('PI',8,'44'), ('PI',9,'45'), ('PI',10,'46'),
            ('PN',1,'S'), ('PN',2,'M'), ('PN',3,'L'),
            ('PU',1,'42'), ('PU',2,'44'), ('PU',3,'46'), ('PU',4,'48'), ('PU',5,'50'),
            ('PU',6,'52'), ('PU',7,'54'), ('PU',8,'56'), ('PU',9,'58'), ('PU',10,'60'),
            ('RH',1,'16'), ('RH',2,'18'), ('RH',3,'20'), ('RH',4,'22'), ('RH',5,'23'),
            ('RH',6,'24'), ('RH',7,'26'),
            ('RI',1,'18'), ('RI',2,'20'), ('RI',3,'22'), ('RI',4,'23'), ('RI',5,'24'),
            ('RI',6,'26'),
            ('RP',1,'17'), ('RP',2,'26'),
            ('S0',3,'39'), ('S0',4,'40'), ('S0',5,'41'), ('S0',6,'42'), ('S0',7,'43'),
            ('S0',8,'44'), ('S0',9,'45'),
            ('S3',1,'38'), ('S3',2,'39'), ('S3',3,'40'), ('S3',4,'41'), ('S3',5,'42'),
            ('S3',6,'43'), ('S3',7,'44'), ('S3',8,'45'), ('S3',9,'46'),
            ('S8',1,'38/4'), ('S8',2,'39/5'), ('S8',3,'40/6'), ('S8',4,'41/7'), ('S8',5,'42/8'),
            ('S8',6,'42,5'), ('S8',7,'43/9'), ('S8',8,'44/10'), ('S8',9,'45/11'), ('S8',10,'46/12'),
            ('S9',1,'39'), ('S9',2,'40'), ('S9',3,'41'), ('S9',4,'41,5'), ('S9',5,'42'),
            ('S9',6,'42,5'), ('S9',7,'43'), ('S9',8,'44'), ('S9',9,'45'), ('S9',10,'46'),
            ('SP',1,'37'), ('SP',2,'38'), ('SP',3,'39'), ('SP',4,'40'), ('SP',5,'41'),
            ('SP',6,'42'), ('SP',7,'43'), ('SP',8,'44'), ('SP',9,'45'), ('SP',10,'46'),
            ('SQ',1,'39'), ('SQ',2,'40'), ('SQ',3,'41'), ('SQ',5,'42'), ('SQ',7,'43'),
            ('SQ',8,'44'), ('SQ',9,'45'), ('SQ',10,'46'),
            ('WO',1,'UNICA'),
            ('X1',1,'M/L')";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
            echo "Postgl synchronized!\n";
            }
            // Anatgl
            $query = "INSERT IGNORE INTO anatgl (cdtagl, dstagl, seqrap)
            VALUES
            ('2','AMERICANE',0), ('10','UOMO',0), ('11','DONNA',0), ('A*','GUANTI',0), ('AD','PANTALONI AMERICANI',0),
            ('AJ','GIAPPONE',0), ('AP','PANT.RO',0), ('B.','T-SHIRT DONNA',0), ('B0','CAPPELLI',0), ('C1','CRAVATTE',0),
            ('C2','CAPPELLI',0), ('C4','CNT10 CAMP',0), ('C8','CAPPELLI',0), ('CC','CAMICIE',0), ('CG','SCARPE',0),
            ('CI','CINTURE',0), ('CJ','CAMICIE',0), ('CL','CALZINI',0), ('CM','CAMICIE',0), ('CN','TG.CINTURE',0),
            ('CQ','SCARPE 1/2',0), ('CV','CAPPELLI PASINI AI17',0), ('CW','CAMICIE NUOVO',0), ('DB','CALZINI',0), ('DL','GILET IN MAGLIA',0),
            ('DM','JERSEY T-SHIRT',0), ('DN','CAMICIE JERSEY',0), ('DO','CAPPELLI',0), ('DP','GUANTI',0), ('DQ','YOSUKE AIZ',0),
            ('DU','MOD.LKT3',0), ('FG','CALZINI',0), ('GC','SCARPE',0), ('L1','MAGLIERIA LARDINI',0), ('L4','MAGLIERIA PE11',0),
            ('L5','GIACCA MAGLIA/COSTUMI',0), ('LB','MAGLIE/GUANTI',0), ('P1','MAGLIE/COSTUMI',0), ('P3','DENIM',0), ('P5','JEANS/PANTALONI',0),
            ('PC','.',0), ('PD','PASINI DENIM',0), ('PI','CAMICIE PI',0), ('PN','S-M-L',0), ('PU','PASINI U',0),
            ('RH','ANELLI',0), ('RI','ANELLI',0), ('RP','ANELLI G.PASINI',0), ('S0','SCARPE',0), ('S3','SCARPE',0),
            ('S8','SCARPE',0), ('S9','SCARPE NEW',0), ('SP','SCARPE PASINI AI17',0), ('SQ','SCARPE Y.A',0), ('WO','TAGLIA UNICA',0),
            ('X1','CAPPELLI DONNA',0)";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
            echo "Anatgl synchronized!\n";
            }

             */

            // Anaart, Lstest, Lscorp
            if (file_exists($fileLst) && ($handle = fopen($fileLst, 'r')) !== false) {
                for ($i = 0; $i < 9; $i++) {
                    // Lstest
                    $query = "INSERT INTO lstest (nulist, dslist, seqrap, cdvalu, dtiniz, dtfine)
                                VALUES (:nulist, :dslist, :seqrap, :cdvalu, :dtiniz, :dtfine)
                                ON DUPLICATE KEY UPDATE
                                    dslist = :dslist, seqrap = :seqrap,
                                    cdvalu = :cdvalu, dtiniz = :dtiniz, dtfine = :dtfine";
                    $params = array(
                        'nulist' => $i + 1,
                        'dslist' => 'Listino ' . ($i + 1),
                        'seqrap' => $i + 1,
                        'cdvalu' => 'EUR',
                        'dtiniz' => '0000-00-00',
                        'dtfine' => '0000-00-00',
                    );
                    Di::getDefault()->get('db')->query($query, $params);
                }

                $j = 1;
                \Go2B\Models\Anaart::blockAllArticles();
                $idListiniAggiornati = [];
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    // Anaart
                    $cdarti = trim($data[0]) . ' ' . trim($data[1]);
                    $query = "INSERT INTO anaart (cdarti, dsarti, cdartn, cdpers, flbloc,
                        cdcolo, dscolo, tpvend, cdmisu, flimag)
                        VALUES (:cdarti, :dsarti, :cdartn, :cdpers, :flbloc, :cdcolo, :dscolo,
                        :tpvend, cdmisu, flimag)
                        ON DUPLICATE KEY UPDATE dsarti = :dsarti, cdartn = :cdartn,
                        cdpers = :cdpers, flbloc = :flbloc, cdcolo = :cdcolo,
                        dscolo = :dscolo, tpvend = :tpvend, cdmisu = :cdmisu,
                        flimag = :flimag";
                    $params = array(
                        'cdarti' => $cdarti,
                        'dsarti' => $cdarti,
                        'cdartn' => trim($data[0]),
                        'cdpers' => trim($data[1]),
                        'flbloc' => 0,
                        'cdcolo' => '',
                        'dscolo' => '',
                        'tpvend' => '',
                        'cdmisu' => '',
                        'flimag' => '',
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    $priceListData = array_chunk(array_slice($data, 2), 3);

                    foreach ($priceListData as $idx => $priceListDatum) {

                        $prezzo = doubleval(str_replace(',', '.', trim($priceListDatum[1])));
                        $moltiplicatoreSconto = (1 - (doubleval(trim($priceListDatum[2])) / 100));
                        $valuta = trim($priceListDatum[0]);
                        $nuList = $idx + 1;

                        if ($prezzo > 0) {
                            $prezzo *= $moltiplicatoreSconto;

                            $query = "INSERT INTO lscorp (nulist, cdarti, taglia, cdvalu, prezzo,preven)
                                        VALUES (:nulist, :cdarti, :taglia, :cdvalu, :prezzo, :preven)
                                        ON DUPLICATE KEY UPDATE
                                            cdvalu = :cdvalu, prezzo = :prezzo, preven = :preven";
                            $params = array(
                                'nulist' => $nuList,
                                'cdarti' => $cdarti,
                                'taglia' => '',
                                'cdvalu' => $valuta,
                                'prezzo' => $prezzo,
                                'preven' => 0,
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }

                        if (!in_array($nuList, $idListiniAggiornati)) {
                            $listino = Lstest::findFirst($nuList);
                            $listino->cdvalu = $valuta;
                            $listino->save();
                            $idListiniAggiornati[] = $nuList;
                        }
                    }

                    if ($echo) {
                        echo "$fileLst Row $j \n";
                        $j++;
                    }
                }

                // Delete empties price lists
                $query = "DELETE FROM lstest
                    WHERE nulist NOT IN (SELECT nulist
                        FROM lscorp
                        GROUP BY nulist
                        HAVING COUNT(*) > 0
                    )";
                Di::getDefault()->get('db')->query($query);
                fclose($handle);
                rename($fileLst, $newFileLst);

                if ($echo) {
                    echo "Anaart, Lscorp, Lstest synchronized!\n";
                }
            }

            // Artcol
            if (file_exists($fileCol) && ($handle = fopen($fileCol, 'r')) !== false) {
                $i = 1;
                //\Go2B\Models\Artcol::blockAllColors();
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    // Search all articles with current fabric code
                    $query = "SELECT cdarti FROM anaart WHERE cdpers = :cdpers";
                    $params = array(
                        'cdpers' => trim($data[0]),
                    );
                    $anaart = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

                    if (count($anaart) > 0) {
                        foreach ($anaart as $article) {
                            // Per il cliente Lardini (sull'installazione THI) Matto ci ha chiesto di non droppare più le descrizioni (probabilmente anche l'immagine) quindi modifico la query per fare un INSERT IGNORE
                            // N.B. Alla fine l'abbiamo implementata su una nuova importazione CsvThi.php
                            // Artcol
                            $query = "INSERT INTO artcol (cdarti, cdcolo, dscolo, flbloc, flimag)
              VALUES (:cdarti, :cdcolo, :dscolo, :flbloc, :flimag)
              ON DUPLICATE KEY UPDATE dscolo = :dscolo, flimag = :flimag";
                            $params = array(
                                'cdarti' => $article['cdarti'],
                                'cdcolo' => trim($data[1]),
                                'dscolo' => trim($data[1]),
                                'flbloc' => 0,
                                'flimag' => '',
                            );
//                            $query = "INSERT IGNORE INTO artcol (cdarti, cdcolo, dscolo, flbloc, flimag) VALUES (:cdarti, :cdcolo, :dscolo, :flbloc, :flimag)";
//                            $params = array(
//                                'cdarti' => $article['cdarti'],
//                                'cdcolo' => trim($data[1]),
//                                'dscolo' => trim($data[1]),
//                                'flbloc' => 0,
//                                'flimag' => '',
//                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                    }

                    if ($echo) {
                        echo "$fileCol Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileCol, $newFileCol);

                if ($echo) {
                    echo "Artcol synchronized!\n";
                }
            }

            // Barcode
            if (file_exists($fileBcd) && ($handle = fopen($fileBcd, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    $query = "INSERT INTO barcod (nubrcd, cdarti, cdcolo, taglia)
              VALUES (:nubrcd, :cdarti, :cdcolo, :taglia)
              ON DUPLICATE KEY UPDATE cdarti = :cdarti, cdcolo = :cdcolo, taglia = :taglia";
                    $params = array(
                        'nubrcd' => trim($data[0]),
                        'cdarti' => trim($data[1]),
                        'cdcolo' => trim($data[2]),
                        'taglia' => trim($data[3]),
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    if ($echo) {
                        echo "$fileBcd Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileBcd, $newFileBcd);

                if ($echo) {
                    echo "Barcod synchronized!\n";
                }
            }

            // Anagra, Tppaga
            if (file_exists($fileCus) && ($handle = fopen($fileCus, 'r')) !== false) {
                // \Go2B\Models\Anagra::blockAllCustomers(); DANIELE -- 24/11/2021
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    $cdnazi = trim($data[8]);
                    switch ($cdnazi) {
                        case 'IT':
                            $idlang = 'it';
                            break;
                        case 'ES':
                            $idlang = 'es';
                            break;
                        case 'DE':
                            $idlang = 'de';
                            break;
                        case 'FR':
                            $idlang = 'fr';
                            break;
                        default:
                            $idlang = 'en';
                            break;
                    }

                    // Anagra
                    $query = "INSERT INTO anagra (tpanag, cdanag, descri, desvid, indiri, codcap, ccitta, provin, cdnazi, idlang,
          cdzona, pariva, codfis, numtel, numcel, numfax, intern, indema, percon, cdvalu, tpaggc, nulist, nuscon,
          scont1, scont2, scont3, tpport, tppaga, cdesen, codabi, codcab, cdiban, cdvett, cdagen, cdblco, dtblco,
          provvi, cddesm, dtvali, newcod, priori, cdetic, latitu, longit, notdes, cdage2, cdage3, cdage4, cdage5,
          indpec)
          VALUES (:tpanag, :cdanag, :descri, :desvid, :indiri, :codcap, :ccitta, :provin, :cdnazi, :idlang, :cdzona,
          :pariva, :codfis, :numtel, :numcel, :numfax, :intern, :indema, :percon, :cdvalu, :tpaggc, :nulist, :nuscon,
          :scont1, :scont2, :scont3, :tpport, :tppaga, :cdesen, :codabi, :codcab, :cdiban, :cdvett, :cdagen, :cdblco,
          :dtblco, :provvi, :cddesm, :dtvali, :newcod, :priori, :cdetic, :latitu, :longit, :notdes, :cdage2, :cdage3,
          :cdage4, :cdage5, :indpec)
          ON DUPLICATE KEY UPDATE descri = :descri, desvid = :desvid, indiri = :indiri, codcap = :codcap,
          ccitta = :ccitta, provin = :provin, cdnazi = :cdnazi, idlang = :idlang, cdzona = :cdzona, pariva = :pariva,
          codfis = :codfis, numtel = :numtel, numcel = :numcel, numfax = :numfax, intern = :intern, indema = :indema,
          percon = :percon, cdvalu = :cdvalu, tpaggc = :tpaggc, nulist = :nulist, nuscon = :nuscon, scont1 = :scont1,
          scont2 = :scont2, scont3 = :scont3, tpport = :tpport, tppaga = :tppaga, cdesen = :cdesen, codabi = :codabi,
          codcab = :codcab, cdiban = :cdiban, cdvett = :cdvett, cdagen = :cdagen, cdblco = :cdblcoUpdate, dtblco = :dtblco,
          provvi = :provvi, cddesm = :cddesm, dtvali = :dtvali, newcod = :newcod, priori = :priori, cdetic = :cdetic,
          latitu = :latitu, longit = :longit, notdes = :notdes, cdage2 = :cdage2, cdage3 = :cdage3, cdage4 = :cdage4,
          cdage5 = :cdage5, indpec = :indpec";
                    $params = array(
                        'tpanag' => 'CL',
                        'cdanag' => trim($data[0]),
                        'descri' => trim($data[2]),
                        'desvid' => trim($data[2]),
                        'indiri' => trim($data[4]),
                        'codcap' => trim($data[5]),
                        'ccitta' => trim($data[6]),
                        'provin' => trim($data[7]),
                        'cdnazi' => $cdnazi,
                        'idlang' => $idlang,
                        'cdzona' => trim($data[14]),
                        'pariva' => trim($data[10]),
                        'codfis' => trim($data[9]),
                        'numtel' => trim($data[11]),
                        'numcel' => '',
                        'numfax' => '',
                        'intern' => '',
                        'indema' => '',
                        'percon' => '',
                        'cdvalu' => '',
                        'tpaggc' => '',
                        'nulist' => trim($data[12]),
                        'nuscon' => 0,
                        'scont1' => 0,
                        'scont2' => 0,
                        'scont3' => 0,
                        'tpport' => '',
                        'tppaga' => trim($data[13]),
                        'cdesen' => '',
                        'codabi' => 0,
                        'codcab' => 0,
                        'cdiban' => '',
                        'cdvett' => '',
                        'cdagen' => trim($data[1]),
                        'cdblco' => 0,
                        'cdblcoUpdate' => 0,
                        'dtblco' => '',
                        'provvi' => 0,
                        'cddesm' => 0,
                        'dtvali' => '',
                        'newcod' => 0,
                        'priori' => '',
                        'cdetic' => '',
                        'latitu' => 0,
                        'longit' => 0,
                        'notdes' => trim($data[3]),
                        'cdage2' => '',
                        'cdage3' => '',
                        'cdage4' => '',
                        'cdage5' => '',
                        'indpec' => '',
                    );

                    $paramMenageCustomer = (new Utility())->getAppSettings('ManageCustomerStatus');
                    if ($paramMenageCustomer != 0) {
                        // Modifica LAR 31/05/2023 Smettiamo di 'Leggere' questo dato per evitare sovrascritture dall'esterno
                        $params['cdblcoUpdate'] = new \Phalcon\Db\RawValue('COALESCE(cdblco, 0)');
                    }

                    Di::getDefault()->get('db')->query($query, $params);

                    // Tppaga
                    $query = "INSERT INTO tppaga (tppaga, dspaga, seqrap, tpeffe, scpaga,
          peracc, defcon, tpindo)
          VALUES (:tppaga, :dspaga, :seqrap, :tpeffe, :scpaga, :peracc, :defcon, :tpindo)
          ON DUPLICATE KEY UPDATE dspaga = :dspaga, seqrap = :seqrap,
          tpeffe = :tpeffe, scpaga = :scpaga, peracc = :peracc,
          defcon = :defcon, tpindo = :tpindo";
                    $params = array(
                        'tppaga' => trim($data[13]),
                        'dspaga' => trim($data[13]),
                        'seqrap' => 0,
                        'tpeffe' => '',
                        'scpaga' => 0,
                        'peracc' => 0,
                        'defcon' => 0,
                        'tpindo' => '',
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    if ($echo) {
                        echo "$fileCus Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileCus, $newFileCus);

                if ($echo) {
                    echo "Anagra, Tppaga synchronized!\n";
                }
            }

            // Ananaz
            $query = "INSERT IGNORE INTO ananaz (cdnazi, dsnazi, seqrap)
      VALUES
      ('AD', 'Andorra', 0), ('AE', 'Emirati Arabi Uniti', 0), ('AF', 'Afghanistan', 0), ('AG', 'Antigua e Barbuda', 0),
      ('AI', 'Anguilla', 0), ('AL', 'Albania', 0), ('AM', 'Armenia', 0), ('AN', 'Antille Olandesi', 0),
      ('AO', 'Angola', 0), ('AQ', 'Antartide', 0), ('AR', 'Argentina', 0), ('AS', 'Samoa Americane', 0),
      ('AT', 'Austria', 0), ('AU', 'Australia', 0), ('AW', 'Aruba', 0), ('AZ', 'Azerbaijan', 0),
      ('BA', 'Bosnia Erzegovina', 0), ('BB', 'Barbados', 0), ('BD', 'Bangladesh', 0), ('BE', 'Belgio', 0),
      ('BF', 'Burkina Faso', 0), ('BG', 'Bulgaria', 0), ('BH', 'Bahrain', 0), ('BI', 'Burundi', 0),
      ('BJ', 'Benin', 0), ('BM', 'Bermuda', 0), ('BN', 'Brunei Darussalam', 0), ('BO', 'Bolivia', 0),
      ('BR', 'Brasile', 0), ('BS', 'Bahamas', 0), ('BT', 'Bhutan', 0),  ('BV', 'Isola Bouvet', 0),
      ('BW', 'Botswana', 0), ('BY', 'Bielorussia', 0), ('BZ', 'Belize', 0), ('CA', 'Canada', 0),
      ('CC', 'Isole Cocos', 0), ('CD', 'Congo', 0), ('CF', 'Repubblica Centroafr', 0), ('CG', 'Repubblica del Congo', 0),
      ('CH', 'Svizzera', 0), ('CI', 'Costa d\'Avorio', 0), ('CK', 'Isole Cook', 0), ('CL', 'Cile', 0),
      ('CM', 'Camerun', 0), ('CN', 'Cina', 0), ('CO', 'Colombia', 0), ('CR', 'Costa Rica', 0),
      ('CS', 'Serbia e Montenegro', 0), ('CU', 'Cuba', 0), ('CV', 'Capo Verde', 0), ('CX', 'Isola di Natale', 0),
      ('CY', 'Cipro', 0), ('CZ', 'Repubblica Ceca', 0), ('DE', 'Germania', 0), ('DJ', 'Gibuti', 0),
      ('DK', 'Danimarca', 0), ('DM', 'Dominica', 0), ('DO', 'Repubblica Dominican', 0), ('DZ', 'Algeria', 0),
      ('EC', 'Ecuador', 0), ('EE', 'Estonia', 0), ('EG', 'Egitto', 0), ('EH', 'Sahara Occidentale', 0),
      ('EL', 'Grecia', 0), ('ER', 'Eritrea', 0), ('ES', 'Spagna', 0), ('ET', 'Etiopia', 0),
      ('FI', 'Finlandia', 0), ('FJ', 'Fiji', 0), ('FK', 'Isole Falkland', 0), ('FM', 'Stati Federati della Micronesia', 0),
      ('FO', 'Isole Faroe', 0), ('FR', 'Francia', 0), ('GA', 'Gabon', 0), ('GB', 'Regno Unito', 0),
      ('GD', 'Grenada', 0), ('GE', 'Georgia', 0), ('GF', 'Guyana Francese', 0), ('GG', 'Guersney', 0),
      ('GH', 'Ghana', 0), ('GI', 'Gibilterra', 0), ('GL', 'Groenlandia', 0), ('GM', 'Gambia', 0),
      ('GN', 'Guinea', 0), ('GP', 'Guadalupa', 0), ('GQ', 'Guinea Equatoriale', 0), ('GR', 'Grecia', 0),
      ('GS', 'Sud Georgia e Isole', 0), ('GT', 'Guatemala', 0), ('GU', 'Guam', 0), ('GW', 'Guinea-Bissau', 0),
      ('GY', 'Guyana', 0), ('HK', 'Hong Kong', 0), ('HM', 'Isola Heard e Isole', 0), ('HN', 'Honduras', 0),
      ('HR', 'Croazia', 0), ('HT', 'Haiti', 0), ('HU', 'Ungheria', 0), ('ID', 'Indonesia', 0),
      ('IE', 'Irlanda', 0), ('IL', 'Israele', 0), ('IN', 'India', 0), ('IO', 'T.Britannici Oceano', 0),
      ('IQ', 'Iraq', 0), ('IR', 'Iran', 0), ('IS', 'Islanda', 0), ('IT', 'Italia', 0),
      ('JM', 'Giamaica', 0), ('JO', 'Giordania', 0), ('JP', 'Giappone', 0), ('KE', 'Kenya', 0),
      ('KG', 'Kirghizistan', 0), ('KH', 'Cambogia', 0), ('KI', 'Kiribati', 0), ('KM', 'Comore', 0),
      ('KN', 'Saint Kitts e Nevis', 0), ('KP', 'Korea', 0), ('KR', 'Corea del Sud', 0), ('KW', 'Kuwait', 0),
      ('KY', 'Isole Cayman', 0), ('KZ', 'Kazakhistan', 0), ('LA', 'Laos', 0), ('LB', 'Libano', 0),
      ('LC', 'Santa Lucia', 0), ('LI', 'Liechtenstein', 0), ('LK', 'Sri Lanka', 0), ('LR', 'Liberia', 0),
      ('LS', 'Lesotho', 0), ('LT', 'Lituania', 0), ('LU', 'Lussemburgo', 0), ('LV', 'Lettonia', 0),
      ('LY', 'Libia', 0), ('MA', 'Marocco', 0), ('MC', 'Monaco', 0), ('MD', 'Moldavia', 0),
      ('MG', 'Madagascar', 0), ('MH', 'Isole Marshall', 0), ('MK', 'Macedonia', 0), ('ML', 'Mali', 0),
      ('MM', 'Myanmar', 0), ('MN', 'Mongolia', 0), ('MO', 'Macao', 0), ('MP', 'Isole Marianne Settentrionali', 0),
      ('MQ', 'Martinica', 0), ('MR', 'Mauritania', 0), ('MS', 'Montserrat', 0), ('MT', 'Malta', 0),
      ('MU', 'Mauritius', 0), ('MV', 'Maldive', 0), ('MW', 'Malawi', 0), ('MX', 'Messico', 0),
      ('MY', 'Malesia', 0), ('MZ', 'Mozambico', 0), ('NA', 'Namibia', 0), ('NC', 'Nuova Caledonia', 0),
      ('NE', 'Niger', 0), ('NF', 'Isola Norfolk', 0), ('NG', 'Nigeria', 0), ('NI', 'Nicaragua', 0),
      ('NL', 'Olanda', 0), ('NO', 'Norvegia', 0), ('NP', 'Nepal', 0), ('NR', 'Nauru', 0),
      ('NU', 'Niue', 0), ('NZ', 'Nuova Zelanda', 0), ('OM', 'Oman', 0), ('PA', 'Panama', 0),
      ('PE', 'Peru', 0), ('PF', 'Polinesia Francese', 0), ('PG', 'Papua Nuova Guinea', 0), ('PH', 'Filippine', 0),
      ('PK', 'Pakistan', 0), ('PL', 'Polonia', 0), ('PM', 'Saint Pierre e Mique', 0), ('PN', 'Pitcairn', 0),
      ('PR', 'Porto Rico', 0), ('PS', 'Territori Palestinesi', 0), ('PT', 'Portogallo', 0), ('PW', 'Palau', 0),
      ('PY', 'Paraguay', 0), ('QA', 'Qatar', 0), ('RE', 'Reunion', 0), ('RO', 'Romania', 0),
      ('RS', 'Serbia', 0), ('RU', 'Federazione Russa', 0), ('RW', 'Ruanda', 0), ('SA', 'Arabia Saudita', 0),
      ('SB', 'Isole Solomon', 0), ('SC', 'Seychelles', 0), ('SD', 'Sudan', 0), ('SE', 'Svezia', 0),
      ('SG', 'Singapore', 0), ('SH', 'Sant\'Elena', 0), ('SI', 'Slovenia', 0), ('SJ', 'Svalbard e Jan Mayen', 0),
      ('SK', 'Repubblica Slovacca', 0), ('SL', 'Sierra Leone', 0), ('SM', 'San Marino', 0), ('SN', 'Senegal', 0),
      ('SO', 'Somalia', 0), ('SR', 'Suriname', 0), ('ST', 'Sao Tome e Principe', 0), ('SV', 'El Salvador', 0),
      ('SY', 'Siria', 0), ('SZ', 'Swaziland', 0), ('TC', 'Isole Turks e Caicos', 0), ('TD', 'Ciad', 0),
      ('TF', 'Territori Francesi d\'Oltremare', 0), ('TG', 'Togo', 0), ('TH', 'Tailandia', 0), ('TJ', 'Tagikistan', 0),
      ('TK', 'Tokelau', 0), ('TL', 'Timor Est', 0), ('TM', 'Turkmenistan', 0), ('TN', 'Tunisia', 0),
      ('TO', 'Tonga', 0), ('TR', 'Turchia', 0), ('TT', 'Trinidad e Tobago', 0), ('TV', 'Tuvalu', 0),
      ('TW', 'Taiwan', 0), ('TZ', 'Tanzania', 0), ('UA', 'Ucraina', 0), ('UG', 'Uganda', 0),
      ('UK', 'Gran Bretagna', 0), ('UM', 'Isole Minori U.S.A.', 0), ('US', 'Stati Uniti d\'America', 0), ('UY', 'Uruguay', 0),
      ('UZ', 'Uzbekistan', 0), ('VA', 'Città del Vaticano', 0), ('VC', 'Saint Vincent e Grenada', 0), ('VE', 'Venezuela', 0),
      ('VG', 'Isole Vergini Britanniche', 0), ('VI', 'Isole Vergini Americane', 0), ('VN', 'Vietnam', 0), ('VU', 'Vanuatu', 0),
      ('WF', 'Wallis e Futuna', 0), ('WS', 'Samoa', 0), ('YE', 'Yemen', 0), ('YT', 'Mayotte', 0),
      ('ZA', 'Sud Africa', 0), ('ZM', 'Zambia', 0), ('ZW', 'Zimbabwe', 0);";
            Di::getDefault()->get('db')->query($query);

            if ($echo) {
                echo "Ananaz synchronized!\n";
            }

            // Anaper
            if (file_exists($fileFbr) && ($handle = fopen($fileFbr, 'r')) !== false) {
                $i = 1;
                \Go2B\Models\Anaart::blockAllArticles();
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (empty($data) || empty($data[0])) {
                        continue;
                    }
                    // Anaper
                    $query = "INSERT INTO anaper (cdpers, dspers, compos, flimag) VALUES (:cdpers, :dspers, :compos, :flimag)
                                ON DUPLICATE KEY UPDATE dspers = :dspers, compos = :compos, flimag = :flimag";
                    $params = array(
                        'cdpers' => trim($data[0]),
                        'dspers' => trim($data[6]),
                        'compos' => trim($data[4]) . ' ' . trim($data[5]),
                        'flimag' => '',
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    $varianteTessuto = trim($data[1]);
                    if (!empty($varianteTessuto)) { // Variante Tessuto 02/05/2024
                        $query = "INSERT INTO b2b_cusper (cdpers, additional_code) VALUES (:cdpers, :addcode)
                                    ON DUPLICATE KEY UPDATE additional_code = :addcode";
                        Di::getDefault()->get('db')->query($query, ['cdpers' => trim($data[0]), 'addcode' => $varianteTessuto]);
                    } else {
                        Di::getDefault()->get('db')->query("DELETE FROM b2b_cusper WHERE cdpers = :cdpers", ['cdpers' => trim($data[0])]);
                    }

                    // Anaart: unblock
                    $query = "UPDATE anaart SET flbloc = 0 WHERE cdpers = :cdpers";
                    $params = array(
                        'cdpers' => trim($data[0]),
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    // B2bAddinf
                    $query = "INSERT INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore) VALUES (:tabell, :codic1, '', :tpdato, :valore)
                                ON DUPLICATE KEY UPDATE valore = :valore";
                    $params = array(
                        'tabell' => 'anaper',
                        'codic1' => trim($data[0]),
                        'tpdato' => 'cddrop',
                        'valore' => trim($data[20]),
                    );
                    Di::getDefault()->get('db')->query($query, $params);

                    if ($echo) {
                        echo "$fileFbr Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileFbr, $newFileFbr);

                if ($echo) {
                    echo "Anaper+B2bAddinf synchronized!\n";
                }
            }

            // B2bAddinf
            if (file_exists($file360) && ($handle = fopen($file360, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // B2bAddinf
                        $query = "INSERT INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore)
           VALUES (:tabell, :codic1, '', :tpdato, :valore)
           ON DUPLICATE KEY UPDATE valore = :valore";
                        $params = array(
                            'tabell' => 'tipolo',
                            'codic1' => trim($data[0]),
                            'tpdato' => 'fl360d',
                            'valore' => trim($data[1]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);
                    }

                    if ($echo) {
                        echo "$file360 Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($file360, $newFile360);

                if ($echo) {
                    echo "B2bAddinf (360° files) synchronized!\n";
                }
            }

            if (file_exists($fileDat) && ($handle = fopen($fileDat, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // B2bAddinf
                        $query = "INSERT INTO b2b_addinf (tabell, codic1, codic2, tpdato, valore)
           VALUES (:tabell, :codic1, :codic2, :tpdato, :valore)
           ON DUPLICATE KEY UPDATE valore = :valore";
                        $params = array(
                            'tabell' => 'anaart',
                            'codic1' => trim($data[0]) . ' ' . trim($data[1]),
                            'codic2' => trim($data[2]),
                            'tpdato' => 'dtmcli',
                            'valore' => trim($data[3]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);
                    }

                    if ($echo) {
                        echo "$fileDat Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileDat, $newFileDat);

                if ($echo) {
                    echo "B2bAddinf (Delivery Drop) synchronized!\n";
                }
            }

            if (file_exists($fileImg) && ($handle = fopen($fileImg, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // Imgart
                        $query = "INSERT INTO imgart (tpimag, codic1, codic2, seqrap, flimag)
           VALUES (:tpimag, :codic1, :codic2, :seqrap, :flimag)
           ON DUPLICATE KEY UPDATE flimag = :flimag";
                        $params = array(
                            'tpimag' => 'ARTP',
                            'codic1' => trim($data[0]),
                            'codic2' => trim($data[1]),
                            'seqrap' => 0,
                            'flimag' => trim($data[2]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);
                    }

                    if ($echo) {
                        echo "$fileImg Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileImg, $newFileImg);

                if ($echo) {
                    echo "Imgart (fabric + color) synchronized!\n";
                }
            }

            if (file_exists($fileBud) && ($handle = fopen($fileBud, 'r')) !== false) {
                $i = 1;
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        // B2BBgtest
                        $query = "INSERT INTO b2b_bgtest (nubudg, tpanag, cdanag, cdtitl,
            cdlinm, cdserm, cduscc, cdstag, qtabdg, valbdg, qtatrg, valtrg)
            VALUES (null, :tpanag, :cdanag, :cdtitl, :cdlinm, :cdserm,
            :cduscc, :cdstag, :qtabdg, :valbdg, :qtatrg, :valtrg)
            ON DUPLICATE KEY UPDATE qtabdg = :qtabdg, valbdg = :valbdg,
            qtatrg = :qtatrg, valtrg = :valtrg";
                        $params = array(
                            'tpanag' => 'CL',
                            'cdanag' => trim($data[0]),
                            'cdtitl' => 'LAR',
                            'cdlinm' => trim($data[1]),
                            'cdserm' => '',
                            'cduscc' => trim($data[2]),
                            'cdstag' => trim($data[3]),
                            'qtabdg' => trim($data[4]),
                            'valbdg' => trim($data[5]),
                            'qtatrg' => trim($data[6]),
                            'valtrg' => trim($data[7]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);

                        $query = "INSERT INTO b2b_bgcorp (nubudg, tpanag, cdstag, qtabdg, valbdg)
            SELECT nubudg, :cdstg1, :qtast1, :valst1
            FROM b2b_bgtest
            WHERE tpanag = :tpanag AND cdanag = :cdanag AND cdtitl = :cdtitl
            AND cdlinm = :cdlinm AND cdserm = :cdserm AND cduscc = :cduscc AND cdstag = :cdstag
            ON DUPLICATE KEY UPDATE qtastg = :qtast1, valstg = :valst1";
                        $params = array(
                            'tpanag' => 'CL',
                            'cdanag' => trim($data[0]),
                            'cdtitl' => 'LAR',
                            'cdlinm' => trim($data[1]),
                            'cdserm' => '',
                            'cduscc' => trim($data[2]),
                            'cdstag' => trim($data[3]),
                            'cdstg1' => trim($data[8]),
                            'qtast1' => trim($data[9]),
                            'valst1' => trim($data[10]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);

                        $query = "INSERT INTO b2b_bgcorp (nubudg, tpanag, cdstag, qtabdg, valbdg)
            SELECT nubudg, :cdstg2, :qtast2, :valst2
            FROM b2b_bgtest
            WHERE tpanag = :tpanag AND cdanag = :cdanag AND cdtitl = :cdtitl
            AND cdlinm = :cdlinm AND cdserm = :cdserm AND cduscc = :cduscc AND cdstag = :cdstag
            ON DUPLICATE KEY UPDATE qtastg = :qtast2, valstg = :valst2";
                        $params = array(
                            'tpanag' => 'CL',
                            'cdanag' => trim($data[0]),
                            'cdtitl' => 'LAR',
                            'cdlinm' => trim($data[1]),
                            'cdserm' => '',
                            'cduscc' => trim($data[2]),
                            'cdstag' => trim($data[3]),
                            'cdstg2' => trim($data[11]),
                            'qtast2' => trim($data[12]),
                            'valst2' => trim($data[13]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);

                        $query = "INSERT INTO b2b_bgcorp (nubudg, tpanag, cdstag, qtabdg, valbdg)
            SELECT nubudg, :cdstg3, :qtast3, :valst3
            FROM b2b_bgtest
            WHERE tpanag = :tpanag AND cdanag = :cdanag AND cdtitl = :cdtitl
            AND cdlinm = :cdlinm AND cdserm = :cdserm AND cduscc = :cduscc AND cdstag = :cdstag
            ON DUPLICATE KEY UPDATE qtastg = :qtast3, valstg = :valst3";
                        $params = array(
                            'tpanag' => 'CL',
                            'cdanag' => trim($data[0]),
                            'cdtitl' => 'LAR',
                            'cdlinm' => trim($data[1]),
                            'cdserm' => '',
                            'cduscc' => trim($data[2]),
                            'cdstag' => trim($data[3]),
                            'cdstg3' => trim($data[14]),
                            'qtast3' => trim($data[15]),
                            'valst3' => trim($data[16]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);

                        $query = "INSERT INTO b2b_bgcorp (nubudg, tpanag, cdstag, qtabdg, valbdg)
            SELECT nubudg, :cdstg4, :qtast4, :valst4
            FROM b2b_bgtest
            WHERE tpanag = :tpanag AND cdanag = :cdanag AND cdtitl = :cdtitl
            AND cdlinm = :cdlinm AND cdserm = :cdserm AND cduscc = :cduscc AND cdstag = :cdstag
            ON DUPLICATE KEY UPDATE qtastg = :qtast4, valstg = :valst4";
                        $params = array(
                            'tpanag' => 'CL',
                            'cdanag' => trim($data[0]),
                            'cdtitl' => 'LAR',
                            'cdlinm' => trim($data[1]),
                            'cdserm' => '',
                            'cduscc' => trim($data[2]),
                            'cdstag' => trim($data[3]),
                            'cdstg4' => trim($data[17]),
                            'qtast4' => trim($data[18]),
                            'valst4' => trim($data[19]),
                        );
                        Di::getDefault()->get('db')->query($query, $params);
                    }

                    if ($echo) {
                        echo "$fileBud Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileBud, $newFileBud);

                if ($echo) {
                    echo "B2bBudget synchronized!\n";
                }
            }

            if (file_exists($fileTag) && ($handle = fopen($fileTag, 'r')) !== false) {
                $i = 1;
                \Go2B\Models\Artcla::emptyTags();
                while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                    if (trim($data[0]) != '') {
                        $query = "INSERT INTO artcla (tpinpu, codice, tpclas, valore)
            VALUES (:tpinpu, :codice, :tpclas, :valore)
            ON DUPLICATE KEY UPDATE valore = :valore";

                        if (trim($data[1]) != '') {
                            // Artcla
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpclas' => 'TB2B',
                                'valore' => trim($data[1]),
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                        if (trim($data[2]) != '') {
                            // Artcla
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpclas' => 'TB2C',
                                'valore' => trim($data[2]),
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                        if (trim($data[3]) != '') {
                            // Artcla
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpclas' => 'TB2D',
                                'valore' => trim($data[3]),
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                        if (trim($data[4]) != '') {
                            // Artcla
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpclas' => 'TB2E',
                                'valore' => trim($data[4]),
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                        if (trim($data[5]) != '') {
                            // Artcla
                            $params = array(
                                'tpinpu' => 'AR',
                                'codice' => trim($data[0]),
                                'tpclas' => 'TB2F',
                                'valore' => trim($data[5]),
                            );
                            Di::getDefault()->get('db')->query($query, $params);
                        }
                    }

                    if ($echo) {
                        echo "$fileTag Row $i \n";
                        $i++;
                    }
                }
                fclose($handle);
                rename($fileTag, $newFileTag);

                if ($echo) {
                    echo "Artcla synchronized!\n";
                }
            }

            // POST IMPORT
            if ($echo) {
                echo "Post-import-operations starting...\n";
            }

            $query = "UPDATE anaart aa
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      SET aa.dsarti = tp.dsartn";
            Di::getDefault()->get('db')->query($query);
            if ($echo) {
                echo "Anaart descriptions updated!\n";
            }

            if ($echo) {
                echo "Post-import-operations done!\n";
            }
        } catch (\Exception $exception) {
            echo $exception->getTraceAsString() . "\n";
        }

        Di::getDefault()->get('db')->close();
    }
}
