<?php

namespace Go2B\Tasks;

use Go2B\Controllers\Utility;
use Go2B\Models\Octest;

class CoreTask extends \Phalcon\CLI\Task
{

    /**
     * Azione da eseguire ogni minuto nei cron di sistema,
     * poi decideremo internamente quali processi lanciare e quando
     *
     * @return void
     */
    public function mainAction()
    {
        echo 'Nothing to do' . PHP_EOL;
    }


    // TODO per gestire al meglio i carrelli abbandonati dovremmo salvare le date di notifica su una tabella apposita e, prima di annullare l'ordine, controllare che l'utente non lo abbia ri-modificato dall'ultima notifica, altrimenti gli dovremmo mandare una nuova notifica e così via
    public function abandonedAction($rawData = '')
    {
        $utility = new Utility();
        $timeoutSettings = $utility->getAppSettings('CartTimeout') ?: 0;
        $timeout = $timeoutSettings * 60;
        if ($timeout > 0) {
            $db = $this->di->get('db');
            $query = 'SELECT o.nuordc, o.closure_notified, o.last_edit, MAX(oi.last_edit) last_edit_item
              FROM octest o
              LEFT JOIN occorp oi ON (o.nuordc = oi.nuordc)
              WHERE o.status = 0 GROUP BY o.nuordc';
            $ordineApertiConDataEdit = $db->query($query)->fetchAll();
            echo 'Trovati n.' . count($ordineApertiConDataEdit) . ' Ordini aperti' . PHP_EOL;
            $now = time();

            $idNotificati = [];
            foreach ($ordineApertiConDataEdit as $ordineAperto) {
                $editTime = max(
                    intval(strtotime($ordineAperto['last_edit'])),
                    intval(strtotime($ordineAperto['last_edit_item']))
                );
                $timeDiff = abs($editTime - $now);

                if ($timeDiff >= $timeout) {
                    // Se non è mai stato notificato prima di tutto lo notifichiamo, al prossimo timeout verrà annullato
                    if ($ordineAperto['closure_notified'] == 0) {
                        echo 'Invio mail per ordine n.' . $ordineAperto['id'] . PHP_EOL;
                        $utility->sendAbandonedOrderClosureEmail($ordineAperto['nuordc'], $now + $timeout);
                        $idNotificati[] = $ordineAperto['nuordc'];
                    } else {
                        if (Octest::findFirstByNuordc($ordineAperto['nuordc'])->delete()) {
                            echo 'Chiuso ordine n.' . $ordineAperto['nuordc'] . PHP_EOL;
                        } else {
                            echo 'Errore nella chiusura ordine n.' . $ordineAperto['nuordc'] . PHP_EOL;
                        }
                    }
                }

            }

            if (!empty($idNotificati)) {
                $db->query('UPDATE octest SET closure_notified = 1 WHERE nuordc IN (' . implode(',', $idNotificati) . ')');
            }
        } else {
            echo 'Timeout ordini disattivato' . PHP_EOL;
        }
    }

}
