<?php

namespace Go2B\Tasks;

use Go2B\Controllers\ControllerBase;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Octagl;
use Phalcon\CLI\Task;

class AgingTask extends Task
{
  public function mainAction() {
    echo "\n*** CHECKING ORDERS AGING starting ... ***\n\n";

    $to_time = strtotime(date("Y-m-d H:i:s"));

    echo "START " . date("Y-m-d H:i:s") . "\n";

    set_time_limit(0);
    try {
      $this->deleteOrders(0); // cart orders
      $this->emptyOrders(1);  // save orders
    } catch (\Exception $e) {
      var_dump($e);
    }
    set_time_limit(30);

    $from_time = strtotime(date("Y-m-d H:i:s"));
    echo "END " . date("Y-m-d H:i:s") . "\n";

    echo "\n" . round(abs($to_time - $from_time) / 60, 2). " minute\n";
  }

  function deleteOrders($flstat) {
    echo "Deleting orders older than 2 days\n";

    $today = date("Y-m-d");
    $sql = "SELECT ot.nuordc FROM octest ot WHERE DATEDIFF('$today', ot.dtmcli) > 2 AND ot.flstat = :flstat";
    $octest = Di::getDefault()->get('db')->query($sql, array('flstat' => $flstat))->fetchAll();

    echo "Found ". count($octest) . " order\s to delete\n";

    if (count($octest) > 0) {
      foreach ($octest as $order) {
        $ocproc = Ocproc::findByNuordc($order->nuordc);
        $ocproc->delete();
        $ocprot = Ocprot::findByNuordc($order->nuordc);
        $ocprot->delete();

        $occorp = Occorp::findByNuordc($order->nuordc);
        if (count($occorp) > 0) {
          foreach ($occorp as $row) {
            $octagl = Octagl::findByNurorc($row->nurorc);
            $octagl->delete();
            $ocasso = Ocasso::findByNurorc($row->nurorc);
            $ocasso->delete();
          }
          $occorp->delete();
        }
      }
      $octest->delete();
    }
  }

  function emptyOrders($flstat) {
    $utility = new Utility();
    $days = $utility->getAppSettings('ParamAvailabilityDateManagement');

    echo "Emptying orders row for orders older than " . $days . " days\n";

    $today = date("Y-m-d");
    $sql = "SELECT ot.nuordc FROM octest ot WHERE DATEDIFF('$today', ot.dtmcli) > :dtspan AND ot.flstat = :flstat";
    $octest = Di::getDefault()->get('db')->query($sql, array('flstat' => $flstat, 'dtspan' => $days))->fetchAll();

    echo "Found ". count($octest) . " order\s to empty\n";

    if (count($octest) > 0) {
      foreach ($octest as $order) {
        $ocproc = Ocproc::findByNuordc($order->nuordc);
        $ocproc->delete();
        $ocprot = Ocprot::findByNuordc($order->nuordc);
        $ocprot->delete();

        $occorp = Occorp::findByNuordc($order->nuordc);
        if (count($occorp) > 0) {
          foreach ($occorp as $row) {
            $octagl = Octagl::findByNurorc($row->nurorc);
            $octagl->delete();
            $ocasso = Ocasso::findByNurorc($row->nurorc);
            $ocasso->delete();
            $occorp->quanti = 0;
            $occorp->save();
          }
        }
      }
    }
  }
}
