<?php
/**
 * @author      Alex Bilbie <hello@alexbilbie.com>
 * @copyright   Copyright (c) Alex Bilbie
 * @license     http://mit-license.org/
 *
 * @link        https://github.com/thephpleague/oauth2-server
 */

namespace Rest\Components\Repositories;

use League\OAuth2\Server\Entities\ClientEntityInterface;
use League\OAuth2\Server\Repositories\ScopeRepositoryInterface;
use Rest\Components\Entities\ScopeEntity;

class ScopeRepository implements ScopeRepositoryInterface
{
  /**
   * {@inheritdoc}
   */
  public function getScopeEntityByIdentifier($scopeIdentifier) {
    $scopes = [
      'basic' => [
        'description' => 'Basic details about you',
      ],
      'email' => [
        'description' => 'Your email address',
      ],
    ];

    if (array_key_exists($scopeIdentifier, $scopes) === false) {
      return;
    }

    $scope = new ScopeEntity();
    $scope->setIdentifier($scopeIdentifier);

    return $scope;
  }

  /**
   * {@inheritdoc}
   */
  public function finalizeScopes(
    array $scopes,
    $grantType,
    ClientEntityInterface $clientEntity,
    $userIdentifier = null
  ) {
    return $scopes;
  }
}
