<?php

namespace Rest\Components\Repositories;

use Go2B\Models\ApiClient;
use League\OAuth2\Server\Repositories\ClientRepositoryInterface;
use Phalcon\Security;
use Rest\Components\Entities\ClientEntity;
use Phalcon\Di\FactoryDefault as Di;

class ClientRepository implements ClientRepositoryInterface
{
  public function getClientEntity($clientIdentifier, $grantType, $clientSecret = null, $mustValidateSecret = true) {
    $di = new Di();
    $security = $di->getShared('security');
    $client = ApiClient::query()
      ->where("name = :name:")
      ->bind([
        'name' => $clientIdentifier
      ])
      ->limit(1)
      ->execute()
      ->toArray();

    $correctDetails = false;
    if (count($client) === 1) {
      $client = current($client);

      if ($mustValidateSecret) {
        if ($security->checkHash($clientSecret, $client['secret'])) {
          $correctDetails = true;
        } else {
          $security->hash(rand());
        }
      } else {
        $correctDetails = true;
      }
    } else {
      // prevent timing attacks
      $security->hash(rand());
    }

    if ($correctDetails) {
      $clientEntity = new ClientEntity();
      $clientEntity->setIdentifier($clientIdentifier);
      $clientEntity->setName($client['name']);
      $clientEntity->setRedirectUri($client['redirectUrl']);
      return $clientEntity;
    }

    return null;
  }
}
