<?php
/**
 * @author      Alex Bilbie <hello@alexbilbie.com>
 * @copyright   Copyright (c) Alex Bilbie
 * @license     http://mit-license.org/
 *
 * @link        https://github.com/thephpleague/oauth2-server
 */

namespace Rest\Components\Entities;

use League\OAuth2\Server\Entities\UserEntityInterface;

class UserEntity implements UserEntityInterface
{
  private $user;

  public function __construct($userArray) {
    $this->user = $userArray;
  }

  /**
   * Return the user's identifier.
   *
   * @return mixed
   */
  public function getIdentifier() {
    return $this->user['id'];
  }
}
