<?php

namespace Go2B\Plugins;

use Go2B\Controllers\ErrorsController;
use Go2B\Controllers\SessionController;
use Go2B\Controllers\Utility;
use Phalcon\Acl;
use Phalcon\Acl\Role;
use Phalcon\Acl\Resource;
use Phalcon\Events\Event;
use Phalcon\Http\Request;
use Phalcon\Mvc\User\Plugin;
use Phalcon\Mvc\Dispatcher;
use Phalcon\Acl\Adapter\Memory as AclList;

/**
 * SecurityPlugin
 *
 * This is the security plugin which controls that users only have access to the modules they're assigned to
 */
class SecurityPlugin extends Plugin
{
    const ACL_FILENAME = "cache/acl/acl.data";
    const ACL_FILE_UPTIME = 86400; // 1 day

    /**
     * Returns an existing or new access control list
     *
     * @returns AclList
     */
    public function getAcl()
    {
        //Check whether acl data already exist
        //if (!isset($this->persistent->acl)) {
        if (empty(self::ACL_FILENAME) || $this->diskManager->getModFileTime(self::ACL_FILENAME) + self::ACL_FILE_UPTIME < time()) {
            $acl = new AclList();
            $acl->setDefaultAction(Acl::DENY);

            // Register roles
            $roles = [
                'Admin' => new Role(
                    'Admin',
                    'Only admin section, granted after sign in.'
                ),
                'Users' => new Role(
                    'Users',
                    'Member privileges, granted after sign in.'
                ),
                'Support' => new Role(
                    'Support',
                    'Only support section, granted after sign in.'
                ),
                'Guests' => new Role(
                    'Guests',
                    'Anyone browsing the site who is not signed in is considered to be a "Guest".'
                )
            ];

            foreach ($roles as $role) {
                $acl->addRole($role);
            }

            $admin = array(
                'addRowToOrder',
                'admin',
                'users',
                'agents',
                'analysis',
                'assignAllImages',
                'bannereditor',
                'blockedItems',
                'budget',
                'bulkstatus',
                'catalogspage',
                'categoryBanner',
                'changecustomdiscountstatus',
                'checkPrices',
                'colorpicker',
                'coupon',
                'createCoupon',
                'createCustomerUser',
                'createCustomerUsers',
                'resetUsersPassword',
                'updateCustomersBanStatus',
                'updateCustomersLoginStatus',
                'createuserage',
                'createuserdsm',
                'createusersdsm',
                'createXlsForStats',
                'customdiscountlist',
                'customers',
                'customersTableContent',
                'customersTableExport',
                'customfamily',
                'customflt',
                'customgroup',
                'customMenu',
                'customPayment',
                'customShipment',
                'customvar',
                'customVariants',
                'customVariantsBis',
                'dashboard',
                'defaultConditions',
                'deleteCoupons',
                'deleteCustomDiscount',
                'deleteCustomerShipping',
                'deleteCustomFilter',
                'deleteCustomPayment',
                'deleteCustomShipment',
                'deleteCustomVar',
                'deleteCustomVarFamily',
                'deleteCustomVarGroup',
                'deleteCustomVariant',
                'deleteFile',
                'deleteGallery',
                'deleteMultipleOrderRows',
                'deleteNewCustomer',
                'deleteOrder',
                'deleteOrderRowsWithNoQuantity',
                'deletePdfConditions',
                'deleteReqAccess',
                'deleteSpecialSelection',
                'deleteUser',
                'dolinkcatalogs',
                'downloadAllOrdersXls',
                'downloadAnalysisXls',
                'downloadBudgetXls',
                'downloadCheckPricesCsv',
                'downloadCustomVariantsCsv',
                'downloadJoorXlsOrder',
                'downloadModinfXlsTemplate',
                'downloadOrderXlsTemplate',
                'duplicateOrder',
                'editAgent',
                'editCustomDiscount',
                'editCustomerShipping',
                'editCustomVar',
                'editCustomVarFamily',
                'editCustomVarGroup',
                'editSpecialSelection',
                'editUser',
                'elaborateAnalysis',
                'emptyAdditionalImages',
                'emptyPrices',
                'emptyCustomvar',
                'featured',
                'filterVisibility',
                'gallery',
                'galleries',
                'getAnalysisForAgent',
                'getAnalysisForCustomer',
                'getBlockElements',
                'getCategoryBanners',
                'getColorsForCurrentArticle',
                'getCoupon',
                'getCustomFilters',
                'getCustomerDetail',
                'getCustomersSearchCount',
                'getFilteredOrders',
                'getGalleries',
                'getItemsForRules',
                'getLocalization',
                'getNewBlockForHomepage',
                'getNewShippingFormForCustomer',
                'getNewUserFormForAgent',
                'getOrderDetail',
                'getOrderRowAvailableVariants',
                'getOrderRowSizes',
                'getPdfConditions',
                'getSalesAnalysis',
                'getShippingsForCustomer',
                'getShippingsForDuplicateOrder',
                'getSpecialSelectionForCatalog',
                'getUsersForAgent',
                'getVariantsForCurrentArticleAndColor',
                'getWhoseForOrders',
                'imageManager',
                'importExport',
                'linkcatalogs',
                'loadBudgetForCustomer',
                'loadCustomDetail',
                'loadCustomMenuForCatalog',
                'loadGlobalBudget',
                'loadHomepageCatalog',
                'loadModels',
                'localization',
                'managementParams',
                'media',
                'modifyCoupon',
                'modifyCustomFilter',
                'modifyModelInfo',
                'modifyStatus',
                'modifyLoginStatus',
                'newCatalogPresentationBox',
                'newCustomers',
                'noteseditor',
                'shipmentnoteseditor',
                'openorders',
                'order',
                'orders',
                'params',
                'pdfConditions',
                'procedures',
                'productinfo',
                'quantityrules',
                'reqaccess',
                'saveCatalogHomepage',
                'saveCatalogPresentationBox',
                'saveColors',
                'saveCustomDetail',
                'saveCustomDiscountBody',
                'saveCustomDiscountHeader',
                'saveCustomFilter',
                'saveCustomFilterBody',
                'saveCustomMenuForCatalog',
                'saveCustomPayment',
                'saveCustomShipment',
                'getCustomShipmentByTpport',
                'deleteCustomShipmentByTpport',
                'saveDefaultCatalog',
                'saveFilterVisibility',
                'saveGallery',
                'saveGalleryPoints',
                'saveLocalization',
                'savePdfConditions',
                'saveRules',
                'saveSpecialSelection',
                'sendCustomVariantsEmail',
                'saveNewAdmin',
                'sendNewCustomersEmail',
                'sendOrder',
                'setDefaultConditions',
                'setManaged',
                'settings',
                'shippings',
                'specialSelectionDetail',
                'specialSelections',
                'sync',
                'toggleProductBlockFlag',
                'updateUser',
                'updateBanner',
                'updateCategoryBanner',
                'updateBrandBanner',
                'updateCustomDiscount',
                'updateDashboard',
                'updateGalleryDescription',
                'updateGalleryImage',
                'updateGalleryOrder',
                'updateModelInfo',
                'updateMultipleOrderRows',
                'updateOrderHeader',
                'updateOrderRowDate',
                'updateOrderRowDiscount',
                'updateOrderRowNotes',
                'updateOrderRowSize',
                'updateOrderRowVariants',
                'updateOrderState',
                'updateParams',
                'updateSettings',
                'updateUtils',
                'uploadColorImage',
                'uploadFile',
                'uploadImage',
                'uploadImageBrand',
                'uploadLogo',
                'uploadProductDescriptions',
                'uploadTemplate',
                'uploadVariantImage',
                'saveBannerBrand',
                'loadBannerBrand',
                'classifications',
                'updateClassification',
                'translateStrings',
                'searchTranslationStrings',
                'updateTranslationString',
                'syncronize',
            );
            $gomanagement = array(
                'agentsList',
                'assignImageAutoAll',
                'availability',
                'brands',
                'catalogDetail',
                'catalogManager',
                'catalogSorting',
                'checkCatalogCode',
                'conditions',
                'createCatalog',
                'deleteAgent',
                'deleteArticleAvailability',
                'deleteBrand',
                'deleteSeason',
                'deleteCatalogs',
                'deleteDevice',
                'deleteExpirationCondition',
                'deleteFromCatalog',
                'deleteLine',
                'deleteLookbook',
                'deletePromo',
                'deleteScale',
                'deleteSeries',
                'deleteSpecialExpirationCondition',
                'devices',
                'downloadImageXlsTemplate',
                'downloadSortingCatalogXls',
                'editArticle',
                'editArticleAvailability',
                'editDevice',
                'editLookbook',
                'editModel',
                'editPromo',
                'expirations',
                'getAllImages',
                'getArticleAvailabilityToEdit',
                'getCatalogDetailArticles',
                'getCatalogDetailLines',
                'getCatalogDetailModels',
                'getCatalogDetailSeasons',
                'getCatalogSorting',
                'getCategoryDetail',
                'getCheckedConditions',
                'getColorsForLookFromModel',
                'getDeliveryDates',
                'getFabricsForLookFromModel',
                'getLookArticleCustomImages',
                'getLookbookItemsOptions',
                'getLookbookPage',
                'getModelsForLookFromSearch',
                'getSpecialDeliveryDates',
                'insertAgent',
                'insertArticlesToCatalog',
                'insertBrand',
                'insertSeason',
                'insertCatalog',
                'insertLine',
                'insertScale',
                'insertSeries',
                'lines',
                'loadArticlesAvailability',
                'loadArticlesWithEmptyAvailability',
                'lookbookManager',
                'promo',
                'saveCategoryImage',
                'saveDevice',
                'saveEditArticle',
                'saveEditLookbook',
                'saveEditModel',
                'saveExpirationCondition',
                'saveLookbook',
                'savePromo',
                'saveSpecialExpirationCondition',
                'saveSortedCatalog',
                'seasons',
                'series',
                'sizes',
                'updateAgent',
                'updateBrand',
                'updateSeason',
                'updateCatalog',
                'updateConditions',
                'updateDefaultConditions',
                'uploadImage',
                'updateLine',
                'updateScale',
                'updateSeries',
            );
            $session = array(
                'switch',
                'end',
            );
            $account = array(
                'changePassword',
                'downloadXlsTemplate',
                'info',
                'loadBudgetForCustomer',
                'loadCustomerInfo',
                'loadDeadlinesForCustomer',
                'loadHistory',
                'loadHistoryDetail',
                'sendEditRequest',
                'saveNewCustomer',
                'loadNewDesmerForm',
                'createNewDesmer',
            );
            $cart = array(
                'applyCoupon',
                'applyDiscounts',
                'changeIndicative',
                'completeOrder',
                'correctorderrow',
                'createOrder',
                'deleteCartRowsWithNoQuantity',
                'deleteCurrentOrder',
                'deleteorderrow',
                'downloadxlstemplate',
                'emptyorderrow',
                'executePayment',
                'getBulkInsertModal',
                'getDeliveryPeriodsOptions',
                'getDestinationsOptions',
                'getAnaregOptionsRules',
                'getModifyQuantityContent',
                'getModifyVariantsContent',
                'getOrderRowInfo',
                'getPromoDetail',
                'index',
                'loadPaypal',
                'modifyOrder',
                'payStripe',
                'recalculateOrderPrices',
                'refreshPromo',
                'removeCoupon',
                'sendOrder',
                'saveBulkQuantity',
                'saveModifyQuantity',
                'saveModifyVariants',
                'saverowsfrompromo',
                'setCurrentOrderDate',
                'setCurrentOrderDates',
                'toggleDiscounts',
                'updateCurrentOrderInfo',
                'updateOrderRowInfo',
                'updatePromoOrder',
                'updateRowShipping',
                'uploadcompiledtemplate',
            );
            $catalog = array(
                'availabilitylist',
                'changecatalog',
                'collection',
                'execExportAvailability',
                'exportAvailability',
                'execExportBrand',
                'exportBrand',
                'fabric',
                'fabricDetail',
                'findbarcode',
                'gallery',
                'getarticlefrombarcode',
                'getGalleryArticleModal',
                'getGalleryModelModal',
                'getInsertQuantityForGalleryArticle',
                'getInsertQuantityForGalleryModel',
                'getModelPreview',
                'index',
                'insertFromBarcode',
                'list',
                'loadFiltersCollection',
                'loadFiltersFabric',
                'loadFiltersSales',
                'loadFiltersSelection',
                'loadFiltersTag',
                'loadFiltersClassification',
                'look',
                'lookbook',
                'promo',
                'quickorder',
                'results',
                'resultsfabric',
                'resultslist',
                'resultsquickorder',
                'sales',
                'search',
                'searchFabric',
                'searchForQuickOrder',
                'selection',
                'setFilterFromHomepage',
                'setFilters',
                'tag',
                'classification',
            );
            $chat = array(
                'startchat',
                'updatechat',
                'addmessage'
            );
            $excel = array(
                'execDownloadAllOrdersXls',
                'execDownloadAnalysisXls',
                'execDownloadBudgetXls',
                'execDownloadImageXlsTemplate',
                'execDownloadJoorXlsOrder',
                'execDownloadSortingCatalogXls',
                'execDownloadXlsTemplateForNewOrder',
                'execDownloadXlsTemplateFromOrderList',
                'uploadCompiledXlsForCart',
                'uploadCompiledXlsTemplateForNewOrder',
                'uploadCompiledXlsTemplateFromAdmin',
                'uploadCompiledXlsTemplateFromOrderList',
                'uploadImageXlsTemplate',
                'uploadSortingCatalogXls',
                'uploadSpecialSelectionXls',
            );
            $info = array(
                'contacts',
                'salesconditions',
                'shipmentconditions',
            );
            $model = array(
                'deleteOrderRowFromArticleWizard',
                'fullscreen',
                'fullscreenvar',
                'getArticleImagesPreview',
                'getColorImagesPreview',
                'getComponentImages',
                'getComponentMaterial',
                'getCurrentArticle',
                'getCurrentArticleJson',
                'getCurrentDesiderata',
                'getCurrentDesiderataSizes',
                'getCustomConfigurationWizard',
                'getSizesForArticleWizard',
                'getSizesForConfiguratorWizard',
                'getSizesForFabricWizard',
                'getSizesFromColor',
                'img360',
                'index',
                'loadLinkedBuy',
                'loadQuickShop',
                'loadRecents',
                'loadRelated',
                'saveCustomArticle',
                'savedesiderataqty',
                'saveNewCustomFromConfigurator',
                'saveOrderRow',
                'saveOrderRows',
                'saveOrderRowsFromCurrentArticleJson',
                'saveOrderRowsFromArticleWizard',
                'saveOrderRowsFromFabricWizard',
                'wizard',
            );
            $pdf = array(
                'order',
                'tickler',
            );
            $statistics = array(
                'createxls',
                'detail',
                'getdashboard',
                'index',
            );
            /*
            $db = array(
                'getCatalogs'
            );
            $rest = array(
                'accessToken',
                'login',
                'renewToken'
            );*/

            // admin area resources
            $adminResources = array(
                'admin' => $admin,
                'gomanagement' => $gomanagement,
                'excel' => $excel,
                'session' => $session,
                'pdf' => array('orderFromAdmin'),
                'support' => array('index', 'chatAdmin', 'listAdmin', 'getchat', 'sendchat', 'uploadAttachment', 'updatestate', 'getOrderRowsForModal'),
            );
            foreach ($adminResources as $resource => $actions) {
                $acl->addResource(new Resource($resource), $actions);
            }

            // users area resources
            $usersResources = array(
                'account' => $account,
                'cart' => $cart,
                'catalog' => $catalog,
                'chat' => $chat,
                'excel' => $excel,
                'info' => $info,
                'model' => $model,
                'pdf' => $pdf,
                'statistics' => $statistics,
                'session' => $session,
                'support' => array('index', 'chat', 'list', 'getchat', 'sendchat', 'uploadAttachment', 'updatestate', 'getOrderRowsForModal', 'newTicket'),
            );
            foreach ($usersResources as $resource => $actions) {
                $acl->addResource(new Resource($resource), $actions);
            }

            // support area resources
            $supportResources = array(
                'session' => $session,
                'support' => array('index', 'chat', 'list', 'chatAdmin', 'listAdmin', 'getchat', 'sendchat', 'uploadAttachment', 'updatestate', 'addmessage', 'deletechat', 'newTicket', 'getOrderRowsForModal'),
            );
            foreach ($supportResources as $resource => $actions) {
                $acl->addResource(new Resource($resource), $actions);
            }

            // Public area resources
            $publicResources = array(
                'errors' => array('show401', 'show404', 'show500'),
                'session' => array('login', 'register', 'start', 'changelanguage', 'saverequest', 'emailrequestaccess'),
                'data' => array('media', 'test'),
                'b2c' => array('download'),
                //'db'			=> $db,
                //'rest'		=> $rest
            );
            foreach ($publicResources as $resource => $actions) {
                $acl->addResource(new Resource($resource), $actions);
            }

            //Grant access to public areas to both users and guests
            foreach ($roles as $role) {
                foreach ($publicResources as $resource => $actions) {
                    foreach ($actions as $action) {
                        $acl->allow($role->getName(), $resource, $action);
                    }
                }
            }

            //Grant access to private area to role Users
            foreach ($usersResources as $resource => $actions) {
                foreach ($actions as $action) {
                    $acl->allow('Users', $resource, $action);
                }
            }

            //Grant access to private area to role Support
            foreach ($supportResources as $resource => $actions) {
                foreach ($actions as $action) {
                    $acl->allow('Support', $resource, $action);
                }
            }

            //Grant access to private area to role Admin
            foreach ($adminResources as $resource => $actions) {
                foreach ($actions as $action) {
                    $acl->allow('Admin', $resource, $action);
                }
            }

            // Allow REST API
            //$acl->allow('*', 'rest', '*');

            // Store serialized list into plain file
            if (!empty(self::ACL_FILENAME)) {
                $this->diskManager->storeFileContentInApp(self::ACL_FILENAME, serialize($acl));
            }
        } else {
            //Restore acl object from serialized file
            $acl = unserialize($this->diskManager->retriveFileContentInApp(self::ACL_FILENAME));
        }

        //The acl is stored in session, APC would be useful here too
        $this->persistent->acl = $acl;

        return $this->persistent->acl;

        //return $acl;
    }

    /**
     * This action is executed before execute any action in the application
     *
     * @param Event $event
     * @param Dispatcher $dispatcher
     * @return bool
     */
    public function beforeDispatch(Event $event, Dispatcher $dispatcher)
    {
        $auth = $this->session->get('auth');

        if (!$auth) {
            $role = 'Guests';
        } else {
            $role = $auth['role'];
        }

        $controller = $dispatcher->getControllerName();
        $action = $dispatcher->getActionName();

        //$this->logger->info('beforeDispatch');
        //$this->logger->info($controller);
        //$this->logger->info($action);

        if ($controller != 'rest') {
            // If it's not a REST API request
            $acl = $this->getAcl();

            if (!$acl->isResource($controller)) {
                switch ($role) {
                    case "Admin":
                        $this->response->redirect('admin/dashboard');
                        break;
                    case "Users":
                        if ((new Utility)->getAppSettings('StartingHomePage') == 0) {
                            $this->response->redirect('catalog/index');
                        } else {
                            $this->response->redirect('catalog/collection');
                        }
                        break;
                    case "Support":
                        $this->response->redirect('support/index');
                        break;
                    case "Guests":
                    default:
                        $this->response->redirect('session/login');
                        break;
                }

                return false;
            }

            $allowed = $acl->isAllowed($role, $controller, $action);

            if ($allowed != Acl::ALLOW) {
                if ($role == 'Guests') {
                    $this->response->redirect('session/login');
                    if (session_status() === PHP_SESSION_ACTIVE) {
                        $this->session->destroy();
                    }
                    return false;
                } else {
                    $this->response->redirect('errors/show401');
                    if (session_status() === PHP_SESSION_ACTIVE) {
                        $this->session->destroy();
                    }
                    return false;
                }
            }
        } else {
            error_reporting(0);
            //ob_start();

            // getting access token is permitted ;)
            if ($action == 'login' || $action == 'authorize' || $this->request->isOptions()
            ) {
                return $this->di->getShared('rateLimits', ['apiAccessToken', $this->request->getClientAddress(), $this]);
            }

            $accessTokenRepository = new \Rest\Components\Repositories\AccessTokenRepository(); // instance of AccessTokenRepositoryInterface
            $publicKeyPath = 'file://' . APP_PATH . '/app/' . $this->config->api->oAuthPublic;

            try {
                $server = new \League\OAuth2\Server\ResourceServer(
                    $accessTokenRepository,
                    $publicKeyPath
                );

                $auth = new \League\OAuth2\Server\Middleware\ResourceServerMiddleware($server);
                $auth(new \Rest\Components\Request($this->request), new \Rest\Components\Response($this->response), function () {
                });
                if (isset($_SERVER['oauth_access_token_id']) &&
                    isset($_SERVER['oauth_client_id']) &&
                    isset($_SERVER['oauth_user_id']) &&
                    isset($_SERVER['oauth_scopes'])
                ) {
                    // TODO: save somewhere the user_id and scopes for future validations, e.g. /users/1/edit
                    // TODO: should be accessible only if the user_id is 1 or the scope is giving permissions, e.g. admin
                    if (strlen($_SERVER['oauth_client_id']) > 0) {
                        return $this->di->getShared('rateLimits', ['apiCommon', 'client' . $_SERVER['oauth_client_id'], $this]);
                    } else {
                        return $this->di->getShared('rateLimits', ['apiCommon', 'user' . $_SERVER['oauth_user_id'], $this]);
                    }
                }
            } catch (\League\OAuth2\Server\Exception\OAuthServerException $e) {
                $httpStatusCode = 401;
                $message = 'Unauthorized';
                $this->response->setContentType("application/json");
                $this->response->setStatusCode($httpStatusCode, \Rest\Components\HttpStatusCodes::getMessage($httpStatusCode))->sendHeaders();
                echo json_encode($message);
                return false;
            }

            $rateLimit = $this->di->getShared('rateLimits', ['apiUnauthorized', $this->request->getClientAddress(), $this]);
            if ($rateLimit === false) {
                $httpStatusCode = 429;
                $message = 'Too Many Requests';
                $this->response->setContentType("application/json");
                $this->response->setStatusCode($httpStatusCode, \Rest\Components\HttpStatusCodes::getMessage($httpStatusCode))->sendHeaders();
                echo json_encode($message);
                return false;
            }

            //$httpStatusCode = 401;
            //$message = 'The bearer token is missing or is invalid';
            //$this->response->setContentType("application/json");
            //$this->response->setStatusCode($httpStatusCode, \Rest\Components\HttpStatusCodes::getMessage($httpStatusCode))->sendHeaders();

            error_reporting(1);
            //ob_end_clean();

            //return false;
        }
    }
}
