<?php

namespace Go2B\plugins\Nav;

class NewAddressCustomerKOC extends \Phalcon\Di\Injectable
{
    public $id;
    public $customerNo;
    public $code;
    public $name;
    public $address;
    public $phoneNo;
    public $countryRegionCode;
    public $postCode;
    public $city;
    public $county;
    public $eMail;
    public $dimension1Code;

    /**
     * @Column(column="etag", type="string", nullable=true)
     * @var string
     */
    private $odata_etag;

    public function setEtag($string)
    {
        $this->odata_etag = 'W/"' . base64_encode($string) . '"';
    }

    public function jsonSerialize()
    {
        // Copia le proprietà dell'oggetto in un array
        $data = get_object_vars($this);

        // Modifica il formato della chiave solo per la proprietà 'odata_etag'
        if (isset($data['odata_etag'])) {
            $data['@odata.etag'] = $data['odata_etag'];
            unset($data['odata_etag']);
        }

        unset($data["_dependencyInjector"]);
        unset($data["_eventsManager"]);

        return json_encode($data);
    }

    public function set($data)
    {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }
}
