<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Visana extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $nupost;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuvisi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtvisi;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $orvisi;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpanag;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdanag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nutrgt;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpvisi;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $esitov;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $rifnot;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('visana');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nupost' => isset($rec->nupost) && (string)$rec->nupost !== '' ? (string)$rec->nupost : new RawValue('""'),
      'nuvisi' => isset($rec->nuvisi) && (string)$rec->nuvisi !== '' ? (string)$rec->nuvisi : 0,
      'dtvisi' => isset($rec->dtvisi) && (string)$rec->dtvisi !== '' ? (string)$rec->dtvisi : '0000-00-00',
      'orvisi' => isset($rec->orvisi) && (string)$rec->orvisi !== '' ? (string)$rec->orvisi : 0,
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
      'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? (string)$rec->cdanag : new RawValue('""'),
      'nutrgt' => isset($rec->nutrgt) && (string)$rec->nutrgt !== '' ? (string)$rec->nutrgt : 0,
      'tpvisi' => isset($rec->tpvisi) && (string)$rec->tpvisi !== '' ? (string)$rec->tpvisi : new RawValue('""'),
      'esitov' => isset($rec->esitov) && (string)$rec->esitov !== '' ? (string)$rec->esitov : new RawValue('""'),
      'rifnot' => isset($rec->rifnot) && (string)$rec->rifnot !== '' ? (string)$rec->rifnot : 0
    );

    $query  = 'nupost = :nupost: AND nuvisi = :nuvisi:';
    $params = array(
      'nupost' => $values['nupost'],
      'nuvisi' => $values['nuvisi']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustomerCode($oldcode, $cdanag) {
    $query = 'UPDATE visana v
      INNER JOIN anagra a ON a.tpanag = v.tpanag AND a.cdanag = v.cdanag
      SET v.tpanag = "CL", v.cdanag = :cdanag
      WHERE v.tpanag = "CN" AND v.cdanag = :oldcode AND a.cdblco = 0';
    Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'oldcode' => $oldcode));
  }
  //endregion
}
