<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpport extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpport;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dstpor;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $defcon;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpport');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpport' => isset($rec->tpport) && (string)$rec->tpport !== '' ? (string)$rec->tpport : new RawValue('""'),
      'dstpor' => isset($rec->dstpor) && (string)$rec->dstpor !== '' ? (string)$rec->dstpor : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'defcon' => isset($rec->defcon) && (string)$rec->defcon !== '' ? (string)$rec->defcon : 0
    );

    $query  = 'tpport = :tpport:';
    $params = array(
      'tpport' => $values['tpport']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpport objects
   */
  public static function getAllShippingTypes() {
    $query = 'SELECT t.tpport, t.dstpor
      FROM Go2B\Models\Tpport t';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga objects
   */
  public static function getAllShippings() {
    $query = 'SELECT t.tpport AS code, t.dstpor AS description, t.defcon AS defcon
      FROM Go2B\Models\Tpport t
      ORDER BY t.tpport';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpport arrays
   */
  public static function getShipmentsForCustomer($tpanag, $cdanag, $idlang = 'IT') {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor ";
      $leftJoinDstpor = "LEFT JOIN deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dstpor = 't.dstpor AS dstpor ';
      $leftJoinDstpor = '';
    }
    $query = "SELECT t.tpport, $dstpor, 0 AS valmin, 0 AS valmax, 0 AS pesmin,
      0 AS pesmax, 0 AS preagg, '' AS dsvett
      FROM tpport t
      $leftJoinDstpor
      INNER JOIN anagra a ON a.tpport = t.tpport
      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag ";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga arrays
   */
  public static function getAllChoosableShipmentsForCustomer($tpanag, $cdanag, $idlang = 'IT') {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor ";
      $leftJoinDstpor = "LEFT JOIN deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dstpor = 't.dstpor AS dstpor ';
      $leftJoinDstpor = '';
    }
    $query = "SELECT t.tpport, $dstpor, 0 AS valmin, 0 AS valmax, 0 AS pesmin,
      0 AS pesmax, 0 AS preagg, '' AS dsvett,
      IF((SELECT a.tpport FROM anagra a WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag) = t.tpport, 1, 0) AS selected
      FROM tpport t
      $leftJoinDstpor
      GROUP BY t.tpport
      ORDER BY dstpor ";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpport arrays
   */
  public static function getAllShipmentsForCustomer($tpanag, $cdanag, $cdnazi, $idlang = 'IT') {
//    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdnazi' => $cdnazi);
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor ";
      $leftJoinDstpor = "LEFT JOIN deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dstpor = 't.dstpor AS dstpor ';
      $leftJoinDstpor = '';
    }
//    $query = "SELECT t.tpport, $dstpor, 0 AS valmin, 0 AS valmax, 0 AS pesmin,
//      0 AS pesmax, 0 AS preagg, '' AS dsvett, 0 AS checkRange
//      FROM tpport t
//      $leftJoinDstpor
//      INNER JOIN anagra a ON a.tpport = t.tpport
//      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag
//      UNION
//      SELECT c.tpport, c.dstpor, c.valmin, c.valmax, c.pesmin,
//      c.pesmax, c.preagg, c.dsvett, 1 AS checkRange
//      FROM b2b_cuspor c
//      WHERE c.cdnazi = :cdnazi OR c.cdnazi = 'ALL'
//      ORDER BY checkRange DESC";
//      return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
      $query = "SELECT t.tpport, $dstpor, 0 AS valmin, 0 AS valmax, 0 AS pesmin,
      0 AS pesmax, 0 AS preagg, '' AS dsvett, 0 AS checkRange
      FROM tpport t
      $leftJoinDstpor
      INNER JOIN anagra a ON a.tpport = t.tpport
      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag";
      $standard = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

      return array_merge(B2bCuspor::getCustomShipmentsForCountry($cdnazi), $standard);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function resetDefcon() {
    $query = "UPDATE tpport t
      SET t.defcon = 0";
    return Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateDefcon($tpport, $defcon) {
    $query = "UPDATE tpport t
      SET t.defcon = :defcon
      WHERE t.tpport = :tpport";
    return Di::getDefault()->get('db')->query($query, array('tpport' => $tpport, 'defcon' => $defcon));
  }
  //endregion
}
