<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tppaga extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tppaga;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dspaga;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpeffe;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $scpaga;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $peracc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $defcon;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpindo;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tppaga');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tppaga' => isset($rec->tppaga) && (string)$rec->tppaga !== '' ? (string)$rec->tppaga : new RawValue('""'),
      'dspaga' => isset($rec->dspaga) && (string)$rec->dspaga !== '' ? (string)$rec->dspaga : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpeffe' => isset($rec->tpeffe) && (string)$rec->tpeffe !== '' ? (string)$rec->tpeffe : new RawValue('""'),
      'scpaga' => isset($rec->scpaga) && (string)$rec->scpaga !== '' ? (string)$rec->scpaga : 0,
      'peracc' => isset($rec->peracc) && (string)$rec->peracc !== '' ? (string)$rec->peracc : 0,
      'defcon' => isset($rec->defcon) && (string)$rec->defcon !== '' ? (string)$rec->defcon : 0,
      'tpindo' => isset($rec->tpindo) && (string)$rec->tpindo !== '' ? (string)$rec->tpindo : new RawValue('""')
    );

    $query  = 'tppaga = :tppaga:';
    $params = array(
      'tppaga' => $values['tppaga']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tppaga objects
   */
  public static function getAllPaymentTypes() {
    $query = 'SELECT t.tppaga, t.dspaga
      FROM Go2B\Models\Tppaga t';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga objects
   */
  public static function getAllPayments() {
    $query = 'SELECT t.tppaga AS code, t.dspaga AS description, t.defcon AS defcon
      FROM Go2B\Models\Tppaga t
      ORDER BY t.tppaga';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga arrays
   */
  public static function getPaymentsForCustomer($tpanag, $cdanag, $idlang = 'IT') {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dspaga = "COALESCE(d1.descri,t.dspaga,'') AS dspaga ";
      $leftJoinDspaga = "LEFT JOIN deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dspaga = 't.dspaga AS dspaga ';
      $leftJoinDspaga = '';
    }
    $query = "SELECT t.tppaga, $dspaga, 0 AS valmin, 0 AS valmax, 0 AS preagg
      FROM tppaga t
      $leftJoinDspaga
      INNER JOIN anagra a ON a.tppaga = t.tppaga
      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag
      GROUP BY t.tppaga ";

    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga arrays
   */
  public static function getAllChoosablePaymentsForCustomer($tpanag, $cdanag, $idlang = 'IT') {
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dspaga = "COALESCE(d1.descri,t.dspaga,'') AS dspaga ";
      $leftJoinDspaga = "LEFT JOIN deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dspaga = 't.dspaga AS dspaga ';
      $leftJoinDspaga = '';
    }
    $query = "SELECT t.tppaga, $dspaga, 0 AS valmin, 0 AS valmax, 0 AS preagg,
      IF((SELECT a.tppaga FROM anagra a WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag) = t.tppaga, 1, 0) AS selected
      FROM tppaga t
      $leftJoinDspaga
      GROUP BY t.tppaga
      ORDER BY dspaga ";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tppaga arrays
   */
  public static function getAllPaymentsForCustomer($tpanag, $cdanag, $cdnazi, $idlang = 'IT') {
//    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'cdnazi' => $cdnazi);
    $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
    if ($idlang != 'IT') {
      $dspaga = "COALESCE(d1.descri,t.dspaga,'') AS dspaga ";
      $leftJoinDspaga = "LEFT JOIN deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dspaga = 't.dspaga AS dspaga ';
      $leftJoinDspaga = '';
    }
//    $query = "SELECT t.tppaga, $dspaga, 0 AS valmin, 0 AS valmax, 0 AS preagg,
//      0 AS checkRange
//      FROM tppaga t
//      $leftJoinDspaga
//      INNER JOIN anagra a ON a.tppaga = t.tppaga
//      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag
//      GROUP BY t.tppaga
//      UNION
//      SELECT c.tppaga, c.dspaga, c.valmin, c.valmax, c.preagg,
//      1 AS checkRange
//      FROM b2b_cuspag c
//      WHERE c.cdnazi = :cdnazi OR c.cdnazi = 'ALL'
//      GROUP BY c.tppaga
//      ORDER BY checkRange DESC";
    $query = "SELECT t.tppaga, $dspaga, 0 AS valmin, 0 AS valmax, 0 AS preagg,
      0 AS checkRange
      FROM tppaga t
      $leftJoinDspaga
      INNER JOIN anagra a ON a.tppaga = t.tppaga
      WHERE a.tpanag = :tpanag AND a.cdanag = :cdanag
      GROUP BY t.tppaga";
    $standard = Di::getDefault()->get('db')->query($query, $params)->fetchAll();

    return array_merge(B2bCuspag::getCustomPaymentsForCountry($cdnazi), $standard);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function resetDefcon() {
    $query = "UPDATE tppaga t
      SET t.defcon = 0";
    return Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateDefcon($tppaga, $defcon) {
    $query = "UPDATE tppaga t
      SET t.defcon = :defcon
      WHERE t.tppaga = :tppaga";
    return Di::getDefault()->get('db')->query($query, array('tppaga' => $tppaga, 'defcon' => $defcon));
  }
  //endregion
}
