<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpocon extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $tpcond;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpport;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtamin;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpocon');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'tpcond' => isset($rec->tpcond) && (string)$rec->tpcond !== '' ? (string)$rec->tpcond : 0,
      'tpport' => isset($rec->tpport) && (string)$rec->tpport !== '' ? (string)$rec->tpport : new RawValue('""'),
      'qtamin' => isset($rec->qtamin) && (string)$rec->qtamin !== '' ? (string)$rec->qtamin : 0
    );

    $query  = 'cdstag = :cdstag: AND tpcond = :tpcond: AND tpport = :tpport:';
    $params = array(
      'cdstag' => $values['cdstag'],
      'tpcond' => $values['tpcond'],
      'tpport' => $values['tpport']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpocon objects
   */
  public static function getConditions($cdstag, $tpcond) {
    $query = "SELECT t.tpport AS tpitem, t.qtamin AS valmin
      FROM Go2B\Models\Tpocon t
      WHERE t.cdstag = :cdstag: AND t.tpcond = :tpcond:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdstag' => $cdstag, 'tpcond' => $tpcond));
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertCondition($cdstag, $tpcond, $tpport, $qtamin) {
    $params = array('cdstag' => $cdstag, 'tpcond' => $tpcond, 'tppaga' => $tppaga, 'qtamin' => $qtamin);
    $query = "INSERT INTO tpocon (cdstag, tpcond, tpport, qtamin)
      VALUES (:cdstag, :tpcond, :tpport, :qtamin)";
    return Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteConditions($cdstag, $tpcond) {
    $params = array('cdstag' => $cdstag, 'tpcond' => $tpcond);
    $query = "DELETE t.*
      FROM tpocon t
      WHERE t.cdstag = :cdstag AND t.tpcond = :tpcond";
    return Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
