<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpmvar extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpmode;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpmvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : 0,
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'tpmode' => isset($rec->tpmode) && (string)$rec->tpmode !== '' ? (string)$rec->tpmode : new RawValue('""')
    );

    $query  = 'cdregv = :cdregv: AND cdvari = :cdvari: AND tpmode = :tpmode:';
    $params = array(
      'cdregv' => $values['cdregv'],
      'cdvari' => $values['cdvari'],
      'tpmode' => $values['tpmode']
    );

    if (trim($tipoagg) == 'del') {
      $row = new self();
      $row->save($values);
    }
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewRecord($cdregv, $cdvari, $tpmode) {
    $query = 'INSERT INTO tpmvar (cdregv, cdvari, tpmode)
      VALUES(:cdregv, :cdvari, :tpmode)';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'cdvari' => $cdvari, 'tpmode' => $tpmode));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregv($cdregv) {
    $query = 'DELETE t
      FROM tpmvar t
      WHERE t.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari) {
    $query = 'DELETE t
      FROM tpmvar t
      INNER JOIN tabvar v ON t.cdregv = v.cdregv
      WHERE t.cdregv = :cdregv AND v.tpvari = :tpvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndCdvari($cdregv, $cdvari) {
    $query = 'DELETE t
      FROM tpmvar t
      WHERE t.cdregv = :cdregv AND t.cdvari = :cdvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'cdvari' => $cdvari));
  }
  //endregion
}
