<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpmode extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpmode;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dstmod;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpmode');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpmode' => isset($rec->tpmode) && (string)$rec->tpmode !== '' ? (string)$rec->tpmode : new RawValue('""'),
      'dstmod' => isset($rec->dstmod) && (string)$rec->dstmod !== '' ? (string)$rec->dstmod : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'tpmode = :tpmode:';
    $params = array(
      'tpmode' => $values['tpmode']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getAllArticleModelTypesFromCatalog($cdcata, $items) {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($items['lang']));

    $innerJoinAnaper = '';
    $andWhere = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT tm.tpmode AS codice, COALESCE(ai.valore,tm.dstmod) AS descri
      FROM Go2B\Models\Tpmode tm
      INNER JOIN Go2B\Models\Tipolo tp ON tm.tpmode = tp.tpmode
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $innerJoinAnaper
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'tpmode' AND ai.codic1 = tm.tpmode AND ai.codic2 = '' AND ai.tpdato = :tpdato:
      WHERE ca.cdcata = :cdcata:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tm.tpmode
      ORDER BY tm.seqrap, tm.dstmod, tm.tpmode";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getModelTypesForLocalization() {
    $query = "SELECT tm.tpmode AS code, tm.dstmod AS description,
      COALESCE(it.valore,'') AS des_it, COALESCE(en.valore,'') AS des_en,
      COALESCE(es.valore,'') AS des_es, COALESCE(fr.valore,'') AS des_fr,
      COALESCE(de.valore,'') AS des_de
      FROM Go2B\Models\Tpmode tm
      LEFT JOIN Go2B\Models\B2bAddinf it ON it.tabell = 'tpmode' AND it.codic1 = tm.tpmode AND it.codic2 = '' AND it.tpdato = 'des_it'
      LEFT JOIN Go2B\Models\B2bAddinf en ON en.tabell = 'tpmode' AND en.codic1 = tm.tpmode AND en.codic2 = '' AND en.tpdato = 'des_en'
      LEFT JOIN Go2B\Models\B2bAddinf es ON es.tabell = 'tpmode' AND es.codic1 = tm.tpmode AND es.codic2 = '' AND es.tpdato = 'des_es'
      LEFT JOIN Go2B\Models\B2bAddinf fr ON fr.tabell = 'tpmode' AND fr.codic1 = tm.tpmode AND fr.codic2 = '' AND fr.tpdato = 'des_fr'
      LEFT JOIN Go2B\Models\B2bAddinf de ON de.tabell = 'tpmode' AND de.codic1 = tm.tpmode AND de.codic2 = '' AND de.tpdato = 'des_de'
      ORDER BY tm.dstmod";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getAllModelTypes() {
    $query = "SELECT tm.tpmode, tm.dstmod,
      tm.tpmode AS code, tm.dstmod AS description
      FROM Go2B\Models\Tpmode tm
      ORDER BY tm.dstmod";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getAllModelTypesWithLanguageDescriptions() {
    $query = "SELECT tm.tpmode, tm.dstmod, COALESCE(den.descri,'') AS des_en,
      COALESCE(des.descri,'') AS des_es, COALESCE(dfr.descri,'') AS des_fr,
      COALESCE(dde.descri,'') AS des_de
      FROM Go2B\Models\Tpmode tm
      LEFT JOIN Go2B\Models\Deslin den ON den.tpdato = 'dstmod' AND den.codic1 = tm.tpmode AND den.codic2 = '' AND den.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin des ON des.tpdato = 'dstmod' AND des.codic1 = tm.tpmode AND des.codic2 = '' AND des.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dfr ON dfr.tpdato = 'dstmod' AND dfr.codic1 = tm.tpmode AND dfr.codic2 = '' AND dfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dde ON dde.tpdato = 'dstmod' AND dde.codic1 = tm.tpmode AND dde.codic2 = '' AND dde.idlang = 'DE'
      ORDER BY tm.dstmod";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getModelTypesFromCatalog($cdcata) {
    $query = 'SELECT tm.tpmode, tm.dstmod
      FROM Go2B\Models\Tpmode tm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.tpmode = tm.tpmode
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY tm.tpmode';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getModelTypesWithDiscountFromCatalogs($whereCatalogs, $params) {
    $query = "SELECT DISTINCT tm.tpmode, tm.dstmod, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Tpmode tm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.tpmode = tm.tpmode
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.tpmode = tm.tpmode AND cb.tpmode != '' AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getAllModelTypesForCustomVar($cdregv, $cdvari) {
    $query = "SELECT t.tpmode, t.dstmod, IF(EXISTS(SELECT m.tpmode
        FROM Go2B\Models\Tpmvar m
        WHERE m.cdregv = :cdregv: AND m.cdvari = :cdvari: AND m.tpmode = t.tpmode), 1, 0) AS exist
      FROM Go2B\Models\Tpmode t
      GROUP BY t.tpmode";

    $params = array('cdregv' => $cdregv, 'cdvari' => $cdvari);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpmode objects
   */
  public static function getAllModelTypesForPromo($cdprom) {
    if (!empty($cdprom)) {
      $presPvcorp = 'COALESCE((SELECT COUNT(c.tpmode) FROM Go2B\Models\Pvcorp c WHERE c.tpmode = t.tpmode AND c.cdprom = :cdprom:), 0) AS presPvcorp';
      $presPvgrup = 'COALESCE((SELECT COUNT(g.tpmode) FROM Go2B\Models\Pvgrup g WHERE g.tpmode = t.tpmode AND g.cdprom = :cdprom:), 0) AS presPvgrup';
      $params = array('cdprom' => $cdprom);
    } else {
      $presPvcorp = '0 AS presPvcorp';
      $presPvgrup = '0 AS presPvgrup';
      $params = array();
    }
    $query = "SELECT t.tpmode, t.dstmod, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Tpmode t
      ORDER BY t.tpmode";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE tpmode";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
