<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tipvar extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpvari;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $dstvar;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flobbl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tipvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : 0,
      'tpvari' => isset($rec->tpvari) && (string)$rec->tpvari !== '' ? (string)$rec->tpvari : new RawValue('""'),
      'dstvar' => isset($rec->dstvar) && (string)$rec->dstvar !== '' ? (string)$rec->dstvar : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'flobbl' => isset($rec->flobbl) && (string)$rec->flobbl !== '' ? (string)$rec->flobbl : 0,
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0
    );

    $query  = 'cdregv = :cdregv: AND tpvari = :tpvari:';
    $params = array(
      'cdregv' => $values['cdregv'],
      'tpvari' => $values['tpvari']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tipvar objects
   */
  public static function getAllFamiliesByCdregv($cdregv) {
    $query = "SELECT t.tpvari, t.dstvar, t.seqrap, t.cdregv, r.dsregv,
      t.flobbl, t.flbloc
      FROM Go2B\Models\Tipvar t
      INNER JOIN Go2B\Models\Regvar r ON r.cdregv = t.cdregv
      WHERE t.cdregv = :cdregv: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdregv' => $cdregv));
  }

  /**
   * Query:   SELECT
   * Return:  Tipvar object
   */
  public static function getFamilyByCdregvAndTpvari($cdregv, $tpvari) {
    $query = "SELECT t.tpvari, t.dstvar, t.seqrap, t.cdregv, r.dsregv,
      t.flobbl, t.flbloc
      FROM Go2B\Models\Tipvar t
      INNER JOIN Go2B\Models\Regvar r ON r.cdregv = t.cdregv
      WHERE t.cdregv = :cdregv: AND t.tpvari = :tpvari: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari))[0];
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewFamily($cdregv, $tpvari, $dstvar, $seqrap, $flobbl, $flbloc) {
    $params = array('cdregv' => $cdregv, 'tpvari' => $tpvari, 'dstvar' => $dstvar, 'seqrap' => $seqrap, 'flobbl' => $flobbl, 'flbloc' => $flbloc);
    $query = 'INSERT INTO tipvar (cdregv, tpvari, dstvar, seqrap, flobbl, flbloc)
      VALUES (:cdregv, :tpvari, :dstvar, :seqrap, :flobbl, :flbloc)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateFamily($cdregv, $tpvari, $dstvar, $seqrap, $flobbl, $flbloc) {
    $params = array('cdregv' => $cdregv, 'tpvari' => $tpvari, 'dstvar' => $dstvar, 'seqrap' => $seqrap, 'flobbl' => $flobbl, 'flbloc' => $flbloc);
    $query = 'UPDATE tipvar t
      SET t.dstvar = :dstvar, t.seqrap = :seqrap, t.flobbl = :flobbl, t.flbloc = :flbloc
      WHERE t.cdregv = :cdregv AND t.tpvari = :tpvari';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregv($cdregv) {
    $query = 'DELETE t
      FROM tipvar t
      WHERE t.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari) {
    $query = 'DELETE t
      FROM tipvar t
      WHERE t.cdregv = :cdregv AND t.tpvari = :tpvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari));
  }
  //endregion
}
