<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tipcla extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpclas;

  /**
   *
   * @var string
   * @Column(type="string", length=50, nullable=false)
   */
  public $dsclas;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tipcla');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'tpclas' => isset($rec->tpclas) && (string)$rec->tpclas !== '' ? (string)$rec->tpclas : new RawValue('""'),
      'dsclas' => isset($rec->dsclas) && (string)$rec->dsclas !== '' ? (string)$rec->dsclas : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'tpinpu = :tpinpu: AND tpclas = :tpclas:';
    $params = array(
      'dsclas' => $values['dsclas'],
      'seqrap' => $values['seqrap']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tipcla arrays
   */
  public static function getFilterTags() {
    $query = "SELECT DISTINCT 'tipcla' AS codic1, COALESCE(t.tpclas,v.codic2) AS codic2,
      COALESCE(v.flbloc,0) AS flbloc, COALESCE(v.des_it,t.dsclas) AS des_it,
      COALESCE(v.des_en,'') AS des_en, COALESCE(v.des_es,'') AS des_es,
      COALESCE(v.des_de,'') AS des_de, COALESCE(v.des_fr,'') AS des_fr,
      COALESCE(v.seqrap,0) AS seqrap
      FROM tipcla t
      LEFT JOIN b2b_flvisi v ON v.codic1 = 'tipcla' AND v.codic2 = t.tpclas ";
    return Di::getDefault()->get('db')->query($query)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tipcla arrays
   */
  public static function getFilterTagsByCatalog($cdcata) {
    $query = "SELECT t.tpclas, t.dsclas, COALESCE(v.flbloc,0) AS flbloc,
      COALESCE(v.des_it, t.dsclas) AS des_it, COALESCE(v.des_en, t.dsclas) AS des_en,
      COALESCE(v.des_es, t.dsclas) AS des_es, COALESCE(v.des_de, t.dsclas) AS des_de,
      COALESCE(v.des_fr, t.dsclas) AS des_fr, COALESCE(v.seqrap, 0) AS seqrap
      FROM Go2B\Models\Tipcla t
      LEFT JOIN Go2B\Models\B2bFlvisi v ON v.codic1 = 'tipcla' AND v.codic2 = t.tpclas
      INNER JOIN Go2B\Models\Artcla ac ON t.tpclas = ac.tpclas
      INNER JOIN Go2B\Models\Anaart aa ON ac.codice = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY t.tpclas";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }
  //endregion
}
