<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Mvc\Model;

class Tgagen extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nurtgc;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nutrgt;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdagen;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $imptrg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $qtatrg;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $ncltrg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tgagen');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nurtgc' => isset($rec->nurtgc) && (string)$rec->nurtgc !== '' ? (string)$rec->nurtgc : 0,
      'nutrgt' => isset($rec->nutrgt) && (string)$rec->nutrgt !== '' ? (string)$rec->nutrgt : 0,
      'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'imptrg' => isset($rec->imptrg) && (string)$rec->imptrg !== '' ? (string)$rec->imptrg : 0,
      'qtatrg' => isset($rec->qtatrg) && (string)$rec->qtatrg !== '' ? (string)$rec->qtatrg : 0,
      'ncltrg' => isset($rec->ncltrg) && (string)$rec->ncltrg !== '' ? (string)$rec->ncltrg : 0
    );

    $query  = 'nurtgc = :nurtgc:';
    $params = array(
      'nurtgc' => $values['nurtgc']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
